# coding: utf-8
"""
    external/v1/auth_service.proto

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)  # noqa: E501

    OpenAPI spec version: version not set

    Generated by: https://github.com/swagger-api/swagger-codegen.git

    NOTE
    ----
    standard swagger-codegen-cli for this python client has been modified
    by custom templates. The purpose of these templates is to include
    typing information in the API and Model code. Please refer to the
    main grid repository for more info
"""

from __future__ import absolute_import

import re  # noqa: F401
from typing import TYPE_CHECKING, Any

# python 2 and python 3 compatibility library
import six

from lightning_cloud.openapi.api_client import ApiClient

if TYPE_CHECKING:
    from datetime import datetime
    from lightning_cloud.openapi.models import *


class ModelsStoreApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def models_store_delete_model(
            self, project_id: 'str', model_id: 'str',
            **kwargs) -> 'V1DeleteModelResponse':  # noqa: E501
        """DeleteModel is used to delete the model and all uploaded archives  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.models_store_delete_model(project_id, model_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id: (required)
        :param str model_id: (required)
        :return: V1DeleteModelResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.models_store_delete_model_with_http_info(
                project_id, model_id, **kwargs)  # noqa: E501
        else:
            (data) = self.models_store_delete_model_with_http_info(
                project_id, model_id, **kwargs)  # noqa: E501
            return data

    def models_store_delete_model_with_http_info(
            self, project_id: 'str', model_id: 'str',
            **kwargs) -> 'V1DeleteModelResponse':  # noqa: E501
        """DeleteModel is used to delete the model and all uploaded archives  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.models_store_delete_model_with_http_info(project_id, model_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id: (required)
        :param str model_id: (required)
        :return: V1DeleteModelResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id', 'model_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError("Got an unexpected keyword argument '%s'"
                                " to method models_store_delete_model" % key)
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or params['project_id'] is None):
            raise ValueError(
                "Missing the required parameter `project_id` when calling `models_store_delete_model`"
            )  # noqa: E501
        # verify the required parameter 'model_id' is set
        if ('model_id' not in params or params['model_id'] is None):
            raise ValueError(
                "Missing the required parameter `model_id` when calling `models_store_delete_model`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['projectId'] = params['project_id']  # noqa: E501
        if 'model_id' in params:
            path_params['modelId'] = params['model_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/projects/{projectId}/models/{modelId}',
            'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1DeleteModelResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def models_store_delete_model_version(
            self, project_id: 'str', model_id: 'str', version: 'str',
            **kwargs) -> 'V1DeleteModelVersionResponse':  # noqa: E501
        """DeleteModelVersion is used to delete a specific model version  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.models_store_delete_model_version(project_id, model_id, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id: (required)
        :param str model_id: (required)
        :param str version: (required)
        :return: V1DeleteModelVersionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.models_store_delete_model_version_with_http_info(
                project_id, model_id, version, **kwargs)  # noqa: E501
        else:
            (data) = self.models_store_delete_model_version_with_http_info(
                project_id, model_id, version, **kwargs)  # noqa: E501
            return data

    def models_store_delete_model_version_with_http_info(
            self, project_id: 'str', model_id: 'str', version: 'str',
            **kwargs) -> 'V1DeleteModelVersionResponse':  # noqa: E501
        """DeleteModelVersion is used to delete a specific model version  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.models_store_delete_model_version_with_http_info(project_id, model_id, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id: (required)
        :param str model_id: (required)
        :param str version: (required)
        :return: V1DeleteModelVersionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id', 'model_id', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method models_store_delete_model_version" % key)
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or params['project_id'] is None):
            raise ValueError(
                "Missing the required parameter `project_id` when calling `models_store_delete_model_version`"
            )  # noqa: E501
        # verify the required parameter 'model_id' is set
        if ('model_id' not in params or params['model_id'] is None):
            raise ValueError(
                "Missing the required parameter `model_id` when calling `models_store_delete_model_version`"
            )  # noqa: E501
        # verify the required parameter 'version' is set
        if ('version' not in params or params['version'] is None):
            raise ValueError(
                "Missing the required parameter `version` when calling `models_store_delete_model_version`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['projectId'] = params['project_id']  # noqa: E501
        if 'model_id' in params:
            path_params['modelId'] = params['model_id']  # noqa: E501
        if 'version' in params:
            path_params['version'] = params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/projects/{projectId}/models/{modelId}/versions/{version}',
            'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1DeleteModelVersionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def models_store_download_model(
            self, **kwargs) -> 'V1DownloadModelResponse':  # noqa: E501
        """DownloadModel is a public facing API used by the Python library to get a presigned URL to download the model. Name is a required query parameter  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.models_store_download_model(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name:
        :param str version:
        :return: V1DownloadModelResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.models_store_download_model_with_http_info(
                **kwargs)  # noqa: E501
        else:
            (data) = self.models_store_download_model_with_http_info(
                **kwargs)  # noqa: E501
            return data

    def models_store_download_model_with_http_info(
            self, **kwargs) -> 'V1DownloadModelResponse':  # noqa: E501
        """DownloadModel is a public facing API used by the Python library to get a presigned URL to download the model. Name is a required query parameter  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.models_store_download_model_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name:
        :param str version:
        :return: V1DownloadModelResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError("Got an unexpected keyword argument '%s'"
                                " to method models_store_download_model" % key)
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'version' in params:
            query_params.append(('version', params['version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/models',
            'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1DownloadModelResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def models_store_get_model(self, project_id: 'str', model_id: 'str',
                               **kwargs) -> 'V1Model':  # noqa: E501
        """GetModel used to get specific model details  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.models_store_get_model(project_id, model_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id: (required)
        :param str model_id: (required)
        :return: V1Model
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.models_store_get_model_with_http_info(
                project_id, model_id, **kwargs)  # noqa: E501
        else:
            (data) = self.models_store_get_model_with_http_info(
                project_id, model_id, **kwargs)  # noqa: E501
            return data

    def models_store_get_model_with_http_info(
            self, project_id: 'str', model_id: 'str',
            **kwargs) -> 'V1Model':  # noqa: E501
        """GetModel used to get specific model details  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.models_store_get_model_with_http_info(project_id, model_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id: (required)
        :param str model_id: (required)
        :return: V1Model
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id', 'model_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError("Got an unexpected keyword argument '%s'"
                                " to method models_store_get_model" % key)
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or params['project_id'] is None):
            raise ValueError(
                "Missing the required parameter `project_id` when calling `models_store_get_model`"
            )  # noqa: E501
        # verify the required parameter 'model_id' is set
        if ('model_id' not in params or params['model_id'] is None):
            raise ValueError(
                "Missing the required parameter `model_id` when calling `models_store_get_model`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['projectId'] = params['project_id']  # noqa: E501
        if 'model_id' in params:
            path_params['modelId'] = params['model_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/projects/{projectId}/models/{modelId}',
            'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1Model',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def models_store_list_model_versions(
            self, project_id: 'str', model_id: 'str',
            **kwargs) -> 'V1ListModelVersionsResponse':  # noqa: E501
        """models_store_list_model_versions  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.models_store_list_model_versions(project_id, model_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id: (required)
        :param str model_id: (required)
        :return: V1ListModelVersionsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.models_store_list_model_versions_with_http_info(
                project_id, model_id, **kwargs)  # noqa: E501
        else:
            (data) = self.models_store_list_model_versions_with_http_info(
                project_id, model_id, **kwargs)  # noqa: E501
            return data

    def models_store_list_model_versions_with_http_info(
            self, project_id: 'str', model_id: 'str',
            **kwargs) -> 'V1ListModelVersionsResponse':  # noqa: E501
        """models_store_list_model_versions  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.models_store_list_model_versions_with_http_info(project_id, model_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id: (required)
        :param str model_id: (required)
        :return: V1ListModelVersionsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id', 'model_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError("Got an unexpected keyword argument '%s'"
                                " to method models_store_list_model_versions" %
                                key)
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or params['project_id'] is None):
            raise ValueError(
                "Missing the required parameter `project_id` when calling `models_store_list_model_versions`"
            )  # noqa: E501
        # verify the required parameter 'model_id' is set
        if ('model_id' not in params or params['model_id'] is None):
            raise ValueError(
                "Missing the required parameter `model_id` when calling `models_store_list_model_versions`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['projectId'] = params['project_id']  # noqa: E501
        if 'model_id' in params:
            path_params['modelId'] = params['model_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/projects/{projectId}/models/{modelId}/versions',
            'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1ListModelVersionsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def models_store_list_models(
            self, project_id: 'str',
            **kwargs) -> 'V1ListModelsResponse':  # noqa: E501
        """ListModels used to list all models that belong to the project  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.models_store_list_models(project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id: (required)
        :return: V1ListModelsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.models_store_list_models_with_http_info(
                project_id, **kwargs)  # noqa: E501
        else:
            (data) = self.models_store_list_models_with_http_info(
                project_id, **kwargs)  # noqa: E501
            return data

    def models_store_list_models_with_http_info(
            self, project_id: 'str',
            **kwargs) -> 'V1ListModelsResponse':  # noqa: E501
        """ListModels used to list all models that belong to the project  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.models_store_list_models_with_http_info(project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id: (required)
        :return: V1ListModelsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError("Got an unexpected keyword argument '%s'"
                                " to method models_store_list_models" % key)
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or params['project_id'] is None):
            raise ValueError(
                "Missing the required parameter `project_id` when calling `models_store_list_models`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['projectId'] = params['project_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/projects/{projectId}/models',
            'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1ListModelsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def models_store_upload_model(
            self, body: 'V1UploadModelRequest',
            **kwargs) -> 'V1UploadModelResponse':  # noqa: E501
        """UploadModel used to upload a new model version. It will either create a new top level model entry or reuse existing if an existing model is found. If version is not supplied, it will overwrite 'latest' version entry.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.models_store_upload_model(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param V1UploadModelRequest body: (required)
        :return: V1UploadModelResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.models_store_upload_model_with_http_info(
                body, **kwargs)  # noqa: E501
        else:
            (data) = self.models_store_upload_model_with_http_info(
                body, **kwargs)  # noqa: E501
            return data

    def models_store_upload_model_with_http_info(
            self, body: 'V1UploadModelRequest',
            **kwargs) -> 'V1UploadModelResponse':  # noqa: E501
        """UploadModel used to upload a new model version. It will either create a new top level model entry or reuse existing if an existing model is found. If version is not supplied, it will overwrite 'latest' version entry.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.models_store_upload_model_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param V1UploadModelRequest body: (required)
        :return: V1UploadModelResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError("Got an unexpected keyword argument '%s'"
                                " to method models_store_upload_model" % key)
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or params['body'] is None):
            raise ValueError(
                "Missing the required parameter `body` when calling `models_store_upload_model`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            'Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
                ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v1/models',
            'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1UploadModelResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
