"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import pw_software_update.tuf_pb2
import typing
import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor = ...

class UpdateBundle(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    class TargetsMetadataEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: typing.Text = ...
        @property
        def value(self) -> pw_software_update.tuf_pb2.SignedTargetsMetadata: ...
        def __init__(self,
            *,
            key : typing.Text = ...,
            value : typing.Optional[pw_software_update.tuf_pb2.SignedTargetsMetadata] = ...,
            ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal[u"value",b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal[u"key",b"key",u"value",b"value"]) -> None: ...

    class TargetPayloadsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: typing.Text = ...
        value: builtins.bytes = ...
        def __init__(self,
            *,
            key : typing.Text = ...,
            value : builtins.bytes = ...,
            ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal[u"key",b"key",u"value",b"value"]) -> None: ...

    TIMESTAMP_METADATA_FIELD_NUMBER: builtins.int
    SNAPSHOT_METADATA_FIELD_NUMBER: builtins.int
    TARGETS_METADATA_FIELD_NUMBER: builtins.int
    TARGET_PAYLOADS_FIELD_NUMBER: builtins.int
    ROOT_METADATA_FIELD_NUMBER: builtins.int
    # The timestamp role is used for freshness check of the snapshot. Any
    # project-specific update metadata should go in the top-level
    # targets_metadata or with the TargetFile information
    @property
    def timestamp_metadata(self) -> pw_software_update.tuf_pb2.SignedTimestampMetadata: ...
    # The snapshot role is used to ensure that the collection of targets_metadata
    # files is securely consistent (no target metadata mix and match). Any
    # project-specific update metadata should go in the top-level
    # targets_metadata or with the TargetFile information
    @property
    def snapshot_metadata(self) -> pw_software_update.tuf_pb2.SignedSnapshotMetadata: ...
    # Map of target metadata name to target metadata.
    # Target metadata name can be an arbitrary name or a path that describes
    # where the file lives relative to the base directory of the repository, as
    # described in the snapshot metadata. e.g. "path/to/target/0".
    @property
    def targets_metadata(self) -> google.protobuf.internal.containers.MessageMap[typing.Text, pw_software_update.tuf_pb2.SignedTargetsMetadata]: ...
    # Map of target file name to target payload bytes.
    # Target file name can be an arbitrary name or a path that describes where
    # the file lives relative to the base directory of the repository, as
    # described in the target metadata. e.g. "path/to/amber_tools/0".
    @property
    def target_payloads(self) -> google.protobuf.internal.containers.ScalarMap[typing.Text, builtins.bytes]: ...
    # If present, a client will attempt to upgrade its on-device trusted root
    # metadata to the root metadata included in the bundle, following the
    # standard "Update the root role" flow specified in the TUF spec, but
    # without "version climbing".
    #
    # The exact steps are:
    # 1. Check if there is a root metadata in the bundle.
    # 2. If the root metadata IS NOT included, assume on-device root metadata
    #    is up-to-date and continue with the rest of metadata verification.
    # 3. If the root metadata IS included, verify the new root metadata using
    #    the on-device root metadata.
    # 4. If the verification is successful, persist new root metadata and
    #    continue with the rest of metadata verification. Otherwise abort the
    #    update session.
    #
    # The key deviation from standard flow is the client assumes it can always
    # directly upgrade to the single new root metadata in the update bundle,
    # without any step-stone history root metadata. This works only because
    # we are not supporting (more than 1) root key rotations.
    @property
    def root_metadata(self) -> pw_software_update.tuf_pb2.SignedRootMetadata: ...
    def __init__(self,
        *,
        timestamp_metadata : typing.Optional[pw_software_update.tuf_pb2.SignedTimestampMetadata] = ...,
        snapshot_metadata : typing.Optional[pw_software_update.tuf_pb2.SignedSnapshotMetadata] = ...,
        targets_metadata : typing.Optional[typing.Mapping[typing.Text, pw_software_update.tuf_pb2.SignedTargetsMetadata]] = ...,
        target_payloads : typing.Optional[typing.Mapping[typing.Text, builtins.bytes]] = ...,
        root_metadata : typing.Optional[pw_software_update.tuf_pb2.SignedRootMetadata] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal[u"_root_metadata",b"_root_metadata",u"_snapshot_metadata",b"_snapshot_metadata",u"_timestamp_metadata",b"_timestamp_metadata",u"root_metadata",b"root_metadata",u"snapshot_metadata",b"snapshot_metadata",u"timestamp_metadata",b"timestamp_metadata"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal[u"_root_metadata",b"_root_metadata",u"_snapshot_metadata",b"_snapshot_metadata",u"_timestamp_metadata",b"_timestamp_metadata",u"root_metadata",b"root_metadata",u"snapshot_metadata",b"snapshot_metadata",u"target_payloads",b"target_payloads",u"targets_metadata",b"targets_metadata",u"timestamp_metadata",b"timestamp_metadata"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal[u"_root_metadata",b"_root_metadata"]) -> typing.Optional[typing_extensions.Literal["root_metadata"]]: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal[u"_snapshot_metadata",b"_snapshot_metadata"]) -> typing.Optional[typing_extensions.Literal["snapshot_metadata"]]: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal[u"_timestamp_metadata",b"_timestamp_metadata"]) -> typing.Optional[typing_extensions.Literal["timestamp_metadata"]]: ...
global___UpdateBundle = UpdateBundle

# Update bundle metadata
# Designed to inform the update server what the device currently has in-place.
# Also used to persist the TUF metadata for use in the verification process.
# Stored manifest is only written/erased by the update service. In all other
# contexts the stored manifest is considered read-only.
class Manifest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    class TargetsMetadataEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: typing.Text = ...
        @property
        def value(self) -> pw_software_update.tuf_pb2.TargetsMetadata: ...
        def __init__(self,
            *,
            key : typing.Text = ...,
            value : typing.Optional[pw_software_update.tuf_pb2.TargetsMetadata] = ...,
            ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal[u"value",b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal[u"key",b"key",u"value",b"value"]) -> None: ...

    TARGETS_METADATA_FIELD_NUMBER: builtins.int
    USER_MANIFEST_FIELD_NUMBER: builtins.int
    @property
    def targets_metadata(self) -> google.protobuf.internal.containers.MessageMap[typing.Text, pw_software_update.tuf_pb2.TargetsMetadata]: ...
    # Insert user manifest target file content here
    user_manifest: builtins.bytes = ...
    def __init__(self,
        *,
        targets_metadata : typing.Optional[typing.Mapping[typing.Text, pw_software_update.tuf_pb2.TargetsMetadata]] = ...,
        user_manifest : builtins.bytes = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal[u"_user_manifest",b"_user_manifest",u"user_manifest",b"user_manifest"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal[u"_user_manifest",b"_user_manifest",u"targets_metadata",b"targets_metadata",u"user_manifest",b"user_manifest"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal[u"_user_manifest",b"_user_manifest"]) -> typing.Optional[typing_extensions.Literal["user_manifest"]]: ...
global___Manifest = Manifest
