# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'CertificateApiPassthrough',
    'CertificateAuthorityAccessDescription',
    'CertificateAuthorityAccessMethod',
    'CertificateAuthorityCrlConfiguration',
    'CertificateAuthorityCsrExtensions',
    'CertificateAuthorityCustomAttribute',
    'CertificateAuthorityEdiPartyName',
    'CertificateAuthorityGeneralName',
    'CertificateAuthorityKeyUsage',
    'CertificateAuthorityOcspConfiguration',
    'CertificateAuthorityOtherName',
    'CertificateAuthorityRevocationConfiguration',
    'CertificateAuthoritySubject',
    'CertificateAuthorityTag',
    'CertificateCustomAttribute',
    'CertificateCustomExtension',
    'CertificateEdiPartyName',
    'CertificateExtendedKeyUsage',
    'CertificateExtensions',
    'CertificateGeneralName',
    'CertificateKeyUsage',
    'CertificateOtherName',
    'CertificatePolicyInformation',
    'CertificatePolicyQualifierInfo',
    'CertificateQualifier',
    'CertificateSubject',
    'CertificateValidity',
]

@pulumi.output_type
class CertificateApiPassthrough(dict):
    """
    Structure that specifies fields to be overridden in a certificate at the time of issuance. These requires an API Passthrough template be used or they will be ignored.
    """
    def __init__(__self__, *,
                 extensions: Optional['outputs.CertificateExtensions'] = None,
                 subject: Optional['outputs.CertificateSubject'] = None):
        """
        Structure that specifies fields to be overridden in a certificate at the time of issuance. These requires an API Passthrough template be used or they will be ignored.
        """
        if extensions is not None:
            pulumi.set(__self__, "extensions", extensions)
        if subject is not None:
            pulumi.set(__self__, "subject", subject)

    @property
    @pulumi.getter
    def extensions(self) -> Optional['outputs.CertificateExtensions']:
        return pulumi.get(self, "extensions")

    @property
    @pulumi.getter
    def subject(self) -> Optional['outputs.CertificateSubject']:
        return pulumi.get(self, "subject")


@pulumi.output_type
class CertificateAuthorityAccessDescription(dict):
    """
    Structure that contains X.509 AccessDescription information.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessLocation":
            suggest = "access_location"
        elif key == "accessMethod":
            suggest = "access_method"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateAuthorityAccessDescription. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateAuthorityAccessDescription.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateAuthorityAccessDescription.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_location: 'outputs.CertificateAuthorityGeneralName',
                 access_method: 'outputs.CertificateAuthorityAccessMethod'):
        """
        Structure that contains X.509 AccessDescription information.
        """
        pulumi.set(__self__, "access_location", access_location)
        pulumi.set(__self__, "access_method", access_method)

    @property
    @pulumi.getter(name="accessLocation")
    def access_location(self) -> 'outputs.CertificateAuthorityGeneralName':
        return pulumi.get(self, "access_location")

    @property
    @pulumi.getter(name="accessMethod")
    def access_method(self) -> 'outputs.CertificateAuthorityAccessMethod':
        return pulumi.get(self, "access_method")


@pulumi.output_type
class CertificateAuthorityAccessMethod(dict):
    """
    Structure that contains X.509 AccessMethod information. Assign one and ONLY one field.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessMethodType":
            suggest = "access_method_type"
        elif key == "customObjectIdentifier":
            suggest = "custom_object_identifier"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateAuthorityAccessMethod. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateAuthorityAccessMethod.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateAuthorityAccessMethod.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_method_type: Optional[str] = None,
                 custom_object_identifier: Optional[str] = None):
        """
        Structure that contains X.509 AccessMethod information. Assign one and ONLY one field.
        """
        if access_method_type is not None:
            pulumi.set(__self__, "access_method_type", access_method_type)
        if custom_object_identifier is not None:
            pulumi.set(__self__, "custom_object_identifier", custom_object_identifier)

    @property
    @pulumi.getter(name="accessMethodType")
    def access_method_type(self) -> Optional[str]:
        return pulumi.get(self, "access_method_type")

    @property
    @pulumi.getter(name="customObjectIdentifier")
    def custom_object_identifier(self) -> Optional[str]:
        return pulumi.get(self, "custom_object_identifier")


@pulumi.output_type
class CertificateAuthorityCrlConfiguration(dict):
    """
    Your certificate authority can create and maintain a certificate revocation list (CRL). A CRL contains information about certificates that have been revoked.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customCname":
            suggest = "custom_cname"
        elif key == "expirationInDays":
            suggest = "expiration_in_days"
        elif key == "s3BucketName":
            suggest = "s3_bucket_name"
        elif key == "s3ObjectAcl":
            suggest = "s3_object_acl"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateAuthorityCrlConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateAuthorityCrlConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateAuthorityCrlConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_cname: Optional[str] = None,
                 enabled: Optional[bool] = None,
                 expiration_in_days: Optional[int] = None,
                 s3_bucket_name: Optional[str] = None,
                 s3_object_acl: Optional[str] = None):
        """
        Your certificate authority can create and maintain a certificate revocation list (CRL). A CRL contains information about certificates that have been revoked.
        """
        if custom_cname is not None:
            pulumi.set(__self__, "custom_cname", custom_cname)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if expiration_in_days is not None:
            pulumi.set(__self__, "expiration_in_days", expiration_in_days)
        if s3_bucket_name is not None:
            pulumi.set(__self__, "s3_bucket_name", s3_bucket_name)
        if s3_object_acl is not None:
            pulumi.set(__self__, "s3_object_acl", s3_object_acl)

    @property
    @pulumi.getter(name="customCname")
    def custom_cname(self) -> Optional[str]:
        return pulumi.get(self, "custom_cname")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="expirationInDays")
    def expiration_in_days(self) -> Optional[int]:
        return pulumi.get(self, "expiration_in_days")

    @property
    @pulumi.getter(name="s3BucketName")
    def s3_bucket_name(self) -> Optional[str]:
        return pulumi.get(self, "s3_bucket_name")

    @property
    @pulumi.getter(name="s3ObjectAcl")
    def s3_object_acl(self) -> Optional[str]:
        return pulumi.get(self, "s3_object_acl")


@pulumi.output_type
class CertificateAuthorityCsrExtensions(dict):
    """
    Structure that contains CSR pass though extensions information.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyUsage":
            suggest = "key_usage"
        elif key == "subjectInformationAccess":
            suggest = "subject_information_access"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateAuthorityCsrExtensions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateAuthorityCsrExtensions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateAuthorityCsrExtensions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_usage: Optional['outputs.CertificateAuthorityKeyUsage'] = None,
                 subject_information_access: Optional[Sequence['outputs.CertificateAuthorityAccessDescription']] = None):
        """
        Structure that contains CSR pass though extensions information.
        """
        if key_usage is not None:
            pulumi.set(__self__, "key_usage", key_usage)
        if subject_information_access is not None:
            pulumi.set(__self__, "subject_information_access", subject_information_access)

    @property
    @pulumi.getter(name="keyUsage")
    def key_usage(self) -> Optional['outputs.CertificateAuthorityKeyUsage']:
        return pulumi.get(self, "key_usage")

    @property
    @pulumi.getter(name="subjectInformationAccess")
    def subject_information_access(self) -> Optional[Sequence['outputs.CertificateAuthorityAccessDescription']]:
        return pulumi.get(self, "subject_information_access")


@pulumi.output_type
class CertificateAuthorityCustomAttribute(dict):
    """
    Structure that contains X.500 attribute type and value.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectIdentifier":
            suggest = "object_identifier"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateAuthorityCustomAttribute. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateAuthorityCustomAttribute.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateAuthorityCustomAttribute.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 object_identifier: str,
                 value: str):
        """
        Structure that contains X.500 attribute type and value.
        """
        pulumi.set(__self__, "object_identifier", object_identifier)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="objectIdentifier")
    def object_identifier(self) -> str:
        return pulumi.get(self, "object_identifier")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class CertificateAuthorityEdiPartyName(dict):
    """
    Structure that contains X.509 EdiPartyName information.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nameAssigner":
            suggest = "name_assigner"
        elif key == "partyName":
            suggest = "party_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateAuthorityEdiPartyName. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateAuthorityEdiPartyName.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateAuthorityEdiPartyName.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name_assigner: str,
                 party_name: str):
        """
        Structure that contains X.509 EdiPartyName information.
        """
        pulumi.set(__self__, "name_assigner", name_assigner)
        pulumi.set(__self__, "party_name", party_name)

    @property
    @pulumi.getter(name="nameAssigner")
    def name_assigner(self) -> str:
        return pulumi.get(self, "name_assigner")

    @property
    @pulumi.getter(name="partyName")
    def party_name(self) -> str:
        return pulumi.get(self, "party_name")


@pulumi.output_type
class CertificateAuthorityGeneralName(dict):
    """
    Structure that contains X.509 GeneralName information. Assign one and ONLY one field.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "directoryName":
            suggest = "directory_name"
        elif key == "dnsName":
            suggest = "dns_name"
        elif key == "ediPartyName":
            suggest = "edi_party_name"
        elif key == "ipAddress":
            suggest = "ip_address"
        elif key == "otherName":
            suggest = "other_name"
        elif key == "registeredId":
            suggest = "registered_id"
        elif key == "rfc822Name":
            suggest = "rfc822_name"
        elif key == "uniformResourceIdentifier":
            suggest = "uniform_resource_identifier"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateAuthorityGeneralName. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateAuthorityGeneralName.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateAuthorityGeneralName.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 directory_name: Optional['outputs.CertificateAuthoritySubject'] = None,
                 dns_name: Optional[str] = None,
                 edi_party_name: Optional['outputs.CertificateAuthorityEdiPartyName'] = None,
                 ip_address: Optional[str] = None,
                 other_name: Optional['outputs.CertificateAuthorityOtherName'] = None,
                 registered_id: Optional[str] = None,
                 rfc822_name: Optional[str] = None,
                 uniform_resource_identifier: Optional[str] = None):
        """
        Structure that contains X.509 GeneralName information. Assign one and ONLY one field.
        """
        if directory_name is not None:
            pulumi.set(__self__, "directory_name", directory_name)
        if dns_name is not None:
            pulumi.set(__self__, "dns_name", dns_name)
        if edi_party_name is not None:
            pulumi.set(__self__, "edi_party_name", edi_party_name)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if other_name is not None:
            pulumi.set(__self__, "other_name", other_name)
        if registered_id is not None:
            pulumi.set(__self__, "registered_id", registered_id)
        if rfc822_name is not None:
            pulumi.set(__self__, "rfc822_name", rfc822_name)
        if uniform_resource_identifier is not None:
            pulumi.set(__self__, "uniform_resource_identifier", uniform_resource_identifier)

    @property
    @pulumi.getter(name="directoryName")
    def directory_name(self) -> Optional['outputs.CertificateAuthoritySubject']:
        return pulumi.get(self, "directory_name")

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> Optional[str]:
        return pulumi.get(self, "dns_name")

    @property
    @pulumi.getter(name="ediPartyName")
    def edi_party_name(self) -> Optional['outputs.CertificateAuthorityEdiPartyName']:
        return pulumi.get(self, "edi_party_name")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[str]:
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="otherName")
    def other_name(self) -> Optional['outputs.CertificateAuthorityOtherName']:
        return pulumi.get(self, "other_name")

    @property
    @pulumi.getter(name="registeredId")
    def registered_id(self) -> Optional[str]:
        return pulumi.get(self, "registered_id")

    @property
    @pulumi.getter(name="rfc822Name")
    def rfc822_name(self) -> Optional[str]:
        return pulumi.get(self, "rfc822_name")

    @property
    @pulumi.getter(name="uniformResourceIdentifier")
    def uniform_resource_identifier(self) -> Optional[str]:
        return pulumi.get(self, "uniform_resource_identifier")


@pulumi.output_type
class CertificateAuthorityKeyUsage(dict):
    """
    Structure that contains X.509 KeyUsage information.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cRLSign":
            suggest = "c_rl_sign"
        elif key == "dataEncipherment":
            suggest = "data_encipherment"
        elif key == "decipherOnly":
            suggest = "decipher_only"
        elif key == "digitalSignature":
            suggest = "digital_signature"
        elif key == "encipherOnly":
            suggest = "encipher_only"
        elif key == "keyAgreement":
            suggest = "key_agreement"
        elif key == "keyCertSign":
            suggest = "key_cert_sign"
        elif key == "keyEncipherment":
            suggest = "key_encipherment"
        elif key == "nonRepudiation":
            suggest = "non_repudiation"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateAuthorityKeyUsage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateAuthorityKeyUsage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateAuthorityKeyUsage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 c_rl_sign: Optional[bool] = None,
                 data_encipherment: Optional[bool] = None,
                 decipher_only: Optional[bool] = None,
                 digital_signature: Optional[bool] = None,
                 encipher_only: Optional[bool] = None,
                 key_agreement: Optional[bool] = None,
                 key_cert_sign: Optional[bool] = None,
                 key_encipherment: Optional[bool] = None,
                 non_repudiation: Optional[bool] = None):
        """
        Structure that contains X.509 KeyUsage information.
        """
        if c_rl_sign is not None:
            pulumi.set(__self__, "c_rl_sign", c_rl_sign)
        if data_encipherment is not None:
            pulumi.set(__self__, "data_encipherment", data_encipherment)
        if decipher_only is not None:
            pulumi.set(__self__, "decipher_only", decipher_only)
        if digital_signature is not None:
            pulumi.set(__self__, "digital_signature", digital_signature)
        if encipher_only is not None:
            pulumi.set(__self__, "encipher_only", encipher_only)
        if key_agreement is not None:
            pulumi.set(__self__, "key_agreement", key_agreement)
        if key_cert_sign is not None:
            pulumi.set(__self__, "key_cert_sign", key_cert_sign)
        if key_encipherment is not None:
            pulumi.set(__self__, "key_encipherment", key_encipherment)
        if non_repudiation is not None:
            pulumi.set(__self__, "non_repudiation", non_repudiation)

    @property
    @pulumi.getter(name="cRLSign")
    def c_rl_sign(self) -> Optional[bool]:
        return pulumi.get(self, "c_rl_sign")

    @property
    @pulumi.getter(name="dataEncipherment")
    def data_encipherment(self) -> Optional[bool]:
        return pulumi.get(self, "data_encipherment")

    @property
    @pulumi.getter(name="decipherOnly")
    def decipher_only(self) -> Optional[bool]:
        return pulumi.get(self, "decipher_only")

    @property
    @pulumi.getter(name="digitalSignature")
    def digital_signature(self) -> Optional[bool]:
        return pulumi.get(self, "digital_signature")

    @property
    @pulumi.getter(name="encipherOnly")
    def encipher_only(self) -> Optional[bool]:
        return pulumi.get(self, "encipher_only")

    @property
    @pulumi.getter(name="keyAgreement")
    def key_agreement(self) -> Optional[bool]:
        return pulumi.get(self, "key_agreement")

    @property
    @pulumi.getter(name="keyCertSign")
    def key_cert_sign(self) -> Optional[bool]:
        return pulumi.get(self, "key_cert_sign")

    @property
    @pulumi.getter(name="keyEncipherment")
    def key_encipherment(self) -> Optional[bool]:
        return pulumi.get(self, "key_encipherment")

    @property
    @pulumi.getter(name="nonRepudiation")
    def non_repudiation(self) -> Optional[bool]:
        return pulumi.get(self, "non_repudiation")


@pulumi.output_type
class CertificateAuthorityOcspConfiguration(dict):
    """
    Helps to configure online certificate status protocol (OCSP) responder for your certificate authority
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ocspCustomCname":
            suggest = "ocsp_custom_cname"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateAuthorityOcspConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateAuthorityOcspConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateAuthorityOcspConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[bool] = None,
                 ocsp_custom_cname: Optional[str] = None):
        """
        Helps to configure online certificate status protocol (OCSP) responder for your certificate authority
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if ocsp_custom_cname is not None:
            pulumi.set(__self__, "ocsp_custom_cname", ocsp_custom_cname)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="ocspCustomCname")
    def ocsp_custom_cname(self) -> Optional[str]:
        return pulumi.get(self, "ocsp_custom_cname")


@pulumi.output_type
class CertificateAuthorityOtherName(dict):
    """
    Structure that contains X.509 OtherName information.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "typeId":
            suggest = "type_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateAuthorityOtherName. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateAuthorityOtherName.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateAuthorityOtherName.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type_id: str,
                 value: str):
        """
        Structure that contains X.509 OtherName information.
        """
        pulumi.set(__self__, "type_id", type_id)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="typeId")
    def type_id(self) -> str:
        return pulumi.get(self, "type_id")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class CertificateAuthorityRevocationConfiguration(dict):
    """
    Certificate Authority revocation information.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "crlConfiguration":
            suggest = "crl_configuration"
        elif key == "ocspConfiguration":
            suggest = "ocsp_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateAuthorityRevocationConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateAuthorityRevocationConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateAuthorityRevocationConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 crl_configuration: Optional['outputs.CertificateAuthorityCrlConfiguration'] = None,
                 ocsp_configuration: Optional['outputs.CertificateAuthorityOcspConfiguration'] = None):
        """
        Certificate Authority revocation information.
        """
        if crl_configuration is not None:
            pulumi.set(__self__, "crl_configuration", crl_configuration)
        if ocsp_configuration is not None:
            pulumi.set(__self__, "ocsp_configuration", ocsp_configuration)

    @property
    @pulumi.getter(name="crlConfiguration")
    def crl_configuration(self) -> Optional['outputs.CertificateAuthorityCrlConfiguration']:
        return pulumi.get(self, "crl_configuration")

    @property
    @pulumi.getter(name="ocspConfiguration")
    def ocsp_configuration(self) -> Optional['outputs.CertificateAuthorityOcspConfiguration']:
        return pulumi.get(self, "ocsp_configuration")


@pulumi.output_type
class CertificateAuthoritySubject(dict):
    """
    Structure that contains X.500 distinguished name information for your CA.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "commonName":
            suggest = "common_name"
        elif key == "customAttributes":
            suggest = "custom_attributes"
        elif key == "distinguishedNameQualifier":
            suggest = "distinguished_name_qualifier"
        elif key == "generationQualifier":
            suggest = "generation_qualifier"
        elif key == "givenName":
            suggest = "given_name"
        elif key == "organizationalUnit":
            suggest = "organizational_unit"
        elif key == "serialNumber":
            suggest = "serial_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateAuthoritySubject. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateAuthoritySubject.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateAuthoritySubject.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 common_name: Optional[str] = None,
                 country: Optional[str] = None,
                 custom_attributes: Optional[Sequence['outputs.CertificateAuthorityCustomAttribute']] = None,
                 distinguished_name_qualifier: Optional[str] = None,
                 generation_qualifier: Optional[str] = None,
                 given_name: Optional[str] = None,
                 initials: Optional[str] = None,
                 locality: Optional[str] = None,
                 organization: Optional[str] = None,
                 organizational_unit: Optional[str] = None,
                 pseudonym: Optional[str] = None,
                 serial_number: Optional[str] = None,
                 state: Optional[str] = None,
                 surname: Optional[str] = None,
                 title: Optional[str] = None):
        """
        Structure that contains X.500 distinguished name information for your CA.
        """
        if common_name is not None:
            pulumi.set(__self__, "common_name", common_name)
        if country is not None:
            pulumi.set(__self__, "country", country)
        if custom_attributes is not None:
            pulumi.set(__self__, "custom_attributes", custom_attributes)
        if distinguished_name_qualifier is not None:
            pulumi.set(__self__, "distinguished_name_qualifier", distinguished_name_qualifier)
        if generation_qualifier is not None:
            pulumi.set(__self__, "generation_qualifier", generation_qualifier)
        if given_name is not None:
            pulumi.set(__self__, "given_name", given_name)
        if initials is not None:
            pulumi.set(__self__, "initials", initials)
        if locality is not None:
            pulumi.set(__self__, "locality", locality)
        if organization is not None:
            pulumi.set(__self__, "organization", organization)
        if organizational_unit is not None:
            pulumi.set(__self__, "organizational_unit", organizational_unit)
        if pseudonym is not None:
            pulumi.set(__self__, "pseudonym", pseudonym)
        if serial_number is not None:
            pulumi.set(__self__, "serial_number", serial_number)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if surname is not None:
            pulumi.set(__self__, "surname", surname)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter(name="commonName")
    def common_name(self) -> Optional[str]:
        return pulumi.get(self, "common_name")

    @property
    @pulumi.getter
    def country(self) -> Optional[str]:
        return pulumi.get(self, "country")

    @property
    @pulumi.getter(name="customAttributes")
    def custom_attributes(self) -> Optional[Sequence['outputs.CertificateAuthorityCustomAttribute']]:
        return pulumi.get(self, "custom_attributes")

    @property
    @pulumi.getter(name="distinguishedNameQualifier")
    def distinguished_name_qualifier(self) -> Optional[str]:
        return pulumi.get(self, "distinguished_name_qualifier")

    @property
    @pulumi.getter(name="generationQualifier")
    def generation_qualifier(self) -> Optional[str]:
        return pulumi.get(self, "generation_qualifier")

    @property
    @pulumi.getter(name="givenName")
    def given_name(self) -> Optional[str]:
        return pulumi.get(self, "given_name")

    @property
    @pulumi.getter
    def initials(self) -> Optional[str]:
        return pulumi.get(self, "initials")

    @property
    @pulumi.getter
    def locality(self) -> Optional[str]:
        return pulumi.get(self, "locality")

    @property
    @pulumi.getter
    def organization(self) -> Optional[str]:
        return pulumi.get(self, "organization")

    @property
    @pulumi.getter(name="organizationalUnit")
    def organizational_unit(self) -> Optional[str]:
        return pulumi.get(self, "organizational_unit")

    @property
    @pulumi.getter
    def pseudonym(self) -> Optional[str]:
        return pulumi.get(self, "pseudonym")

    @property
    @pulumi.getter(name="serialNumber")
    def serial_number(self) -> Optional[str]:
        return pulumi.get(self, "serial_number")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def surname(self) -> Optional[str]:
        return pulumi.get(self, "surname")

    @property
    @pulumi.getter
    def title(self) -> Optional[str]:
        return pulumi.get(self, "title")


@pulumi.output_type
class CertificateAuthorityTag(dict):
    def __init__(__self__, *,
                 key: Optional[str] = None,
                 value: Optional[str] = None):
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        return pulumi.get(self, "value")


@pulumi.output_type
class CertificateCustomAttribute(dict):
    """
    Structure that contains X.500 attribute type and value.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectIdentifier":
            suggest = "object_identifier"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateCustomAttribute. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateCustomAttribute.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateCustomAttribute.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 object_identifier: str,
                 value: str):
        """
        Structure that contains X.500 attribute type and value.
        """
        pulumi.set(__self__, "object_identifier", object_identifier)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="objectIdentifier")
    def object_identifier(self) -> str:
        return pulumi.get(self, "object_identifier")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class CertificateCustomExtension(dict):
    """
    Structure that contains X.509 extension information for a certificate.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectIdentifier":
            suggest = "object_identifier"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateCustomExtension. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateCustomExtension.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateCustomExtension.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 object_identifier: str,
                 value: str,
                 critical: Optional[bool] = None):
        """
        Structure that contains X.509 extension information for a certificate.
        """
        pulumi.set(__self__, "object_identifier", object_identifier)
        pulumi.set(__self__, "value", value)
        if critical is not None:
            pulumi.set(__self__, "critical", critical)

    @property
    @pulumi.getter(name="objectIdentifier")
    def object_identifier(self) -> str:
        return pulumi.get(self, "object_identifier")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def critical(self) -> Optional[bool]:
        return pulumi.get(self, "critical")


@pulumi.output_type
class CertificateEdiPartyName(dict):
    """
    Structure that contains X.509 EdiPartyName information.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nameAssigner":
            suggest = "name_assigner"
        elif key == "partyName":
            suggest = "party_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateEdiPartyName. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateEdiPartyName.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateEdiPartyName.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name_assigner: str,
                 party_name: str):
        """
        Structure that contains X.509 EdiPartyName information.
        """
        pulumi.set(__self__, "name_assigner", name_assigner)
        pulumi.set(__self__, "party_name", party_name)

    @property
    @pulumi.getter(name="nameAssigner")
    def name_assigner(self) -> str:
        return pulumi.get(self, "name_assigner")

    @property
    @pulumi.getter(name="partyName")
    def party_name(self) -> str:
        return pulumi.get(self, "party_name")


@pulumi.output_type
class CertificateExtendedKeyUsage(dict):
    """
    Structure that contains X.509 ExtendedKeyUsage information.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "extendedKeyUsageObjectIdentifier":
            suggest = "extended_key_usage_object_identifier"
        elif key == "extendedKeyUsageType":
            suggest = "extended_key_usage_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateExtendedKeyUsage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateExtendedKeyUsage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateExtendedKeyUsage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 extended_key_usage_object_identifier: Optional[str] = None,
                 extended_key_usage_type: Optional[str] = None):
        """
        Structure that contains X.509 ExtendedKeyUsage information.
        """
        if extended_key_usage_object_identifier is not None:
            pulumi.set(__self__, "extended_key_usage_object_identifier", extended_key_usage_object_identifier)
        if extended_key_usage_type is not None:
            pulumi.set(__self__, "extended_key_usage_type", extended_key_usage_type)

    @property
    @pulumi.getter(name="extendedKeyUsageObjectIdentifier")
    def extended_key_usage_object_identifier(self) -> Optional[str]:
        return pulumi.get(self, "extended_key_usage_object_identifier")

    @property
    @pulumi.getter(name="extendedKeyUsageType")
    def extended_key_usage_type(self) -> Optional[str]:
        return pulumi.get(self, "extended_key_usage_type")


@pulumi.output_type
class CertificateExtensions(dict):
    """
    Structure that contains X.500 extensions for a Certificate.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificatePolicies":
            suggest = "certificate_policies"
        elif key == "customExtensions":
            suggest = "custom_extensions"
        elif key == "extendedKeyUsage":
            suggest = "extended_key_usage"
        elif key == "keyUsage":
            suggest = "key_usage"
        elif key == "subjectAlternativeNames":
            suggest = "subject_alternative_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateExtensions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateExtensions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateExtensions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_policies: Optional[Sequence['outputs.CertificatePolicyInformation']] = None,
                 custom_extensions: Optional[Sequence['outputs.CertificateCustomExtension']] = None,
                 extended_key_usage: Optional[Sequence['outputs.CertificateExtendedKeyUsage']] = None,
                 key_usage: Optional['outputs.CertificateKeyUsage'] = None,
                 subject_alternative_names: Optional[Sequence['outputs.CertificateGeneralName']] = None):
        """
        Structure that contains X.500 extensions for a Certificate.
        """
        if certificate_policies is not None:
            pulumi.set(__self__, "certificate_policies", certificate_policies)
        if custom_extensions is not None:
            pulumi.set(__self__, "custom_extensions", custom_extensions)
        if extended_key_usage is not None:
            pulumi.set(__self__, "extended_key_usage", extended_key_usage)
        if key_usage is not None:
            pulumi.set(__self__, "key_usage", key_usage)
        if subject_alternative_names is not None:
            pulumi.set(__self__, "subject_alternative_names", subject_alternative_names)

    @property
    @pulumi.getter(name="certificatePolicies")
    def certificate_policies(self) -> Optional[Sequence['outputs.CertificatePolicyInformation']]:
        return pulumi.get(self, "certificate_policies")

    @property
    @pulumi.getter(name="customExtensions")
    def custom_extensions(self) -> Optional[Sequence['outputs.CertificateCustomExtension']]:
        return pulumi.get(self, "custom_extensions")

    @property
    @pulumi.getter(name="extendedKeyUsage")
    def extended_key_usage(self) -> Optional[Sequence['outputs.CertificateExtendedKeyUsage']]:
        return pulumi.get(self, "extended_key_usage")

    @property
    @pulumi.getter(name="keyUsage")
    def key_usage(self) -> Optional['outputs.CertificateKeyUsage']:
        return pulumi.get(self, "key_usage")

    @property
    @pulumi.getter(name="subjectAlternativeNames")
    def subject_alternative_names(self) -> Optional[Sequence['outputs.CertificateGeneralName']]:
        return pulumi.get(self, "subject_alternative_names")


@pulumi.output_type
class CertificateGeneralName(dict):
    """
    Structure that contains X.509 GeneralName information. Assign one and ONLY one field.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "directoryName":
            suggest = "directory_name"
        elif key == "dnsName":
            suggest = "dns_name"
        elif key == "ediPartyName":
            suggest = "edi_party_name"
        elif key == "ipAddress":
            suggest = "ip_address"
        elif key == "otherName":
            suggest = "other_name"
        elif key == "registeredId":
            suggest = "registered_id"
        elif key == "rfc822Name":
            suggest = "rfc822_name"
        elif key == "uniformResourceIdentifier":
            suggest = "uniform_resource_identifier"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateGeneralName. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateGeneralName.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateGeneralName.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 directory_name: Optional['outputs.CertificateSubject'] = None,
                 dns_name: Optional[str] = None,
                 edi_party_name: Optional['outputs.CertificateEdiPartyName'] = None,
                 ip_address: Optional[str] = None,
                 other_name: Optional['outputs.CertificateOtherName'] = None,
                 registered_id: Optional[str] = None,
                 rfc822_name: Optional[str] = None,
                 uniform_resource_identifier: Optional[str] = None):
        """
        Structure that contains X.509 GeneralName information. Assign one and ONLY one field.
        """
        if directory_name is not None:
            pulumi.set(__self__, "directory_name", directory_name)
        if dns_name is not None:
            pulumi.set(__self__, "dns_name", dns_name)
        if edi_party_name is not None:
            pulumi.set(__self__, "edi_party_name", edi_party_name)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if other_name is not None:
            pulumi.set(__self__, "other_name", other_name)
        if registered_id is not None:
            pulumi.set(__self__, "registered_id", registered_id)
        if rfc822_name is not None:
            pulumi.set(__self__, "rfc822_name", rfc822_name)
        if uniform_resource_identifier is not None:
            pulumi.set(__self__, "uniform_resource_identifier", uniform_resource_identifier)

    @property
    @pulumi.getter(name="directoryName")
    def directory_name(self) -> Optional['outputs.CertificateSubject']:
        return pulumi.get(self, "directory_name")

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> Optional[str]:
        return pulumi.get(self, "dns_name")

    @property
    @pulumi.getter(name="ediPartyName")
    def edi_party_name(self) -> Optional['outputs.CertificateEdiPartyName']:
        return pulumi.get(self, "edi_party_name")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[str]:
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="otherName")
    def other_name(self) -> Optional['outputs.CertificateOtherName']:
        return pulumi.get(self, "other_name")

    @property
    @pulumi.getter(name="registeredId")
    def registered_id(self) -> Optional[str]:
        return pulumi.get(self, "registered_id")

    @property
    @pulumi.getter(name="rfc822Name")
    def rfc822_name(self) -> Optional[str]:
        return pulumi.get(self, "rfc822_name")

    @property
    @pulumi.getter(name="uniformResourceIdentifier")
    def uniform_resource_identifier(self) -> Optional[str]:
        return pulumi.get(self, "uniform_resource_identifier")


@pulumi.output_type
class CertificateKeyUsage(dict):
    """
    Structure that contains X.509 KeyUsage information.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cRLSign":
            suggest = "c_rl_sign"
        elif key == "dataEncipherment":
            suggest = "data_encipherment"
        elif key == "decipherOnly":
            suggest = "decipher_only"
        elif key == "digitalSignature":
            suggest = "digital_signature"
        elif key == "encipherOnly":
            suggest = "encipher_only"
        elif key == "keyAgreement":
            suggest = "key_agreement"
        elif key == "keyCertSign":
            suggest = "key_cert_sign"
        elif key == "keyEncipherment":
            suggest = "key_encipherment"
        elif key == "nonRepudiation":
            suggest = "non_repudiation"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateKeyUsage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateKeyUsage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateKeyUsage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 c_rl_sign: Optional[bool] = None,
                 data_encipherment: Optional[bool] = None,
                 decipher_only: Optional[bool] = None,
                 digital_signature: Optional[bool] = None,
                 encipher_only: Optional[bool] = None,
                 key_agreement: Optional[bool] = None,
                 key_cert_sign: Optional[bool] = None,
                 key_encipherment: Optional[bool] = None,
                 non_repudiation: Optional[bool] = None):
        """
        Structure that contains X.509 KeyUsage information.
        """
        if c_rl_sign is not None:
            pulumi.set(__self__, "c_rl_sign", c_rl_sign)
        if data_encipherment is not None:
            pulumi.set(__self__, "data_encipherment", data_encipherment)
        if decipher_only is not None:
            pulumi.set(__self__, "decipher_only", decipher_only)
        if digital_signature is not None:
            pulumi.set(__self__, "digital_signature", digital_signature)
        if encipher_only is not None:
            pulumi.set(__self__, "encipher_only", encipher_only)
        if key_agreement is not None:
            pulumi.set(__self__, "key_agreement", key_agreement)
        if key_cert_sign is not None:
            pulumi.set(__self__, "key_cert_sign", key_cert_sign)
        if key_encipherment is not None:
            pulumi.set(__self__, "key_encipherment", key_encipherment)
        if non_repudiation is not None:
            pulumi.set(__self__, "non_repudiation", non_repudiation)

    @property
    @pulumi.getter(name="cRLSign")
    def c_rl_sign(self) -> Optional[bool]:
        return pulumi.get(self, "c_rl_sign")

    @property
    @pulumi.getter(name="dataEncipherment")
    def data_encipherment(self) -> Optional[bool]:
        return pulumi.get(self, "data_encipherment")

    @property
    @pulumi.getter(name="decipherOnly")
    def decipher_only(self) -> Optional[bool]:
        return pulumi.get(self, "decipher_only")

    @property
    @pulumi.getter(name="digitalSignature")
    def digital_signature(self) -> Optional[bool]:
        return pulumi.get(self, "digital_signature")

    @property
    @pulumi.getter(name="encipherOnly")
    def encipher_only(self) -> Optional[bool]:
        return pulumi.get(self, "encipher_only")

    @property
    @pulumi.getter(name="keyAgreement")
    def key_agreement(self) -> Optional[bool]:
        return pulumi.get(self, "key_agreement")

    @property
    @pulumi.getter(name="keyCertSign")
    def key_cert_sign(self) -> Optional[bool]:
        return pulumi.get(self, "key_cert_sign")

    @property
    @pulumi.getter(name="keyEncipherment")
    def key_encipherment(self) -> Optional[bool]:
        return pulumi.get(self, "key_encipherment")

    @property
    @pulumi.getter(name="nonRepudiation")
    def non_repudiation(self) -> Optional[bool]:
        return pulumi.get(self, "non_repudiation")


@pulumi.output_type
class CertificateOtherName(dict):
    """
    Structure that contains X.509 OtherName information.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "typeId":
            suggest = "type_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateOtherName. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateOtherName.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateOtherName.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type_id: str,
                 value: str):
        """
        Structure that contains X.509 OtherName information.
        """
        pulumi.set(__self__, "type_id", type_id)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="typeId")
    def type_id(self) -> str:
        return pulumi.get(self, "type_id")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class CertificatePolicyInformation(dict):
    """
    Structure that contains X.509 Policy information.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certPolicyId":
            suggest = "cert_policy_id"
        elif key == "policyQualifiers":
            suggest = "policy_qualifiers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificatePolicyInformation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificatePolicyInformation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificatePolicyInformation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cert_policy_id: str,
                 policy_qualifiers: Optional[Sequence['outputs.CertificatePolicyQualifierInfo']] = None):
        """
        Structure that contains X.509 Policy information.
        """
        pulumi.set(__self__, "cert_policy_id", cert_policy_id)
        if policy_qualifiers is not None:
            pulumi.set(__self__, "policy_qualifiers", policy_qualifiers)

    @property
    @pulumi.getter(name="certPolicyId")
    def cert_policy_id(self) -> str:
        return pulumi.get(self, "cert_policy_id")

    @property
    @pulumi.getter(name="policyQualifiers")
    def policy_qualifiers(self) -> Optional[Sequence['outputs.CertificatePolicyQualifierInfo']]:
        return pulumi.get(self, "policy_qualifiers")


@pulumi.output_type
class CertificatePolicyQualifierInfo(dict):
    """
    Structure that contains X.509 Policy qualifier information.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "policyQualifierId":
            suggest = "policy_qualifier_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificatePolicyQualifierInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificatePolicyQualifierInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificatePolicyQualifierInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 policy_qualifier_id: str,
                 qualifier: 'outputs.CertificateQualifier'):
        """
        Structure that contains X.509 Policy qualifier information.
        """
        pulumi.set(__self__, "policy_qualifier_id", policy_qualifier_id)
        pulumi.set(__self__, "qualifier", qualifier)

    @property
    @pulumi.getter(name="policyQualifierId")
    def policy_qualifier_id(self) -> str:
        return pulumi.get(self, "policy_qualifier_id")

    @property
    @pulumi.getter
    def qualifier(self) -> 'outputs.CertificateQualifier':
        return pulumi.get(self, "qualifier")


@pulumi.output_type
class CertificateQualifier(dict):
    """
    Structure that contains a X.509 policy qualifier.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpsUri":
            suggest = "cps_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateQualifier. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateQualifier.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateQualifier.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cps_uri: str):
        """
        Structure that contains a X.509 policy qualifier.
        """
        pulumi.set(__self__, "cps_uri", cps_uri)

    @property
    @pulumi.getter(name="cpsUri")
    def cps_uri(self) -> str:
        return pulumi.get(self, "cps_uri")


@pulumi.output_type
class CertificateSubject(dict):
    """
    Structure that contains X.500 distinguished name information.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "commonName":
            suggest = "common_name"
        elif key == "customAttributes":
            suggest = "custom_attributes"
        elif key == "distinguishedNameQualifier":
            suggest = "distinguished_name_qualifier"
        elif key == "generationQualifier":
            suggest = "generation_qualifier"
        elif key == "givenName":
            suggest = "given_name"
        elif key == "organizationalUnit":
            suggest = "organizational_unit"
        elif key == "serialNumber":
            suggest = "serial_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateSubject. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateSubject.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateSubject.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 common_name: Optional[str] = None,
                 country: Optional[str] = None,
                 custom_attributes: Optional[Sequence['outputs.CertificateCustomAttribute']] = None,
                 distinguished_name_qualifier: Optional[str] = None,
                 generation_qualifier: Optional[str] = None,
                 given_name: Optional[str] = None,
                 initials: Optional[str] = None,
                 locality: Optional[str] = None,
                 organization: Optional[str] = None,
                 organizational_unit: Optional[str] = None,
                 pseudonym: Optional[str] = None,
                 serial_number: Optional[str] = None,
                 state: Optional[str] = None,
                 surname: Optional[str] = None,
                 title: Optional[str] = None):
        """
        Structure that contains X.500 distinguished name information.
        """
        if common_name is not None:
            pulumi.set(__self__, "common_name", common_name)
        if country is not None:
            pulumi.set(__self__, "country", country)
        if custom_attributes is not None:
            pulumi.set(__self__, "custom_attributes", custom_attributes)
        if distinguished_name_qualifier is not None:
            pulumi.set(__self__, "distinguished_name_qualifier", distinguished_name_qualifier)
        if generation_qualifier is not None:
            pulumi.set(__self__, "generation_qualifier", generation_qualifier)
        if given_name is not None:
            pulumi.set(__self__, "given_name", given_name)
        if initials is not None:
            pulumi.set(__self__, "initials", initials)
        if locality is not None:
            pulumi.set(__self__, "locality", locality)
        if organization is not None:
            pulumi.set(__self__, "organization", organization)
        if organizational_unit is not None:
            pulumi.set(__self__, "organizational_unit", organizational_unit)
        if pseudonym is not None:
            pulumi.set(__self__, "pseudonym", pseudonym)
        if serial_number is not None:
            pulumi.set(__self__, "serial_number", serial_number)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if surname is not None:
            pulumi.set(__self__, "surname", surname)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter(name="commonName")
    def common_name(self) -> Optional[str]:
        return pulumi.get(self, "common_name")

    @property
    @pulumi.getter
    def country(self) -> Optional[str]:
        return pulumi.get(self, "country")

    @property
    @pulumi.getter(name="customAttributes")
    def custom_attributes(self) -> Optional[Sequence['outputs.CertificateCustomAttribute']]:
        return pulumi.get(self, "custom_attributes")

    @property
    @pulumi.getter(name="distinguishedNameQualifier")
    def distinguished_name_qualifier(self) -> Optional[str]:
        return pulumi.get(self, "distinguished_name_qualifier")

    @property
    @pulumi.getter(name="generationQualifier")
    def generation_qualifier(self) -> Optional[str]:
        return pulumi.get(self, "generation_qualifier")

    @property
    @pulumi.getter(name="givenName")
    def given_name(self) -> Optional[str]:
        return pulumi.get(self, "given_name")

    @property
    @pulumi.getter
    def initials(self) -> Optional[str]:
        return pulumi.get(self, "initials")

    @property
    @pulumi.getter
    def locality(self) -> Optional[str]:
        return pulumi.get(self, "locality")

    @property
    @pulumi.getter
    def organization(self) -> Optional[str]:
        return pulumi.get(self, "organization")

    @property
    @pulumi.getter(name="organizationalUnit")
    def organizational_unit(self) -> Optional[str]:
        return pulumi.get(self, "organizational_unit")

    @property
    @pulumi.getter
    def pseudonym(self) -> Optional[str]:
        return pulumi.get(self, "pseudonym")

    @property
    @pulumi.getter(name="serialNumber")
    def serial_number(self) -> Optional[str]:
        return pulumi.get(self, "serial_number")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def surname(self) -> Optional[str]:
        return pulumi.get(self, "surname")

    @property
    @pulumi.getter
    def title(self) -> Optional[str]:
        return pulumi.get(self, "title")


@pulumi.output_type
class CertificateValidity(dict):
    """
    Validity for a certificate.
    """
    def __init__(__self__, *,
                 type: str,
                 value: float):
        """
        Validity for a certificate.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> float:
        return pulumi.get(self, "value")


