# coding: utf-8
"""
Data source: Dutour Sikirić, Mathieu, Olaf Delgado-Friedrichs, and Michel Deza. “Space Fullerenes: a Computer Search for New Frank-Kasper Structures” Acta Crystallographica Section A Foundations of Crystallography 66.Pt 5 (2010): 602–615.

Cage composition:
 (12,14,15,16) = (40,12,24,4,)
"""

pairs="""
324 373
254 328
430 439
26 90
301 78
227 129
270 141
444 262
453 275
250 16
386 171
89 132
179 9
294 385
414 235
343 270
196 265
284 168
12 53
435 138
392 128
25 115
194 137
371 34
89 321
166 106
230 155
437 16
176 63
69 168
335 202
119 159
288 88
430 272
65 45
333 213
138 257
94 162
375 85
259 441
391 182
365 393
173 143
119 385
226 292
27 134
227 77
378 422
164 38
226 435
226 434
271 143
86 191
51 298
140 345
111 58
194 377
229 321
51 16
145 144
453 410
384 382
19 23
72 273
56 332
21 257
103 269
122 406
242 423
391 21
392 25
235 424
135 181
297 96
420 200
439 245
409 100
70 292
92 91
379 455
369 63
366 348
270 224
62 295
84 11
248 285
357 302
244 92
68 184
156 410
318 224
17 70
186 388
225 212
357 22
339 421
43 282
166 415
171 361
214 390
363 85
120 8
142 197
367 407
20 268
156 440
256 13
14 254
333 50
384 438
251 411
248 42
59 84
348 185
253 410
150 38
182 155
284 49
313 22
389 88
183 318
323 0
337 268
123 53
6 186
83 434
188 255
283 127
218 64
5 439
414 230
192 443
170 147
216 411
201 0
123 321
89 390
403 398
56 347
259 393
242 250
251 154
326 117
220 398
160 53
438 374
328 45
417 163
174 336
380 352
203 108
60 212
332 8
258 11
444 186
381 274
313 107
422 62
259 434
173 78
293 159
360 291
405 72
451 448
168 163
448 453
28 272
81 438
291 263
170 425
298 23
451 436
166 48
217 209
413 54
189 276
175 217
60 91
337 364
355 77
392 176
183 310
288 141
372 216
315 158
343 52
118 397
56 300
145 398
452 395
161 42
399 319
126 75
253 400
189 68
320 91
147 411
86 328
408 424
275 31
194 418
202 279
189 53
283 402
34 433
9 274
293 285
58 181
223 310
154 299
67 211
292 393
126 114
241 47
338 178
320 64
30 287
301 38
252 32
354 97
169 228
133 395
193 104
345 306
149 365
445 318
76 161
327 92
357 233
307 219
243 381
221 129
165 147
361 381
181 252
242 122
301 98
247 359
273 311
201 110
387 158
280 331
21 211
73 137
441 290
255 214
404 317
266 167
446 370
330 100
170 265
330 101
276 423
50 43
34 106
74 336
185 114
290 83
74 257
197 32
109 315
404 197
136 397
359 285
236 286
79 312
319 33
389 274
446 394
329 426
224 383
137 45
213 385
289 110
316 436
82 324
299 31
219 293
227 217
238 347
425 281
81 228
241 298
262 299
106 32
21 399
329 278
160 58
304 205
80 292
125 411
73 349
350 112
381 41
218 387
151 345
323 379
4 393
237 420
237 419
20 174
122 41
447 245
97 192
395 199
227 304
151 385
155 131
213 282
154 133
230 103
182 82
286 188
180 164
229 258
379 1
215 332
329 13
49 275
17 225
449 46
237 293
216 265
134 38
71 124
69 341
401 35
369 361
26 178
193 447
390 285
148 43
370 407
18 55
145 41
222 117
167 95
256 37
15 85
132 157
191 208
420 272
454 376
404 167
371 199
80 222
15 261
116 400
313 3
295 158
76 68
109 439
57 317
440 442
234 22
308 186
97 224
28 42
406 312
143 167
39 245
69 442
267 352
345 159
308 380
416 47
221 75
222 75
152 326
421 138
419 139
31 395
324 92
255 455
256 90
363 59
303 366
234 266
113 88
72 172
198 45
236 132
289 437
231 238
261 96
284 162
260 306
302 107
16 1
81 397
118 66
416 144
189 23
266 352
72 322
82 17
277 8
71 161
413 370
128 139
342 60
391 435
204 387
61 415
123 48
201 440
433 168
378 66
333 9
371 40
122 246
260 379
251 162
391 70
338 55
59 12
130 344
124 178
406 350
405 373
172 348
74 268
403 176
342 97
383 50
129 225
71 419
249 162
277 347
192 50
340 450
136 182
386 63
188 61
141 13
449 305
374 399
94 163
313 152
28 254
142 143
396 428
447 28
365 239
226 331
244 364
135 157
310 232
102 90
30 396
247 30
300 328
344 101
52 294
37 184
67 190
18 356
312 279
363 206
427 98
107 368
15 401
49 267
89 120
367 185
17 75
210 134
377 294
35 358
353 450
234 271
244 29
24 305
220 240
26 254
202 55
130 355
338 102
301 424
7 4
389 2
448 442
253 31
5 413
140 113
304 104
25 106
140 51
417 199
65 418
280 3
151 356
118 387
451 296
193 332
353 344
334 400
111 206
429 273
215 412
445 64
441 149
7 446
255 362
18 361
238 419
160 115
125 429
266 3
346 316
86 272
409 218
243 179
365 446
334 264
169 177
416 263
384 394
183 450
131 397
20 378
297 410
180 258
335 121
190 198
432 127
198 77
246 279
190 4
57 32
340 101
165 303
420 208
200 282
211 33
136 399
39 195
69 0
130 394
210 263
269 233
39 127
260 153
310 383
179 349
205 109
290 36
307 455
277 132
325 327
114 431
209 295
302 438
76 426
6 421
93 78
270 402
296 177
274 287
280 95
342 204
105 22
380 265
220 10
372 93
344 148
289 112
451 24
386 128
160 121
170 366
253 316
249 216
103 421
176 371
52 418
113 250
401 98
125 105
59 454
358 305
277 279
249 267
111 263
113 13
191 104
87 334
427 436
150 11
142 133
91 432
340 445
173 429
353 200
178 300
112 11
29 138
396 282
7 355
136 204
2 41
343 14
5 195
74 374
453 388
81 314
346 269
323 40
174 368
384 239
372 322
426 276
317 146
444 275
238 208
1 10
405 358
26 161
18 187
19 291
278 8
335 187
406 144
171 287
339 449
349 377
354 137
57 376
242 329
307 390
70 190
127 212
234 262
19 12
146 93
149 407
380 36
36 368
87 210
426 120
445 33
314 303
259 327
408 311
413 315
194 192
141 412
351 44
203 146
264 99
314 62
179 412
223 359
338 349
99 375
149 368
261 46
221 209
337 218
123 454
452 49
103 207
109 450
235 207
303 117
331 152
78 108
175 205
304 245
203 309
165 105
135 286
225 198
318 52
357 228
102 294
119 200
82 60
251 296
288 383
79 416
101 319
54 295
6 233
334 341
354 212
229 350
409 315
372 429
388 339
102 356
356 37
281 24
15 317
405 414
134 206
30 231
145 369
165 228
351 66
195 431
437 423
96 424
142 108
99 98
375 440
187 184
27 156
351 281
337 66
233 262
455 415
343 90
47 187
125 271
73 215
83 46
229 157
283 447
284 448
220 341
14 65
340 409
362 398
210 116
425 308
392 286
278 412
241 153
360 40
196 322
169 269
150 99
61 163
373 44
204 443
326 273
236 214
221 431
314 382
403 417
73 300
94 133
39 129
126 324
24 388
244 44
362 1
362 2
330 374
247 389
418 33
312 157
54 431
441 185
289 10
370 100
307 48
67 65
14 283
29 434
175 148
188 403
408 95
320 364
316 207
87 150
6 336
400 199
130 217
276 321
364 257
297 207
174 308
164 108
80 239
213 287
110 84
35 322
135 180
223 88
25 181
215 402
154 271
2 250
404 267
105 326
79 58
139 115
169 131
86 77
354 402
40 153
339 297
79 335
396 208
151 171
333 377
281 177
54 367
243 246
180 309
423 350
437 23
243 55
325 432
327 114
373 155
323 433
147 177
342 64
111 12
444 352
331 311
35 46
63 153
240 144
209 382
288 9
126 172
375 84
235 427
351 131
166 376
44 305
34 452
94 203
219 306
120 248
61 309
428 104
302 336
175 158
415 433
320 211
427 358
230 435
428 359
366 422
0 10
367 422
48 115
27 96
156 116
360 116
353 430
347 124
202 124
239 107
76 256
298 184
346 299
454 258
425 378
278 246
280 83
68 121
260 51
341 417
252 164
264 436
261 95
264 442
452 197
5 7
360 201
67 432
309 376
223 159
206 252
148 443
386 306
193 248
80 152
118 62
42 237
414 311
56 191
222 382
196 348
3 36
20 407
241 291
325 195
346 296
330 394
87 240
19 110
100 268
29 449
71 121
57 363
183 119
231 128
430 355
428 232
231 236
369 47
219 139
205 232
172 117
27 85
401 93
249 146
247 214
140 37
325 4
173 408
240 112
43 232
319 443
196 290
"""

waters="""
0.66666 0.80805 0.97468
0.57058 0.7721 0.89343
0.5 0.78049 0.75
0.92275 0.39818 0.24108
0.13917 0.25558 0.2259
0.18255 0.40236 0.06345
0.94938 0.77703 0.26639
0.16829 0.37365 0.22152
0.41848 0.23056 0.74347
0.37443 0.84506 0.63526
0.62557 0.84506 0.86474
0.66829 0.12635 0.77849
0.62557 0.15494 0.13526
0.40633 0.97628 0.94
0.27712 0.1191 0.1127
0.79571 0.20823 0.04722
0.53079 0.85335 0.93705
0.1184 0.16595 0.58577
0.46416 0.93995 0.35399
0.61652 0.03679 0.11015
0.03079 0.64666 0.06295
0.10354 0.93727 0.32669
0.93916 0.52373 0.435
0.56084 0.02373 0.065
0.89484 0.85781 0.92892
0.60354 0.43727 0.32669
0.36374 0.15981 0.20915
0.76859 0.07733 0.25022
0.31931 0.31229 0.11424
0.98991 0.03999 0.125
0.42934 0.58272 0.56008
0.791 0.71931 0.3761
0.7001 0.39551 0.24868
0.2001 0.89551 0.24868
0.67718 0.58426 0.21948
0.88161 0.16595 0.91424
0.94202 0.43508 0.13459
0.44202 0.93508 0.13459
0.73059 0.16678 0.54722
0.20901 0.28069 0.8761
0.63917 0.75558 0.2259
0.51078 0.86652 0.64147
0.38161 0.33405 0.08577
0.28585 0.66875 0.57875
0.98991 0.96002 0.875
0.24366 0.13807 0.41972
0.89484 0.14219 0.07108
0.55798 0.93508 0.36541
0.57067 0.41728 0.06008
0.77712 0.6191 0.1127
0.291 0.78069 0.6239
0.51423 0.8302 0.06455
0.28681 0.91055 0.172
0.57058 0.2279 0.10657
0.11652 0.46321 0.88985
0.43916 0.02373 0.435
0.36246 0.28389 0.56937
0.71416 0.33125 0.07875
0.59136 0.23278 0.35423
0.66666 0.19195 0.02533
0.15359 0.02376 0.78185
0.65359 0.52376 0.78185
0.07726 0.60183 0.74108
0.56156 0.72031 0.36642
0.16764 0.87199 0.94914
0.23141 0.07733 0.24978
0.04078 0.77481 0.88592
0.17718 0.08426 0.21948
0.48923 0.13348 0.14147
0.70901 0.78069 0.8761
0.10517 0.14219 0.42892
0.44938 0.27703 0.26639
0.94938 0.22297 0.73361
0.31745 0.09764 0.56345
0.05062 0.77703 0.23361
0.09136 0.26722 0.64577
0.43697 0.15153 0.06438
0.23059 0.33323 0.45279
0.791 0.28069 0.6239
0.56303 0.15153 0.43562
0.04646 0.32532 0.44188
0.04646 0.67468 0.55812
0.10354 0.06273 0.67331
0.93844 0.22031 0.13358
0.68255 0.09764 0.93656
0.75635 0.13807 0.08029
0.28585 0.33125 0.42126
0.69123 0.98694 0.57985
0.40864 0.76722 0.85423
0.49495 0.34292 0.82897
0.36211 0.03679 0.13985
0.13081 0.04375 0.95639
0.07067 0.08272 0.93992
0.81296 0.29965 0.80592
0.7411 0.54767 0.71509
0.86083 0.25558 0.2741
0.82282 0.08426 0.28053
0.23141 0.92267 0.75022
0.7999 0.10449 0.74868
0.7589 0.04767 0.78491
0.12557 0.65494 0.13526
0.18704 0.70035 0.30592
0.3728 0.95812 0.25842
0.92934 0.91728 0.43992
0.32282 0.41575 0.71948
0.93916 0.47628 0.565
0.65359 0.47624 0.21816
0.00573 0.50058 0.3125
0.74366 0.36194 0.58029
0.23895 0.56074 0.95507
0.6499 0.0 0.0
0.63626 0.15981 0.29085
0.6272 0.04189 0.75842
0.43697 0.84847 0.93562
0.07058 0.2721 0.89343
0.55489 0.3983 0.21816
0.71319 0.91055 0.32801
0.01078 0.36652 0.64147
0.08152 0.73056 0.75654
0.34223 0.66748 0.16761
0.43844 0.27969 0.86642
0.5 0.21951 0.25
0.50573 0.99943 0.6875
0.57484 0.30919 0.99203
0.42942 0.2279 0.39343
0.88348 0.46321 0.61015
0.05062 0.22297 0.76639
0.21416 0.16875 0.92126
0.5101 0.53999 0.375
0.18704 0.29965 0.69408
0.19123 0.51307 0.42016
0.00505 0.84292 0.67104
0.50505 0.34292 0.67104
0.76105 0.56074 0.54494
0.72288 0.1191 0.38731
0.60517 0.35781 0.57108
0.10517 0.85781 0.57108
0.26105 0.06074 0.54494
0.0 0.96205 0.25
0.5 0.46205 0.25
0.45354 0.82532 0.05812
0.36211 0.96321 0.86015
0.76105 0.43926 0.45507
0.81745 0.40236 0.43656
0.59367 0.97628 0.56
0.56303 0.84847 0.56438
0.77712 0.3809 0.88731
0.92275 0.60183 0.75892
0.23059 0.66678 0.54722
0.03584 0.43995 0.14601
0.71319 0.08945 0.672
0.41848 0.76944 0.25654
0.98577 0.3302 0.43546
0.58152 0.76944 0.24347
0.81745 0.59764 0.56345
0.0101 0.96002 0.625
0.7589 0.95233 0.21509
0.56156 0.27969 0.63358
0.16829 0.62635 0.77849
0.39484 0.64219 0.07108
0.55062 0.27703 0.23361
0.40864 0.23278 0.14577
0.78681 0.58945 0.82801
0.7001 0.60449 0.75132
0.70429 0.29178 0.54722
0.96416 0.56005 0.64601
0.63081 0.45625 0.04362
0.83171 0.37365 0.27849
0.71416 0.66875 0.92126
0.95922 0.77481 0.61409
0.94202 0.56493 0.86541
0.45922 0.72519 0.38592
0.0 0.28049 0.75
0.83334 0.30805 0.52533
0.98923 0.63348 0.14147
0.21319 0.58945 0.672
0.60517 0.64219 0.42892
0.91848 0.73056 0.74347
0.37443 0.15494 0.36474
0.38348 0.96321 0.61015
0.65777 0.33252 0.66761
0.6184 0.33405 0.41424
0.07453 0.98001 0.57546
0.29571 0.70823 0.04722
0.49427 0.00058 0.1875
0.03079 0.35335 0.93705
0.90864 0.73278 0.14577
0.50573 0.00058 0.3125
0.60354 0.56273 0.67331
0.53079 0.14666 0.06295
0.15777 0.16748 0.33239
0.33236 0.37199 0.55086
0.24366 0.86194 0.58029
0.34223 0.33252 0.83239
0.26105 0.93926 0.45507
0.16666 0.30805 0.97468
0.93697 0.34847 0.93562
0.7411 0.45233 0.28491
0.20429 0.20823 0.45279
0.70429 0.70823 0.45279
0.32282 0.58426 0.28053
0.68255 0.90236 0.06345
0.46921 0.14666 0.43705
0.73141 0.42267 0.75022
0.15777 0.83252 0.66761
0.2589 0.54767 0.78491
0.68704 0.20035 0.30592
0.86919 0.95625 0.45639
0.36919 0.45625 0.45639
0.13789 0.46321 0.63985
0.69123 0.01307 0.42016
0.15359 0.97624 0.21816
0.2001 0.10449 0.75132
0.36246 0.71611 0.43063
0.5 0.53796 0.75
0.33171 0.12635 0.72152
0.86211 0.46321 0.86015
0.19123 0.48694 0.57985
0.13754 0.78389 0.93063
0.48991 0.53999 0.125
0.63626 0.84019 0.70915
0.13626 0.34019 0.70915
0.06303 0.34847 0.56438
0.38161 0.66595 0.91424
0.27712 0.8809 0.88731
0.18069 0.18772 0.61424
0.00505 0.15708 0.32897
0.22288 0.3809 0.6127
0.98577 0.66981 0.56455
0.58152 0.23056 0.75654
0.96844 0.0 0.5
0.46844 0.5 0.5
0.2999 0.60449 0.74868
0.92942 0.7279 0.39343
0.88348 0.53679 0.38985
0.86919 0.04375 0.54362
0.5101 0.46002 0.625
0.39647 0.43727 0.17331
0.42934 0.41728 0.43992
0.05798 0.43508 0.36541
0.63789 0.96321 0.63985
0.57726 0.89818 0.25892
0.49427 0.99943 0.8125
0.43916 0.97628 0.565
0.03156 0.0 0.0
0.25635 0.36194 0.91972
0.46416 0.06005 0.64601
0.44512 0.6017 0.71816
0.39484 0.35781 0.92892
0.80878 0.48694 0.92016
0.48923 0.86652 0.85854
0.83171 0.62635 0.72152
0.68069 0.31229 0.38577
0.78585 0.83125 0.42126
0.31296 0.20035 0.19408
0.55489 0.6017 0.78185
0.40633 0.02373 0.06
0.05489 0.8983 0.21816
0.63917 0.24442 0.7741
0.04078 0.22519 0.11409
0.54078 0.72519 0.11409
0.84223 0.16748 0.16761
0.87443 0.65494 0.36474
0.63789 0.03679 0.36015
0.76859 0.92267 0.74978
0.90633 0.47628 0.94
0.8728 0.45812 0.25842
0.80878 0.51307 0.07985
0.07058 0.7279 0.10657
0.92516 0.80919 0.50797
0.30878 0.98694 0.92016
0.8501 0.5 0.5
0.2999 0.39551 0.25132
0.92942 0.2721 0.60657
0.42942 0.7721 0.60657
0.81296 0.70035 0.19408
0.51423 0.16981 0.93546
0.45922 0.27481 0.61409
0.42275 0.10183 0.75892
0.48577 0.16981 0.56455
0.91848 0.26944 0.25654
0.93844 0.77969 0.86642
0.33236 0.62801 0.44914
0.26941 0.16678 0.95279
0.76941 0.66678 0.95279
0.42548 0.48001 0.92454
0.57453 0.48001 0.57546
0.42516 0.69082 0.49203
0.36374 0.84019 0.79085
0.61652 0.96321 0.88985
0.95354 0.32532 0.05812
0.6272 0.95812 0.24158
0.06156 0.22031 0.36642
0.42548 0.51999 0.07546
0.33171 0.87365 0.27849
0.1272 0.54189 0.75842
0.86083 0.74442 0.7259
0.84642 0.97624 0.28185
0.53584 0.93995 0.14601
0.83334 0.69195 0.47468
0.33334 0.19195 0.47468
0.78585 0.16875 0.57875
0.01078 0.63348 0.35854
0.00573 0.49943 0.6875
0.26859 0.42267 0.74978
0.92548 0.98001 0.92454
0.49495 0.65708 0.17104
0.53156 0.5 0.0
0.93697 0.65153 0.06438
0.67718 0.41575 0.78053
0.31931 0.68772 0.88577
0.92516 0.19082 0.49203
0.54646 0.17468 0.55812
0.96416 0.43995 0.35399
0.05798 0.56493 0.63459
0.18255 0.59764 0.93656
0.83236 0.87199 0.55086
0.76941 0.33323 0.04722
0.26941 0.83323 0.04722
0.18069 0.81229 0.38577
0.13081 0.95625 0.04362
0.54078 0.27481 0.88592
0.90864 0.26722 0.85423
0.63754 0.71611 0.06937
0.05489 0.1017 0.78185
0.13754 0.21611 0.06937
0.96921 0.35335 0.56295
0.07484 0.19082 0.00797
0.291 0.21931 0.3761
0.44202 0.06493 0.86541
0.13626 0.65981 0.29085
0.95922 0.22519 0.38592
0.36083 0.24442 0.7259
0.33334 0.80805 0.52533
0.72288 0.8809 0.6127
0.51078 0.13348 0.35854
0.0 0.71951 0.25
0.07484 0.80919 0.99203
0.38348 0.03679 0.38985
0.89647 0.93727 0.17331
0.20901 0.71931 0.1239
0.68704 0.79965 0.69408
0.17718 0.91575 0.78053
0.30878 0.01307 0.07985
0.22288 0.6191 0.38731
0.43844 0.72031 0.13358
0.86246 0.78389 0.56937
0.42516 0.30919 0.50797
0.98923 0.36652 0.85854
0.3501 0.0 0.5
0.57726 0.10183 0.74108
0.99495 0.84292 0.82897
0.86211 0.53679 0.13985
0.26859 0.57733 0.25022
0.2411 0.04767 0.71509
0.21319 0.41055 0.32801
0.42275 0.89818 0.24108
0.96921 0.64666 0.43705
0.89647 0.06273 0.82669
0.39647 0.56273 0.82669
0.66829 0.87365 0.22152
0.48577 0.8302 0.43546
0.55062 0.72297 0.76639
0.70901 0.21931 0.1239
0.07067 0.91728 0.06008
0.07726 0.39818 0.25892
0.99427 0.49943 0.8125
0.06084 0.47628 0.935
0.99427 0.50058 0.1875
0.54646 0.82532 0.44188
0.11652 0.53679 0.11015
0.65777 0.66748 0.33239
0.86374 0.34019 0.79085
0.0 0.03796 0.75
0.09136 0.73278 0.35423
0.73895 0.06074 0.95507
0.66764 0.37199 0.94914
0.31745 0.90236 0.43656
0.01423 0.66981 0.93546
0.57484 0.69082 0.00797
0.90633 0.52373 0.06
0.46921 0.85335 0.56295
0.09367 0.47628 0.56
0.31296 0.79965 0.80592
0.09367 0.52373 0.44
0.36083 0.75558 0.2741
0.50505 0.65708 0.32897
0.13917 0.74442 0.7741
0.88161 0.83405 0.08577
0.44938 0.72297 0.73361
0.48991 0.46002 0.875
0.07453 0.01999 0.42454
0.57453 0.51999 0.42454
0.08152 0.26944 0.24347
0.13789 0.53679 0.36015
0.74366 0.63807 0.41972
0.36919 0.54375 0.54362
0.06156 0.77969 0.63358
0.59136 0.76722 0.64577
0.1184 0.83405 0.41424
0.73059 0.83323 0.45279
0.81931 0.18772 0.88577
0.28681 0.08945 0.82801
0.6184 0.66595 0.58577
0.78681 0.41055 0.172
0.94512 0.1017 0.71816
0.55798 0.06493 0.63459
0.06084 0.52373 0.065
0.86246 0.21611 0.43063
0.16666 0.69195 0.02533
0.7999 0.89551 0.25132
0.8728 0.54189 0.74158
0.3728 0.04189 0.74158
0.1499 0.5 0.0
0.92934 0.08272 0.56008
0.63081 0.54375 0.95639
0.59367 0.02373 0.44
0.68069 0.68772 0.61424
0.2411 0.95233 0.28491
0.44512 0.3983 0.28185
0.34642 0.47624 0.28185
0.94512 0.8983 0.28185
0.03584 0.56005 0.85399
0.53584 0.06005 0.85399
0.83236 0.12801 0.44914
0.95354 0.67468 0.94188
0.45354 0.17468 0.94188
0.84642 0.02376 0.71816
0.34642 0.52376 0.71816
0.87443 0.34506 0.63526
0.2589 0.45233 0.21509
0.12557 0.34506 0.86474
0.16764 0.12801 0.05086
0.66764 0.62801 0.05086
0.99495 0.15708 0.17104
0.0101 0.03999 0.375
0.82282 0.91575 0.71948
0.56084 0.97628 0.935
0.06303 0.65153 0.43562
0.23895 0.43926 0.04494
0.73895 0.93926 0.04494
0.01423 0.3302 0.06455
0.75635 0.86194 0.91972
0.20429 0.79178 0.54722
0.86374 0.65981 0.20915
0.21416 0.83125 0.07875
0.1272 0.45812 0.24158
0.29571 0.29178 0.95279
0.79571 0.79178 0.95279
0.92548 0.01999 0.07546
0.25635 0.63807 0.08029
0.84223 0.83252 0.83239
0.73141 0.57733 0.24978
0.81931 0.81229 0.11424
0.63754 0.28389 0.93063
0.57067 0.58272 0.93992
"""

coord= "relative"

cages="""
12 0.0 0.3125 0.25
12 0.0 0.6875 0.75
12 0.5 0.8125 0.25
12 0.5 0.1875 0.75
12 0.10001 0.3524 0.07404
12 0.89999 0.6476 0.57404
12 0.89999 0.3524 0.42596
12 0.60001 0.8524 0.07404
12 0.10001 0.6476 0.92596
12 0.39999 0.1476 0.57404
12 0.39999 0.8524 0.42596
12 0.60001 0.1476 0.92596
14 0.08331 0.07997 0.19816
14 0.91669 0.92003 0.69816
14 0.91669 0.07997 0.30184
14 0.58331 0.57997 0.19816
14 0.08331 0.92003 0.80184
14 0.41669 0.42003 0.69816
14 0.41669 0.57997 0.30184
14 0.58331 0.42003 0.80184
12 0.43374 0.0949 0.24001
12 0.56626 0.9051 0.74001
12 0.56626 0.0949 0.25999
12 0.93374 0.5949 0.24001
12 0.43374 0.9051 0.75999
12 0.06626 0.4051 0.74001
12 0.06626 0.5949 0.25999
12 0.93374 0.4051 0.75999
15 0.02019 0.15588 0.56586
15 0.97981 0.84412 0.06586
15 0.97981 0.15588 0.93414
15 0.52019 0.65588 0.56586
15 0.02019 0.84412 0.43414
15 0.47981 0.34412 0.06586
15 0.47981 0.65588 0.93414
15 0.52019 0.34412 0.43414
15 0.23062 0.25705 0.17974
15 0.76938 0.74295 0.67974
15 0.76938 0.25705 0.32026
15 0.73062 0.75705 0.17974
15 0.23062 0.74295 0.82026
15 0.26938 0.24295 0.67974
15 0.26938 0.75705 0.32026
15 0.73062 0.24295 0.82026
12 0.36377 0.32499 0.32554
12 0.63623 0.67501 0.82554
12 0.63623 0.32499 0.17446
12 0.86377 0.82499 0.32554
12 0.36377 0.67501 0.67446
12 0.13623 0.17501 0.82554
12 0.13623 0.82499 0.17446
12 0.86377 0.17501 0.67446
16 0.17441 0.0 0.5
16 0.82559 0.0 0.0
16 0.67441 0.5 0.5
16 0.32559 0.5 0.0
15 0.14275 0.3329 0.45166
15 0.85725 0.6671 0.95166
15 0.85725 0.3329 0.04834
15 0.64275 0.8329 0.45166
15 0.14275 0.6671 0.54834
15 0.35725 0.1671 0.95166
15 0.35725 0.8329 0.04834
15 0.64275 0.1671 0.54834
14 0.22039 0.0 0.0
14 0.77961 0.0 0.5
14 0.72039 0.5 0.0
14 0.27961 0.5 0.5
12 0.47709 0.0 0.0
12 0.52291 0.0 0.5
12 0.97709 0.5 0.0
12 0.02291 0.5 0.5
12 0.30021 0.05226 0.31938
12 0.69979 0.94774 0.81938
12 0.69979 0.05226 0.18062
12 0.80021 0.55226 0.31938
12 0.30021 0.94774 0.68062
12 0.19979 0.44774 0.81938
12 0.19979 0.55226 0.18062
12 0.80021 0.44774 0.68062
"""

bondlen = 3


cell = """
60.68215625656757 29.106420943085343 21.36763082543155
"""

density = 0.3611523245935869



from genice.cell import cellvectors
cell = cellvectors(a=60.68215625656757,
                   b=29.106420943085343,
                   c=21.36763082543155)
