# coding: utf-8
"""
XMol file format (.xyz)
"""

import numpy as np

from genice import rigid

def hook7(lattice):
    lattice.logger.info("Hook7: Output in XYZ format.")
    s = ""
    s += "{0}\n".format(len(lattice.atoms))
    s += "Generated by GenIce. https://github.com/vitroid/GenIce\n"
    for atom in lattice.atoms:
        molorder, resname, atomname, position, order = atom
        s += "{0:5} {1:9.4f} {2:9.4f} {3:9.4f}\n".format(atomname,position[0]*10,position[1]*10,position[2]*10)
    s = '#' + "\n#".join(lattice.doc) + "\n" + s
    print(s,end="")
    lattice.logger.info("Hook7: end.")


hooks = {7:hook7}
