# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/utils.ipynb (unless otherwise specified).

__all__ = ['PatternGenerator']

# Cell
import re

from typing import Tuple, Any
from itertools import groupby
from collections import defaultdict

# Cell
class PatternGenerator:
    """Generates a generic pattern given a value and a generalization language."""

    def __init__(self, alpha: str = 'type', digit: str = 'type', other: str = 'type',
                 preserve_space: bool = False, add_length: bool = True):
        self.alpha = alpha
        self.digit = digit
        self.other = other
        self.preserve_space= preserve_space
        self.add_length = add_length

    def __call__(self, value: Any) -> str:
        pattern = ''
        value = list(str(value))

        for c in value:
            pattern += self._get_representation(c)

        grouped_pattern = [''.join(g) for _, g in groupby(pattern)]

        if self.add_length:
            return ''.join([f'{v[0]}({len(v)})' for v in grouped_pattern])

        return ''.join([s[0] for s in grouped_pattern])

    def _get_representation(self, c: str):
        if c.isalpha():
            return self._get_alpha_representation(c)
        if c.isnumeric():
            return self._get_digit_representation(c)
        return self._get_other_representation(c)

    def _get_alpha_representation(self, c: str):
        if self.alpha == 'root':
            return 'A'
        if self.alpha == 'type':
            return 'L'
        if self.alpha == 'case':
            return 'u' if c.isupper() else 'l'
        return c

    def _get_digit_representation(self, c: str):
        if self.digit == 'root':
            return 'A'
        if self.digit == 'type':
            return 'D'
        return c

    def _get_other_representation(self, c: str):
        if c == ' ':
            return ' ' if self.preserve_space else ''
        if self.other == 'root':
            return 'A'
        if self.other == 'type':
            return 'S'
        return c