_str = "3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|1|1|1|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|1|1|1|1|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|1|1|1|1|1|1|1|1|1|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|3|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|1|1|1|1|1|1|1|1|1|4|4|4|4|2|2|2|2|2|2|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|0|0|0|0|0|0|0|0|1|1|0|0|0|0|0|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|0|0|1|1|1|1|1|1|1|1|1|1|1|1|1|0|0|0|0|0|1|1|1|1|1|1|1|0|0|0|0|0|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|0|0|0|0|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|1|1|0|1|1|1|0|0|0|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|0|0|1|1|1|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|3|3|3|3|3|3|3|3|3|3|3|3|3|3|2|1|1|0|0|1|1|1|1|1|1|1|1|1|1|1|0|0|0|0|1|1|1|1|1|1|1|1|0|0|0|1|0|0|0|0|0|0|0|0|0|0|0|0|0|1|1|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|0|0|1|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|4|4|4|4|0|0|0|0|0|0|0|2|2|2|2|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|4|4|4|4|4|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|4|4|4|4|4|4|4|4|4|4|0|0|0|0|0|0|4|4|4|4|4|4|4|4|4|4|4|4|4|0|0|0|0|0|0|4|4|4|4|4|4|4|4|4|0|0|0|0|0|0|0|0|0|4|4|4|4|4|4|4|4|4|4|4|4|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|4|4|4|4|4|4|4|4|4|4|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|4|4|4|4|4|4|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|4|4|4|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|2|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|0|0|0|0|0|0|0|0|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|1|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|3|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4|4"
import os.path as op
import sys
import time
import gzip
import logging

import numpy as np
import toolshed as ts
from sklearn import svm
from sklearn.pipeline import make_pipeline
from sklearn.decomposition import PCA
try:
    import cPickle
except ImportError:
    import pickle as cPickle

log = logging.getLogger(__name__)

HERE = op.dirname(op.abspath(__file__))

def pca(fig_path, genotype_matrix=None, sites=None, sites_file="1kg.sites"):

    f = op.join(HERE, sites_file + ".bin.gz")
    t0 = time.time()
    tmp = np.fromstring(gzip.open(f, 'rb').read(), dtype=np.uint8).astype(np.int32)
    genos1kg = tmp.reshape((23556, int(len(tmp) / 23556))).T


    if genotype_matrix is not None:
        kgsites = [x.strip() for x in open(op.join(HERE, "1kg.sites"), "r")]

        # exclude missing from 1kg. these may come out of order because of
        # parallelization so we put 1kg is same order
        kgsites_index = dict((k, i) for i, k in enumerate(kgsites))

        # pull all things in sites:
        try:
            idxs = np.array([kgsites_index[s] for s in sites])
        except KeyError:  # check 'chr' prefix'
            kgsites = ['chr' + kg for kg in kgsites]
            kgsites_index = dict((k, i) for i, k in enumerate(kgsites))
            idxs = np.array([kgsites_index[s] for s in sites])

        kgsites = np.array(kgsites)[idxs]

        # now we have the kgsites but need them in order of incoming sites
        assert np.all((kgsites) == np.array(sites)), (set(kgsites) - set(sites), set(sites) - set(kgsites))

        genos1kg = np.array(genos1kg[:, idxs])

        assert genotype_matrix.shape[1] == genos1kg.shape[1]
    log.info("loaded and subsetted thousand-genomes genotypes (shape: %s) in %.1f seconds" % 
            (genos1kg.shape, time.time() - t0))

    t0 = time.time()
    clf = make_pipeline(PCA(n_components=4, whiten=True, copy=True, svd_solver="randomized"),
                    svm.SVC(C=2, probability=True))
    background_target = np.array([int(x) for x in _str.split("|")])

    clf.fit(genos1kg, background_target)
    log.info("ran randomized PCA on thousand-genomes samples at %d sites in %.1f seconds" 
             % (genos1kg.shape[1], time.time() - t0))

    ipops = "AFR AMR EAS EUR SAS UNKNOWN".split()

    t0 = time.time()
    background_tf = clf.named_steps['pca'].transform(genos1kg)

    background_df, df = None, None

    if genotype_matrix is not None:
        import pandas as pd
        tf = clf.named_steps['pca'].transform(genotype_matrix)
        s = (genotype_matrix != 3).sum(axis=1)
        s = s / np.mean(s)
        s = s * 15
        pred = clf.predict(genotype_matrix)
        proba = clf.predict_proba(genotype_matrix).max(axis=1)
        pred[proba < 0.65] = len(ipops) - 1

        df = pd.DataFrame({'ancestry-prediction': [ipops[v] for v in pred],
                           'ancestry-prob': proba,
                           'PC1': tf[:, 0],
                           'PC2': tf[:, 1],
                           'PC3': tf[:, 2],
                           'PC4': tf[:, 3]})
        background_df = pd.DataFrame({'ancestry': [ipops[t] for t in background_target],
                                      'PC1': background_tf[:, 0],
                                      'PC2': background_tf[:, 1],
                                      'PC3': background_tf[:, 2],
                                      'PC4': background_tf[:, 3]})
    log.info("Projected thousand-genomes genotypes and sample genotypes and predicted ancestry via SVM in %.1f seconds"
             % (time.time() - t0))
    if not fig_path:
        return df, background_df


    import seaborn as sns
    from matplotlib import pyplot as plt
    plt.close()
    fig, axes = plt.subplots(2)
    fig.set_size_inches((6, 12))
    import matplotlib.patches as mpatches
    patches = []
    pal = sns.color_palette('Set1')
    sns.set_style('whitegrid')

    pal[len(ipops) - 1] = (0.5, 0.5, 0.5)

    for i, p in enumerate(ipops):
        subset = i == background_target
        axes[0].scatter(background_tf[subset, 0], background_tf[subset, 1], c=pal[i],
                        edgecolor='none',
                        s=8,
                        label=p, alpha=0.15)

        axes[1].scatter(background_tf[subset, 0], background_tf[subset, 2], c=pal[i],
                        edgecolor='none',
                        s=8,
                        label=p, alpha=0.15)

        patches.append(mpatches.Patch(color=pal[i], label=p))


        c = 'none' #(0.55, 0.55, 0.55)
        for axi in range(2):
            for i, p in enumerate(ipops):
                subset = i == pred
                # plot the first vs 2nd, then 3rd pc
                axes[axi].scatter(tf[subset, 0], tf[subset, axi + 1], c=c,
                                  s=s,
                                  alpha=0.7,
                                  linewidth=1.4,
                                  edgecolor=pal[i])

    axes[0].set_xlabel("PC1")
    axes[0].set_ylabel("PC2")
    axes[1].set_xlabel("PC1")
    axes[1].set_ylabel("PC3")
    plt.legend(loc='best', handles=patches, title="population from 1kg")
    plt.title("study samples colored by inferred ancestry")
    plt.savefig(fig_path)
    plt.close()

    return df, background_df

if __name__ == "__main__":
    pca("1kg", None)

