# World of Tanks Datfile Parser (Python) `WIP`
A parser for `.dat` battle result files generated by the game World of Tanks. `.dat` files are generated whenever a battle's results are viewed in-game. For Windows, these files are found in a location like:
```
C:\Users\<YOUR_USER_NAME>\AppData\Roaming\Wargaming.net\WorldOfTanks\battle_results
```
This project simply provides python bindings for the Rust library: [`wot_datfile_parser`](https://github.com/dacite/wot-battle-results-parser/tree/main/datfile_parser)

Install with:
```
pip install wot_datfile_parser_py
```

## Example:
```python
from wot_datfile_parser_py import DatfileParser

# You can use this same parser for any number of datfiles
parser = DatfileParser()

with open("9252658313363554.dat", "rb") as file:
    battle = parser.parse(file)
    print(battle)
```

## Supported WoT Versions
```
1.20.0
```
