import { aws_rds as rds, aws_secretsmanager as secretsmanager } from "aws-cdk-lib";
import { Construct } from "constructs";
import { BootstrapPgStacProps } from "../bootstrapper";
/**
 * An RDS instance with pgSTAC installed. This is a wrapper around the
 * `rds.DatabaseInstance` higher-level construct making use
 * of the BootstrapPgStac construct.
 */
export declare class PgStacDatabase extends Construct {
    db: rds.DatabaseInstance;
    pgstacSecret: secretsmanager.ISecret;
    constructor(scope: Construct, id: string, props: PgStacDatabaseProps);
    getParameters(instanceType: string, parameters: PgStacDatabaseProps["parameters"]): DatabaseParameters;
}
export interface PgStacDatabaseProps extends rds.DatabaseInstanceProps {
    readonly pgstacDbName?: BootstrapPgStacProps["pgstacDbName"];
    readonly pgstacVersion?: BootstrapPgStacProps["pgstacVersion"];
    readonly pgstacUsername?: BootstrapPgStacProps["pgstacUsername"];
    readonly secretsPrefix?: BootstrapPgStacProps["secretsPrefix"];
}
export interface DatabaseParameters {
    /**
     * @default - LEAST({DBInstanceClassMemory/9531392}, 5000)
     */
    readonly maxConnections: string;
    /**
     * Note: This value is measured in 8KB blocks.
     *
     * @default '{DBInstanceClassMemory/32768}' 25% of instance memory, ie `{(DBInstanceClassMemory/(1024*8)) * 0.25}`
     */
    readonly sharedBuffers: string;
    /**
     * @default - 75% of instance memory
     */
    readonly effectiveCacheSize: string;
    /**
     * @default - shared buffers divided by max connections
     */
    readonly workMem: string;
    /**
     * @default - 25% of shared buffers
     */
    readonly maintenanceWorkMem: string;
    /**
     * @default 1024
     */
    readonly maxLocksPerTransaction: string;
    /**
     * @default 131172 (128 * 1024)
     */
    readonly tempBuffers: string;
    /**
     * @default 1
     */
    readonly seqPageCost: string;
    /**
     * @default 1.1
     */
    readonly randomPageCost: string;
}
