execnb
================

<!-- WARNING: THIS FILE WAS AUTOGENERATED! DO NOT EDIT! -->

[![CI](https://github.com/fastai/execnb/actions/workflows/test.yaml/badge.svg)](https://github.com/fastai/execnb/actions/workflows/test.yaml)
[![Deploy to GitHub
Pages](https://github.com/fastai/execnb/actions/workflows/deploy.yaml/badge.svg)](https://github.com/fastai/execnb/actions/workflows/deploy.yaml)

## Install

Either:

    pip install execnb

or if you use conda:

    conda install -c fastai execnb

(You can replace `conda` with `mamba` in the line above if you have
mamba installed.)

## How to use

Use [CaptureShell](https://fastai.github.io/execnb/shell#CaptureShell)
to run Jupyter code and capture notebook outputs, without running a
Jupyter server (or even having it installed):

``` python
from execnb.nbio import *
from execnb.shell import *
from fastcore.utils import *
```

``` python
s = CaptureShell()
s.run('1+1')
```

    [{'data': {'text/plain': ['2']},
      'metadata': {},
      'output_type': 'execute_result',
      'execution_count': 1}]

To execute a notebook and save it with outputs filled in, use
[CaptureShell.execute](https://fastai.github.io/execnb/shell#CaptureShell.execute):

``` python
try:
    s.execute('../tests/clean.ipynb', 'tmp.ipynb')
    print(read_nb('tmp.ipynb').cells[1].outputs)
finally: Path('tmp.ipynb').unlink()
```

    [{'name': 'stdout', 'output_type': 'stream', 'text': ['1\n']}, {'data': {'text/plain': ['2']}, 'execution_count': 3, 'metadata': {}, 'output_type': 'execute_result'}]

You can also execute notebooks from the command line with
[exec_nb](https://fastai.github.io/execnb/shell#exec_nb):

``` python
!exec_nb --help
```

    usage: exec_nb [-h] [--dest DEST] [--exc_stop] [--inject_code INJECT_CODE]
                   [--inject_path INJECT_PATH] [--inject_idx INJECT_IDX]
                   src

    Execute notebook from `src` and save with outputs to `dest`

    positional arguments:
      src                        Notebook path to read from

    optional arguments:
      -h, --help                 show this help message and exit
      --dest DEST                Notebook path to write to (default: )
      --exc_stop                 Stop on exceptions? (default: False)
      --inject_code INJECT_CODE  Code to inject into a cell
      --inject_path INJECT_PATH  Path to file containing code to inject into a cell
      --inject_idx INJECT_IDX    Cell to replace with `inject_code` (default: 0)
