# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool
from edgeimpulse_api.models.set_impulse_thresholds_request_thresholds_inner import SetImpulseThresholdsRequestThresholdsInner

class SetImpulseThresholdsRequest(BaseModel):
    thresholds: List[SetImpulseThresholdsRequestThresholdsInner] = ...
    allow_creating_regenerate_model_testing_jobs: StrictBool = Field(..., alias="allowCreatingRegenerateModelTestingJobs", description="Whether a call to this function is allowed to create jobs to regenerate model testing results (e.g. object detection datasets, or large datasets). This option is here because further calls to setImpulseThresholds are blocked while model testing jobs are running (so e.g. live classification has this to FALSE). ")
    force_run_regenerate_model_testing_in_job: Optional[StrictBool] = Field(None, alias="forceRunRegenerateModelTestingInJob", description="If set, this'll force the creation of a job to regenerate the model testing results.")
    __properties = ["thresholds", "allowCreatingRegenerateModelTestingJobs", "forceRunRegenerateModelTestingInJob"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> SetImpulseThresholdsRequest:
        """Create an instance of SetImpulseThresholdsRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in thresholds (list)
        _items = []
        if self.thresholds:
            for _item in self.thresholds:
                if _item:
                    _items.append(_item.to_dict())
            _dict['thresholds'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SetImpulseThresholdsRequest:
        """Create an instance of SetImpulseThresholdsRequest from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return SetImpulseThresholdsRequest.construct(**obj)

        _obj = SetImpulseThresholdsRequest.construct(**{
            "thresholds": [SetImpulseThresholdsRequestThresholdsInner.from_dict(_item) for _item in obj.get("thresholds")] if obj.get("thresholds") is not None else None,
            "allow_creating_regenerate_model_testing_jobs": obj.get("allowCreatingRegenerateModelTestingJobs"),
            "force_run_regenerate_model_testing_in_job": obj.get("forceRunRegenerateModelTestingInJob")
        })
        return _obj

