# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Dict, List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr
from edgeimpulse_api.models.bounding_box import BoundingBox
from edgeimpulse_api.models.structured_label import StructuredLabel

class SampleProposedChanges(BaseModel):
    label: Optional[StrictStr] = Field(None, description="New label (single-label)")
    is_disabled: Optional[StrictBool] = Field(None, alias="isDisabled", description="True if the current sample should be disabled; or false if it should not be disabled.")
    bounding_boxes: Optional[List[BoundingBox]] = Field(None, alias="boundingBoxes", description="List of bounding boxes. The existing bounding boxes on the sample will be replaced (so if you want to add new bounding boxes, use the existing list as a basis).")
    metadata: Optional[Dict[str, StrictStr]] = Field(None, description="Free form associated metadata. The existing metadata on the sample will be replaced (so if you want to add new metadata, use the existing list as a basis).")
    structured_labels: Optional[List[StructuredLabel]] = Field(None, alias="structuredLabels", description="New label (multi-label)")
    __properties = ["label", "isDisabled", "boundingBoxes", "metadata", "structuredLabels"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> SampleProposedChanges:
        """Create an instance of SampleProposedChanges from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in bounding_boxes (list)
        _items = []
        if self.bounding_boxes:
            for _item in self.bounding_boxes:
                if _item:
                    _items.append(_item.to_dict())
            _dict['boundingBoxes'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in structured_labels (list)
        _items = []
        if self.structured_labels:
            for _item in self.structured_labels:
                if _item:
                    _items.append(_item.to_dict())
            _dict['structuredLabels'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SampleProposedChanges:
        """Create an instance of SampleProposedChanges from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return SampleProposedChanges.construct(**obj)

        _obj = SampleProposedChanges.construct(**{
            "label": obj.get("label"),
            "is_disabled": obj.get("isDisabled"),
            "bounding_boxes": [BoundingBox.from_dict(_item) for _item in obj.get("boundingBoxes")] if obj.get("boundingBoxes") is not None else None,
            "metadata": obj.get("metadata"),
            "structured_labels": [StructuredLabel.from_dict(_item) for _item in obj.get("structuredLabels")] if obj.get("structuredLabels") is not None else None
        })
        return _obj

