# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr
from edgeimpulse_api.models.created_updated_by_user import CreatedUpdatedByUser

class OrganizationDataExport(BaseModel):
    id: StrictInt = ...
    created: datetime = ...
    created_by_user: Optional[CreatedUpdatedByUser] = Field(None, alias="createdByUser")
    job_id: StrictInt = Field(..., alias="jobId")
    job_finished: StrictBool = Field(..., alias="jobFinished")
    job_finished_successful: StrictBool = Field(..., alias="jobFinishedSuccessful")
    description: Optional[StrictStr] = Field(None, description="Description of the data export")
    expiration_date: datetime = Field(..., alias="expirationDate", description="Date when the export will expire. Default is 30 days. Maximum expiration date is 60 days from the creation date.")
    download_url: Optional[StrictStr] = Field(None, alias="downloadUrl")
    __properties = ["id", "created", "createdByUser", "jobId", "jobFinished", "jobFinishedSuccessful", "description", "expirationDate", "downloadUrl"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> OrganizationDataExport:
        """Create an instance of OrganizationDataExport from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of created_by_user
        if self.created_by_user:
            _dict['createdByUser'] = self.created_by_user.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> OrganizationDataExport:
        """Create an instance of OrganizationDataExport from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return OrganizationDataExport.construct(**obj)

        _obj = OrganizationDataExport.construct(**{
            "id": obj.get("id"),
            "created": obj.get("created"),
            "created_by_user": CreatedUpdatedByUser.from_dict(obj.get("createdByUser")) if obj.get("createdByUser") is not None else None,
            "job_id": obj.get("jobId"),
            "job_finished": obj.get("jobFinished"),
            "job_finished_successful": obj.get("jobFinishedSuccessful"),
            "description": obj.get("description"),
            "expiration_date": obj.get("expirationDate"),
            "download_url": obj.get("downloadUrl")
        })
        return _obj

