# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr, validator
from edgeimpulse_api.models.optimize_config import OptimizeConfig
from edgeimpulse_api.models.optimize_state_response_all_of_status import OptimizeStateResponseAllOfStatus
from edgeimpulse_api.models.optimize_state_response_all_of_workers import OptimizeStateResponseAllOfWorkers
from edgeimpulse_api.models.tuner_trial import TunerTrial

class OptimizeStateResponseAllOf(BaseModel):
    config: OptimizeConfig = ...
    status: OptimizeStateResponseAllOfStatus = ...
    tuner_job_id: Optional[StrictInt] = Field(None, alias="tunerJobId", description="Actual tuner process, job message events will be tagged with this ID")
    tuner_coordinator_job_id: Optional[StrictInt] = Field(None, alias="tunerCoordinatorJobId", description="The coordinator pod, attach the job runner to this process for finished events")
    continuation_job_id: Optional[StrictInt] = Field(None, alias="continuationJobId", description="Job ID for the initial job this job continuous the hyperparameter search process for.")
    tuning_algorithm: Optional[StrictStr] = Field(None, alias="tuningAlgorithm", description="Tuning algorithm to use to search hyperparameter space")
    tuner_job_is_running: StrictBool = Field(..., alias="tunerJobIsRunning", description="Whether the job is active (if false => finished)")
    trials: List[TunerTrial] = ...
    project_data_type: StrictStr = Field(..., alias="projectDataType")
    job_error: Optional[StrictStr] = Field(None, alias="jobError")
    workers: List[OptimizeStateResponseAllOfWorkers] = ...
    next_run_index: StrictInt = Field(..., alias="nextRunIndex", description="Index of the next run to be created. Used to pre-populate the name of the next run.")
    can_extend_search: StrictBool = Field(..., alias="canExtendSearch", description="Whether the search can be extended to evaluate more candidate models. Extending is possible if the search space contains candidate models that are expected to perform better than the current best candidate. And extending is also possible if the previous run was paused due to the total runtime limit being exceeded.")
    is_whitelabel: StrictBool = Field(..., alias="isWhitelabel")
    total_training_time_exceeded: StrictBool = Field(..., alias="totalTrainingTimeExceeded", description="Whether the total training time has exceeded the defined limit for the current run.")
    __properties = ["config", "status", "tunerJobId", "tunerCoordinatorJobId", "continuationJobId", "tuningAlgorithm", "tunerJobIsRunning", "trials", "projectDataType", "jobError", "workers", "nextRunIndex", "canExtendSearch", "isWhitelabel", "totalTrainingTimeExceeded"]

    @validator('tuning_algorithm')
    def tuning_algorithm_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ('random', 'hyperband', 'bayesian', 'custom'):
            raise ValueError("must validate the enum values ('random', 'hyperband', 'bayesian', 'custom')")
        return v

    @validator('project_data_type')
    def project_data_type_validate_enum(cls, v):
        if v not in ('audio', 'image', 'motion', 'other'):
            raise ValueError("must validate the enum values ('audio', 'image', 'motion', 'other')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> OptimizeStateResponseAllOf:
        """Create an instance of OptimizeStateResponseAllOf from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of config
        if self.config:
            _dict['config'] = self.config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of status
        if self.status:
            _dict['status'] = self.status.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in trials (list)
        _items = []
        if self.trials:
            for _item in self.trials:
                if _item:
                    _items.append(_item.to_dict())
            _dict['trials'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in workers (list)
        _items = []
        if self.workers:
            for _item in self.workers:
                if _item:
                    _items.append(_item.to_dict())
            _dict['workers'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> OptimizeStateResponseAllOf:
        """Create an instance of OptimizeStateResponseAllOf from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return OptimizeStateResponseAllOf.construct(**obj)

        _obj = OptimizeStateResponseAllOf.construct(**{
            "config": OptimizeConfig.from_dict(obj.get("config")) if obj.get("config") is not None else None,
            "status": OptimizeStateResponseAllOfStatus.from_dict(obj.get("status")) if obj.get("status") is not None else None,
            "tuner_job_id": obj.get("tunerJobId"),
            "tuner_coordinator_job_id": obj.get("tunerCoordinatorJobId"),
            "continuation_job_id": obj.get("continuationJobId"),
            "tuning_algorithm": obj.get("tuningAlgorithm"),
            "tuner_job_is_running": obj.get("tunerJobIsRunning"),
            "trials": [TunerTrial.from_dict(_item) for _item in obj.get("trials")] if obj.get("trials") is not None else None,
            "project_data_type": obj.get("projectDataType"),
            "job_error": obj.get("jobError"),
            "workers": [OptimizeStateResponseAllOfWorkers.from_dict(_item) for _item in obj.get("workers")] if obj.get("workers") is not None else None,
            "next_run_index": obj.get("nextRunIndex"),
            "can_extend_search": obj.get("canExtendSearch"),
            "is_whitelabel": obj.get("isWhitelabel"),
            "total_training_time_exceeded": obj.get("totalTrainingTimeExceeded")
        })
        return _obj

