# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Dict, List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr, validator
from edgeimpulse_api.models.optimize_config_optimization_objectives_inner import OptimizeConfigOptimizationObjectivesInner
from edgeimpulse_api.models.optimize_config_search_space_source import OptimizeConfigSearchSpaceSource
from edgeimpulse_api.models.optimize_config_search_space_template import OptimizeConfigSearchSpaceTemplate
from edgeimpulse_api.models.optimize_config_target_device import OptimizeConfigTargetDevice
from edgeimpulse_api.models.tuner_space_impulse import TunerSpaceImpulse

class OptimizeConfig(BaseModel):
    name: Optional[StrictStr] = None
    target_latency: StrictInt = Field(..., alias="targetLatency", description="Target latency in MS")
    target_device: OptimizeConfigTargetDevice = Field(..., alias="targetDevice")
    compiler: Optional[List[StrictStr]] = None
    precision: Optional[List[StrictStr]] = None
    training_cycles: Optional[StrictInt] = Field(None, alias="trainingCycles", description="Maximum number of training cycles")
    tuning_max_trials: Optional[StrictInt] = Field(None, alias="tuningMaxTrials", description="Maximum number of trials")
    tuning_workers: Optional[StrictInt] = Field(None, alias="tuningWorkers", description="Maximum number of parallel workers/jobs")
    initial_trials: Optional[StrictInt] = Field(None, alias="initialTrials", description="Number of initial trials")
    optimization_rounds: Optional[StrictInt] = Field(None, alias="optimizationRounds", description="Number of optimization rounds")
    trials_per_optimization_round: Optional[StrictInt] = Field(None, alias="trialsPerOptimizationRound", description="Number of trials per optimization round")
    min_maccs: Optional[float] = Field(None, alias="minMACCS")
    max_maccs: Optional[float] = Field(None, alias="maxMACCS")
    tuning_algorithm: Optional[StrictStr] = Field(None, alias="tuningAlgorithm", description="Tuning algorithm to use to search hyperparameter space")
    notification_on_completion: Optional[StrictBool] = Field(None, alias="notificationOnCompletion")
    import_project_metrics: Optional[StrictBool] = Field(None, alias="importProjectMetrics", description="Whether to import metrics for previous EON tuner runs in the same project to accelerate the hyperparameter search process")
    import_resource_metrics: Optional[StrictBool] = Field(None, alias="importResourceMetrics", description="Whether to import resource usage (RAM/ROM/latency) metrics to accelerate the hyperparameter search process")
    num_import_project_metrics: Optional[float] = Field(None, alias="numImportProjectMetrics", description="Number of project trials to import")
    num_import_resource_metrics: Optional[float] = Field(None, alias="numImportResourceMetrics", description="Number of resource usage trials to import")
    enable_sem: Optional[StrictBool] = Field(None, alias="enableSEM", description="Enable standard error of the mean (SEM)")
    accuracy_sem: Optional[float] = Field(None, alias="accuracySEM", description="Standard error of the trial accuracy mean")
    latency_sem: Optional[float] = Field(None, alias="latencySEM", description="Standard error of the trial latency mean")
    optimization_objectives: Optional[List[OptimizeConfigOptimizationObjectivesInner]] = Field(None, alias="optimizationObjectives", description="Hyperparameter optimization objectives and corresponding weights")
    raw_objectives: Optional[StrictStr] = Field(None, alias="rawObjectives", description="Hyperparameter optimization objectives + weights in string format")
    optimization_precision: Optional[StrictStr] = Field(None, alias="optimizationPrecision", description="Model variant to optimize for")
    early_stopping: Optional[StrictBool] = Field(None, alias="earlyStopping", description="Enable trial level early stopping based on loss metrics during training")
    early_stopping_window_size: Optional[float] = Field(None, alias="earlyStoppingWindowSize", description="Stops the EON tuner if the feasible (mean) objective has not improved over the past “window_size” iterations")
    early_stopping_improvement_bar: Optional[float] = Field(None, alias="earlyStoppingImprovementBar", description="Threshold (in [0,1]) for considering relative improvement over the best point.")
    momf: Optional[StrictBool] = Field(None, alias="MOMF", description="Enable Multi-fidelity Multi-Objective optimization")
    verbose_logging: Optional[StrictBool] = Field(None, alias="verboseLogging", description="Enable verbose logging")
    disable_constraints: Optional[StrictBool] = Field(None, alias="disableConstraints", description="Disable search constraints")
    disable_deduplicate: Optional[StrictBool] = Field(None, alias="disableDeduplicate", description="Disable trial deduplication")
    max_total_training_time: Optional[float] = Field(None, alias="maxTotalTrainingTime", description="Maximum total training time in seconds")
    tuner_space_options: Optional[Dict[str, List[StrictStr]]] = Field(None, alias="tunerSpaceOptions")
    space: Optional[List[TunerSpaceImpulse]] = Field(None, description="List of impulses specifying the EON Tuner search space")
    search_space_template: Optional[OptimizeConfigSearchSpaceTemplate] = Field(None, alias="searchSpaceTemplate")
    search_space_source: Optional[OptimizeConfigSearchSpaceSource] = Field(None, alias="searchSpaceSource")
    __properties = ["name", "targetLatency", "targetDevice", "compiler", "precision", "trainingCycles", "tuningMaxTrials", "tuningWorkers", "initialTrials", "optimizationRounds", "trialsPerOptimizationRound", "minMACCS", "maxMACCS", "tuningAlgorithm", "notificationOnCompletion", "importProjectMetrics", "importResourceMetrics", "numImportProjectMetrics", "numImportResourceMetrics", "enableSEM", "accuracySEM", "latencySEM", "optimizationObjectives", "rawObjectives", "optimizationPrecision", "earlyStopping", "earlyStoppingWindowSize", "earlyStoppingImprovementBar", "MOMF", "verboseLogging", "disableConstraints", "disableDeduplicate", "maxTotalTrainingTime", "tunerSpaceOptions", "space", "searchSpaceTemplate", "searchSpaceSource"]

    @validator('tuning_algorithm')
    def tuning_algorithm_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ('random', 'hyperband', 'bayesian', 'custom'):
            raise ValueError("must validate the enum values ('random', 'hyperband', 'bayesian', 'custom')")
        return v

    @validator('optimization_precision')
    def optimization_precision_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ('float32', 'int8'):
            raise ValueError("must validate the enum values ('float32', 'int8')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> OptimizeConfig:
        """Create an instance of OptimizeConfig from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of target_device
        if self.target_device:
            _dict['targetDevice'] = self.target_device.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in optimization_objectives (list)
        _items = []
        if self.optimization_objectives:
            for _item in self.optimization_objectives:
                if _item:
                    _items.append(_item.to_dict())
            _dict['optimizationObjectives'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in space (list)
        _items = []
        if self.space:
            for _item in self.space:
                if _item:
                    _items.append(_item.to_dict())
            _dict['space'] = _items
        # override the default output from pydantic by calling `to_dict()` of search_space_template
        if self.search_space_template:
            _dict['searchSpaceTemplate'] = self.search_space_template.to_dict()
        # override the default output from pydantic by calling `to_dict()` of search_space_source
        if self.search_space_source:
            _dict['searchSpaceSource'] = self.search_space_source.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> OptimizeConfig:
        """Create an instance of OptimizeConfig from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return OptimizeConfig.construct(**obj)

        _obj = OptimizeConfig.construct(**{
            "name": obj.get("name"),
            "target_latency": obj.get("targetLatency"),
            "target_device": OptimizeConfigTargetDevice.from_dict(obj.get("targetDevice")) if obj.get("targetDevice") is not None else None,
            "compiler": obj.get("compiler"),
            "precision": obj.get("precision"),
            "training_cycles": obj.get("trainingCycles"),
            "tuning_max_trials": obj.get("tuningMaxTrials"),
            "tuning_workers": obj.get("tuningWorkers"),
            "initial_trials": obj.get("initialTrials"),
            "optimization_rounds": obj.get("optimizationRounds"),
            "trials_per_optimization_round": obj.get("trialsPerOptimizationRound"),
            "min_maccs": obj.get("minMACCS"),
            "max_maccs": obj.get("maxMACCS"),
            "tuning_algorithm": obj.get("tuningAlgorithm"),
            "notification_on_completion": obj.get("notificationOnCompletion"),
            "import_project_metrics": obj.get("importProjectMetrics"),
            "import_resource_metrics": obj.get("importResourceMetrics"),
            "num_import_project_metrics": obj.get("numImportProjectMetrics"),
            "num_import_resource_metrics": obj.get("numImportResourceMetrics"),
            "enable_sem": obj.get("enableSEM"),
            "accuracy_sem": obj.get("accuracySEM"),
            "latency_sem": obj.get("latencySEM"),
            "optimization_objectives": [OptimizeConfigOptimizationObjectivesInner.from_dict(_item) for _item in obj.get("optimizationObjectives")] if obj.get("optimizationObjectives") is not None else None,
            "raw_objectives": obj.get("rawObjectives"),
            "optimization_precision": obj.get("optimizationPrecision"),
            "early_stopping": obj.get("earlyStopping"),
            "early_stopping_window_size": obj.get("earlyStoppingWindowSize"),
            "early_stopping_improvement_bar": obj.get("earlyStoppingImprovementBar"),
            "momf": obj.get("MOMF"),
            "verbose_logging": obj.get("verboseLogging"),
            "disable_constraints": obj.get("disableConstraints"),
            "disable_deduplicate": obj.get("disableDeduplicate"),
            "max_total_training_time": obj.get("maxTotalTrainingTime"),
            "tuner_space_options": obj.get("tunerSpaceOptions"),
            "space": [TunerSpaceImpulse.from_dict(_item) for _item in obj.get("space")] if obj.get("space") is not None else None,
            "search_space_template": OptimizeConfigSearchSpaceTemplate.from_dict(obj.get("searchSpaceTemplate")) if obj.get("searchSpaceTemplate") is not None else None,
            "search_space_source": OptimizeConfigSearchSpaceSource.from_dict(obj.get("searchSpaceSource")) if obj.get("searchSpaceSource") is not None else None
        })
        return _obj

