# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictInt
from edgeimpulse_api.models.neighbors_score_neighbor_windows_inner import NeighborsScoreNeighborWindowsInner
from edgeimpulse_api.models.sample import Sample

class NeighborsScore(BaseModel):
    id: StrictInt = Field(..., description="The ID of the sample this window belongs to")
    sample: Optional[Sample] = None
    window_start: StrictInt = Field(..., alias="windowStart", description="The start time of this window in milliseconds")
    window_end: StrictInt = Field(..., alias="windowEnd", description="The end time of this window in milliseconds")
    score: float = Field(..., description="The label noise score for this window, from 0 to the total number of windows.")
    neighbor_windows: List[NeighborsScoreNeighborWindowsInner] = Field(..., alias="neighborWindows", description="Details of the nearest neighbors to this window")
    __properties = ["id", "sample", "windowStart", "windowEnd", "score", "neighborWindows"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> NeighborsScore:
        """Create an instance of NeighborsScore from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of sample
        if self.sample:
            _dict['sample'] = self.sample.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in neighbor_windows (list)
        _items = []
        if self.neighbor_windows:
            for _item in self.neighbor_windows:
                if _item:
                    _items.append(_item.to_dict())
            _dict['neighborWindows'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> NeighborsScore:
        """Create an instance of NeighborsScore from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return NeighborsScore.construct(**obj)

        _obj = NeighborsScore.construct(**{
            "id": obj.get("id"),
            "sample": Sample.from_dict(obj.get("sample")) if obj.get("sample") is not None else None,
            "window_start": obj.get("windowStart"),
            "window_end": obj.get("windowEnd"),
            "score": obj.get("score"),
            "neighbor_windows": [NeighborsScoreNeighborWindowsInner.from_dict(_item) for _item in obj.get("neighborWindows")] if obj.get("neighborWindows") is not None else None
        })
        return _obj

