# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr
from edgeimpulse_api.models.keras_model_metadata_graph_series import KerasModelMetadataGraphSeries

class KerasModelMetadataGraph(BaseModel):
    title: StrictStr = Field(..., description="Graph title")
    x_label: Optional[StrictStr] = Field(None, alias="xLabel", description="X-axis title")
    y_label: Optional[StrictStr] = Field(None, alias="yLabel", description="Y-axis title")
    description: Optional[StrictStr] = Field(None, description="A description for the graph")
    hide_in_ui: Optional[StrictBool] = Field(None, alias="hideInUI", description="Whether this graph should be hidden by default in the Studio UI")
    data: List[KerasModelMetadataGraphSeries] = ...
    __properties = ["title", "xLabel", "yLabel", "description", "hideInUI", "data"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> KerasModelMetadataGraph:
        """Create an instance of KerasModelMetadataGraph from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in data (list)
        _items = []
        if self.data:
            for _item in self.data:
                if _item:
                    _items.append(_item.to_dict())
            _dict['data'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> KerasModelMetadataGraph:
        """Create an instance of KerasModelMetadataGraph from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return KerasModelMetadataGraph.construct(**obj)

        _obj = KerasModelMetadataGraph.construct(**{
            "title": obj.get("title"),
            "x_label": obj.get("xLabel"),
            "y_label": obj.get("yLabel"),
            "description": obj.get("description"),
            "hide_in_ui": obj.get("hideInUI"),
            "data": [KerasModelMetadataGraphSeries.from_dict(_item) for _item in obj.get("data")] if obj.get("data") is not None else None
        })
        return _obj

