# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, Dict, List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr
from edgeimpulse_api.models.created_updated_by_user import CreatedUpdatedByUser

class Job(BaseModel):
    id: StrictInt = Field(..., description="Job id, use this to refer back to the job. The web socket API also uses this ID.")
    category: StrictStr = ...
    key: StrictStr = Field(..., description="External job identifier, this can be used to categorize jobs, and recover job status. E.g. set this to 'keras-192' for a Keras learning block with ID 192. When a user refreshes the page you can check whether a job is active for this ID and re-attach. ")
    created: datetime = Field(..., description="When the job was created.")
    started: Optional[datetime] = Field(None, description="When the job was started.")
    finished: Optional[datetime] = Field(None, description="When the job was finished.")
    finished_successful: Optional[StrictBool] = Field(None, alias="finishedSuccessful", description="Whether the job finished successfully.")
    job_notification_uids: List[StrictInt] = Field(..., alias="jobNotificationUids", description="The IDs of users who should be notified when a job is finished.")
    additional_info: Optional[StrictStr] = Field(None, alias="additionalInfo", description="Additional metadata associated with this job.")
    compute_time: Optional[float] = Field(None, alias="computeTime", description="Job duration time in seconds from start to finished, measured by k8s job watcher.")
    created_by_user: Optional[CreatedUpdatedByUser] = Field(None, alias="createdByUser")
    category_count: Optional[StrictInt] = Field(None, alias="categoryCount", description="Some job categories keep a counter on the job number, e.g. in synthetic data, so we know what the 1st, 2nd etc. job was in the UI.")
    metadata: Optional[Dict[str, Any]] = Field(None, description="Structured job metadata")
    __properties = ["id", "category", "key", "created", "started", "finished", "finishedSuccessful", "jobNotificationUids", "additionalInfo", "computeTime", "createdByUser", "categoryCount", "metadata"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> Job:
        """Create an instance of Job from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of created_by_user
        if self.created_by_user:
            _dict['createdByUser'] = self.created_by_user.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Job:
        """Create an instance of Job from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return Job.construct(**obj)

        _obj = Job.construct(**{
            "id": obj.get("id"),
            "category": obj.get("category"),
            "key": obj.get("key"),
            "created": obj.get("created"),
            "started": obj.get("started"),
            "finished": obj.get("finished"),
            "finished_successful": obj.get("finishedSuccessful"),
            "job_notification_uids": obj.get("jobNotificationUids"),
            "additional_info": obj.get("additionalInfo"),
            "compute_time": obj.get("computeTime"),
            "created_by_user": CreatedUpdatedByUser.from_dict(obj.get("createdByUser")) if obj.get("createdByUser") is not None else None,
            "category_count": obj.get("categoryCount"),
            "metadata": obj.get("metadata")
        })
        return _obj

