# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List
from pydantic import BaseModel, Field, StrictStr
from edgeimpulse_api.models.inference_summary_metrics import InferenceSummaryMetrics

class InferenceHistoryAggregate(BaseModel):
    device_id: StrictStr = Field(..., alias="deviceId")
    device_name: StrictStr = Field(..., alias="deviceName")
    total_inferences: float = Field(..., alias="totalInferences")
    total_classifications: List[InferenceSummaryMetrics] = Field(..., alias="totalClassifications")
    means: List[InferenceSummaryMetrics] = ...
    standard_deviations: List[InferenceSummaryMetrics] = Field(..., alias="standardDeviations")
    metrics: List[InferenceSummaryMetrics] = ...
    __properties = ["deviceId", "deviceName", "totalInferences", "totalClassifications", "means", "standardDeviations", "metrics"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> InferenceHistoryAggregate:
        """Create an instance of InferenceHistoryAggregate from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in total_classifications (list)
        _items = []
        if self.total_classifications:
            for _item in self.total_classifications:
                if _item:
                    _items.append(_item.to_dict())
            _dict['totalClassifications'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in means (list)
        _items = []
        if self.means:
            for _item in self.means:
                if _item:
                    _items.append(_item.to_dict())
            _dict['means'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in standard_deviations (list)
        _items = []
        if self.standard_deviations:
            for _item in self.standard_deviations:
                if _item:
                    _items.append(_item.to_dict())
            _dict['standardDeviations'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in metrics (list)
        _items = []
        if self.metrics:
            for _item in self.metrics:
                if _item:
                    _items.append(_item.to_dict())
            _dict['metrics'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> InferenceHistoryAggregate:
        """Create an instance of InferenceHistoryAggregate from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return InferenceHistoryAggregate.construct(**obj)

        _obj = InferenceHistoryAggregate.construct(**{
            "device_id": obj.get("deviceId"),
            "device_name": obj.get("deviceName"),
            "total_inferences": obj.get("totalInferences"),
            "total_classifications": [InferenceSummaryMetrics.from_dict(_item) for _item in obj.get("totalClassifications")] if obj.get("totalClassifications") is not None else None,
            "means": [InferenceSummaryMetrics.from_dict(_item) for _item in obj.get("means")] if obj.get("means") is not None else None,
            "standard_deviations": [InferenceSummaryMetrics.from_dict(_item) for _item in obj.get("standardDeviations")] if obj.get("standardDeviations") is not None else None,
            "metrics": [InferenceSummaryMetrics.from_dict(_item) for _item in obj.get("metrics")] if obj.get("metrics") is not None else None
        })
        return _obj

