# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import List, Optional
from pydantic import BaseModel, Field, StrictInt, StrictStr, conint
from edgeimpulse_api.models.impulse_dsp_block_named_axes_inner import ImpulseDspBlockNamedAxesInner
from edgeimpulse_api.models.impulse_dsp_block_organization import ImpulseDspBlockOrganization

class ImpulseDspBlock(BaseModel):
    id: conint(strict=True, ge=1) = Field(..., description="Identifier for this block. Make sure to up this number when creating a new block via `getNewBlockId`, and don't re-use identifiers. If the block hasn't changed, keep the ID as-is. ID must be unique across the project and greather than zero (>0).")
    type: StrictStr = Field(..., description="Block type")
    name: StrictStr = Field(..., description="Block name, will be used in menus")
    axes: List[StrictStr] = Field(..., description="Input axes, identified by the name in the name of the axis")
    title: StrictStr = Field(..., description="Block title, used in the impulse UI")
    values_per_axis: Optional[StrictInt] = Field(None, alias="valuesPerAxis", description="Number of features this DSP block outputs per axis. This is only set when the DSP block is configured.")
    input: Optional[StrictInt] = Field(None, description="The ID of the Input block a DSP block is connected to")
    created_by: Optional[StrictStr] = Field(None, alias="createdBy", description="The system component that created the block version (createImpulse | clone | tuner). Cannot be set via API.")
    created_at: Optional[datetime] = Field(None, alias="createdAt", description="The datetime that the block version was created. Cannot be set via API.")
    implementation_version: StrictInt = Field(..., alias="implementationVersion", description="Implementation version of the block")
    organization: Optional[ImpulseDspBlockOrganization] = None
    custom_url: Optional[StrictStr] = Field(None, alias="customUrl", description="Required for type 'custom'")
    named_axes: Optional[List[ImpulseDspBlockNamedAxesInner]] = Field(None, alias="namedAxes", description="Named axes for the block")
    __properties = ["id", "type", "name", "axes", "title", "valuesPerAxis", "input", "createdBy", "createdAt", "implementationVersion", "organization", "customUrl", "namedAxes"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> ImpulseDspBlock:
        """Create an instance of ImpulseDspBlock from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of organization
        if self.organization:
            _dict['organization'] = self.organization.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in named_axes (list)
        _items = []
        if self.named_axes:
            for _item in self.named_axes:
                if _item:
                    _items.append(_item.to_dict())
            _dict['namedAxes'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ImpulseDspBlock:
        """Create an instance of ImpulseDspBlock from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return ImpulseDspBlock.construct(**obj)

        _obj = ImpulseDspBlock.construct(**{
            "id": obj.get("id"),
            "type": obj.get("type"),
            "name": obj.get("name"),
            "axes": obj.get("axes"),
            "title": obj.get("title"),
            "values_per_axis": obj.get("valuesPerAxis"),
            "input": obj.get("input"),
            "created_by": obj.get("createdBy"),
            "created_at": obj.get("createdAt"),
            "implementation_version": obj.get("implementationVersion"),
            "organization": ImpulseDspBlockOrganization.from_dict(obj.get("organization")) if obj.get("organization") is not None else None,
            "custom_url": obj.get("customUrl"),
            "named_axes": [ImpulseDspBlockNamedAxesInner.from_dict(_item) for _item in obj.get("namedAxes")] if obj.get("namedAxes") is not None else None
        })
        return _obj

