# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt

class GenerateFeaturesRequest(BaseModel):
    dsp_id: StrictInt = Field(..., alias="dspId", description="DSP block ID to generate features for")
    calculate_feature_importance: Optional[StrictBool] = Field(None, alias="calculateFeatureImportance", description="Whether to generate feature importance (only when available)")
    skip_feature_explorer: Optional[StrictBool] = Field(None, alias="skipFeatureExplorer", description="If set, skips feature explorer (used in tests)")
    __properties = ["dspId", "calculateFeatureImportance", "skipFeatureExplorer"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> GenerateFeaturesRequest:
        """Create an instance of GenerateFeaturesRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> GenerateFeaturesRequest:
        """Create an instance of GenerateFeaturesRequest from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return GenerateFeaturesRequest.construct(**obj)

        _obj = GenerateFeaturesRequest.construct(**{
            "dsp_id": obj.get("dspId"),
            "calculate_feature_importance": obj.get("calculateFeatureImportance"),
            "skip_feature_explorer": obj.get("skipFeatureExplorer")
        })
        return _obj

