# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictInt, StrictStr

class CreateOrganizationPortalRequest(BaseModel):
    name: StrictStr = Field(..., description="The name of the upload portal.")
    description: Optional[StrictStr] = Field(None, description="The purpose and description of the upload portal.")
    bucket_id: StrictInt = Field(..., alias="bucketId", description="The S3 bucket id to store the uploaded data. Set to '0' to select a bucket hosted by Edge Impulse.")
    bucket_path: StrictStr = Field(..., alias="bucketPath", description="The path in the bucket the upload portal will write to.")
    __properties = ["name", "description", "bucketId", "bucketPath"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> CreateOrganizationPortalRequest:
        """Create an instance of CreateOrganizationPortalRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CreateOrganizationPortalRequest:
        """Create an instance of CreateOrganizationPortalRequest from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return CreateOrganizationPortalRequest.construct(**obj)

        _obj = CreateOrganizationPortalRequest.construct(**{
            "name": obj.get("name"),
            "description": obj.get("description"),
            "bucket_id": obj.get("bucketId"),
            "bucket_path": obj.get("bucketPath")
        })
        return _obj

