# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr
from edgeimpulse_api.models.oauth_client import OauthClient

class AdminGetOauthClientsResponse(BaseModel):
    success: StrictBool = Field(..., description="Whether the operation succeeded")
    error: Optional[StrictStr] = Field(None, description="Optional error description (set if 'success' was false)")
    oauth_clients: List[OauthClient] = Field(..., alias="oauthClients")
    total_count: Optional[StrictInt] = Field(None, alias="totalCount", description="Total number of OAuth clients in the system.")
    __properties = ["success", "error", "oauthClients", "totalCount"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> AdminGetOauthClientsResponse:
        """Create an instance of AdminGetOauthClientsResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in oauth_clients (list)
        _items = []
        if self.oauth_clients:
            for _item in self.oauth_clients:
                if _item:
                    _items.append(_item.to_dict())
            _dict['oauthClients'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AdminGetOauthClientsResponse:
        """Create an instance of AdminGetOauthClientsResponse from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return AdminGetOauthClientsResponse.construct(**obj)

        _obj = AdminGetOauthClientsResponse.construct(**{
            "success": obj.get("success"),
            "error": obj.get("error"),
            "oauth_clients": [OauthClient.from_dict(_item) for _item in obj.get("oauthClients")] if obj.get("oauthClients") is not None else None,
            "total_count": obj.get("totalCount")
        })
        return _obj

