# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from pydantic import Field, StrictBool, StrictInt, StrictStr

from typing import Optional

from edgeimpulse_api.models.batch_add_metadata_request import BatchAddMetadataRequest
from edgeimpulse_api.models.batch_clear_metadata_by_key_request import BatchClearMetadataByKeyRequest
from edgeimpulse_api.models.count_samples_response import CountSamplesResponse
from edgeimpulse_api.models.crop_sample_request import CropSampleRequest
from edgeimpulse_api.models.crop_sample_response import CropSampleResponse
from edgeimpulse_api.models.data_explorer_predictions_response import DataExplorerPredictionsResponse
from edgeimpulse_api.models.data_explorer_settings import DataExplorerSettings
from edgeimpulse_api.models.edit_sample_label_request import EditSampleLabelRequest
from edgeimpulse_api.models.find_segment_sample_request import FindSegmentSampleRequest
from edgeimpulse_api.models.find_segment_sample_response import FindSegmentSampleResponse
from edgeimpulse_api.models.generic_api_response import GenericApiResponse
from edgeimpulse_api.models.get_ai_actions_proposed_changes_response import GetAIActionsProposedChangesResponse
from edgeimpulse_api.models.get_all_imported_from_response import GetAllImportedFromResponse
from edgeimpulse_api.models.get_data_explorer_features_response import GetDataExplorerFeaturesResponse
from edgeimpulse_api.models.get_data_explorer_settings_response import GetDataExplorerSettingsResponse
from edgeimpulse_api.models.get_diversity_data_response import GetDiversityDataResponse
from edgeimpulse_api.models.get_label_noise_data_response import GetLabelNoiseDataResponse
from edgeimpulse_api.models.get_sample_metadata_response import GetSampleMetadataResponse
from edgeimpulse_api.models.get_sample_response import GetSampleResponse
from edgeimpulse_api.models.has_data_explorer_features_response import HasDataExplorerFeaturesResponse
from edgeimpulse_api.models.list_samples_response import ListSamplesResponse
from edgeimpulse_api.models.move_raw_data_request import MoveRawDataRequest
from edgeimpulse_api.models.object_detection_auto_label_request import ObjectDetectionAutoLabelRequest
from edgeimpulse_api.models.object_detection_auto_label_response import ObjectDetectionAutoLabelResponse
from edgeimpulse_api.models.object_detection_label_queue_count_response import ObjectDetectionLabelQueueCountResponse
from edgeimpulse_api.models.object_detection_label_queue_response import ObjectDetectionLabelQueueResponse
from edgeimpulse_api.models.raw_data_category import RawDataCategory
from edgeimpulse_api.models.rebalance_dataset_response import RebalanceDatasetResponse
from edgeimpulse_api.models.rename_sample_request import RenameSampleRequest
from edgeimpulse_api.models.sample_bounding_boxes_request import SampleBoundingBoxesRequest
from edgeimpulse_api.models.segment_sample_request import SegmentSampleRequest
from edgeimpulse_api.models.set_sample_metadata_request import SetSampleMetadataRequest
from edgeimpulse_api.models.set_sample_proposed_changes_request import SetSampleProposedChangesRequest
from edgeimpulse_api.models.set_sample_structured_labels_request import SetSampleStructuredLabelsRequest
from edgeimpulse_api.models.set_sample_video_dimensions_request import SetSampleVideoDimensionsRequest
from edgeimpulse_api.models.split_sample_in_frames200_response import SplitSampleInFrames200Response
from edgeimpulse_api.models.split_sample_in_frames_request import SplitSampleInFramesRequest
from edgeimpulse_api.models.store_segment_length_request import StoreSegmentLengthRequest
from edgeimpulse_api.models.track_objects_request import TrackObjectsRequest
from edgeimpulse_api.models.track_objects_response import TrackObjectsResponse

from edgeimpulse_api.api_client import ApiClient
from edgeimpulse_api.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class RawDataApi(object):
    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def batch_add_metadata(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], category : Annotated[RawDataCategory, Field(..., description="Which of the three acquisition categories to retrieve data from")], batch_add_metadata_request : BatchAddMetadataRequest, labels : Annotated[Optional[StrictStr], Field(description="Only include samples with a label within the given list of labels, given as a JSON string")] = None, filename : Annotated[Optional[StrictStr], Field(description="Only include samples whose filename includes the given filename")] = None, max_length : Annotated[Optional[StrictInt], Field(description="Only include samples shorter than the given length, in milliseconds")] = None, min_length : Annotated[Optional[StrictInt], Field(description="Only include samples longer than the given length, in milliseconds")] = None, min_frequency : Annotated[Optional[float], Field(description="Only include samples with higher frequency than given frequency, in hertz")] = None, max_frequency : Annotated[Optional[float], Field(description="Only include samples with lower frequency than given frequency, in hertz")] = None, signature_validity : Annotated[Optional[StrictStr], Field(description="Include samples with either valid or invalid signatures")] = None, include_disabled : Annotated[Optional[StrictStr], Field(description="Include only enabled or disabled samples (or both)")] = None, ids : Annotated[Optional[StrictStr], Field(description="Only include samples with an ID within the given list of IDs, given as a JSON string")] = None, exclude_ids : Annotated[Optional[StrictStr], Field(description="Exclude samples with an ID within the given list of IDs, given as a JSON string")] = None, min_label : Annotated[Optional[float], Field(description="Only include samples with a label >= this value")] = None, max_label : Annotated[Optional[float], Field(description="Only include samples with a label < this value")] = None, search : Annotated[Optional[StrictStr], Field(description="Search query")] = None, data_type : Annotated[Optional[StrictStr], Field(description="Include only samples with a particular data type")] = None, min_id : Annotated[Optional[float], Field(description="Include only samples with an ID >= this value")] = None, max_id : Annotated[Optional[float], Field(description="Include only samples with an ID < this value")] = None, **kwargs) -> SplitSampleInFrames200Response:  # noqa: E501
        """Add metadata (multiple samples)

        Add specific metadata for multiple samples.

        :param project_id: Project ID (required)
        :type project_id: int
        :param category: Which of the three acquisition categories to retrieve data from (required)
        :type category: RawDataCategory
        :param batch_add_metadata_request: (required)
        :type batch_add_metadata_request: BatchAddMetadataRequest
        :param labels: Only include samples with a label within the given list of labels, given as a JSON string
        :type labels: str
        :param filename: Only include samples whose filename includes the given filename
        :type filename: str
        :param max_length: Only include samples shorter than the given length, in milliseconds
        :type max_length: int
        :param min_length: Only include samples longer than the given length, in milliseconds
        :type min_length: int
        :param min_frequency: Only include samples with higher frequency than given frequency, in hertz
        :type min_frequency: float
        :param max_frequency: Only include samples with lower frequency than given frequency, in hertz
        :type max_frequency: float
        :param signature_validity: Include samples with either valid or invalid signatures
        :type signature_validity: str
        :param include_disabled: Include only enabled or disabled samples (or both)
        :type include_disabled: str
        :param ids: Only include samples with an ID within the given list of IDs, given as a JSON string
        :type ids: str
        :param exclude_ids: Exclude samples with an ID within the given list of IDs, given as a JSON string
        :type exclude_ids: str
        :param min_label: Only include samples with a label >= this value
        :type min_label: float
        :param max_label: Only include samples with a label < this value
        :type max_label: float
        :param search: Search query
        :type search: str
        :param data_type: Include only samples with a particular data type
        :type data_type: str
        :param min_id: Include only samples with an ID >= this value
        :type min_id: float
        :param max_id: Include only samples with an ID < this value
        :type max_id: float
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SplitSampleInFrames200Response
        """
        kwargs['_return_http_data_only'] = True
        return self._batch_add_metadata_with_http_info(project_id, category, batch_add_metadata_request, labels, filename, max_length, min_length, min_frequency, max_frequency, signature_validity, include_disabled, ids, exclude_ids, min_label, max_label, search, data_type, min_id, max_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _batch_add_metadata_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], category : Annotated[RawDataCategory, Field(..., description="Which of the three acquisition categories to retrieve data from")], batch_add_metadata_request : BatchAddMetadataRequest, labels : Annotated[Optional[StrictStr], Field(description="Only include samples with a label within the given list of labels, given as a JSON string")] = None, filename : Annotated[Optional[StrictStr], Field(description="Only include samples whose filename includes the given filename")] = None, max_length : Annotated[Optional[StrictInt], Field(description="Only include samples shorter than the given length, in milliseconds")] = None, min_length : Annotated[Optional[StrictInt], Field(description="Only include samples longer than the given length, in milliseconds")] = None, min_frequency : Annotated[Optional[float], Field(description="Only include samples with higher frequency than given frequency, in hertz")] = None, max_frequency : Annotated[Optional[float], Field(description="Only include samples with lower frequency than given frequency, in hertz")] = None, signature_validity : Annotated[Optional[StrictStr], Field(description="Include samples with either valid or invalid signatures")] = None, include_disabled : Annotated[Optional[StrictStr], Field(description="Include only enabled or disabled samples (or both)")] = None, ids : Annotated[Optional[StrictStr], Field(description="Only include samples with an ID within the given list of IDs, given as a JSON string")] = None, exclude_ids : Annotated[Optional[StrictStr], Field(description="Exclude samples with an ID within the given list of IDs, given as a JSON string")] = None, min_label : Annotated[Optional[float], Field(description="Only include samples with a label >= this value")] = None, max_label : Annotated[Optional[float], Field(description="Only include samples with a label < this value")] = None, search : Annotated[Optional[StrictStr], Field(description="Search query")] = None, data_type : Annotated[Optional[StrictStr], Field(description="Include only samples with a particular data type")] = None, min_id : Annotated[Optional[float], Field(description="Include only samples with an ID >= this value")] = None, max_id : Annotated[Optional[float], Field(description="Include only samples with an ID < this value")] = None, **kwargs):  # noqa: E501
        """Add metadata (multiple samples) 

        Add specific metadata for multiple samples.

        :param project_id: Project ID (required)
        :type project_id: int
        :param category: Which of the three acquisition categories to retrieve data from (required)
        :type category: RawDataCategory
        :param batch_add_metadata_request: (required)
        :type batch_add_metadata_request: BatchAddMetadataRequest
        :param labels: Only include samples with a label within the given list of labels, given as a JSON string
        :type labels: str
        :param filename: Only include samples whose filename includes the given filename
        :type filename: str
        :param max_length: Only include samples shorter than the given length, in milliseconds
        :type max_length: int
        :param min_length: Only include samples longer than the given length, in milliseconds
        :type min_length: int
        :param min_frequency: Only include samples with higher frequency than given frequency, in hertz
        :type min_frequency: float
        :param max_frequency: Only include samples with lower frequency than given frequency, in hertz
        :type max_frequency: float
        :param signature_validity: Include samples with either valid or invalid signatures
        :type signature_validity: str
        :param include_disabled: Include only enabled or disabled samples (or both)
        :type include_disabled: str
        :param ids: Only include samples with an ID within the given list of IDs, given as a JSON string
        :type ids: str
        :param exclude_ids: Exclude samples with an ID within the given list of IDs, given as a JSON string
        :type exclude_ids: str
        :param min_label: Only include samples with a label >= this value
        :type min_label: float
        :param max_label: Only include samples with a label < this value
        :type max_label: float
        :param search: Search query
        :type search: str
        :param data_type: Include only samples with a particular data type
        :type data_type: str
        :param min_id: Include only samples with an ID >= this value
        :type min_id: float
        :param max_id: Include only samples with an ID < this value
        :type max_id: float
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SplitSampleInFrames200Response, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'category',
            'batch_add_metadata_request',
            'labels',
            'filename',
            'max_length',
            'min_length',
            'min_frequency',
            'max_frequency',
            'signature_validity',
            'include_disabled',
            'ids',
            'exclude_ids',
            'min_label',
            'max_label',
            'search',
            'data_type',
            'min_id',
            'max_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_add_metadata" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []
        if _params.get('category') is not None:  # noqa: E501
            _query_params.append(('category', _params['category']))
        if _params.get('labels') is not None:  # noqa: E501
            _query_params.append(('labels', _params['labels']))
        if _params.get('filename') is not None:  # noqa: E501
            _query_params.append(('filename', _params['filename']))
        if _params.get('max_length') is not None:  # noqa: E501
            _query_params.append(('maxLength', _params['max_length']))
        if _params.get('min_length') is not None:  # noqa: E501
            _query_params.append(('minLength', _params['min_length']))
        if _params.get('min_frequency') is not None:  # noqa: E501
            _query_params.append(('minFrequency', _params['min_frequency']))
        if _params.get('max_frequency') is not None:  # noqa: E501
            _query_params.append(('maxFrequency', _params['max_frequency']))
        if _params.get('signature_validity') is not None:  # noqa: E501
            _query_params.append(('signatureValidity', _params['signature_validity']))
        if _params.get('include_disabled') is not None:  # noqa: E501
            _query_params.append(('includeDisabled', _params['include_disabled']))
        if _params.get('ids') is not None:  # noqa: E501
            _query_params.append(('ids', _params['ids']))
        if _params.get('exclude_ids') is not None:  # noqa: E501
            _query_params.append(('excludeIds', _params['exclude_ids']))
        if _params.get('min_label') is not None:  # noqa: E501
            _query_params.append(('minLabel', _params['min_label']))
        if _params.get('max_label') is not None:  # noqa: E501
            _query_params.append(('maxLabel', _params['max_label']))
        if _params.get('search') is not None:  # noqa: E501
            _query_params.append(('search', _params['search']))
        if _params.get('data_type') is not None:  # noqa: E501
            _query_params.append(('dataType', _params['data_type']))
        if _params.get('min_id') is not None:  # noqa: E501
            _query_params.append(('minId', _params['min_id']))
        if _params.get('max_id') is not None:  # noqa: E501
            _query_params.append(('maxId', _params['max_id']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['batch_add_metadata_request']:
            _body_params = _params['batch_add_metadata_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "SplitSampleInFrames200Response",
        }

        return self.api_client.call_api(
            '/api/{projectId}/raw-data/batch/add-metadata', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def batch_clear_metadata(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], category : Annotated[RawDataCategory, Field(..., description="Which of the three acquisition categories to retrieve data from")], labels : Annotated[Optional[StrictStr], Field(description="Only include samples with a label within the given list of labels, given as a JSON string")] = None, filename : Annotated[Optional[StrictStr], Field(description="Only include samples whose filename includes the given filename")] = None, max_length : Annotated[Optional[StrictInt], Field(description="Only include samples shorter than the given length, in milliseconds")] = None, min_length : Annotated[Optional[StrictInt], Field(description="Only include samples longer than the given length, in milliseconds")] = None, min_frequency : Annotated[Optional[float], Field(description="Only include samples with higher frequency than given frequency, in hertz")] = None, max_frequency : Annotated[Optional[float], Field(description="Only include samples with lower frequency than given frequency, in hertz")] = None, signature_validity : Annotated[Optional[StrictStr], Field(description="Include samples with either valid or invalid signatures")] = None, include_disabled : Annotated[Optional[StrictStr], Field(description="Include only enabled or disabled samples (or both)")] = None, ids : Annotated[Optional[StrictStr], Field(description="Only include samples with an ID within the given list of IDs, given as a JSON string")] = None, exclude_ids : Annotated[Optional[StrictStr], Field(description="Exclude samples with an ID within the given list of IDs, given as a JSON string")] = None, min_label : Annotated[Optional[float], Field(description="Only include samples with a label >= this value")] = None, max_label : Annotated[Optional[float], Field(description="Only include samples with a label < this value")] = None, search : Annotated[Optional[StrictStr], Field(description="Search query")] = None, data_type : Annotated[Optional[StrictStr], Field(description="Include only samples with a particular data type")] = None, min_id : Annotated[Optional[float], Field(description="Include only samples with an ID >= this value")] = None, max_id : Annotated[Optional[float], Field(description="Include only samples with an ID < this value")] = None, **kwargs) -> GenericApiResponse:  # noqa: E501
        """Clear all metadata (multiple samples)

        Clears all metadata for multiple samples.

        :param project_id: Project ID (required)
        :type project_id: int
        :param category: Which of the three acquisition categories to retrieve data from (required)
        :type category: RawDataCategory
        :param labels: Only include samples with a label within the given list of labels, given as a JSON string
        :type labels: str
        :param filename: Only include samples whose filename includes the given filename
        :type filename: str
        :param max_length: Only include samples shorter than the given length, in milliseconds
        :type max_length: int
        :param min_length: Only include samples longer than the given length, in milliseconds
        :type min_length: int
        :param min_frequency: Only include samples with higher frequency than given frequency, in hertz
        :type min_frequency: float
        :param max_frequency: Only include samples with lower frequency than given frequency, in hertz
        :type max_frequency: float
        :param signature_validity: Include samples with either valid or invalid signatures
        :type signature_validity: str
        :param include_disabled: Include only enabled or disabled samples (or both)
        :type include_disabled: str
        :param ids: Only include samples with an ID within the given list of IDs, given as a JSON string
        :type ids: str
        :param exclude_ids: Exclude samples with an ID within the given list of IDs, given as a JSON string
        :type exclude_ids: str
        :param min_label: Only include samples with a label >= this value
        :type min_label: float
        :param max_label: Only include samples with a label < this value
        :type max_label: float
        :param search: Search query
        :type search: str
        :param data_type: Include only samples with a particular data type
        :type data_type: str
        :param min_id: Include only samples with an ID >= this value
        :type min_id: float
        :param max_id: Include only samples with an ID < this value
        :type max_id: float
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GenericApiResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._batch_clear_metadata_with_http_info(project_id, category, labels, filename, max_length, min_length, min_frequency, max_frequency, signature_validity, include_disabled, ids, exclude_ids, min_label, max_label, search, data_type, min_id, max_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _batch_clear_metadata_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], category : Annotated[RawDataCategory, Field(..., description="Which of the three acquisition categories to retrieve data from")], labels : Annotated[Optional[StrictStr], Field(description="Only include samples with a label within the given list of labels, given as a JSON string")] = None, filename : Annotated[Optional[StrictStr], Field(description="Only include samples whose filename includes the given filename")] = None, max_length : Annotated[Optional[StrictInt], Field(description="Only include samples shorter than the given length, in milliseconds")] = None, min_length : Annotated[Optional[StrictInt], Field(description="Only include samples longer than the given length, in milliseconds")] = None, min_frequency : Annotated[Optional[float], Field(description="Only include samples with higher frequency than given frequency, in hertz")] = None, max_frequency : Annotated[Optional[float], Field(description="Only include samples with lower frequency than given frequency, in hertz")] = None, signature_validity : Annotated[Optional[StrictStr], Field(description="Include samples with either valid or invalid signatures")] = None, include_disabled : Annotated[Optional[StrictStr], Field(description="Include only enabled or disabled samples (or both)")] = None, ids : Annotated[Optional[StrictStr], Field(description="Only include samples with an ID within the given list of IDs, given as a JSON string")] = None, exclude_ids : Annotated[Optional[StrictStr], Field(description="Exclude samples with an ID within the given list of IDs, given as a JSON string")] = None, min_label : Annotated[Optional[float], Field(description="Only include samples with a label >= this value")] = None, max_label : Annotated[Optional[float], Field(description="Only include samples with a label < this value")] = None, search : Annotated[Optional[StrictStr], Field(description="Search query")] = None, data_type : Annotated[Optional[StrictStr], Field(description="Include only samples with a particular data type")] = None, min_id : Annotated[Optional[float], Field(description="Include only samples with an ID >= this value")] = None, max_id : Annotated[Optional[float], Field(description="Include only samples with an ID < this value")] = None, **kwargs):  # noqa: E501
        """Clear all metadata (multiple samples) 

        Clears all metadata for multiple samples.

        :param project_id: Project ID (required)
        :type project_id: int
        :param category: Which of the three acquisition categories to retrieve data from (required)
        :type category: RawDataCategory
        :param labels: Only include samples with a label within the given list of labels, given as a JSON string
        :type labels: str
        :param filename: Only include samples whose filename includes the given filename
        :type filename: str
        :param max_length: Only include samples shorter than the given length, in milliseconds
        :type max_length: int
        :param min_length: Only include samples longer than the given length, in milliseconds
        :type min_length: int
        :param min_frequency: Only include samples with higher frequency than given frequency, in hertz
        :type min_frequency: float
        :param max_frequency: Only include samples with lower frequency than given frequency, in hertz
        :type max_frequency: float
        :param signature_validity: Include samples with either valid or invalid signatures
        :type signature_validity: str
        :param include_disabled: Include only enabled or disabled samples (or both)
        :type include_disabled: str
        :param ids: Only include samples with an ID within the given list of IDs, given as a JSON string
        :type ids: str
        :param exclude_ids: Exclude samples with an ID within the given list of IDs, given as a JSON string
        :type exclude_ids: str
        :param min_label: Only include samples with a label >= this value
        :type min_label: float
        :param max_label: Only include samples with a label < this value
        :type max_label: float
        :param search: Search query
        :type search: str
        :param data_type: Include only samples with a particular data type
        :type data_type: str
        :param min_id: Include only samples with an ID >= this value
        :type min_id: float
        :param max_id: Include only samples with an ID < this value
        :type max_id: float
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GenericApiResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'category',
            'labels',
            'filename',
            'max_length',
            'min_length',
            'min_frequency',
            'max_frequency',
            'signature_validity',
            'include_disabled',
            'ids',
            'exclude_ids',
            'min_label',
            'max_label',
            'search',
            'data_type',
            'min_id',
            'max_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_clear_metadata" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []
        if _params.get('category') is not None:  # noqa: E501
            _query_params.append(('category', _params['category']))
        if _params.get('labels') is not None:  # noqa: E501
            _query_params.append(('labels', _params['labels']))
        if _params.get('filename') is not None:  # noqa: E501
            _query_params.append(('filename', _params['filename']))
        if _params.get('max_length') is not None:  # noqa: E501
            _query_params.append(('maxLength', _params['max_length']))
        if _params.get('min_length') is not None:  # noqa: E501
            _query_params.append(('minLength', _params['min_length']))
        if _params.get('min_frequency') is not None:  # noqa: E501
            _query_params.append(('minFrequency', _params['min_frequency']))
        if _params.get('max_frequency') is not None:  # noqa: E501
            _query_params.append(('maxFrequency', _params['max_frequency']))
        if _params.get('signature_validity') is not None:  # noqa: E501
            _query_params.append(('signatureValidity', _params['signature_validity']))
        if _params.get('include_disabled') is not None:  # noqa: E501
            _query_params.append(('includeDisabled', _params['include_disabled']))
        if _params.get('ids') is not None:  # noqa: E501
            _query_params.append(('ids', _params['ids']))
        if _params.get('exclude_ids') is not None:  # noqa: E501
            _query_params.append(('excludeIds', _params['exclude_ids']))
        if _params.get('min_label') is not None:  # noqa: E501
            _query_params.append(('minLabel', _params['min_label']))
        if _params.get('max_label') is not None:  # noqa: E501
            _query_params.append(('maxLabel', _params['max_label']))
        if _params.get('search') is not None:  # noqa: E501
            _query_params.append(('search', _params['search']))
        if _params.get('data_type') is not None:  # noqa: E501
            _query_params.append(('dataType', _params['data_type']))
        if _params.get('min_id') is not None:  # noqa: E501
            _query_params.append(('minId', _params['min_id']))
        if _params.get('max_id') is not None:  # noqa: E501
            _query_params.append(('maxId', _params['max_id']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GenericApiResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/raw-data/batch/clear-metadata', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def batch_clear_metadata_by_key(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], category : Annotated[RawDataCategory, Field(..., description="Which of the three acquisition categories to retrieve data from")], batch_clear_metadata_by_key_request : BatchClearMetadataByKeyRequest, labels : Annotated[Optional[StrictStr], Field(description="Only include samples with a label within the given list of labels, given as a JSON string")] = None, filename : Annotated[Optional[StrictStr], Field(description="Only include samples whose filename includes the given filename")] = None, max_length : Annotated[Optional[StrictInt], Field(description="Only include samples shorter than the given length, in milliseconds")] = None, min_length : Annotated[Optional[StrictInt], Field(description="Only include samples longer than the given length, in milliseconds")] = None, min_frequency : Annotated[Optional[float], Field(description="Only include samples with higher frequency than given frequency, in hertz")] = None, max_frequency : Annotated[Optional[float], Field(description="Only include samples with lower frequency than given frequency, in hertz")] = None, signature_validity : Annotated[Optional[StrictStr], Field(description="Include samples with either valid or invalid signatures")] = None, include_disabled : Annotated[Optional[StrictStr], Field(description="Include only enabled or disabled samples (or both)")] = None, ids : Annotated[Optional[StrictStr], Field(description="Only include samples with an ID within the given list of IDs, given as a JSON string")] = None, exclude_ids : Annotated[Optional[StrictStr], Field(description="Exclude samples with an ID within the given list of IDs, given as a JSON string")] = None, min_label : Annotated[Optional[float], Field(description="Only include samples with a label >= this value")] = None, max_label : Annotated[Optional[float], Field(description="Only include samples with a label < this value")] = None, search : Annotated[Optional[StrictStr], Field(description="Search query")] = None, data_type : Annotated[Optional[StrictStr], Field(description="Include only samples with a particular data type")] = None, min_id : Annotated[Optional[float], Field(description="Include only samples with an ID >= this value")] = None, max_id : Annotated[Optional[float], Field(description="Include only samples with an ID < this value")] = None, **kwargs) -> SplitSampleInFrames200Response:  # noqa: E501
        """Clear metadata by key (multiple samples)

        Clears a specific metadata field (by key) for multiple samples.

        :param project_id: Project ID (required)
        :type project_id: int
        :param category: Which of the three acquisition categories to retrieve data from (required)
        :type category: RawDataCategory
        :param batch_clear_metadata_by_key_request: (required)
        :type batch_clear_metadata_by_key_request: BatchClearMetadataByKeyRequest
        :param labels: Only include samples with a label within the given list of labels, given as a JSON string
        :type labels: str
        :param filename: Only include samples whose filename includes the given filename
        :type filename: str
        :param max_length: Only include samples shorter than the given length, in milliseconds
        :type max_length: int
        :param min_length: Only include samples longer than the given length, in milliseconds
        :type min_length: int
        :param min_frequency: Only include samples with higher frequency than given frequency, in hertz
        :type min_frequency: float
        :param max_frequency: Only include samples with lower frequency than given frequency, in hertz
        :type max_frequency: float
        :param signature_validity: Include samples with either valid or invalid signatures
        :type signature_validity: str
        :param include_disabled: Include only enabled or disabled samples (or both)
        :type include_disabled: str
        :param ids: Only include samples with an ID within the given list of IDs, given as a JSON string
        :type ids: str
        :param exclude_ids: Exclude samples with an ID within the given list of IDs, given as a JSON string
        :type exclude_ids: str
        :param min_label: Only include samples with a label >= this value
        :type min_label: float
        :param max_label: Only include samples with a label < this value
        :type max_label: float
        :param search: Search query
        :type search: str
        :param data_type: Include only samples with a particular data type
        :type data_type: str
        :param min_id: Include only samples with an ID >= this value
        :type min_id: float
        :param max_id: Include only samples with an ID < this value
        :type max_id: float
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SplitSampleInFrames200Response
        """
        kwargs['_return_http_data_only'] = True
        return self._batch_clear_metadata_by_key_with_http_info(project_id, category, batch_clear_metadata_by_key_request, labels, filename, max_length, min_length, min_frequency, max_frequency, signature_validity, include_disabled, ids, exclude_ids, min_label, max_label, search, data_type, min_id, max_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _batch_clear_metadata_by_key_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], category : Annotated[RawDataCategory, Field(..., description="Which of the three acquisition categories to retrieve data from")], batch_clear_metadata_by_key_request : BatchClearMetadataByKeyRequest, labels : Annotated[Optional[StrictStr], Field(description="Only include samples with a label within the given list of labels, given as a JSON string")] = None, filename : Annotated[Optional[StrictStr], Field(description="Only include samples whose filename includes the given filename")] = None, max_length : Annotated[Optional[StrictInt], Field(description="Only include samples shorter than the given length, in milliseconds")] = None, min_length : Annotated[Optional[StrictInt], Field(description="Only include samples longer than the given length, in milliseconds")] = None, min_frequency : Annotated[Optional[float], Field(description="Only include samples with higher frequency than given frequency, in hertz")] = None, max_frequency : Annotated[Optional[float], Field(description="Only include samples with lower frequency than given frequency, in hertz")] = None, signature_validity : Annotated[Optional[StrictStr], Field(description="Include samples with either valid or invalid signatures")] = None, include_disabled : Annotated[Optional[StrictStr], Field(description="Include only enabled or disabled samples (or both)")] = None, ids : Annotated[Optional[StrictStr], Field(description="Only include samples with an ID within the given list of IDs, given as a JSON string")] = None, exclude_ids : Annotated[Optional[StrictStr], Field(description="Exclude samples with an ID within the given list of IDs, given as a JSON string")] = None, min_label : Annotated[Optional[float], Field(description="Only include samples with a label >= this value")] = None, max_label : Annotated[Optional[float], Field(description="Only include samples with a label < this value")] = None, search : Annotated[Optional[StrictStr], Field(description="Search query")] = None, data_type : Annotated[Optional[StrictStr], Field(description="Include only samples with a particular data type")] = None, min_id : Annotated[Optional[float], Field(description="Include only samples with an ID >= this value")] = None, max_id : Annotated[Optional[float], Field(description="Include only samples with an ID < this value")] = None, **kwargs):  # noqa: E501
        """Clear metadata by key (multiple samples) 

        Clears a specific metadata field (by key) for multiple samples.

        :param project_id: Project ID (required)
        :type project_id: int
        :param category: Which of the three acquisition categories to retrieve data from (required)
        :type category: RawDataCategory
        :param batch_clear_metadata_by_key_request: (required)
        :type batch_clear_metadata_by_key_request: BatchClearMetadataByKeyRequest
        :param labels: Only include samples with a label within the given list of labels, given as a JSON string
        :type labels: str
        :param filename: Only include samples whose filename includes the given filename
        :type filename: str
        :param max_length: Only include samples shorter than the given length, in milliseconds
        :type max_length: int
        :param min_length: Only include samples longer than the given length, in milliseconds
        :type min_length: int
        :param min_frequency: Only include samples with higher frequency than given frequency, in hertz
        :type min_frequency: float
        :param max_frequency: Only include samples with lower frequency than given frequency, in hertz
        :type max_frequency: float
        :param signature_validity: Include samples with either valid or invalid signatures
        :type signature_validity: str
        :param include_disabled: Include only enabled or disabled samples (or both)
        :type include_disabled: str
        :param ids: Only include samples with an ID within the given list of IDs, given as a JSON string
        :type ids: str
        :param exclude_ids: Exclude samples with an ID within the given list of IDs, given as a JSON string
        :type exclude_ids: str
        :param min_label: Only include samples with a label >= this value
        :type min_label: float
        :param max_label: Only include samples with a label < this value
        :type max_label: float
        :param search: Search query
        :type search: str
        :param data_type: Include only samples with a particular data type
        :type data_type: str
        :param min_id: Include only samples with an ID >= this value
        :type min_id: float
        :param max_id: Include only samples with an ID < this value
        :type max_id: float
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SplitSampleInFrames200Response, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'category',
            'batch_clear_metadata_by_key_request',
            'labels',
            'filename',
            'max_length',
            'min_length',
            'min_frequency',
            'max_frequency',
            'signature_validity',
            'include_disabled',
            'ids',
            'exclude_ids',
            'min_label',
            'max_label',
            'search',
            'data_type',
            'min_id',
            'max_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_clear_metadata_by_key" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []
        if _params.get('category') is not None:  # noqa: E501
            _query_params.append(('category', _params['category']))
        if _params.get('labels') is not None:  # noqa: E501
            _query_params.append(('labels', _params['labels']))
        if _params.get('filename') is not None:  # noqa: E501
            _query_params.append(('filename', _params['filename']))
        if _params.get('max_length') is not None:  # noqa: E501
            _query_params.append(('maxLength', _params['max_length']))
        if _params.get('min_length') is not None:  # noqa: E501
            _query_params.append(('minLength', _params['min_length']))
        if _params.get('min_frequency') is not None:  # noqa: E501
            _query_params.append(('minFrequency', _params['min_frequency']))
        if _params.get('max_frequency') is not None:  # noqa: E501
            _query_params.append(('maxFrequency', _params['max_frequency']))
        if _params.get('signature_validity') is not None:  # noqa: E501
            _query_params.append(('signatureValidity', _params['signature_validity']))
        if _params.get('include_disabled') is not None:  # noqa: E501
            _query_params.append(('includeDisabled', _params['include_disabled']))
        if _params.get('ids') is not None:  # noqa: E501
            _query_params.append(('ids', _params['ids']))
        if _params.get('exclude_ids') is not None:  # noqa: E501
            _query_params.append(('excludeIds', _params['exclude_ids']))
        if _params.get('min_label') is not None:  # noqa: E501
            _query_params.append(('minLabel', _params['min_label']))
        if _params.get('max_label') is not None:  # noqa: E501
            _query_params.append(('maxLabel', _params['max_label']))
        if _params.get('search') is not None:  # noqa: E501
            _query_params.append(('search', _params['search']))
        if _params.get('data_type') is not None:  # noqa: E501
            _query_params.append(('dataType', _params['data_type']))
        if _params.get('min_id') is not None:  # noqa: E501
            _query_params.append(('minId', _params['min_id']))
        if _params.get('max_id') is not None:  # noqa: E501
            _query_params.append(('maxId', _params['max_id']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['batch_clear_metadata_by_key_request']:
            _body_params = _params['batch_clear_metadata_by_key_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "SplitSampleInFrames200Response",
        }

        return self.api_client.call_api(
            '/api/{projectId}/raw-data/batch/clear-metadata-by-key', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def batch_delete(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], category : Annotated[RawDataCategory, Field(..., description="Which of the three acquisition categories to retrieve data from")], labels : Annotated[Optional[StrictStr], Field(description="Only include samples with a label within the given list of labels, given as a JSON string")] = None, filename : Annotated[Optional[StrictStr], Field(description="Only include samples whose filename includes the given filename")] = None, max_length : Annotated[Optional[StrictInt], Field(description="Only include samples shorter than the given length, in milliseconds")] = None, min_length : Annotated[Optional[StrictInt], Field(description="Only include samples longer than the given length, in milliseconds")] = None, min_frequency : Annotated[Optional[float], Field(description="Only include samples with higher frequency than given frequency, in hertz")] = None, max_frequency : Annotated[Optional[float], Field(description="Only include samples with lower frequency than given frequency, in hertz")] = None, signature_validity : Annotated[Optional[StrictStr], Field(description="Include samples with either valid or invalid signatures")] = None, include_disabled : Annotated[Optional[StrictStr], Field(description="Include only enabled or disabled samples (or both)")] = None, ids : Annotated[Optional[StrictStr], Field(description="Only include samples with an ID within the given list of IDs, given as a JSON string")] = None, exclude_ids : Annotated[Optional[StrictStr], Field(description="Exclude samples with an ID within the given list of IDs, given as a JSON string")] = None, min_label : Annotated[Optional[float], Field(description="Only include samples with a label >= this value")] = None, max_label : Annotated[Optional[float], Field(description="Only include samples with a label < this value")] = None, search : Annotated[Optional[StrictStr], Field(description="Search query")] = None, data_type : Annotated[Optional[StrictStr], Field(description="Include only samples with a particular data type")] = None, min_id : Annotated[Optional[float], Field(description="Include only samples with an ID >= this value")] = None, max_id : Annotated[Optional[float], Field(description="Include only samples with an ID < this value")] = None, **kwargs) -> SplitSampleInFrames200Response:  # noqa: E501
        """Remove multiple samples

        Deletes samples. Note that this does not delete the data from cold storage. Depending on the number of affected samples this will either execute immediately or return the ID of a job that will perform this action in batches. 

        :param project_id: Project ID (required)
        :type project_id: int
        :param category: Which of the three acquisition categories to retrieve data from (required)
        :type category: RawDataCategory
        :param labels: Only include samples with a label within the given list of labels, given as a JSON string
        :type labels: str
        :param filename: Only include samples whose filename includes the given filename
        :type filename: str
        :param max_length: Only include samples shorter than the given length, in milliseconds
        :type max_length: int
        :param min_length: Only include samples longer than the given length, in milliseconds
        :type min_length: int
        :param min_frequency: Only include samples with higher frequency than given frequency, in hertz
        :type min_frequency: float
        :param max_frequency: Only include samples with lower frequency than given frequency, in hertz
        :type max_frequency: float
        :param signature_validity: Include samples with either valid or invalid signatures
        :type signature_validity: str
        :param include_disabled: Include only enabled or disabled samples (or both)
        :type include_disabled: str
        :param ids: Only include samples with an ID within the given list of IDs, given as a JSON string
        :type ids: str
        :param exclude_ids: Exclude samples with an ID within the given list of IDs, given as a JSON string
        :type exclude_ids: str
        :param min_label: Only include samples with a label >= this value
        :type min_label: float
        :param max_label: Only include samples with a label < this value
        :type max_label: float
        :param search: Search query
        :type search: str
        :param data_type: Include only samples with a particular data type
        :type data_type: str
        :param min_id: Include only samples with an ID >= this value
        :type min_id: float
        :param max_id: Include only samples with an ID < this value
        :type max_id: float
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SplitSampleInFrames200Response
        """
        kwargs['_return_http_data_only'] = True
        return self._batch_delete_with_http_info(project_id, category, labels, filename, max_length, min_length, min_frequency, max_frequency, signature_validity, include_disabled, ids, exclude_ids, min_label, max_label, search, data_type, min_id, max_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _batch_delete_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], category : Annotated[RawDataCategory, Field(..., description="Which of the three acquisition categories to retrieve data from")], labels : Annotated[Optional[StrictStr], Field(description="Only include samples with a label within the given list of labels, given as a JSON string")] = None, filename : Annotated[Optional[StrictStr], Field(description="Only include samples whose filename includes the given filename")] = None, max_length : Annotated[Optional[StrictInt], Field(description="Only include samples shorter than the given length, in milliseconds")] = None, min_length : Annotated[Optional[StrictInt], Field(description="Only include samples longer than the given length, in milliseconds")] = None, min_frequency : Annotated[Optional[float], Field(description="Only include samples with higher frequency than given frequency, in hertz")] = None, max_frequency : Annotated[Optional[float], Field(description="Only include samples with lower frequency than given frequency, in hertz")] = None, signature_validity : Annotated[Optional[StrictStr], Field(description="Include samples with either valid or invalid signatures")] = None, include_disabled : Annotated[Optional[StrictStr], Field(description="Include only enabled or disabled samples (or both)")] = None, ids : Annotated[Optional[StrictStr], Field(description="Only include samples with an ID within the given list of IDs, given as a JSON string")] = None, exclude_ids : Annotated[Optional[StrictStr], Field(description="Exclude samples with an ID within the given list of IDs, given as a JSON string")] = None, min_label : Annotated[Optional[float], Field(description="Only include samples with a label >= this value")] = None, max_label : Annotated[Optional[float], Field(description="Only include samples with a label < this value")] = None, search : Annotated[Optional[StrictStr], Field(description="Search query")] = None, data_type : Annotated[Optional[StrictStr], Field(description="Include only samples with a particular data type")] = None, min_id : Annotated[Optional[float], Field(description="Include only samples with an ID >= this value")] = None, max_id : Annotated[Optional[float], Field(description="Include only samples with an ID < this value")] = None, **kwargs):  # noqa: E501
        """Remove multiple samples 

        Deletes samples. Note that this does not delete the data from cold storage. Depending on the number of affected samples this will either execute immediately or return the ID of a job that will perform this action in batches. 

        :param project_id: Project ID (required)
        :type project_id: int
        :param category: Which of the three acquisition categories to retrieve data from (required)
        :type category: RawDataCategory
        :param labels: Only include samples with a label within the given list of labels, given as a JSON string
        :type labels: str
        :param filename: Only include samples whose filename includes the given filename
        :type filename: str
        :param max_length: Only include samples shorter than the given length, in milliseconds
        :type max_length: int
        :param min_length: Only include samples longer than the given length, in milliseconds
        :type min_length: int
        :param min_frequency: Only include samples with higher frequency than given frequency, in hertz
        :type min_frequency: float
        :param max_frequency: Only include samples with lower frequency than given frequency, in hertz
        :type max_frequency: float
        :param signature_validity: Include samples with either valid or invalid signatures
        :type signature_validity: str
        :param include_disabled: Include only enabled or disabled samples (or both)
        :type include_disabled: str
        :param ids: Only include samples with an ID within the given list of IDs, given as a JSON string
        :type ids: str
        :param exclude_ids: Exclude samples with an ID within the given list of IDs, given as a JSON string
        :type exclude_ids: str
        :param min_label: Only include samples with a label >= this value
        :type min_label: float
        :param max_label: Only include samples with a label < this value
        :type max_label: float
        :param search: Search query
        :type search: str
        :param data_type: Include only samples with a particular data type
        :type data_type: str
        :param min_id: Include only samples with an ID >= this value
        :type min_id: float
        :param max_id: Include only samples with an ID < this value
        :type max_id: float
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SplitSampleInFrames200Response, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'category',
            'labels',
            'filename',
            'max_length',
            'min_length',
            'min_frequency',
            'max_frequency',
            'signature_validity',
            'include_disabled',
            'ids',
            'exclude_ids',
            'min_label',
            'max_label',
            'search',
            'data_type',
            'min_id',
            'max_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_delete" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []
        if _params.get('category') is not None:  # noqa: E501
            _query_params.append(('category', _params['category']))
        if _params.get('labels') is not None:  # noqa: E501
            _query_params.append(('labels', _params['labels']))
        if _params.get('filename') is not None:  # noqa: E501
            _query_params.append(('filename', _params['filename']))
        if _params.get('max_length') is not None:  # noqa: E501
            _query_params.append(('maxLength', _params['max_length']))
        if _params.get('min_length') is not None:  # noqa: E501
            _query_params.append(('minLength', _params['min_length']))
        if _params.get('min_frequency') is not None:  # noqa: E501
            _query_params.append(('minFrequency', _params['min_frequency']))
        if _params.get('max_frequency') is not None:  # noqa: E501
            _query_params.append(('maxFrequency', _params['max_frequency']))
        if _params.get('signature_validity') is not None:  # noqa: E501
            _query_params.append(('signatureValidity', _params['signature_validity']))
        if _params.get('include_disabled') is not None:  # noqa: E501
            _query_params.append(('includeDisabled', _params['include_disabled']))
        if _params.get('ids') is not None:  # noqa: E501
            _query_params.append(('ids', _params['ids']))
        if _params.get('exclude_ids') is not None:  # noqa: E501
            _query_params.append(('excludeIds', _params['exclude_ids']))
        if _params.get('min_label') is not None:  # noqa: E501
            _query_params.append(('minLabel', _params['min_label']))
        if _params.get('max_label') is not None:  # noqa: E501
            _query_params.append(('maxLabel', _params['max_label']))
        if _params.get('search') is not None:  # noqa: E501
            _query_params.append(('search', _params['search']))
        if _params.get('data_type') is not None:  # noqa: E501
            _query_params.append(('dataType', _params['data_type']))
        if _params.get('min_id') is not None:  # noqa: E501
            _query_params.append(('minId', _params['min_id']))
        if _params.get('max_id') is not None:  # noqa: E501
            _query_params.append(('maxId', _params['max_id']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "SplitSampleInFrames200Response",
        }

        return self.api_client.call_api(
            '/api/{projectId}/raw-data/batch/delete', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def batch_disable(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], category : Annotated[RawDataCategory, Field(..., description="Which of the three acquisition categories to retrieve data from")], labels : Annotated[Optional[StrictStr], Field(description="Only include samples with a label within the given list of labels, given as a JSON string")] = None, filename : Annotated[Optional[StrictStr], Field(description="Only include samples whose filename includes the given filename")] = None, max_length : Annotated[Optional[StrictInt], Field(description="Only include samples shorter than the given length, in milliseconds")] = None, min_length : Annotated[Optional[StrictInt], Field(description="Only include samples longer than the given length, in milliseconds")] = None, min_frequency : Annotated[Optional[float], Field(description="Only include samples with higher frequency than given frequency, in hertz")] = None, max_frequency : Annotated[Optional[float], Field(description="Only include samples with lower frequency than given frequency, in hertz")] = None, signature_validity : Annotated[Optional[StrictStr], Field(description="Include samples with either valid or invalid signatures")] = None, include_disabled : Annotated[Optional[StrictStr], Field(description="Include only enabled or disabled samples (or both)")] = None, ids : Annotated[Optional[StrictStr], Field(description="Only include samples with an ID within the given list of IDs, given as a JSON string")] = None, exclude_ids : Annotated[Optional[StrictStr], Field(description="Exclude samples with an ID within the given list of IDs, given as a JSON string")] = None, min_label : Annotated[Optional[float], Field(description="Only include samples with a label >= this value")] = None, max_label : Annotated[Optional[float], Field(description="Only include samples with a label < this value")] = None, search : Annotated[Optional[StrictStr], Field(description="Search query")] = None, data_type : Annotated[Optional[StrictStr], Field(description="Include only samples with a particular data type")] = None, min_id : Annotated[Optional[float], Field(description="Include only samples with an ID >= this value")] = None, max_id : Annotated[Optional[float], Field(description="Include only samples with an ID < this value")] = None, **kwargs) -> SplitSampleInFrames200Response:  # noqa: E501
        """Disable multiple samples

        Disables samples, ensuring that they are excluded from the dataset. Depending on the number of affected samples this will either execute immediately or return the ID of a job that will perform this action in batches. 

        :param project_id: Project ID (required)
        :type project_id: int
        :param category: Which of the three acquisition categories to retrieve data from (required)
        :type category: RawDataCategory
        :param labels: Only include samples with a label within the given list of labels, given as a JSON string
        :type labels: str
        :param filename: Only include samples whose filename includes the given filename
        :type filename: str
        :param max_length: Only include samples shorter than the given length, in milliseconds
        :type max_length: int
        :param min_length: Only include samples longer than the given length, in milliseconds
        :type min_length: int
        :param min_frequency: Only include samples with higher frequency than given frequency, in hertz
        :type min_frequency: float
        :param max_frequency: Only include samples with lower frequency than given frequency, in hertz
        :type max_frequency: float
        :param signature_validity: Include samples with either valid or invalid signatures
        :type signature_validity: str
        :param include_disabled: Include only enabled or disabled samples (or both)
        :type include_disabled: str
        :param ids: Only include samples with an ID within the given list of IDs, given as a JSON string
        :type ids: str
        :param exclude_ids: Exclude samples with an ID within the given list of IDs, given as a JSON string
        :type exclude_ids: str
        :param min_label: Only include samples with a label >= this value
        :type min_label: float
        :param max_label: Only include samples with a label < this value
        :type max_label: float
        :param search: Search query
        :type search: str
        :param data_type: Include only samples with a particular data type
        :type data_type: str
        :param min_id: Include only samples with an ID >= this value
        :type min_id: float
        :param max_id: Include only samples with an ID < this value
        :type max_id: float
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SplitSampleInFrames200Response
        """
        kwargs['_return_http_data_only'] = True
        return self._batch_disable_with_http_info(project_id, category, labels, filename, max_length, min_length, min_frequency, max_frequency, signature_validity, include_disabled, ids, exclude_ids, min_label, max_label, search, data_type, min_id, max_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _batch_disable_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], category : Annotated[RawDataCategory, Field(..., description="Which of the three acquisition categories to retrieve data from")], labels : Annotated[Optional[StrictStr], Field(description="Only include samples with a label within the given list of labels, given as a JSON string")] = None, filename : Annotated[Optional[StrictStr], Field(description="Only include samples whose filename includes the given filename")] = None, max_length : Annotated[Optional[StrictInt], Field(description="Only include samples shorter than the given length, in milliseconds")] = None, min_length : Annotated[Optional[StrictInt], Field(description="Only include samples longer than the given length, in milliseconds")] = None, min_frequency : Annotated[Optional[float], Field(description="Only include samples with higher frequency than given frequency, in hertz")] = None, max_frequency : Annotated[Optional[float], Field(description="Only include samples with lower frequency than given frequency, in hertz")] = None, signature_validity : Annotated[Optional[StrictStr], Field(description="Include samples with either valid or invalid signatures")] = None, include_disabled : Annotated[Optional[StrictStr], Field(description="Include only enabled or disabled samples (or both)")] = None, ids : Annotated[Optional[StrictStr], Field(description="Only include samples with an ID within the given list of IDs, given as a JSON string")] = None, exclude_ids : Annotated[Optional[StrictStr], Field(description="Exclude samples with an ID within the given list of IDs, given as a JSON string")] = None, min_label : Annotated[Optional[float], Field(description="Only include samples with a label >= this value")] = None, max_label : Annotated[Optional[float], Field(description="Only include samples with a label < this value")] = None, search : Annotated[Optional[StrictStr], Field(description="Search query")] = None, data_type : Annotated[Optional[StrictStr], Field(description="Include only samples with a particular data type")] = None, min_id : Annotated[Optional[float], Field(description="Include only samples with an ID >= this value")] = None, max_id : Annotated[Optional[float], Field(description="Include only samples with an ID < this value")] = None, **kwargs):  # noqa: E501
        """Disable multiple samples 

        Disables samples, ensuring that they are excluded from the dataset. Depending on the number of affected samples this will either execute immediately or return the ID of a job that will perform this action in batches. 

        :param project_id: Project ID (required)
        :type project_id: int
        :param category: Which of the three acquisition categories to retrieve data from (required)
        :type category: RawDataCategory
        :param labels: Only include samples with a label within the given list of labels, given as a JSON string
        :type labels: str
        :param filename: Only include samples whose filename includes the given filename
        :type filename: str
        :param max_length: Only include samples shorter than the given length, in milliseconds
        :type max_length: int
        :param min_length: Only include samples longer than the given length, in milliseconds
        :type min_length: int
        :param min_frequency: Only include samples with higher frequency than given frequency, in hertz
        :type min_frequency: float
        :param max_frequency: Only include samples with lower frequency than given frequency, in hertz
        :type max_frequency: float
        :param signature_validity: Include samples with either valid or invalid signatures
        :type signature_validity: str
        :param include_disabled: Include only enabled or disabled samples (or both)
        :type include_disabled: str
        :param ids: Only include samples with an ID within the given list of IDs, given as a JSON string
        :type ids: str
        :param exclude_ids: Exclude samples with an ID within the given list of IDs, given as a JSON string
        :type exclude_ids: str
        :param min_label: Only include samples with a label >= this value
        :type min_label: float
        :param max_label: Only include samples with a label < this value
        :type max_label: float
        :param search: Search query
        :type search: str
        :param data_type: Include only samples with a particular data type
        :type data_type: str
        :param min_id: Include only samples with an ID >= this value
        :type min_id: float
        :param max_id: Include only samples with an ID < this value
        :type max_id: float
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SplitSampleInFrames200Response, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'category',
            'labels',
            'filename',
            'max_length',
            'min_length',
            'min_frequency',
            'max_frequency',
            'signature_validity',
            'include_disabled',
            'ids',
            'exclude_ids',
            'min_label',
            'max_label',
            'search',
            'data_type',
            'min_id',
            'max_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_disable" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []
        if _params.get('category') is not None:  # noqa: E501
            _query_params.append(('category', _params['category']))
        if _params.get('labels') is not None:  # noqa: E501
            _query_params.append(('labels', _params['labels']))
        if _params.get('filename') is not None:  # noqa: E501
            _query_params.append(('filename', _params['filename']))
        if _params.get('max_length') is not None:  # noqa: E501
            _query_params.append(('maxLength', _params['max_length']))
        if _params.get('min_length') is not None:  # noqa: E501
            _query_params.append(('minLength', _params['min_length']))
        if _params.get('min_frequency') is not None:  # noqa: E501
            _query_params.append(('minFrequency', _params['min_frequency']))
        if _params.get('max_frequency') is not None:  # noqa: E501
            _query_params.append(('maxFrequency', _params['max_frequency']))
        if _params.get('signature_validity') is not None:  # noqa: E501
            _query_params.append(('signatureValidity', _params['signature_validity']))
        if _params.get('include_disabled') is not None:  # noqa: E501
            _query_params.append(('includeDisabled', _params['include_disabled']))
        if _params.get('ids') is not None:  # noqa: E501
            _query_params.append(('ids', _params['ids']))
        if _params.get('exclude_ids') is not None:  # noqa: E501
            _query_params.append(('excludeIds', _params['exclude_ids']))
        if _params.get('min_label') is not None:  # noqa: E501
            _query_params.append(('minLabel', _params['min_label']))
        if _params.get('max_label') is not None:  # noqa: E501
            _query_params.append(('maxLabel', _params['max_label']))
        if _params.get('search') is not None:  # noqa: E501
            _query_params.append(('search', _params['search']))
        if _params.get('data_type') is not None:  # noqa: E501
            _query_params.append(('dataType', _params['data_type']))
        if _params.get('min_id') is not None:  # noqa: E501
            _query_params.append(('minId', _params['min_id']))
        if _params.get('max_id') is not None:  # noqa: E501
            _query_params.append(('maxId', _params['max_id']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "SplitSampleInFrames200Response",
        }

        return self.api_client.call_api(
            '/api/{projectId}/raw-data/batch/disable-samples', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def batch_edit_labels(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], category : Annotated[RawDataCategory, Field(..., description="Which of the three acquisition categories to retrieve data from")], edit_sample_label_request : EditSampleLabelRequest, labels : Annotated[Optional[StrictStr], Field(description="Only include samples with a label within the given list of labels, given as a JSON string")] = None, filename : Annotated[Optional[StrictStr], Field(description="Only include samples whose filename includes the given filename")] = None, max_length : Annotated[Optional[StrictInt], Field(description="Only include samples shorter than the given length, in milliseconds")] = None, min_length : Annotated[Optional[StrictInt], Field(description="Only include samples longer than the given length, in milliseconds")] = None, min_frequency : Annotated[Optional[float], Field(description="Only include samples with higher frequency than given frequency, in hertz")] = None, max_frequency : Annotated[Optional[float], Field(description="Only include samples with lower frequency than given frequency, in hertz")] = None, signature_validity : Annotated[Optional[StrictStr], Field(description="Include samples with either valid or invalid signatures")] = None, include_disabled : Annotated[Optional[StrictStr], Field(description="Include only enabled or disabled samples (or both)")] = None, ids : Annotated[Optional[StrictStr], Field(description="Only include samples with an ID within the given list of IDs, given as a JSON string")] = None, exclude_ids : Annotated[Optional[StrictStr], Field(description="Exclude samples with an ID within the given list of IDs, given as a JSON string")] = None, min_label : Annotated[Optional[float], Field(description="Only include samples with a label >= this value")] = None, max_label : Annotated[Optional[float], Field(description="Only include samples with a label < this value")] = None, search : Annotated[Optional[StrictStr], Field(description="Search query")] = None, data_type : Annotated[Optional[StrictStr], Field(description="Include only samples with a particular data type")] = None, min_id : Annotated[Optional[float], Field(description="Include only samples with an ID >= this value")] = None, max_id : Annotated[Optional[float], Field(description="Include only samples with an ID < this value")] = None, **kwargs) -> SplitSampleInFrames200Response:  # noqa: E501
        """Edit labels for multiple samples

        Sets the label (also known as class) of multiple samples. Depending on the number of affected samples this will either execute immediately or return the ID of a job that will perform this action in batches. 

        :param project_id: Project ID (required)
        :type project_id: int
        :param category: Which of the three acquisition categories to retrieve data from (required)
        :type category: RawDataCategory
        :param edit_sample_label_request: (required)
        :type edit_sample_label_request: EditSampleLabelRequest
        :param labels: Only include samples with a label within the given list of labels, given as a JSON string
        :type labels: str
        :param filename: Only include samples whose filename includes the given filename
        :type filename: str
        :param max_length: Only include samples shorter than the given length, in milliseconds
        :type max_length: int
        :param min_length: Only include samples longer than the given length, in milliseconds
        :type min_length: int
        :param min_frequency: Only include samples with higher frequency than given frequency, in hertz
        :type min_frequency: float
        :param max_frequency: Only include samples with lower frequency than given frequency, in hertz
        :type max_frequency: float
        :param signature_validity: Include samples with either valid or invalid signatures
        :type signature_validity: str
        :param include_disabled: Include only enabled or disabled samples (or both)
        :type include_disabled: str
        :param ids: Only include samples with an ID within the given list of IDs, given as a JSON string
        :type ids: str
        :param exclude_ids: Exclude samples with an ID within the given list of IDs, given as a JSON string
        :type exclude_ids: str
        :param min_label: Only include samples with a label >= this value
        :type min_label: float
        :param max_label: Only include samples with a label < this value
        :type max_label: float
        :param search: Search query
        :type search: str
        :param data_type: Include only samples with a particular data type
        :type data_type: str
        :param min_id: Include only samples with an ID >= this value
        :type min_id: float
        :param max_id: Include only samples with an ID < this value
        :type max_id: float
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SplitSampleInFrames200Response
        """
        kwargs['_return_http_data_only'] = True
        return self._batch_edit_labels_with_http_info(project_id, category, edit_sample_label_request, labels, filename, max_length, min_length, min_frequency, max_frequency, signature_validity, include_disabled, ids, exclude_ids, min_label, max_label, search, data_type, min_id, max_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _batch_edit_labels_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], category : Annotated[RawDataCategory, Field(..., description="Which of the three acquisition categories to retrieve data from")], edit_sample_label_request : EditSampleLabelRequest, labels : Annotated[Optional[StrictStr], Field(description="Only include samples with a label within the given list of labels, given as a JSON string")] = None, filename : Annotated[Optional[StrictStr], Field(description="Only include samples whose filename includes the given filename")] = None, max_length : Annotated[Optional[StrictInt], Field(description="Only include samples shorter than the given length, in milliseconds")] = None, min_length : Annotated[Optional[StrictInt], Field(description="Only include samples longer than the given length, in milliseconds")] = None, min_frequency : Annotated[Optional[float], Field(description="Only include samples with higher frequency than given frequency, in hertz")] = None, max_frequency : Annotated[Optional[float], Field(description="Only include samples with lower frequency than given frequency, in hertz")] = None, signature_validity : Annotated[Optional[StrictStr], Field(description="Include samples with either valid or invalid signatures")] = None, include_disabled : Annotated[Optional[StrictStr], Field(description="Include only enabled or disabled samples (or both)")] = None, ids : Annotated[Optional[StrictStr], Field(description="Only include samples with an ID within the given list of IDs, given as a JSON string")] = None, exclude_ids : Annotated[Optional[StrictStr], Field(description="Exclude samples with an ID within the given list of IDs, given as a JSON string")] = None, min_label : Annotated[Optional[float], Field(description="Only include samples with a label >= this value")] = None, max_label : Annotated[Optional[float], Field(description="Only include samples with a label < this value")] = None, search : Annotated[Optional[StrictStr], Field(description="Search query")] = None, data_type : Annotated[Optional[StrictStr], Field(description="Include only samples with a particular data type")] = None, min_id : Annotated[Optional[float], Field(description="Include only samples with an ID >= this value")] = None, max_id : Annotated[Optional[float], Field(description="Include only samples with an ID < this value")] = None, **kwargs):  # noqa: E501
        """Edit labels for multiple samples 

        Sets the label (also known as class) of multiple samples. Depending on the number of affected samples this will either execute immediately or return the ID of a job that will perform this action in batches. 

        :param project_id: Project ID (required)
        :type project_id: int
        :param category: Which of the three acquisition categories to retrieve data from (required)
        :type category: RawDataCategory
        :param edit_sample_label_request: (required)
        :type edit_sample_label_request: EditSampleLabelRequest
        :param labels: Only include samples with a label within the given list of labels, given as a JSON string
        :type labels: str
        :param filename: Only include samples whose filename includes the given filename
        :type filename: str
        :param max_length: Only include samples shorter than the given length, in milliseconds
        :type max_length: int
        :param min_length: Only include samples longer than the given length, in milliseconds
        :type min_length: int
        :param min_frequency: Only include samples with higher frequency than given frequency, in hertz
        :type min_frequency: float
        :param max_frequency: Only include samples with lower frequency than given frequency, in hertz
        :type max_frequency: float
        :param signature_validity: Include samples with either valid or invalid signatures
        :type signature_validity: str
        :param include_disabled: Include only enabled or disabled samples (or both)
        :type include_disabled: str
        :param ids: Only include samples with an ID within the given list of IDs, given as a JSON string
        :type ids: str
        :param exclude_ids: Exclude samples with an ID within the given list of IDs, given as a JSON string
        :type exclude_ids: str
        :param min_label: Only include samples with a label >= this value
        :type min_label: float
        :param max_label: Only include samples with a label < this value
        :type max_label: float
        :param search: Search query
        :type search: str
        :param data_type: Include only samples with a particular data type
        :type data_type: str
        :param min_id: Include only samples with an ID >= this value
        :type min_id: float
        :param max_id: Include only samples with an ID < this value
        :type max_id: float
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SplitSampleInFrames200Response, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'category',
            'edit_sample_label_request',
            'labels',
            'filename',
            'max_length',
            'min_length',
            'min_frequency',
            'max_frequency',
            'signature_validity',
            'include_disabled',
            'ids',
            'exclude_ids',
            'min_label',
            'max_label',
            'search',
            'data_type',
            'min_id',
            'max_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_edit_labels" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []
        if _params.get('category') is not None:  # noqa: E501
            _query_params.append(('category', _params['category']))
        if _params.get('labels') is not None:  # noqa: E501
            _query_params.append(('labels', _params['labels']))
        if _params.get('filename') is not None:  # noqa: E501
            _query_params.append(('filename', _params['filename']))
        if _params.get('max_length') is not None:  # noqa: E501
            _query_params.append(('maxLength', _params['max_length']))
        if _params.get('min_length') is not None:  # noqa: E501
            _query_params.append(('minLength', _params['min_length']))
        if _params.get('min_frequency') is not None:  # noqa: E501
            _query_params.append(('minFrequency', _params['min_frequency']))
        if _params.get('max_frequency') is not None:  # noqa: E501
            _query_params.append(('maxFrequency', _params['max_frequency']))
        if _params.get('signature_validity') is not None:  # noqa: E501
            _query_params.append(('signatureValidity', _params['signature_validity']))
        if _params.get('include_disabled') is not None:  # noqa: E501
            _query_params.append(('includeDisabled', _params['include_disabled']))
        if _params.get('ids') is not None:  # noqa: E501
            _query_params.append(('ids', _params['ids']))
        if _params.get('exclude_ids') is not None:  # noqa: E501
            _query_params.append(('excludeIds', _params['exclude_ids']))
        if _params.get('min_label') is not None:  # noqa: E501
            _query_params.append(('minLabel', _params['min_label']))
        if _params.get('max_label') is not None:  # noqa: E501
            _query_params.append(('maxLabel', _params['max_label']))
        if _params.get('search') is not None:  # noqa: E501
            _query_params.append(('search', _params['search']))
        if _params.get('data_type') is not None:  # noqa: E501
            _query_params.append(('dataType', _params['data_type']))
        if _params.get('min_id') is not None:  # noqa: E501
            _query_params.append(('minId', _params['min_id']))
        if _params.get('max_id') is not None:  # noqa: E501
            _query_params.append(('maxId', _params['max_id']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['edit_sample_label_request']:
            _body_params = _params['edit_sample_label_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "SplitSampleInFrames200Response",
        }

        return self.api_client.call_api(
            '/api/{projectId}/raw-data/batch/edit-labels', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def batch_enable(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], category : Annotated[RawDataCategory, Field(..., description="Which of the three acquisition categories to retrieve data from")], labels : Annotated[Optional[StrictStr], Field(description="Only include samples with a label within the given list of labels, given as a JSON string")] = None, filename : Annotated[Optional[StrictStr], Field(description="Only include samples whose filename includes the given filename")] = None, max_length : Annotated[Optional[StrictInt], Field(description="Only include samples shorter than the given length, in milliseconds")] = None, min_length : Annotated[Optional[StrictInt], Field(description="Only include samples longer than the given length, in milliseconds")] = None, min_frequency : Annotated[Optional[float], Field(description="Only include samples with higher frequency than given frequency, in hertz")] = None, max_frequency : Annotated[Optional[float], Field(description="Only include samples with lower frequency than given frequency, in hertz")] = None, signature_validity : Annotated[Optional[StrictStr], Field(description="Include samples with either valid or invalid signatures")] = None, include_disabled : Annotated[Optional[StrictStr], Field(description="Include only enabled or disabled samples (or both)")] = None, ids : Annotated[Optional[StrictStr], Field(description="Only include samples with an ID within the given list of IDs, given as a JSON string")] = None, exclude_ids : Annotated[Optional[StrictStr], Field(description="Exclude samples with an ID within the given list of IDs, given as a JSON string")] = None, min_label : Annotated[Optional[float], Field(description="Only include samples with a label >= this value")] = None, max_label : Annotated[Optional[float], Field(description="Only include samples with a label < this value")] = None, search : Annotated[Optional[StrictStr], Field(description="Search query")] = None, data_type : Annotated[Optional[StrictStr], Field(description="Include only samples with a particular data type")] = None, min_id : Annotated[Optional[float], Field(description="Include only samples with an ID >= this value")] = None, max_id : Annotated[Optional[float], Field(description="Include only samples with an ID < this value")] = None, **kwargs) -> SplitSampleInFrames200Response:  # noqa: E501
        """Enable multiple samples

        Enables samples, ensuring that they are not excluded from the dataset. Depending on the number of affected samples this will either execute immediately or return the ID of a job that will perform this action in batches. 

        :param project_id: Project ID (required)
        :type project_id: int
        :param category: Which of the three acquisition categories to retrieve data from (required)
        :type category: RawDataCategory
        :param labels: Only include samples with a label within the given list of labels, given as a JSON string
        :type labels: str
        :param filename: Only include samples whose filename includes the given filename
        :type filename: str
        :param max_length: Only include samples shorter than the given length, in milliseconds
        :type max_length: int
        :param min_length: Only include samples longer than the given length, in milliseconds
        :type min_length: int
        :param min_frequency: Only include samples with higher frequency than given frequency, in hertz
        :type min_frequency: float
        :param max_frequency: Only include samples with lower frequency than given frequency, in hertz
        :type max_frequency: float
        :param signature_validity: Include samples with either valid or invalid signatures
        :type signature_validity: str
        :param include_disabled: Include only enabled or disabled samples (or both)
        :type include_disabled: str
        :param ids: Only include samples with an ID within the given list of IDs, given as a JSON string
        :type ids: str
        :param exclude_ids: Exclude samples with an ID within the given list of IDs, given as a JSON string
        :type exclude_ids: str
        :param min_label: Only include samples with a label >= this value
        :type min_label: float
        :param max_label: Only include samples with a label < this value
        :type max_label: float
        :param search: Search query
        :type search: str
        :param data_type: Include only samples with a particular data type
        :type data_type: str
        :param min_id: Include only samples with an ID >= this value
        :type min_id: float
        :param max_id: Include only samples with an ID < this value
        :type max_id: float
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SplitSampleInFrames200Response
        """
        kwargs['_return_http_data_only'] = True
        return self._batch_enable_with_http_info(project_id, category, labels, filename, max_length, min_length, min_frequency, max_frequency, signature_validity, include_disabled, ids, exclude_ids, min_label, max_label, search, data_type, min_id, max_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _batch_enable_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], category : Annotated[RawDataCategory, Field(..., description="Which of the three acquisition categories to retrieve data from")], labels : Annotated[Optional[StrictStr], Field(description="Only include samples with a label within the given list of labels, given as a JSON string")] = None, filename : Annotated[Optional[StrictStr], Field(description="Only include samples whose filename includes the given filename")] = None, max_length : Annotated[Optional[StrictInt], Field(description="Only include samples shorter than the given length, in milliseconds")] = None, min_length : Annotated[Optional[StrictInt], Field(description="Only include samples longer than the given length, in milliseconds")] = None, min_frequency : Annotated[Optional[float], Field(description="Only include samples with higher frequency than given frequency, in hertz")] = None, max_frequency : Annotated[Optional[float], Field(description="Only include samples with lower frequency than given frequency, in hertz")] = None, signature_validity : Annotated[Optional[StrictStr], Field(description="Include samples with either valid or invalid signatures")] = None, include_disabled : Annotated[Optional[StrictStr], Field(description="Include only enabled or disabled samples (or both)")] = None, ids : Annotated[Optional[StrictStr], Field(description="Only include samples with an ID within the given list of IDs, given as a JSON string")] = None, exclude_ids : Annotated[Optional[StrictStr], Field(description="Exclude samples with an ID within the given list of IDs, given as a JSON string")] = None, min_label : Annotated[Optional[float], Field(description="Only include samples with a label >= this value")] = None, max_label : Annotated[Optional[float], Field(description="Only include samples with a label < this value")] = None, search : Annotated[Optional[StrictStr], Field(description="Search query")] = None, data_type : Annotated[Optional[StrictStr], Field(description="Include only samples with a particular data type")] = None, min_id : Annotated[Optional[float], Field(description="Include only samples with an ID >= this value")] = None, max_id : Annotated[Optional[float], Field(description="Include only samples with an ID < this value")] = None, **kwargs):  # noqa: E501
        """Enable multiple samples 

        Enables samples, ensuring that they are not excluded from the dataset. Depending on the number of affected samples this will either execute immediately or return the ID of a job that will perform this action in batches. 

        :param project_id: Project ID (required)
        :type project_id: int
        :param category: Which of the three acquisition categories to retrieve data from (required)
        :type category: RawDataCategory
        :param labels: Only include samples with a label within the given list of labels, given as a JSON string
        :type labels: str
        :param filename: Only include samples whose filename includes the given filename
        :type filename: str
        :param max_length: Only include samples shorter than the given length, in milliseconds
        :type max_length: int
        :param min_length: Only include samples longer than the given length, in milliseconds
        :type min_length: int
        :param min_frequency: Only include samples with higher frequency than given frequency, in hertz
        :type min_frequency: float
        :param max_frequency: Only include samples with lower frequency than given frequency, in hertz
        :type max_frequency: float
        :param signature_validity: Include samples with either valid or invalid signatures
        :type signature_validity: str
        :param include_disabled: Include only enabled or disabled samples (or both)
        :type include_disabled: str
        :param ids: Only include samples with an ID within the given list of IDs, given as a JSON string
        :type ids: str
        :param exclude_ids: Exclude samples with an ID within the given list of IDs, given as a JSON string
        :type exclude_ids: str
        :param min_label: Only include samples with a label >= this value
        :type min_label: float
        :param max_label: Only include samples with a label < this value
        :type max_label: float
        :param search: Search query
        :type search: str
        :param data_type: Include only samples with a particular data type
        :type data_type: str
        :param min_id: Include only samples with an ID >= this value
        :type min_id: float
        :param max_id: Include only samples with an ID < this value
        :type max_id: float
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SplitSampleInFrames200Response, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'category',
            'labels',
            'filename',
            'max_length',
            'min_length',
            'min_frequency',
            'max_frequency',
            'signature_validity',
            'include_disabled',
            'ids',
            'exclude_ids',
            'min_label',
            'max_label',
            'search',
            'data_type',
            'min_id',
            'max_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_enable" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []
        if _params.get('category') is not None:  # noqa: E501
            _query_params.append(('category', _params['category']))
        if _params.get('labels') is not None:  # noqa: E501
            _query_params.append(('labels', _params['labels']))
        if _params.get('filename') is not None:  # noqa: E501
            _query_params.append(('filename', _params['filename']))
        if _params.get('max_length') is not None:  # noqa: E501
            _query_params.append(('maxLength', _params['max_length']))
        if _params.get('min_length') is not None:  # noqa: E501
            _query_params.append(('minLength', _params['min_length']))
        if _params.get('min_frequency') is not None:  # noqa: E501
            _query_params.append(('minFrequency', _params['min_frequency']))
        if _params.get('max_frequency') is not None:  # noqa: E501
            _query_params.append(('maxFrequency', _params['max_frequency']))
        if _params.get('signature_validity') is not None:  # noqa: E501
            _query_params.append(('signatureValidity', _params['signature_validity']))
        if _params.get('include_disabled') is not None:  # noqa: E501
            _query_params.append(('includeDisabled', _params['include_disabled']))
        if _params.get('ids') is not None:  # noqa: E501
            _query_params.append(('ids', _params['ids']))
        if _params.get('exclude_ids') is not None:  # noqa: E501
            _query_params.append(('excludeIds', _params['exclude_ids']))
        if _params.get('min_label') is not None:  # noqa: E501
            _query_params.append(('minLabel', _params['min_label']))
        if _params.get('max_label') is not None:  # noqa: E501
            _query_params.append(('maxLabel', _params['max_label']))
        if _params.get('search') is not None:  # noqa: E501
            _query_params.append(('search', _params['search']))
        if _params.get('data_type') is not None:  # noqa: E501
            _query_params.append(('dataType', _params['data_type']))
        if _params.get('min_id') is not None:  # noqa: E501
            _query_params.append(('minId', _params['min_id']))
        if _params.get('max_id') is not None:  # noqa: E501
            _query_params.append(('maxId', _params['max_id']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "SplitSampleInFrames200Response",
        }

        return self.api_client.call_api(
            '/api/{projectId}/raw-data/batch/enable-samples', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def batch_move(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], category : Annotated[RawDataCategory, Field(..., description="Which of the three acquisition categories to retrieve data from")], move_raw_data_request : MoveRawDataRequest, labels : Annotated[Optional[StrictStr], Field(description="Only include samples with a label within the given list of labels, given as a JSON string")] = None, filename : Annotated[Optional[StrictStr], Field(description="Only include samples whose filename includes the given filename")] = None, max_length : Annotated[Optional[StrictInt], Field(description="Only include samples shorter than the given length, in milliseconds")] = None, min_length : Annotated[Optional[StrictInt], Field(description="Only include samples longer than the given length, in milliseconds")] = None, min_frequency : Annotated[Optional[float], Field(description="Only include samples with higher frequency than given frequency, in hertz")] = None, max_frequency : Annotated[Optional[float], Field(description="Only include samples with lower frequency than given frequency, in hertz")] = None, signature_validity : Annotated[Optional[StrictStr], Field(description="Include samples with either valid or invalid signatures")] = None, include_disabled : Annotated[Optional[StrictStr], Field(description="Include only enabled or disabled samples (or both)")] = None, ids : Annotated[Optional[StrictStr], Field(description="Only include samples with an ID within the given list of IDs, given as a JSON string")] = None, exclude_ids : Annotated[Optional[StrictStr], Field(description="Exclude samples with an ID within the given list of IDs, given as a JSON string")] = None, min_label : Annotated[Optional[float], Field(description="Only include samples with a label >= this value")] = None, max_label : Annotated[Optional[float], Field(description="Only include samples with a label < this value")] = None, search : Annotated[Optional[StrictStr], Field(description="Search query")] = None, data_type : Annotated[Optional[StrictStr], Field(description="Include only samples with a particular data type")] = None, min_id : Annotated[Optional[float], Field(description="Include only samples with an ID >= this value")] = None, max_id : Annotated[Optional[float], Field(description="Include only samples with an ID < this value")] = None, **kwargs) -> SplitSampleInFrames200Response:  # noqa: E501
        """Move multiple samples

        Move multiple samples to another category (e.g. from test to training). Depending on the number of affected samples this will either execute immediately or return the ID of a job that will perform this action in batches. 

        :param project_id: Project ID (required)
        :type project_id: int
        :param category: Which of the three acquisition categories to retrieve data from (required)
        :type category: RawDataCategory
        :param move_raw_data_request: (required)
        :type move_raw_data_request: MoveRawDataRequest
        :param labels: Only include samples with a label within the given list of labels, given as a JSON string
        :type labels: str
        :param filename: Only include samples whose filename includes the given filename
        :type filename: str
        :param max_length: Only include samples shorter than the given length, in milliseconds
        :type max_length: int
        :param min_length: Only include samples longer than the given length, in milliseconds
        :type min_length: int
        :param min_frequency: Only include samples with higher frequency than given frequency, in hertz
        :type min_frequency: float
        :param max_frequency: Only include samples with lower frequency than given frequency, in hertz
        :type max_frequency: float
        :param signature_validity: Include samples with either valid or invalid signatures
        :type signature_validity: str
        :param include_disabled: Include only enabled or disabled samples (or both)
        :type include_disabled: str
        :param ids: Only include samples with an ID within the given list of IDs, given as a JSON string
        :type ids: str
        :param exclude_ids: Exclude samples with an ID within the given list of IDs, given as a JSON string
        :type exclude_ids: str
        :param min_label: Only include samples with a label >= this value
        :type min_label: float
        :param max_label: Only include samples with a label < this value
        :type max_label: float
        :param search: Search query
        :type search: str
        :param data_type: Include only samples with a particular data type
        :type data_type: str
        :param min_id: Include only samples with an ID >= this value
        :type min_id: float
        :param max_id: Include only samples with an ID < this value
        :type max_id: float
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SplitSampleInFrames200Response
        """
        kwargs['_return_http_data_only'] = True
        return self._batch_move_with_http_info(project_id, category, move_raw_data_request, labels, filename, max_length, min_length, min_frequency, max_frequency, signature_validity, include_disabled, ids, exclude_ids, min_label, max_label, search, data_type, min_id, max_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _batch_move_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], category : Annotated[RawDataCategory, Field(..., description="Which of the three acquisition categories to retrieve data from")], move_raw_data_request : MoveRawDataRequest, labels : Annotated[Optional[StrictStr], Field(description="Only include samples with a label within the given list of labels, given as a JSON string")] = None, filename : Annotated[Optional[StrictStr], Field(description="Only include samples whose filename includes the given filename")] = None, max_length : Annotated[Optional[StrictInt], Field(description="Only include samples shorter than the given length, in milliseconds")] = None, min_length : Annotated[Optional[StrictInt], Field(description="Only include samples longer than the given length, in milliseconds")] = None, min_frequency : Annotated[Optional[float], Field(description="Only include samples with higher frequency than given frequency, in hertz")] = None, max_frequency : Annotated[Optional[float], Field(description="Only include samples with lower frequency than given frequency, in hertz")] = None, signature_validity : Annotated[Optional[StrictStr], Field(description="Include samples with either valid or invalid signatures")] = None, include_disabled : Annotated[Optional[StrictStr], Field(description="Include only enabled or disabled samples (or both)")] = None, ids : Annotated[Optional[StrictStr], Field(description="Only include samples with an ID within the given list of IDs, given as a JSON string")] = None, exclude_ids : Annotated[Optional[StrictStr], Field(description="Exclude samples with an ID within the given list of IDs, given as a JSON string")] = None, min_label : Annotated[Optional[float], Field(description="Only include samples with a label >= this value")] = None, max_label : Annotated[Optional[float], Field(description="Only include samples with a label < this value")] = None, search : Annotated[Optional[StrictStr], Field(description="Search query")] = None, data_type : Annotated[Optional[StrictStr], Field(description="Include only samples with a particular data type")] = None, min_id : Annotated[Optional[float], Field(description="Include only samples with an ID >= this value")] = None, max_id : Annotated[Optional[float], Field(description="Include only samples with an ID < this value")] = None, **kwargs):  # noqa: E501
        """Move multiple samples 

        Move multiple samples to another category (e.g. from test to training). Depending on the number of affected samples this will either execute immediately or return the ID of a job that will perform this action in batches. 

        :param project_id: Project ID (required)
        :type project_id: int
        :param category: Which of the three acquisition categories to retrieve data from (required)
        :type category: RawDataCategory
        :param move_raw_data_request: (required)
        :type move_raw_data_request: MoveRawDataRequest
        :param labels: Only include samples with a label within the given list of labels, given as a JSON string
        :type labels: str
        :param filename: Only include samples whose filename includes the given filename
        :type filename: str
        :param max_length: Only include samples shorter than the given length, in milliseconds
        :type max_length: int
        :param min_length: Only include samples longer than the given length, in milliseconds
        :type min_length: int
        :param min_frequency: Only include samples with higher frequency than given frequency, in hertz
        :type min_frequency: float
        :param max_frequency: Only include samples with lower frequency than given frequency, in hertz
        :type max_frequency: float
        :param signature_validity: Include samples with either valid or invalid signatures
        :type signature_validity: str
        :param include_disabled: Include only enabled or disabled samples (or both)
        :type include_disabled: str
        :param ids: Only include samples with an ID within the given list of IDs, given as a JSON string
        :type ids: str
        :param exclude_ids: Exclude samples with an ID within the given list of IDs, given as a JSON string
        :type exclude_ids: str
        :param min_label: Only include samples with a label >= this value
        :type min_label: float
        :param max_label: Only include samples with a label < this value
        :type max_label: float
        :param search: Search query
        :type search: str
        :param data_type: Include only samples with a particular data type
        :type data_type: str
        :param min_id: Include only samples with an ID >= this value
        :type min_id: float
        :param max_id: Include only samples with an ID < this value
        :type max_id: float
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SplitSampleInFrames200Response, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'category',
            'move_raw_data_request',
            'labels',
            'filename',
            'max_length',
            'min_length',
            'min_frequency',
            'max_frequency',
            'signature_validity',
            'include_disabled',
            'ids',
            'exclude_ids',
            'min_label',
            'max_label',
            'search',
            'data_type',
            'min_id',
            'max_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_move" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []
        if _params.get('category') is not None:  # noqa: E501
            _query_params.append(('category', _params['category']))
        if _params.get('labels') is not None:  # noqa: E501
            _query_params.append(('labels', _params['labels']))
        if _params.get('filename') is not None:  # noqa: E501
            _query_params.append(('filename', _params['filename']))
        if _params.get('max_length') is not None:  # noqa: E501
            _query_params.append(('maxLength', _params['max_length']))
        if _params.get('min_length') is not None:  # noqa: E501
            _query_params.append(('minLength', _params['min_length']))
        if _params.get('min_frequency') is not None:  # noqa: E501
            _query_params.append(('minFrequency', _params['min_frequency']))
        if _params.get('max_frequency') is not None:  # noqa: E501
            _query_params.append(('maxFrequency', _params['max_frequency']))
        if _params.get('signature_validity') is not None:  # noqa: E501
            _query_params.append(('signatureValidity', _params['signature_validity']))
        if _params.get('include_disabled') is not None:  # noqa: E501
            _query_params.append(('includeDisabled', _params['include_disabled']))
        if _params.get('ids') is not None:  # noqa: E501
            _query_params.append(('ids', _params['ids']))
        if _params.get('exclude_ids') is not None:  # noqa: E501
            _query_params.append(('excludeIds', _params['exclude_ids']))
        if _params.get('min_label') is not None:  # noqa: E501
            _query_params.append(('minLabel', _params['min_label']))
        if _params.get('max_label') is not None:  # noqa: E501
            _query_params.append(('maxLabel', _params['max_label']))
        if _params.get('search') is not None:  # noqa: E501
            _query_params.append(('search', _params['search']))
        if _params.get('data_type') is not None:  # noqa: E501
            _query_params.append(('dataType', _params['data_type']))
        if _params.get('min_id') is not None:  # noqa: E501
            _query_params.append(('minId', _params['min_id']))
        if _params.get('max_id') is not None:  # noqa: E501
            _query_params.append(('maxId', _params['max_id']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['move_raw_data_request']:
            _body_params = _params['move_raw_data_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "SplitSampleInFrames200Response",
        }

        return self.api_client.call_api(
            '/api/{projectId}/raw-data/batch/moveSamples', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def classify_using_autolabel(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], object_detection_auto_label_request : ObjectDetectionAutoLabelRequest, **kwargs) -> ObjectDetectionAutoLabelResponse:  # noqa: E501
        """Auto-label an image

        Classify an image using another neural network.

        :param project_id: Project ID (required)
        :type project_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param object_detection_auto_label_request: (required)
        :type object_detection_auto_label_request: ObjectDetectionAutoLabelRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ObjectDetectionAutoLabelResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._classify_using_autolabel_with_http_info(project_id, sample_id, object_detection_auto_label_request, **kwargs)  # noqa: E501

    @validate_arguments
    def _classify_using_autolabel_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], object_detection_auto_label_request : ObjectDetectionAutoLabelRequest, **kwargs):  # noqa: E501
        """Auto-label an image 

        Classify an image using another neural network.

        :param project_id: Project ID (required)
        :type project_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param object_detection_auto_label_request: (required)
        :type object_detection_auto_label_request: ObjectDetectionAutoLabelRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ObjectDetectionAutoLabelResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'sample_id',
            'object_detection_auto_label_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method classify_using_autolabel" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['sample_id']:
            _path_params['sampleId'] = _params['sample_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['object_detection_auto_label_request']:
            _body_params = _params['object_detection_auto_label_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "ObjectDetectionAutoLabelResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/raw-data/{sampleId}/autolabel', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def clear_all_object_detection_labels(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], **kwargs) -> GenericApiResponse:  # noqa: E501
        """Clear all object detection labels

        Clears all object detection labels for this dataset, and places all images back in the labeling queue.

        :param project_id: Project ID (required)
        :type project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GenericApiResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._clear_all_object_detection_labels_with_http_info(project_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _clear_all_object_detection_labels_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], **kwargs):  # noqa: E501
        """Clear all object detection labels 

        Clears all object detection labels for this dataset, and places all images back in the labeling queue.

        :param project_id: Project ID (required)
        :type project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GenericApiResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method clear_all_object_detection_labels" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GenericApiResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/raw-data/clear-all-object-detection-labels', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def clear_data_explorer(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], **kwargs) -> GenericApiResponse:  # noqa: E501
        """Clear data explorer

        Remove the current data explorer state

        :param project_id: Project ID (required)
        :type project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GenericApiResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._clear_data_explorer_with_http_info(project_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _clear_data_explorer_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], **kwargs):  # noqa: E501
        """Clear data explorer 

        Remove the current data explorer state

        :param project_id: Project ID (required)
        :type project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GenericApiResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method clear_data_explorer" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GenericApiResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/raw-data/data-explorer/clear', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def count_samples(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], category : Annotated[RawDataCategory, Field(..., description="Which of the three acquisition categories to retrieve data from")], labels : Annotated[Optional[StrictStr], Field(description="Only include samples with a label within the given list of labels, given as a JSON string")] = None, filename : Annotated[Optional[StrictStr], Field(description="Only include samples whose filename includes the given filename")] = None, max_length : Annotated[Optional[StrictInt], Field(description="Only include samples shorter than the given length, in milliseconds")] = None, min_length : Annotated[Optional[StrictInt], Field(description="Only include samples longer than the given length, in milliseconds")] = None, min_frequency : Annotated[Optional[float], Field(description="Only include samples with higher frequency than given frequency, in hertz")] = None, max_frequency : Annotated[Optional[float], Field(description="Only include samples with lower frequency than given frequency, in hertz")] = None, signature_validity : Annotated[Optional[StrictStr], Field(description="Include samples with either valid or invalid signatures")] = None, include_disabled : Annotated[Optional[StrictStr], Field(description="Include only enabled or disabled samples (or both)")] = None, min_label : Annotated[Optional[float], Field(description="Only include samples with a label >= this value")] = None, max_label : Annotated[Optional[float], Field(description="Only include samples with a label < this value")] = None, search : Annotated[Optional[StrictStr], Field(description="Search query")] = None, data_type : Annotated[Optional[StrictStr], Field(description="Include only samples with a particular data type")] = None, min_id : Annotated[Optional[float], Field(description="Include only samples with an ID >= this value")] = None, max_id : Annotated[Optional[float], Field(description="Include only samples with an ID < this value")] = None, **kwargs) -> CountSamplesResponse:  # noqa: E501
        """Count samples

        Count all raw data by category.

        :param project_id: Project ID (required)
        :type project_id: int
        :param category: Which of the three acquisition categories to retrieve data from (required)
        :type category: RawDataCategory
        :param labels: Only include samples with a label within the given list of labels, given as a JSON string
        :type labels: str
        :param filename: Only include samples whose filename includes the given filename
        :type filename: str
        :param max_length: Only include samples shorter than the given length, in milliseconds
        :type max_length: int
        :param min_length: Only include samples longer than the given length, in milliseconds
        :type min_length: int
        :param min_frequency: Only include samples with higher frequency than given frequency, in hertz
        :type min_frequency: float
        :param max_frequency: Only include samples with lower frequency than given frequency, in hertz
        :type max_frequency: float
        :param signature_validity: Include samples with either valid or invalid signatures
        :type signature_validity: str
        :param include_disabled: Include only enabled or disabled samples (or both)
        :type include_disabled: str
        :param min_label: Only include samples with a label >= this value
        :type min_label: float
        :param max_label: Only include samples with a label < this value
        :type max_label: float
        :param search: Search query
        :type search: str
        :param data_type: Include only samples with a particular data type
        :type data_type: str
        :param min_id: Include only samples with an ID >= this value
        :type min_id: float
        :param max_id: Include only samples with an ID < this value
        :type max_id: float
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CountSamplesResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._count_samples_with_http_info(project_id, category, labels, filename, max_length, min_length, min_frequency, max_frequency, signature_validity, include_disabled, min_label, max_label, search, data_type, min_id, max_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _count_samples_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], category : Annotated[RawDataCategory, Field(..., description="Which of the three acquisition categories to retrieve data from")], labels : Annotated[Optional[StrictStr], Field(description="Only include samples with a label within the given list of labels, given as a JSON string")] = None, filename : Annotated[Optional[StrictStr], Field(description="Only include samples whose filename includes the given filename")] = None, max_length : Annotated[Optional[StrictInt], Field(description="Only include samples shorter than the given length, in milliseconds")] = None, min_length : Annotated[Optional[StrictInt], Field(description="Only include samples longer than the given length, in milliseconds")] = None, min_frequency : Annotated[Optional[float], Field(description="Only include samples with higher frequency than given frequency, in hertz")] = None, max_frequency : Annotated[Optional[float], Field(description="Only include samples with lower frequency than given frequency, in hertz")] = None, signature_validity : Annotated[Optional[StrictStr], Field(description="Include samples with either valid or invalid signatures")] = None, include_disabled : Annotated[Optional[StrictStr], Field(description="Include only enabled or disabled samples (or both)")] = None, min_label : Annotated[Optional[float], Field(description="Only include samples with a label >= this value")] = None, max_label : Annotated[Optional[float], Field(description="Only include samples with a label < this value")] = None, search : Annotated[Optional[StrictStr], Field(description="Search query")] = None, data_type : Annotated[Optional[StrictStr], Field(description="Include only samples with a particular data type")] = None, min_id : Annotated[Optional[float], Field(description="Include only samples with an ID >= this value")] = None, max_id : Annotated[Optional[float], Field(description="Include only samples with an ID < this value")] = None, **kwargs):  # noqa: E501
        """Count samples 

        Count all raw data by category.

        :param project_id: Project ID (required)
        :type project_id: int
        :param category: Which of the three acquisition categories to retrieve data from (required)
        :type category: RawDataCategory
        :param labels: Only include samples with a label within the given list of labels, given as a JSON string
        :type labels: str
        :param filename: Only include samples whose filename includes the given filename
        :type filename: str
        :param max_length: Only include samples shorter than the given length, in milliseconds
        :type max_length: int
        :param min_length: Only include samples longer than the given length, in milliseconds
        :type min_length: int
        :param min_frequency: Only include samples with higher frequency than given frequency, in hertz
        :type min_frequency: float
        :param max_frequency: Only include samples with lower frequency than given frequency, in hertz
        :type max_frequency: float
        :param signature_validity: Include samples with either valid or invalid signatures
        :type signature_validity: str
        :param include_disabled: Include only enabled or disabled samples (or both)
        :type include_disabled: str
        :param min_label: Only include samples with a label >= this value
        :type min_label: float
        :param max_label: Only include samples with a label < this value
        :type max_label: float
        :param search: Search query
        :type search: str
        :param data_type: Include only samples with a particular data type
        :type data_type: str
        :param min_id: Include only samples with an ID >= this value
        :type min_id: float
        :param max_id: Include only samples with an ID < this value
        :type max_id: float
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CountSamplesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'category',
            'labels',
            'filename',
            'max_length',
            'min_length',
            'min_frequency',
            'max_frequency',
            'signature_validity',
            'include_disabled',
            'min_label',
            'max_label',
            'search',
            'data_type',
            'min_id',
            'max_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method count_samples" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []
        if _params.get('category') is not None:  # noqa: E501
            _query_params.append(('category', _params['category']))
        if _params.get('labels') is not None:  # noqa: E501
            _query_params.append(('labels', _params['labels']))
        if _params.get('filename') is not None:  # noqa: E501
            _query_params.append(('filename', _params['filename']))
        if _params.get('max_length') is not None:  # noqa: E501
            _query_params.append(('maxLength', _params['max_length']))
        if _params.get('min_length') is not None:  # noqa: E501
            _query_params.append(('minLength', _params['min_length']))
        if _params.get('min_frequency') is not None:  # noqa: E501
            _query_params.append(('minFrequency', _params['min_frequency']))
        if _params.get('max_frequency') is not None:  # noqa: E501
            _query_params.append(('maxFrequency', _params['max_frequency']))
        if _params.get('signature_validity') is not None:  # noqa: E501
            _query_params.append(('signatureValidity', _params['signature_validity']))
        if _params.get('include_disabled') is not None:  # noqa: E501
            _query_params.append(('includeDisabled', _params['include_disabled']))
        if _params.get('min_label') is not None:  # noqa: E501
            _query_params.append(('minLabel', _params['min_label']))
        if _params.get('max_label') is not None:  # noqa: E501
            _query_params.append(('maxLabel', _params['max_label']))
        if _params.get('search') is not None:  # noqa: E501
            _query_params.append(('search', _params['search']))
        if _params.get('data_type') is not None:  # noqa: E501
            _query_params.append(('dataType', _params['data_type']))
        if _params.get('min_id') is not None:  # noqa: E501
            _query_params.append(('minId', _params['min_id']))
        if _params.get('max_id') is not None:  # noqa: E501
            _query_params.append(('maxId', _params['max_id']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "CountSamplesResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/raw-data/count', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def crop_sample(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], crop_sample_request : CropSampleRequest, **kwargs) -> CropSampleResponse:  # noqa: E501
        """Crop sample

        Crop a sample to within a new range.

        :param project_id: Project ID (required)
        :type project_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param crop_sample_request: (required)
        :type crop_sample_request: CropSampleRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CropSampleResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._crop_sample_with_http_info(project_id, sample_id, crop_sample_request, **kwargs)  # noqa: E501

    @validate_arguments
    def _crop_sample_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], crop_sample_request : CropSampleRequest, **kwargs):  # noqa: E501
        """Crop sample 

        Crop a sample to within a new range.

        :param project_id: Project ID (required)
        :type project_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param crop_sample_request: (required)
        :type crop_sample_request: CropSampleRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CropSampleResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'sample_id',
            'crop_sample_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method crop_sample" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['sample_id']:
            _path_params['sampleId'] = _params['sample_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['crop_sample_request']:
            _body_params = _params['crop_sample_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "CropSampleResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/raw-data/{sampleId}/crop', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def delete_all_samples(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], **kwargs) -> GenericApiResponse:  # noqa: E501
        """Remove all samples

        Deletes all samples for this project over all categories. This also invalidates all DSP and learn blocks. Note that this does not delete the data from cold storage.

        :param project_id: Project ID (required)
        :type project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GenericApiResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._delete_all_samples_with_http_info(project_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _delete_all_samples_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], **kwargs):  # noqa: E501
        """Remove all samples 

        Deletes all samples for this project over all categories. This also invalidates all DSP and learn blocks. Note that this does not delete the data from cold storage.

        :param project_id: Project ID (required)
        :type project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GenericApiResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_all_samples" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GenericApiResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/raw-data/delete-all', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def delete_all_samples_by_category(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], category : Annotated[RawDataCategory, Field(..., description="Which of the three acquisition categories to download data from")], **kwargs) -> GenericApiResponse:  # noqa: E501
        """Remove all samples by category

        Deletes all samples for this project over a single category. Note that this does not delete the data from cold storage.

        :param project_id: Project ID (required)
        :type project_id: int
        :param category: Which of the three acquisition categories to download data from (required)
        :type category: RawDataCategory
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GenericApiResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._delete_all_samples_by_category_with_http_info(project_id, category, **kwargs)  # noqa: E501

    @validate_arguments
    def _delete_all_samples_by_category_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], category : Annotated[RawDataCategory, Field(..., description="Which of the three acquisition categories to download data from")], **kwargs):  # noqa: E501
        """Remove all samples by category 

        Deletes all samples for this project over a single category. Note that this does not delete the data from cold storage.

        :param project_id: Project ID (required)
        :type project_id: int
        :param category: Which of the three acquisition categories to download data from (required)
        :type category: RawDataCategory
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GenericApiResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'category'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_all_samples_by_category" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['category']:
            _path_params['category'] = _params['category']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GenericApiResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/raw-data/delete-all/{category}', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def delete_sample(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], **kwargs) -> GenericApiResponse:  # noqa: E501
        """Remove sample

        Deletes the sample. Note that this does not delete the data from cold storage.

        :param project_id: Project ID (required)
        :type project_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GenericApiResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._delete_sample_with_http_info(project_id, sample_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _delete_sample_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], **kwargs):  # noqa: E501
        """Remove sample 

        Deletes the sample. Note that this does not delete the data from cold storage.

        :param project_id: Project ID (required)
        :type project_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GenericApiResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'sample_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_sample" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['sample_id']:
            _path_params['sampleId'] = _params['sample_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GenericApiResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/raw-data/{sampleId}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def disable_sample(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], **kwargs) -> GenericApiResponse:  # noqa: E501
        """Disable sample

        Disable a sample, ensuring that it is excluded from the dataset.

        :param project_id: Project ID (required)
        :type project_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GenericApiResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._disable_sample_with_http_info(project_id, sample_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _disable_sample_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], **kwargs):  # noqa: E501
        """Disable sample 

        Disable a sample, ensuring that it is excluded from the dataset.

        :param project_id: Project ID (required)
        :type project_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GenericApiResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'sample_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method disable_sample" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['sample_id']:
            _path_params['sampleId'] = _params['sample_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GenericApiResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/raw-data/{sampleId}/disable', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def edit_label(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], edit_sample_label_request : EditSampleLabelRequest, **kwargs) -> GenericApiResponse:  # noqa: E501
        """Edit label

        Sets the label (also known as class) of the sample. Use the same label for similar types of data, as they are used during training.

        :param project_id: Project ID (required)
        :type project_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param edit_sample_label_request: (required)
        :type edit_sample_label_request: EditSampleLabelRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GenericApiResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._edit_label_with_http_info(project_id, sample_id, edit_sample_label_request, **kwargs)  # noqa: E501

    @validate_arguments
    def _edit_label_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], edit_sample_label_request : EditSampleLabelRequest, **kwargs):  # noqa: E501
        """Edit label 

        Sets the label (also known as class) of the sample. Use the same label for similar types of data, as they are used during training.

        :param project_id: Project ID (required)
        :type project_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param edit_sample_label_request: (required)
        :type edit_sample_label_request: EditSampleLabelRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GenericApiResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'sample_id',
            'edit_sample_label_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_label" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['sample_id']:
            _path_params['sampleId'] = _params['sample_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['edit_sample_label_request']:
            _body_params = _params['edit_sample_label_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GenericApiResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/raw-data/{sampleId}/edit-label', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def enable_sample(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], **kwargs) -> GenericApiResponse:  # noqa: E501
        """Enable sample

        Enable a sample, ensuring that it is not excluded from the dataset.

        :param project_id: Project ID (required)
        :type project_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GenericApiResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._enable_sample_with_http_info(project_id, sample_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _enable_sample_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], **kwargs):  # noqa: E501
        """Enable sample 

        Enable a sample, ensuring that it is not excluded from the dataset.

        :param project_id: Project ID (required)
        :type project_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GenericApiResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'sample_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method enable_sample" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['sample_id']:
            _path_params['sampleId'] = _params['sample_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GenericApiResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/raw-data/{sampleId}/enable', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def find_segments_in_sample(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], find_segment_sample_request : FindSegmentSampleRequest, **kwargs) -> FindSegmentSampleResponse:  # noqa: E501
        """Find segments

        Find start and end times for all non-noise events in a sample

        :param project_id: Project ID (required)
        :type project_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param find_segment_sample_request: (required)
        :type find_segment_sample_request: FindSegmentSampleRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FindSegmentSampleResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._find_segments_in_sample_with_http_info(project_id, sample_id, find_segment_sample_request, **kwargs)  # noqa: E501

    @validate_arguments
    def _find_segments_in_sample_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], find_segment_sample_request : FindSegmentSampleRequest, **kwargs):  # noqa: E501
        """Find segments 

        Find start and end times for all non-noise events in a sample

        :param project_id: Project ID (required)
        :type project_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param find_segment_sample_request: (required)
        :type find_segment_sample_request: FindSegmentSampleRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(FindSegmentSampleResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'sample_id',
            'find_segment_sample_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method find_segments_in_sample" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['sample_id']:
            _path_params['sampleId'] = _params['sample_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['find_segment_sample_request']:
            _body_params = _params['find_segment_sample_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "FindSegmentSampleResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/raw-data/{sampleId}/find-segments', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_ai_actions_proposed_changes(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], job_id : Annotated[StrictInt, Field(..., description="Job ID")], **kwargs) -> GetAIActionsProposedChangesResponse:  # noqa: E501
        """Get AI Actions proposed changes

        Get proposed changes from an AI Actions job.

        :param project_id: Project ID (required)
        :type project_id: int
        :param job_id: Job ID (required)
        :type job_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetAIActionsProposedChangesResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._get_ai_actions_proposed_changes_with_http_info(project_id, job_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_ai_actions_proposed_changes_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], job_id : Annotated[StrictInt, Field(..., description="Job ID")], **kwargs):  # noqa: E501
        """Get AI Actions proposed changes 

        Get proposed changes from an AI Actions job.

        :param project_id: Project ID (required)
        :type project_id: int
        :param job_id: Job ID (required)
        :type job_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetAIActionsProposedChangesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'job_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ai_actions_proposed_changes" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['job_id']:
            _path_params['jobId'] = _params['job_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GetAIActionsProposedChangesResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/raw-data/ai-actions-preview/{jobId}/proposed-changes', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_all_imported_from(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], limit : Annotated[Optional[StrictInt], Field(description="Maximum number of results")] = None, offset : Annotated[Optional[StrictInt], Field(description="Offset in results, can be used in conjunction with LimitResultsParameter to implement paging.")] = None, **kwargs) -> GetAllImportedFromResponse:  # noqa: E501
        """List data with \"imported from\" metadata key

        Lists all data with an 'imported from' metadata key. Used to check in a data source which items are already in a project.

        :param project_id: Project ID (required)
        :type project_id: int
        :param limit: Maximum number of results
        :type limit: int
        :param offset: Offset in results, can be used in conjunction with LimitResultsParameter to implement paging.
        :type offset: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetAllImportedFromResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._get_all_imported_from_with_http_info(project_id, limit, offset, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_all_imported_from_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], limit : Annotated[Optional[StrictInt], Field(description="Maximum number of results")] = None, offset : Annotated[Optional[StrictInt], Field(description="Offset in results, can be used in conjunction with LimitResultsParameter to implement paging.")] = None, **kwargs):  # noqa: E501
        """List data with \"imported from\" metadata key 

        Lists all data with an 'imported from' metadata key. Used to check in a data source which items are already in a project.

        :param project_id: Project ID (required)
        :type project_id: int
        :param limit: Maximum number of results
        :type limit: int
        :param offset: Offset in results, can be used in conjunction with LimitResultsParameter to implement paging.
        :type offset: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetAllImportedFromResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'limit',
            'offset'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_imported_from" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []
        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))
        if _params.get('offset') is not None:  # noqa: E501
            _query_params.append(('offset', _params['offset']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GetAllImportedFromResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/raw-data/imported-from', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_data_explorer_features(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], **kwargs) -> GetDataExplorerFeaturesResponse:  # noqa: E501
        """Get data explorer features

        t-SNE2 output of the raw dataset

        :param project_id: Project ID (required)
        :type project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetDataExplorerFeaturesResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._get_data_explorer_features_with_http_info(project_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_data_explorer_features_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], **kwargs):  # noqa: E501
        """Get data explorer features 

        t-SNE2 output of the raw dataset

        :param project_id: Project ID (required)
        :type project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetDataExplorerFeaturesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_data_explorer_features" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GetDataExplorerFeaturesResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/raw-data/data-explorer/features', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_data_explorer_predictions(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], **kwargs) -> DataExplorerPredictionsResponse:  # noqa: E501
        """Get data explorer predictions

        Predictions for every data explorer point (only available when using current impulse to populate data explorer)

        :param project_id: Project ID (required)
        :type project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DataExplorerPredictionsResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._get_data_explorer_predictions_with_http_info(project_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_data_explorer_predictions_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], **kwargs):  # noqa: E501
        """Get data explorer predictions 

        Predictions for every data explorer point (only available when using current impulse to populate data explorer)

        :param project_id: Project ID (required)
        :type project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DataExplorerPredictionsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_data_explorer_predictions" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "DataExplorerPredictionsResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/raw-data/data-explorer/predictions', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_data_explorer_settings(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], **kwargs) -> GetDataExplorerSettingsResponse:  # noqa: E501
        """Get data explorer settings

        Get data explorer configuration, like the type of data, and the input / dsp block to use.

        :param project_id: Project ID (required)
        :type project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetDataExplorerSettingsResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._get_data_explorer_settings_with_http_info(project_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_data_explorer_settings_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], **kwargs):  # noqa: E501
        """Get data explorer settings 

        Get data explorer configuration, like the type of data, and the input / dsp block to use.

        :param project_id: Project ID (required)
        :type project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetDataExplorerSettingsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_data_explorer_settings" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GetDataExplorerSettingsResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/raw-data/data-explorer/settings', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_diversity_data(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], **kwargs) -> GetDiversityDataResponse:  # noqa: E501
        """Get diversity metrics data

        Obtain metrics that describe the similarity and diversity of a dataset. To calculate these metrics, use the `calculateDataQualityMetrics` endpoint.

        :param project_id: Project ID (required)
        :type project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetDiversityDataResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._get_diversity_data_with_http_info(project_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_diversity_data_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], **kwargs):  # noqa: E501
        """Get diversity metrics data 

        Obtain metrics that describe the similarity and diversity of a dataset. To calculate these metrics, use the `calculateDataQualityMetrics` endpoint.

        :param project_id: Project ID (required)
        :type project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetDiversityDataResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_diversity_data" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GetDiversityDataResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/raw-data/data-quality/diversity', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_label_noise_data(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], **kwargs) -> GetLabelNoiseDataResponse:  # noqa: E501
        """Get label noise data

        Obtain metrics that describe potential label noise issues in the dataset. To calculate these metrics, use the `calculateDataQualityMetrics` endpoint.

        :param project_id: Project ID (required)
        :type project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetLabelNoiseDataResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._get_label_noise_data_with_http_info(project_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_label_noise_data_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], **kwargs):  # noqa: E501
        """Get label noise data 

        Obtain metrics that describe potential label noise issues in the dataset. To calculate these metrics, use the `calculateDataQualityMetrics` endpoint.

        :param project_id: Project ID (required)
        :type project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetLabelNoiseDataResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_label_noise_data" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GetLabelNoiseDataResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/raw-data/data-quality/label-noise', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_object_detection_label_queue(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], **kwargs) -> ObjectDetectionLabelQueueResponse:  # noqa: E501
        """Object detection label queue

        Get all unlabeled items from the object detection queue.

        :param project_id: Project ID (required)
        :type project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ObjectDetectionLabelQueueResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._get_object_detection_label_queue_with_http_info(project_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_object_detection_label_queue_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], **kwargs):  # noqa: E501
        """Object detection label queue 

        Get all unlabeled items from the object detection queue.

        :param project_id: Project ID (required)
        :type project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ObjectDetectionLabelQueueResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_object_detection_label_queue" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "ObjectDetectionLabelQueueResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/raw-data/label-object-detection-queue', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_object_detection_label_queue_count(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], **kwargs) -> ObjectDetectionLabelQueueCountResponse:  # noqa: E501
        """Object detection label queue count

        Get count for unlabeled items from the object detection queue.

        :param project_id: Project ID (required)
        :type project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ObjectDetectionLabelQueueCountResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._get_object_detection_label_queue_count_with_http_info(project_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_object_detection_label_queue_count_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], **kwargs):  # noqa: E501
        """Object detection label queue count 

        Get count for unlabeled items from the object detection queue.

        :param project_id: Project ID (required)
        :type project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ObjectDetectionLabelQueueCountResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_object_detection_label_queue_count" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "ObjectDetectionLabelQueueCountResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/raw-data/label-object-detection-queue/count', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_sample(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], limit_payload_values : Annotated[Optional[StrictInt], Field(description="Limit the number of payload values in the response")] = None, cache_key : Annotated[Optional[StrictStr], Field(description="If set, then a long cache header is sent. If this is omitted then a no-cache header is sent. You can use this if you f.e. know the last modified date of a sample. Stick the last modified date in the cache key, so the sample can be stored in browser cache (and will automatically be invalidated if the modified date changes).")] = None, impulse_id : Annotated[Optional[StrictInt], Field(description="Impulse ID. If this is unset then the default impulse is used.")] = None, proposed_actions_job_id : Annotated[Optional[StrictInt], Field(description="Pass this parameter when querying samples from inside an AI Action job. If you pass this parameter in a multi-stage AI Action, previous proposed changes (from an earlier step) will be applied to the returned dataset.")] = None, truncate_structured_labels : Annotated[Optional[StrictBool], Field(description="If true, only a slice of labels will be returned for samples with multiple labels.")] = None, **kwargs) -> GetSampleResponse:  # noqa: E501
        """Get sample

        Get a sample.

        :param project_id: Project ID (required)
        :type project_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param limit_payload_values: Limit the number of payload values in the response
        :type limit_payload_values: int
        :param cache_key: If set, then a long cache header is sent. If this is omitted then a no-cache header is sent. You can use this if you f.e. know the last modified date of a sample. Stick the last modified date in the cache key, so the sample can be stored in browser cache (and will automatically be invalidated if the modified date changes).
        :type cache_key: str
        :param impulse_id: Impulse ID. If this is unset then the default impulse is used.
        :type impulse_id: int
        :param proposed_actions_job_id: Pass this parameter when querying samples from inside an AI Action job. If you pass this parameter in a multi-stage AI Action, previous proposed changes (from an earlier step) will be applied to the returned dataset.
        :type proposed_actions_job_id: int
        :param truncate_structured_labels: If true, only a slice of labels will be returned for samples with multiple labels.
        :type truncate_structured_labels: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetSampleResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._get_sample_with_http_info(project_id, sample_id, limit_payload_values, cache_key, impulse_id, proposed_actions_job_id, truncate_structured_labels, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_sample_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], limit_payload_values : Annotated[Optional[StrictInt], Field(description="Limit the number of payload values in the response")] = None, cache_key : Annotated[Optional[StrictStr], Field(description="If set, then a long cache header is sent. If this is omitted then a no-cache header is sent. You can use this if you f.e. know the last modified date of a sample. Stick the last modified date in the cache key, so the sample can be stored in browser cache (and will automatically be invalidated if the modified date changes).")] = None, impulse_id : Annotated[Optional[StrictInt], Field(description="Impulse ID. If this is unset then the default impulse is used.")] = None, proposed_actions_job_id : Annotated[Optional[StrictInt], Field(description="Pass this parameter when querying samples from inside an AI Action job. If you pass this parameter in a multi-stage AI Action, previous proposed changes (from an earlier step) will be applied to the returned dataset.")] = None, truncate_structured_labels : Annotated[Optional[StrictBool], Field(description="If true, only a slice of labels will be returned for samples with multiple labels.")] = None, **kwargs):  # noqa: E501
        """Get sample 

        Get a sample.

        :param project_id: Project ID (required)
        :type project_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param limit_payload_values: Limit the number of payload values in the response
        :type limit_payload_values: int
        :param cache_key: If set, then a long cache header is sent. If this is omitted then a no-cache header is sent. You can use this if you f.e. know the last modified date of a sample. Stick the last modified date in the cache key, so the sample can be stored in browser cache (and will automatically be invalidated if the modified date changes).
        :type cache_key: str
        :param impulse_id: Impulse ID. If this is unset then the default impulse is used.
        :type impulse_id: int
        :param proposed_actions_job_id: Pass this parameter when querying samples from inside an AI Action job. If you pass this parameter in a multi-stage AI Action, previous proposed changes (from an earlier step) will be applied to the returned dataset.
        :type proposed_actions_job_id: int
        :param truncate_structured_labels: If true, only a slice of labels will be returned for samples with multiple labels.
        :type truncate_structured_labels: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetSampleResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'sample_id',
            'limit_payload_values',
            'cache_key',
            'impulse_id',
            'proposed_actions_job_id',
            'truncate_structured_labels'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_sample" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['sample_id']:
            _path_params['sampleId'] = _params['sample_id']

        # process the query parameters
        _query_params = []
        if _params.get('limit_payload_values') is not None:  # noqa: E501
            _query_params.append(('limitPayloadValues', _params['limit_payload_values']))
        if _params.get('cache_key') is not None:  # noqa: E501
            _query_params.append(('cacheKey', _params['cache_key']))
        if _params.get('impulse_id') is not None:  # noqa: E501
            _query_params.append(('impulseId', _params['impulse_id']))
        if _params.get('proposed_actions_job_id') is not None:  # noqa: E501
            _query_params.append(('proposedActionsJobId', _params['proposed_actions_job_id']))
        if _params.get('truncate_structured_labels') is not None:  # noqa: E501
            _query_params.append(('truncateStructuredLabels', _params['truncate_structured_labels']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GetSampleResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/raw-data/{sampleId}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_sample_as_audio(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], axis_ix : Annotated[StrictInt, Field(..., description="Axis index")], slice_start : Annotated[Optional[StrictInt], Field(description="Begin index of the slice. If not given, the whole sample is used.")] = None, slice_end : Annotated[Optional[StrictInt], Field(description="End index of the slice. If not given, the whole sample is used.")] = None, cache_key : Annotated[Optional[StrictStr], Field(description="If set, then a long cache header is sent. If this is omitted then a no-cache header is sent. You can use this if you f.e. know the last modified date of a sample. Stick the last modified date in the cache key, so the sample can be stored in browser cache (and will automatically be invalidated if the modified date changes).")] = None, **kwargs) -> str:  # noqa: E501
        """Get WAV file

        Get a sample as a WAV file. This only applies to samples with an audio axis.

        :param project_id: Project ID (required)
        :type project_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param axis_ix: Axis index (required)
        :type axis_ix: int
        :param slice_start: Begin index of the slice. If not given, the whole sample is used.
        :type slice_start: int
        :param slice_end: End index of the slice. If not given, the whole sample is used.
        :type slice_end: int
        :param cache_key: If set, then a long cache header is sent. If this is omitted then a no-cache header is sent. You can use this if you f.e. know the last modified date of a sample. Stick the last modified date in the cache key, so the sample can be stored in browser cache (and will automatically be invalidated if the modified date changes).
        :type cache_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        return self._get_sample_as_audio_with_http_info(project_id, sample_id, axis_ix, slice_start, slice_end, cache_key, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_sample_as_audio_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], axis_ix : Annotated[StrictInt, Field(..., description="Axis index")], slice_start : Annotated[Optional[StrictInt], Field(description="Begin index of the slice. If not given, the whole sample is used.")] = None, slice_end : Annotated[Optional[StrictInt], Field(description="End index of the slice. If not given, the whole sample is used.")] = None, cache_key : Annotated[Optional[StrictStr], Field(description="If set, then a long cache header is sent. If this is omitted then a no-cache header is sent. You can use this if you f.e. know the last modified date of a sample. Stick the last modified date in the cache key, so the sample can be stored in browser cache (and will automatically be invalidated if the modified date changes).")] = None, **kwargs):  # noqa: E501
        """Get WAV file 

        Get a sample as a WAV file. This only applies to samples with an audio axis.

        :param project_id: Project ID (required)
        :type project_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param axis_ix: Axis index (required)
        :type axis_ix: int
        :param slice_start: Begin index of the slice. If not given, the whole sample is used.
        :type slice_start: int
        :param slice_end: End index of the slice. If not given, the whole sample is used.
        :type slice_end: int
        :param cache_key: If set, then a long cache header is sent. If this is omitted then a no-cache header is sent. You can use this if you f.e. know the last modified date of a sample. Stick the last modified date in the cache key, so the sample can be stored in browser cache (and will automatically be invalidated if the modified date changes).
        :type cache_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'sample_id',
            'axis_ix',
            'slice_start',
            'slice_end',
            'cache_key'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_sample_as_audio" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['sample_id']:
            _path_params['sampleId'] = _params['sample_id']

        # process the query parameters
        _query_params = []
        if _params.get('axis_ix') is not None:  # noqa: E501
            _query_params.append(('axisIx', _params['axis_ix']))
        if _params.get('slice_start') is not None:  # noqa: E501
            _query_params.append(('sliceStart', _params['slice_start']))
        if _params.get('slice_end') is not None:  # noqa: E501
            _query_params.append(('sliceEnd', _params['slice_end']))
        if _params.get('cache_key') is not None:  # noqa: E501
            _query_params.append(('cacheKey', _params['cache_key']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['audio/wav'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "str",
        }

        return self.api_client.call_api(
            '/api/{projectId}/raw-data/{sampleId}/wav', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_sample_as_image(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], after_input_block : Annotated[Optional[StrictBool], Field(description="Whether to process the image through the input block first")] = None, cache_key : Annotated[Optional[StrictStr], Field(description="If set, then a long cache header is sent. If this is omitted then a no-cache header is sent. You can use this if you f.e. know the last modified date of a sample. Stick the last modified date in the cache key, so the sample can be stored in browser cache (and will automatically be invalidated if the modified date changes).")] = None, impulse_id : Annotated[Optional[StrictInt], Field(description="Impulse ID. If this is unset then the default impulse is used.")] = None, **kwargs) -> str:  # noqa: E501
        """Get image file

        Get a sample as an image file. This only applies to samples with RGBA data.

        :param project_id: Project ID (required)
        :type project_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param after_input_block: Whether to process the image through the input block first
        :type after_input_block: bool
        :param cache_key: If set, then a long cache header is sent. If this is omitted then a no-cache header is sent. You can use this if you f.e. know the last modified date of a sample. Stick the last modified date in the cache key, so the sample can be stored in browser cache (and will automatically be invalidated if the modified date changes).
        :type cache_key: str
        :param impulse_id: Impulse ID. If this is unset then the default impulse is used.
        :type impulse_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        return self._get_sample_as_image_with_http_info(project_id, sample_id, after_input_block, cache_key, impulse_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_sample_as_image_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], after_input_block : Annotated[Optional[StrictBool], Field(description="Whether to process the image through the input block first")] = None, cache_key : Annotated[Optional[StrictStr], Field(description="If set, then a long cache header is sent. If this is omitted then a no-cache header is sent. You can use this if you f.e. know the last modified date of a sample. Stick the last modified date in the cache key, so the sample can be stored in browser cache (and will automatically be invalidated if the modified date changes).")] = None, impulse_id : Annotated[Optional[StrictInt], Field(description="Impulse ID. If this is unset then the default impulse is used.")] = None, **kwargs):  # noqa: E501
        """Get image file 

        Get a sample as an image file. This only applies to samples with RGBA data.

        :param project_id: Project ID (required)
        :type project_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param after_input_block: Whether to process the image through the input block first
        :type after_input_block: bool
        :param cache_key: If set, then a long cache header is sent. If this is omitted then a no-cache header is sent. You can use this if you f.e. know the last modified date of a sample. Stick the last modified date in the cache key, so the sample can be stored in browser cache (and will automatically be invalidated if the modified date changes).
        :type cache_key: str
        :param impulse_id: Impulse ID. If this is unset then the default impulse is used.
        :type impulse_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'sample_id',
            'after_input_block',
            'cache_key',
            'impulse_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_sample_as_image" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['sample_id']:
            _path_params['sampleId'] = _params['sample_id']

        # process the query parameters
        _query_params = []
        if _params.get('after_input_block') is not None:  # noqa: E501
            _query_params.append(('afterInputBlock', _params['after_input_block']))
        if _params.get('cache_key') is not None:  # noqa: E501
            _query_params.append(('cacheKey', _params['cache_key']))
        if _params.get('impulse_id') is not None:  # noqa: E501
            _query_params.append(('impulseId', _params['impulse_id']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['image/jpeg'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "str",
        }

        return self.api_client.call_api(
            '/api/{projectId}/raw-data/{sampleId}/image', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_sample_as_raw(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], **kwargs) -> str:  # noqa: E501
        """Download file

        Download a sample in it's original format as uploaded to the ingestion service.

        :param project_id: Project ID (required)
        :type project_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        return self._get_sample_as_raw_with_http_info(project_id, sample_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_sample_as_raw_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], **kwargs):  # noqa: E501
        """Download file 

        Download a sample in it's original format as uploaded to the ingestion service.

        :param project_id: Project ID (required)
        :type project_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'sample_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_sample_as_raw" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['sample_id']:
            _path_params['sampleId'] = _params['sample_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "str",
        }

        return self.api_client.call_api(
            '/api/{projectId}/raw-data/{sampleId}/raw', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_sample_as_video(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], after_input_block : Annotated[Optional[StrictBool], Field(description="Whether to process the image through the input block first")] = None, cache_key : Annotated[Optional[StrictStr], Field(description="If set, then a long cache header is sent. If this is omitted then a no-cache header is sent. You can use this if you f.e. know the last modified date of a sample. Stick the last modified date in the cache key, so the sample can be stored in browser cache (and will automatically be invalidated if the modified date changes).")] = None, impulse_id : Annotated[Optional[StrictInt], Field(description="Impulse ID. If this is unset then the default impulse is used.")] = None, **kwargs) -> str:  # noqa: E501
        """Get video file

        Get a sample as an video file. This only applies to samples with video data.

        :param project_id: Project ID (required)
        :type project_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param after_input_block: Whether to process the image through the input block first
        :type after_input_block: bool
        :param cache_key: If set, then a long cache header is sent. If this is omitted then a no-cache header is sent. You can use this if you f.e. know the last modified date of a sample. Stick the last modified date in the cache key, so the sample can be stored in browser cache (and will automatically be invalidated if the modified date changes).
        :type cache_key: str
        :param impulse_id: Impulse ID. If this is unset then the default impulse is used.
        :type impulse_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        return self._get_sample_as_video_with_http_info(project_id, sample_id, after_input_block, cache_key, impulse_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_sample_as_video_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], after_input_block : Annotated[Optional[StrictBool], Field(description="Whether to process the image through the input block first")] = None, cache_key : Annotated[Optional[StrictStr], Field(description="If set, then a long cache header is sent. If this is omitted then a no-cache header is sent. You can use this if you f.e. know the last modified date of a sample. Stick the last modified date in the cache key, so the sample can be stored in browser cache (and will automatically be invalidated if the modified date changes).")] = None, impulse_id : Annotated[Optional[StrictInt], Field(description="Impulse ID. If this is unset then the default impulse is used.")] = None, **kwargs):  # noqa: E501
        """Get video file 

        Get a sample as an video file. This only applies to samples with video data.

        :param project_id: Project ID (required)
        :type project_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param after_input_block: Whether to process the image through the input block first
        :type after_input_block: bool
        :param cache_key: If set, then a long cache header is sent. If this is omitted then a no-cache header is sent. You can use this if you f.e. know the last modified date of a sample. Stick the last modified date in the cache key, so the sample can be stored in browser cache (and will automatically be invalidated if the modified date changes).
        :type cache_key: str
        :param impulse_id: Impulse ID. If this is unset then the default impulse is used.
        :type impulse_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'sample_id',
            'after_input_block',
            'cache_key',
            'impulse_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_sample_as_video" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['sample_id']:
            _path_params['sampleId'] = _params['sample_id']

        # process the query parameters
        _query_params = []
        if _params.get('after_input_block') is not None:  # noqa: E501
            _query_params.append(('afterInputBlock', _params['after_input_block']))
        if _params.get('cache_key') is not None:  # noqa: E501
            _query_params.append(('cacheKey', _params['cache_key']))
        if _params.get('impulse_id') is not None:  # noqa: E501
            _query_params.append(('impulseId', _params['impulse_id']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['video/mp4'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "str",
        }

        return self.api_client.call_api(
            '/api/{projectId}/raw-data/{sampleId}/video', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_sample_metadata(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], category : Annotated[RawDataCategory, Field(..., description="Which of the three acquisition categories to retrieve data from")], **kwargs) -> GetSampleMetadataResponse:  # noqa: E501
        """Get project sample metadata

        Get metadata for all samples in a project.

        :param project_id: Project ID (required)
        :type project_id: int
        :param category: Which of the three acquisition categories to retrieve data from (required)
        :type category: RawDataCategory
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetSampleMetadataResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._get_sample_metadata_with_http_info(project_id, category, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_sample_metadata_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], category : Annotated[RawDataCategory, Field(..., description="Which of the three acquisition categories to retrieve data from")], **kwargs):  # noqa: E501
        """Get project sample metadata 

        Get metadata for all samples in a project.

        :param project_id: Project ID (required)
        :type project_id: int
        :param category: Which of the three acquisition categories to retrieve data from (required)
        :type category: RawDataCategory
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetSampleMetadataResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'category'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_sample_metadata" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []
        if _params.get('category') is not None:  # noqa: E501
            _query_params.append(('category', _params['category']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GetSampleMetadataResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/raw-data/metadata', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_sample_slice(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], slice_start : Annotated[StrictInt, Field(..., description="Begin index of the slice")], slice_end : Annotated[Optional[StrictInt], Field(description="End index of the slice. If not given, the sample will be sliced to the same length as the impulse input block window length.")] = None, impulse_id : Annotated[Optional[StrictInt], Field(description="Impulse ID. If this is unset then the default impulse is used.")] = None, truncate_structured_labels : Annotated[Optional[StrictBool], Field(description="If true, only a slice of labels will be returned for samples with multiple labels.")] = None, **kwargs) -> GetSampleResponse:  # noqa: E501
        """Get sample slice

        Get a slice of a sample.

        :param project_id: Project ID (required)
        :type project_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param slice_start: Begin index of the slice (required)
        :type slice_start: int
        :param slice_end: End index of the slice. If not given, the sample will be sliced to the same length as the impulse input block window length.
        :type slice_end: int
        :param impulse_id: Impulse ID. If this is unset then the default impulse is used.
        :type impulse_id: int
        :param truncate_structured_labels: If true, only a slice of labels will be returned for samples with multiple labels.
        :type truncate_structured_labels: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetSampleResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._get_sample_slice_with_http_info(project_id, sample_id, slice_start, slice_end, impulse_id, truncate_structured_labels, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_sample_slice_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], slice_start : Annotated[StrictInt, Field(..., description="Begin index of the slice")], slice_end : Annotated[Optional[StrictInt], Field(description="End index of the slice. If not given, the sample will be sliced to the same length as the impulse input block window length.")] = None, impulse_id : Annotated[Optional[StrictInt], Field(description="Impulse ID. If this is unset then the default impulse is used.")] = None, truncate_structured_labels : Annotated[Optional[StrictBool], Field(description="If true, only a slice of labels will be returned for samples with multiple labels.")] = None, **kwargs):  # noqa: E501
        """Get sample slice 

        Get a slice of a sample.

        :param project_id: Project ID (required)
        :type project_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param slice_start: Begin index of the slice (required)
        :type slice_start: int
        :param slice_end: End index of the slice. If not given, the sample will be sliced to the same length as the impulse input block window length.
        :type slice_end: int
        :param impulse_id: Impulse ID. If this is unset then the default impulse is used.
        :type impulse_id: int
        :param truncate_structured_labels: If true, only a slice of labels will be returned for samples with multiple labels.
        :type truncate_structured_labels: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetSampleResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'sample_id',
            'slice_start',
            'slice_end',
            'impulse_id',
            'truncate_structured_labels'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_sample_slice" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['sample_id']:
            _path_params['sampleId'] = _params['sample_id']

        # process the query parameters
        _query_params = []
        if _params.get('slice_start') is not None:  # noqa: E501
            _query_params.append(('sliceStart', _params['slice_start']))
        if _params.get('slice_end') is not None:  # noqa: E501
            _query_params.append(('sliceEnd', _params['slice_end']))
        if _params.get('impulse_id') is not None:  # noqa: E501
            _query_params.append(('impulseId', _params['impulse_id']))
        if _params.get('truncate_structured_labels') is not None:  # noqa: E501
            _query_params.append(('truncateStructuredLabels', _params['truncate_structured_labels']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GetSampleResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/raw-data/{sampleId}/slice', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_uncropped_downsampled_sample(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], limit_payload_values : Annotated[Optional[StrictInt], Field(description="Limit the number of payload values in the response")] = None, zoom_start : Annotated[Optional[StrictInt], Field(description="Zoom into the sample, with the focus starting at this index")] = None, zoom_end : Annotated[Optional[StrictInt], Field(description="Zoom into the sample, with the focus ending at this index")] = None, impulse_id : Annotated[Optional[StrictInt], Field(description="Impulse ID. If this is unset then the default impulse is used.")] = None, truncate_structured_labels : Annotated[Optional[StrictBool], Field(description="If true, only a slice of labels will be returned for samples with multiple labels.")] = None, **kwargs) -> GetSampleResponse:  # noqa: E501
        """Get the original downsampled data

        Get the original, uncropped, downsampled data.

        :param project_id: Project ID (required)
        :type project_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param limit_payload_values: Limit the number of payload values in the response
        :type limit_payload_values: int
        :param zoom_start: Zoom into the sample, with the focus starting at this index
        :type zoom_start: int
        :param zoom_end: Zoom into the sample, with the focus ending at this index
        :type zoom_end: int
        :param impulse_id: Impulse ID. If this is unset then the default impulse is used.
        :type impulse_id: int
        :param truncate_structured_labels: If true, only a slice of labels will be returned for samples with multiple labels.
        :type truncate_structured_labels: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetSampleResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._get_uncropped_downsampled_sample_with_http_info(project_id, sample_id, limit_payload_values, zoom_start, zoom_end, impulse_id, truncate_structured_labels, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_uncropped_downsampled_sample_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], limit_payload_values : Annotated[Optional[StrictInt], Field(description="Limit the number of payload values in the response")] = None, zoom_start : Annotated[Optional[StrictInt], Field(description="Zoom into the sample, with the focus starting at this index")] = None, zoom_end : Annotated[Optional[StrictInt], Field(description="Zoom into the sample, with the focus ending at this index")] = None, impulse_id : Annotated[Optional[StrictInt], Field(description="Impulse ID. If this is unset then the default impulse is used.")] = None, truncate_structured_labels : Annotated[Optional[StrictBool], Field(description="If true, only a slice of labels will be returned for samples with multiple labels.")] = None, **kwargs):  # noqa: E501
        """Get the original downsampled data 

        Get the original, uncropped, downsampled data.

        :param project_id: Project ID (required)
        :type project_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param limit_payload_values: Limit the number of payload values in the response
        :type limit_payload_values: int
        :param zoom_start: Zoom into the sample, with the focus starting at this index
        :type zoom_start: int
        :param zoom_end: Zoom into the sample, with the focus ending at this index
        :type zoom_end: int
        :param impulse_id: Impulse ID. If this is unset then the default impulse is used.
        :type impulse_id: int
        :param truncate_structured_labels: If true, only a slice of labels will be returned for samples with multiple labels.
        :type truncate_structured_labels: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetSampleResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'sample_id',
            'limit_payload_values',
            'zoom_start',
            'zoom_end',
            'impulse_id',
            'truncate_structured_labels'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_uncropped_downsampled_sample" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['sample_id']:
            _path_params['sampleId'] = _params['sample_id']

        # process the query parameters
        _query_params = []
        if _params.get('limit_payload_values') is not None:  # noqa: E501
            _query_params.append(('limitPayloadValues', _params['limit_payload_values']))
        if _params.get('zoom_start') is not None:  # noqa: E501
            _query_params.append(('zoomStart', _params['zoom_start']))
        if _params.get('zoom_end') is not None:  # noqa: E501
            _query_params.append(('zoomEnd', _params['zoom_end']))
        if _params.get('impulse_id') is not None:  # noqa: E501
            _query_params.append(('impulseId', _params['impulse_id']))
        if _params.get('truncate_structured_labels') is not None:  # noqa: E501
            _query_params.append(('truncateStructuredLabels', _params['truncate_structured_labels']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GetSampleResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/raw-data/{sampleId}/original', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def has_data_explorer_features(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], **kwargs) -> HasDataExplorerFeaturesResponse:  # noqa: E501
        """Check data explorer features

        t-SNE2 output of the raw dataset

        :param project_id: Project ID (required)
        :type project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: HasDataExplorerFeaturesResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._has_data_explorer_features_with_http_info(project_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _has_data_explorer_features_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], **kwargs):  # noqa: E501
        """Check data explorer features 

        t-SNE2 output of the raw dataset

        :param project_id: Project ID (required)
        :type project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(HasDataExplorerFeaturesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method has_data_explorer_features" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "HasDataExplorerFeaturesResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/raw-data/data-explorer/has-features', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def has_diversity_data(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], **kwargs) -> HasDataExplorerFeaturesResponse:  # noqa: E501
        """Check if data diversity metrics exist

        Determine if data diversity metrics have been calculated. To calculate these metrics, use the `calculateDataQualityMetrics` endpoint.

        :param project_id: Project ID (required)
        :type project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: HasDataExplorerFeaturesResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._has_diversity_data_with_http_info(project_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _has_diversity_data_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], **kwargs):  # noqa: E501
        """Check if data diversity metrics exist 

        Determine if data diversity metrics have been calculated. To calculate these metrics, use the `calculateDataQualityMetrics` endpoint.

        :param project_id: Project ID (required)
        :type project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(HasDataExplorerFeaturesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method has_diversity_data" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "HasDataExplorerFeaturesResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/raw-data/data-quality/diversity/exists', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def has_label_noise_data(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], **kwargs) -> HasDataExplorerFeaturesResponse:  # noqa: E501
        """Check if label noise metrics exist

        Determine if label noise metrics have been calculated. To calculate these metrics, use the `calculateDataQualityMetrics` endpoint.

        :param project_id: Project ID (required)
        :type project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: HasDataExplorerFeaturesResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._has_label_noise_data_with_http_info(project_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _has_label_noise_data_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], **kwargs):  # noqa: E501
        """Check if label noise metrics exist 

        Determine if label noise metrics have been calculated. To calculate these metrics, use the `calculateDataQualityMetrics` endpoint.

        :param project_id: Project ID (required)
        :type project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(HasDataExplorerFeaturesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method has_label_noise_data" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "HasDataExplorerFeaturesResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/raw-data/data-quality/label-noise/exists', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_samples(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], category : Annotated[RawDataCategory, Field(..., description="Which of the three acquisition categories to retrieve data from")], limit : Annotated[Optional[StrictInt], Field(description="Maximum number of results")] = None, offset : Annotated[Optional[StrictInt], Field(description="Offset in results, can be used in conjunction with LimitResultsParameter to implement paging.")] = None, exclude_sensors : Annotated[Optional[StrictBool], Field(description="Whether to exclude sensors in the response (as these can slow down requests when you have large pages).")] = None, labels : Annotated[Optional[StrictStr], Field(description="Only include samples with a label within the given list of labels, given as a JSON string")] = None, filename : Annotated[Optional[StrictStr], Field(description="Only include samples whose filename includes the given filename")] = None, max_length : Annotated[Optional[StrictInt], Field(description="Only include samples shorter than the given length, in milliseconds")] = None, min_length : Annotated[Optional[StrictInt], Field(description="Only include samples longer than the given length, in milliseconds")] = None, min_frequency : Annotated[Optional[float], Field(description="Only include samples with higher frequency than given frequency, in hertz")] = None, max_frequency : Annotated[Optional[float], Field(description="Only include samples with lower frequency than given frequency, in hertz")] = None, signature_validity : Annotated[Optional[StrictStr], Field(description="Include samples with either valid or invalid signatures")] = None, include_disabled : Annotated[Optional[StrictStr], Field(description="Include only enabled or disabled samples (or both)")] = None, min_label : Annotated[Optional[float], Field(description="Only include samples with a label >= this value")] = None, max_label : Annotated[Optional[float], Field(description="Only include samples with a label < this value")] = None, search : Annotated[Optional[StrictStr], Field(description="Search query")] = None, proposed_actions_job_id : Annotated[Optional[StrictInt], Field(description="Pass this parameter when querying samples from inside an AI Action job. If you pass this parameter in a multi-stage AI Action, previous proposed changes (from an earlier step) will be applied to the returned dataset.")] = None, truncate_structured_labels : Annotated[Optional[StrictBool], Field(description="If true, only a slice of labels will be returned for samples with multiple labels.")] = None, sort_by : Annotated[Optional[StrictStr], Field(description="If not specified, \"id-desc\" is used.")] = None, data_type : Annotated[Optional[StrictStr], Field(description="Include only samples with a particular data type")] = None, min_id : Annotated[Optional[float], Field(description="Include only samples with an ID >= this value")] = None, max_id : Annotated[Optional[float], Field(description="Include only samples with an ID < this value")] = None, **kwargs) -> ListSamplesResponse:  # noqa: E501
        """List samples

        Retrieve all raw data by category.

        :param project_id: Project ID (required)
        :type project_id: int
        :param category: Which of the three acquisition categories to retrieve data from (required)
        :type category: RawDataCategory
        :param limit: Maximum number of results
        :type limit: int
        :param offset: Offset in results, can be used in conjunction with LimitResultsParameter to implement paging.
        :type offset: int
        :param exclude_sensors: Whether to exclude sensors in the response (as these can slow down requests when you have large pages).
        :type exclude_sensors: bool
        :param labels: Only include samples with a label within the given list of labels, given as a JSON string
        :type labels: str
        :param filename: Only include samples whose filename includes the given filename
        :type filename: str
        :param max_length: Only include samples shorter than the given length, in milliseconds
        :type max_length: int
        :param min_length: Only include samples longer than the given length, in milliseconds
        :type min_length: int
        :param min_frequency: Only include samples with higher frequency than given frequency, in hertz
        :type min_frequency: float
        :param max_frequency: Only include samples with lower frequency than given frequency, in hertz
        :type max_frequency: float
        :param signature_validity: Include samples with either valid or invalid signatures
        :type signature_validity: str
        :param include_disabled: Include only enabled or disabled samples (or both)
        :type include_disabled: str
        :param min_label: Only include samples with a label >= this value
        :type min_label: float
        :param max_label: Only include samples with a label < this value
        :type max_label: float
        :param search: Search query
        :type search: str
        :param proposed_actions_job_id: Pass this parameter when querying samples from inside an AI Action job. If you pass this parameter in a multi-stage AI Action, previous proposed changes (from an earlier step) will be applied to the returned dataset.
        :type proposed_actions_job_id: int
        :param truncate_structured_labels: If true, only a slice of labels will be returned for samples with multiple labels.
        :type truncate_structured_labels: bool
        :param sort_by: If not specified, \"id-desc\" is used.
        :type sort_by: str
        :param data_type: Include only samples with a particular data type
        :type data_type: str
        :param min_id: Include only samples with an ID >= this value
        :type min_id: float
        :param max_id: Include only samples with an ID < this value
        :type max_id: float
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ListSamplesResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._list_samples_with_http_info(project_id, category, limit, offset, exclude_sensors, labels, filename, max_length, min_length, min_frequency, max_frequency, signature_validity, include_disabled, min_label, max_label, search, proposed_actions_job_id, truncate_structured_labels, sort_by, data_type, min_id, max_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _list_samples_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], category : Annotated[RawDataCategory, Field(..., description="Which of the three acquisition categories to retrieve data from")], limit : Annotated[Optional[StrictInt], Field(description="Maximum number of results")] = None, offset : Annotated[Optional[StrictInt], Field(description="Offset in results, can be used in conjunction with LimitResultsParameter to implement paging.")] = None, exclude_sensors : Annotated[Optional[StrictBool], Field(description="Whether to exclude sensors in the response (as these can slow down requests when you have large pages).")] = None, labels : Annotated[Optional[StrictStr], Field(description="Only include samples with a label within the given list of labels, given as a JSON string")] = None, filename : Annotated[Optional[StrictStr], Field(description="Only include samples whose filename includes the given filename")] = None, max_length : Annotated[Optional[StrictInt], Field(description="Only include samples shorter than the given length, in milliseconds")] = None, min_length : Annotated[Optional[StrictInt], Field(description="Only include samples longer than the given length, in milliseconds")] = None, min_frequency : Annotated[Optional[float], Field(description="Only include samples with higher frequency than given frequency, in hertz")] = None, max_frequency : Annotated[Optional[float], Field(description="Only include samples with lower frequency than given frequency, in hertz")] = None, signature_validity : Annotated[Optional[StrictStr], Field(description="Include samples with either valid or invalid signatures")] = None, include_disabled : Annotated[Optional[StrictStr], Field(description="Include only enabled or disabled samples (or both)")] = None, min_label : Annotated[Optional[float], Field(description="Only include samples with a label >= this value")] = None, max_label : Annotated[Optional[float], Field(description="Only include samples with a label < this value")] = None, search : Annotated[Optional[StrictStr], Field(description="Search query")] = None, proposed_actions_job_id : Annotated[Optional[StrictInt], Field(description="Pass this parameter when querying samples from inside an AI Action job. If you pass this parameter in a multi-stage AI Action, previous proposed changes (from an earlier step) will be applied to the returned dataset.")] = None, truncate_structured_labels : Annotated[Optional[StrictBool], Field(description="If true, only a slice of labels will be returned for samples with multiple labels.")] = None, sort_by : Annotated[Optional[StrictStr], Field(description="If not specified, \"id-desc\" is used.")] = None, data_type : Annotated[Optional[StrictStr], Field(description="Include only samples with a particular data type")] = None, min_id : Annotated[Optional[float], Field(description="Include only samples with an ID >= this value")] = None, max_id : Annotated[Optional[float], Field(description="Include only samples with an ID < this value")] = None, **kwargs):  # noqa: E501
        """List samples 

        Retrieve all raw data by category.

        :param project_id: Project ID (required)
        :type project_id: int
        :param category: Which of the three acquisition categories to retrieve data from (required)
        :type category: RawDataCategory
        :param limit: Maximum number of results
        :type limit: int
        :param offset: Offset in results, can be used in conjunction with LimitResultsParameter to implement paging.
        :type offset: int
        :param exclude_sensors: Whether to exclude sensors in the response (as these can slow down requests when you have large pages).
        :type exclude_sensors: bool
        :param labels: Only include samples with a label within the given list of labels, given as a JSON string
        :type labels: str
        :param filename: Only include samples whose filename includes the given filename
        :type filename: str
        :param max_length: Only include samples shorter than the given length, in milliseconds
        :type max_length: int
        :param min_length: Only include samples longer than the given length, in milliseconds
        :type min_length: int
        :param min_frequency: Only include samples with higher frequency than given frequency, in hertz
        :type min_frequency: float
        :param max_frequency: Only include samples with lower frequency than given frequency, in hertz
        :type max_frequency: float
        :param signature_validity: Include samples with either valid or invalid signatures
        :type signature_validity: str
        :param include_disabled: Include only enabled or disabled samples (or both)
        :type include_disabled: str
        :param min_label: Only include samples with a label >= this value
        :type min_label: float
        :param max_label: Only include samples with a label < this value
        :type max_label: float
        :param search: Search query
        :type search: str
        :param proposed_actions_job_id: Pass this parameter when querying samples from inside an AI Action job. If you pass this parameter in a multi-stage AI Action, previous proposed changes (from an earlier step) will be applied to the returned dataset.
        :type proposed_actions_job_id: int
        :param truncate_structured_labels: If true, only a slice of labels will be returned for samples with multiple labels.
        :type truncate_structured_labels: bool
        :param sort_by: If not specified, \"id-desc\" is used.
        :type sort_by: str
        :param data_type: Include only samples with a particular data type
        :type data_type: str
        :param min_id: Include only samples with an ID >= this value
        :type min_id: float
        :param max_id: Include only samples with an ID < this value
        :type max_id: float
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ListSamplesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'category',
            'limit',
            'offset',
            'exclude_sensors',
            'labels',
            'filename',
            'max_length',
            'min_length',
            'min_frequency',
            'max_frequency',
            'signature_validity',
            'include_disabled',
            'min_label',
            'max_label',
            'search',
            'proposed_actions_job_id',
            'truncate_structured_labels',
            'sort_by',
            'data_type',
            'min_id',
            'max_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_samples" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []
        if _params.get('category') is not None:  # noqa: E501
            _query_params.append(('category', _params['category']))
        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))
        if _params.get('offset') is not None:  # noqa: E501
            _query_params.append(('offset', _params['offset']))
        if _params.get('exclude_sensors') is not None:  # noqa: E501
            _query_params.append(('excludeSensors', _params['exclude_sensors']))
        if _params.get('labels') is not None:  # noqa: E501
            _query_params.append(('labels', _params['labels']))
        if _params.get('filename') is not None:  # noqa: E501
            _query_params.append(('filename', _params['filename']))
        if _params.get('max_length') is not None:  # noqa: E501
            _query_params.append(('maxLength', _params['max_length']))
        if _params.get('min_length') is not None:  # noqa: E501
            _query_params.append(('minLength', _params['min_length']))
        if _params.get('min_frequency') is not None:  # noqa: E501
            _query_params.append(('minFrequency', _params['min_frequency']))
        if _params.get('max_frequency') is not None:  # noqa: E501
            _query_params.append(('maxFrequency', _params['max_frequency']))
        if _params.get('signature_validity') is not None:  # noqa: E501
            _query_params.append(('signatureValidity', _params['signature_validity']))
        if _params.get('include_disabled') is not None:  # noqa: E501
            _query_params.append(('includeDisabled', _params['include_disabled']))
        if _params.get('min_label') is not None:  # noqa: E501
            _query_params.append(('minLabel', _params['min_label']))
        if _params.get('max_label') is not None:  # noqa: E501
            _query_params.append(('maxLabel', _params['max_label']))
        if _params.get('search') is not None:  # noqa: E501
            _query_params.append(('search', _params['search']))
        if _params.get('proposed_actions_job_id') is not None:  # noqa: E501
            _query_params.append(('proposedActionsJobId', _params['proposed_actions_job_id']))
        if _params.get('truncate_structured_labels') is not None:  # noqa: E501
            _query_params.append(('truncateStructuredLabels', _params['truncate_structured_labels']))
        if _params.get('sort_by') is not None:  # noqa: E501
            _query_params.append(('sortBy', _params['sort_by']))
        if _params.get('data_type') is not None:  # noqa: E501
            _query_params.append(('dataType', _params['data_type']))
        if _params.get('min_id') is not None:  # noqa: E501
            _query_params.append(('minId', _params['min_id']))
        if _params.get('max_id') is not None:  # noqa: E501
            _query_params.append(('maxId', _params['max_id']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "ListSamplesResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/raw-data', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def move_sample(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], move_raw_data_request : MoveRawDataRequest, **kwargs) -> GenericApiResponse:  # noqa: E501
        """Move sample

        Move a sample to another category (e.g. from test to training).

        :param project_id: Project ID (required)
        :type project_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param move_raw_data_request: (required)
        :type move_raw_data_request: MoveRawDataRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GenericApiResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._move_sample_with_http_info(project_id, sample_id, move_raw_data_request, **kwargs)  # noqa: E501

    @validate_arguments
    def _move_sample_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], move_raw_data_request : MoveRawDataRequest, **kwargs):  # noqa: E501
        """Move sample 

        Move a sample to another category (e.g. from test to training).

        :param project_id: Project ID (required)
        :type project_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param move_raw_data_request: (required)
        :type move_raw_data_request: MoveRawDataRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GenericApiResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'sample_id',
            'move_raw_data_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method move_sample" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['sample_id']:
            _path_params['sampleId'] = _params['sample_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['move_raw_data_request']:
            _body_params = _params['move_raw_data_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GenericApiResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/raw-data/{sampleId}/move', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def move_to_labeling_queue(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], **kwargs) -> GenericApiResponse:  # noqa: E501
        """Move sample to labeling queue

        Clears the bounding box labels and moves item back to labeling queue

        :param project_id: Project ID (required)
        :type project_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GenericApiResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._move_to_labeling_queue_with_http_info(project_id, sample_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _move_to_labeling_queue_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], **kwargs):  # noqa: E501
        """Move sample to labeling queue 

        Clears the bounding box labels and moves item back to labeling queue

        :param project_id: Project ID (required)
        :type project_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GenericApiResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'sample_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method move_to_labeling_queue" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['sample_id']:
            _path_params['sampleId'] = _params['sample_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GenericApiResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/raw-data/{sampleId}/to-labeling-queue', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def rebalance_dataset(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], **kwargs) -> RebalanceDatasetResponse:  # noqa: E501
        """Rebalance dataset

        Rebalances the dataset over training / testing categories. This resets the category for all data and splits it 80%/20% between training and testing. This is a deterministic process based on the hash of the name of the data.

        :param project_id: Project ID (required)
        :type project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: RebalanceDatasetResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._rebalance_dataset_with_http_info(project_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _rebalance_dataset_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], **kwargs):  # noqa: E501
        """Rebalance dataset 

        Rebalances the dataset over training / testing categories. This resets the category for all data and splits it 80%/20% between training and testing. This is a deterministic process based on the hash of the name of the data.

        :param project_id: Project ID (required)
        :type project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(RebalanceDatasetResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method rebalance_dataset" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "RebalanceDatasetResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/rebalance', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def rename_sample(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], rename_sample_request : RenameSampleRequest, **kwargs) -> GenericApiResponse:  # noqa: E501
        """Rename sample

        Sets the file name of the sample. This name does not need to be unique, but it's highly recommended to do so.

        :param project_id: Project ID (required)
        :type project_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param rename_sample_request: (required)
        :type rename_sample_request: RenameSampleRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GenericApiResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._rename_sample_with_http_info(project_id, sample_id, rename_sample_request, **kwargs)  # noqa: E501

    @validate_arguments
    def _rename_sample_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], rename_sample_request : RenameSampleRequest, **kwargs):  # noqa: E501
        """Rename sample 

        Sets the file name of the sample. This name does not need to be unique, but it's highly recommended to do so.

        :param project_id: Project ID (required)
        :type project_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param rename_sample_request: (required)
        :type rename_sample_request: RenameSampleRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GenericApiResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'sample_id',
            'rename_sample_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method rename_sample" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['sample_id']:
            _path_params['sampleId'] = _params['sample_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['rename_sample_request']:
            _body_params = _params['rename_sample_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GenericApiResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/raw-data/{sampleId}/rename', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def retry_processing(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], **kwargs) -> GenericApiResponse:  # noqa: E501
        """Retry processing

        If a sample failed processing, retry the processing operation.

        :param project_id: Project ID (required)
        :type project_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GenericApiResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._retry_processing_with_http_info(project_id, sample_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _retry_processing_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], **kwargs):  # noqa: E501
        """Retry processing 

        If a sample failed processing, retry the processing operation.

        :param project_id: Project ID (required)
        :type project_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GenericApiResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'sample_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method retry_processing" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['sample_id']:
            _path_params['sampleId'] = _params['sample_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GenericApiResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/raw-data/{sampleId}/retry-processing', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def segment_sample(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], segment_sample_request : SegmentSampleRequest, **kwargs) -> GenericApiResponse:  # noqa: E501
        """Segment sample

        Slice a sample into multiple segments. The original file will be marked as deleted, but you can crop any created segment to retrieve the original file.

        :param project_id: Project ID (required)
        :type project_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param segment_sample_request: (required)
        :type segment_sample_request: SegmentSampleRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GenericApiResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._segment_sample_with_http_info(project_id, sample_id, segment_sample_request, **kwargs)  # noqa: E501

    @validate_arguments
    def _segment_sample_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], segment_sample_request : SegmentSampleRequest, **kwargs):  # noqa: E501
        """Segment sample 

        Slice a sample into multiple segments. The original file will be marked as deleted, but you can crop any created segment to retrieve the original file.

        :param project_id: Project ID (required)
        :type project_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param segment_sample_request: (required)
        :type segment_sample_request: SegmentSampleRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GenericApiResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'sample_id',
            'segment_sample_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method segment_sample" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['sample_id']:
            _path_params['sampleId'] = _params['sample_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['segment_sample_request']:
            _body_params = _params['segment_sample_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GenericApiResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/raw-data/{sampleId}/segment', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def set_data_explorer_settings(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], data_explorer_settings : DataExplorerSettings, **kwargs) -> GenericApiResponse:  # noqa: E501
        """Set data explorer settings

        Set data explorer configuration, like the type of data, and the input / dsp block to use.

        :param project_id: Project ID (required)
        :type project_id: int
        :param data_explorer_settings: (required)
        :type data_explorer_settings: DataExplorerSettings
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GenericApiResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._set_data_explorer_settings_with_http_info(project_id, data_explorer_settings, **kwargs)  # noqa: E501

    @validate_arguments
    def _set_data_explorer_settings_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], data_explorer_settings : DataExplorerSettings, **kwargs):  # noqa: E501
        """Set data explorer settings 

        Set data explorer configuration, like the type of data, and the input / dsp block to use.

        :param project_id: Project ID (required)
        :type project_id: int
        :param data_explorer_settings: (required)
        :type data_explorer_settings: DataExplorerSettings
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GenericApiResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'data_explorer_settings'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_data_explorer_settings" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['data_explorer_settings']:
            _body_params = _params['data_explorer_settings']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GenericApiResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/raw-data/data-explorer/settings', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def set_sample_bounding_boxes(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], sample_bounding_boxes_request : SampleBoundingBoxesRequest, **kwargs) -> GenericApiResponse:  # noqa: E501
        """Set bounding boxes

        Set the bounding boxes for a sample

        :param project_id: Project ID (required)
        :type project_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param sample_bounding_boxes_request: (required)
        :type sample_bounding_boxes_request: SampleBoundingBoxesRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GenericApiResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._set_sample_bounding_boxes_with_http_info(project_id, sample_id, sample_bounding_boxes_request, **kwargs)  # noqa: E501

    @validate_arguments
    def _set_sample_bounding_boxes_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], sample_bounding_boxes_request : SampleBoundingBoxesRequest, **kwargs):  # noqa: E501
        """Set bounding boxes 

        Set the bounding boxes for a sample

        :param project_id: Project ID (required)
        :type project_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param sample_bounding_boxes_request: (required)
        :type sample_bounding_boxes_request: SampleBoundingBoxesRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GenericApiResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'sample_id',
            'sample_bounding_boxes_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_sample_bounding_boxes" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['sample_id']:
            _path_params['sampleId'] = _params['sample_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['sample_bounding_boxes_request']:
            _body_params = _params['sample_bounding_boxes_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GenericApiResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/raw-data/{sampleId}/bounding-boxes', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def set_sample_metadata(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], set_sample_metadata_request : SetSampleMetadataRequest, **kwargs) -> GenericApiResponse:  # noqa: E501
        """Set sample metadata

        Adds or updates the metadata associated to a sample.

        :param project_id: Project ID (required)
        :type project_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param set_sample_metadata_request: (required)
        :type set_sample_metadata_request: SetSampleMetadataRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GenericApiResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._set_sample_metadata_with_http_info(project_id, sample_id, set_sample_metadata_request, **kwargs)  # noqa: E501

    @validate_arguments
    def _set_sample_metadata_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], set_sample_metadata_request : SetSampleMetadataRequest, **kwargs):  # noqa: E501
        """Set sample metadata 

        Adds or updates the metadata associated to a sample.

        :param project_id: Project ID (required)
        :type project_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param set_sample_metadata_request: (required)
        :type set_sample_metadata_request: SetSampleMetadataRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GenericApiResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'sample_id',
            'set_sample_metadata_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_sample_metadata" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['sample_id']:
            _path_params['sampleId'] = _params['sample_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['set_sample_metadata_request']:
            _body_params = _params['set_sample_metadata_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GenericApiResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/raw-data/{sampleId}/metadata', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def set_sample_proposed_changes(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], set_sample_proposed_changes_request : SetSampleProposedChangesRequest, **kwargs) -> GenericApiResponse:  # noqa: E501
        """Propose changes

        Queue up changes to an object as part of the AI Actions flow. This overwrites any previous proposed changes.

        :param project_id: Project ID (required)
        :type project_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param set_sample_proposed_changes_request: (required)
        :type set_sample_proposed_changes_request: SetSampleProposedChangesRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GenericApiResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._set_sample_proposed_changes_with_http_info(project_id, sample_id, set_sample_proposed_changes_request, **kwargs)  # noqa: E501

    @validate_arguments
    def _set_sample_proposed_changes_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], set_sample_proposed_changes_request : SetSampleProposedChangesRequest, **kwargs):  # noqa: E501
        """Propose changes 

        Queue up changes to an object as part of the AI Actions flow. This overwrites any previous proposed changes.

        :param project_id: Project ID (required)
        :type project_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param set_sample_proposed_changes_request: (required)
        :type set_sample_proposed_changes_request: SetSampleProposedChangesRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GenericApiResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'sample_id',
            'set_sample_proposed_changes_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_sample_proposed_changes" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['sample_id']:
            _path_params['sampleId'] = _params['sample_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['set_sample_proposed_changes_request']:
            _body_params = _params['set_sample_proposed_changes_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GenericApiResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/raw-data/{sampleId}/propose-changes', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def set_sample_structured_labels(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], set_sample_structured_labels_request : SetSampleStructuredLabelsRequest, **kwargs) -> GenericApiResponse:  # noqa: E501
        """Update structured labels

        Set structured labels for a sample. If a sample has structured labels the `label` column is ignored, and the sample is allowed to have multiple labels. An array of { startIndex, endIndex, label } needs to be passed in with labels for the complete sample (see `valuesCount` to get the upper bound). endIndex is _inclusive_. If you pass in an incorrect array (e.g. missing values) you'll get an error back.

        :param project_id: Project ID (required)
        :type project_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param set_sample_structured_labels_request: (required)
        :type set_sample_structured_labels_request: SetSampleStructuredLabelsRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GenericApiResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._set_sample_structured_labels_with_http_info(project_id, sample_id, set_sample_structured_labels_request, **kwargs)  # noqa: E501

    @validate_arguments
    def _set_sample_structured_labels_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], set_sample_structured_labels_request : SetSampleStructuredLabelsRequest, **kwargs):  # noqa: E501
        """Update structured labels 

        Set structured labels for a sample. If a sample has structured labels the `label` column is ignored, and the sample is allowed to have multiple labels. An array of { startIndex, endIndex, label } needs to be passed in with labels for the complete sample (see `valuesCount` to get the upper bound). endIndex is _inclusive_. If you pass in an incorrect array (e.g. missing values) you'll get an error back.

        :param project_id: Project ID (required)
        :type project_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param set_sample_structured_labels_request: (required)
        :type set_sample_structured_labels_request: SetSampleStructuredLabelsRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GenericApiResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'sample_id',
            'set_sample_structured_labels_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_sample_structured_labels" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['sample_id']:
            _path_params['sampleId'] = _params['sample_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['set_sample_structured_labels_request']:
            _body_params = _params['set_sample_structured_labels_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GenericApiResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/raw-data/{sampleId}/structured-labels', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def set_sample_video_dimensions(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], set_sample_video_dimensions_request : SetSampleVideoDimensionsRequest, **kwargs) -> GenericApiResponse:  # noqa: E501
        """Set sample video dimensions

        Update the video dimensions for a sample. This is only available for video files that do not have dimensions set yet.

        :param project_id: Project ID (required)
        :type project_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param set_sample_video_dimensions_request: (required)
        :type set_sample_video_dimensions_request: SetSampleVideoDimensionsRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GenericApiResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._set_sample_video_dimensions_with_http_info(project_id, sample_id, set_sample_video_dimensions_request, **kwargs)  # noqa: E501

    @validate_arguments
    def _set_sample_video_dimensions_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], set_sample_video_dimensions_request : SetSampleVideoDimensionsRequest, **kwargs):  # noqa: E501
        """Set sample video dimensions 

        Update the video dimensions for a sample. This is only available for video files that do not have dimensions set yet.

        :param project_id: Project ID (required)
        :type project_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param set_sample_video_dimensions_request: (required)
        :type set_sample_video_dimensions_request: SetSampleVideoDimensionsRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GenericApiResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'sample_id',
            'set_sample_video_dimensions_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_sample_video_dimensions" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['sample_id']:
            _path_params['sampleId'] = _params['sample_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['set_sample_video_dimensions_request']:
            _body_params = _params['set_sample_video_dimensions_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GenericApiResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/raw-data/{sampleId}/video-dimensions', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def split_sample_in_frames(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], split_sample_in_frames_request : SplitSampleInFramesRequest, **kwargs) -> SplitSampleInFrames200Response:  # noqa: E501
        """Split sample into frames

        Split a video sample into individual frames. Depending on the length of the video sample this will either execute immediately or return the ID of a job that will perform this action. 

        :param project_id: Project ID (required)
        :type project_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param split_sample_in_frames_request: (required)
        :type split_sample_in_frames_request: SplitSampleInFramesRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SplitSampleInFrames200Response
        """
        kwargs['_return_http_data_only'] = True
        return self._split_sample_in_frames_with_http_info(project_id, sample_id, split_sample_in_frames_request, **kwargs)  # noqa: E501

    @validate_arguments
    def _split_sample_in_frames_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], split_sample_in_frames_request : SplitSampleInFramesRequest, **kwargs):  # noqa: E501
        """Split sample into frames 

        Split a video sample into individual frames. Depending on the length of the video sample this will either execute immediately or return the ID of a job that will perform this action. 

        :param project_id: Project ID (required)
        :type project_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param split_sample_in_frames_request: (required)
        :type split_sample_in_frames_request: SplitSampleInFramesRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SplitSampleInFrames200Response, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'sample_id',
            'split_sample_in_frames_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method split_sample_in_frames" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['sample_id']:
            _path_params['sampleId'] = _params['sample_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['split_sample_in_frames_request']:
            _body_params = _params['split_sample_in_frames_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "SplitSampleInFrames200Response",
        }

        return self.api_client.call_api(
            '/api/{projectId}/raw-data/{sampleId}/split', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def store_segment_length(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], store_segment_length_request : StoreSegmentLengthRequest, **kwargs) -> GenericApiResponse:  # noqa: E501
        """Store the last segment length

        When segmenting a sample into smaller segments, store the segment length to ensure uniform segment lengths.

        :param project_id: Project ID (required)
        :type project_id: int
        :param store_segment_length_request: (required)
        :type store_segment_length_request: StoreSegmentLengthRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GenericApiResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._store_segment_length_with_http_info(project_id, store_segment_length_request, **kwargs)  # noqa: E501

    @validate_arguments
    def _store_segment_length_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], store_segment_length_request : StoreSegmentLengthRequest, **kwargs):  # noqa: E501
        """Store the last segment length 

        When segmenting a sample into smaller segments, store the segment length to ensure uniform segment lengths.

        :param project_id: Project ID (required)
        :type project_id: int
        :param store_segment_length_request: (required)
        :type store_segment_length_request: StoreSegmentLengthRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GenericApiResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'store_segment_length_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method store_segment_length" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['store_segment_length_request']:
            _body_params = _params['store_segment_length_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GenericApiResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/raw-data/store-segment-length', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def track_objects(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], track_objects_request : TrackObjectsRequest, **kwargs) -> TrackObjectsResponse:  # noqa: E501
        """Track objects

        Track objects between two samples. Source sample should have bounding boxes set.

        :param project_id: Project ID (required)
        :type project_id: int
        :param track_objects_request: (required)
        :type track_objects_request: TrackObjectsRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TrackObjectsResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._track_objects_with_http_info(project_id, track_objects_request, **kwargs)  # noqa: E501

    @validate_arguments
    def _track_objects_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], track_objects_request : TrackObjectsRequest, **kwargs):  # noqa: E501
        """Track objects 

        Track objects between two samples. Source sample should have bounding boxes set.

        :param project_id: Project ID (required)
        :type project_id: int
        :param track_objects_request: (required)
        :type track_objects_request: TrackObjectsRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(TrackObjectsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'track_objects_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method track_objects" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['track_objects_request']:
            _body_params = _params['track_objects_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "TrackObjectsResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/raw-data/track-objects', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
