# source: https://cabforum.org/wp-content/uploads/CA-Browser-Forum-BR-1.8.1.pdf
CERTIFICATE_TYPES = {
    "2.23.140.1.1": "EV",
    "2.23.140.1.2.2": "OV",
    "2.23.140.1.2.3": "IV",
    "2.23.140.1.2.1": "DV",
}

RDN_DESCRIPTIONS = {
    # source: https://datatracker.ietf.org/doc/html/rfc4514
    "2.5.4.3":                      "commonName",
    "2.5.4.7":                      "localityName",
    "2.5.4.8":                      "stateOrProvinceName",
    "2.5.4.10":                     "organizationName",
    "2.5.4.11":                     "organizationalUnit",
    "2.5.4.6":                      "countryName",
    "2.5.4.9":                      "streetAddress",
    "0.9.2342.19200300.100.1.25":   "domainComponent",
    "0.9.2342.19200300.100.1.1":    "userId",

    # source: https://oidref.com/2.5.4
    "2.5.4.0":                      "objectClass",
    "2.5.4.1":                      "aliasedEntryName",
    "2.5.4.2":                      "knowledgeInformation",
    "2.5.4.4":                      "surname",
    "2.5.4.5":                      "serialNumber",
    "2.5.4.12":                     "title",
    "2.5.4.13":                     "description",
    "2.5.4.14":                     "searchGuide",
    "2.5.4.15":                     "businessCategory",
    "2.5.4.16":                     "postalAddress",
    "2.5.4.17":                     "postalCode",
    "2.5.4.18":                     "postOfficeBox",
    "2.5.4.19":                     "physicalDeliveryOfficeName",
    "2.5.4.20":                     "telephoneNumber",
    "2.5.4.21":                     "telexNumber",
    "2.5.4.22":                     "teletexTerminalIdentifier",
    "2.5.4.23":                     "facsimileTelephoneNumber",
    "2.5.4.24":                     "x121Address",
    "2.5.4.25":                     "internationalISDNNumber",
    "2.5.4.26":                     "registeredAddress",
    "2.5.4.27":                     "destinationIndicator",
    "2.5.4.28":                     "preferredDeliveryMethod",
    "2.5.4.29":                     "presentationAddress",
    "2.5.4.30":                     "supportedApplicationContext",
    "2.5.4.31":                     "member",
    "2.5.4.32":                     "owner",
    "2.5.4.33":                     "roleOccupant",
    "2.5.4.34":                     "seeAlso",
    "2.5.4.35":                     "userPassword",
    "2.5.4.36":                     "userCertificate",
    "2.5.4.37":                     "cACertificate",
    "2.5.4.38":                     "authorityRevocationList",
    "2.5.4.39":                     "certificateRevocationList",
    "2.5.4.40":                     "crossCertificatePair",
    "2.5.4.41":                     "name",
    "2.5.4.42":                     "givenName",
    "2.5.4.43":                     "initials",
    "2.5.4.44":                     "generationQualifier",
    "2.5.4.45":                     "uniqueIdentifier",
    "2.5.4.46":                     "dnQualifier",
    "2.5.4.47":                     "enhancedSearchGuide",
    "2.5.4.48":                     "protocolInformation",
    "2.5.4.49":                     "distinguishedName",
    "2.5.4.50":                     "uniqueMember",
    "2.5.4.51":                     "houseIdentifier",
    "2.5.4.52":                     "supportedAlgorithms",
    "2.5.4.53":                     "deltaRevocationList",
    "2.5.4.54":                     "dmdName",
    "2.5.4.55":                     "clearance",
    "2.5.4.56":                     "defaultDirQop",
    "2.5.4.57":                     "attributeIntegrityInfo",
    "2.5.4.58":                     "attributeCertificate",
    "2.5.4.59":                     "attributeCertificateRevocationList",
    "2.5.4.60":                     "confKeyInfo",
    "2.5.4.61":                     "aACertificate",
    "2.5.4.62":                     "attributeDescriptorCertificate",
    "2.5.4.63":                     "attributeAuthorityRevocationList",
    "2.5.4.64":                     "familyInformation",
    "2.5.4.65":                     "pseudonym",
    "2.5.4.66":                     "communicationsService",
    "2.5.4.67":                     "communicationsNetwork",
    "2.5.4.68":                     "certificationPracticeStmt",
    "2.5.4.69":                     "certificatePolicy",
    "2.5.4.70":                     "pkiPath",
    "2.5.4.71":                     "privPolicy",
    "2.5.4.72":                     "role",
    "2.5.4.73":                     "delegationPath",
    "2.5.4.74":                     "protPrivPolicy",
    "2.5.4.75":                     "xMLPrivilegeInfo",
    "2.5.4.76":                     "xmlPrivPolicy",
    "2.5.4.77":                     "uuidpair",
    "2.5.4.78":                     "tagOid",
    "2.5.4.79":                     "uiiFormat",
    "2.5.4.80":                     "uiiInUrh",
    "2.5.4.81":                     "contentUrl",
    "2.5.4.82":                     "permission",
    "2.5.4.83":                     "uri",
    "2.5.4.84":                     "pwdAttribute",
    "2.5.4.85":                     "userPwd",
    "2.5.4.86":                     "urn",
    "2.5.4.87":                     "url",
    "2.5.4.88":                     "utmCoordinates",
    "2.5.4.89":                     "urnC",
    "2.5.4.90":                     "uii",
    "2.5.4.91":                     "epc",
    "2.5.4.92":                     "tagAfi",
    "2.5.4.93":                     "epcFormat",
    "2.5.4.94":                     "epcInUrn",
    "2.5.4.95":                     "ldapUrl",
    "2.5.4.96":                     "ldapUrl",
    "2.5.4.97":                     "organizationIdentifier",

    # source: https://www.cryptosys.net/pki/manpki/pki_distnames.html
    "1.2.840.113549.1.9.1":         "emailAddress",

    # source: http://oidref.com/1.3.6.1.4.1.311.60.2.1
    "1.3.6.1.4.1.311.60.2.1.1":     "jurisdictionOfIncorporationLocalityName",
    "1.3.6.1.4.1.311.60.2.1.2":     "jurisdictionOfIncorporationStateOrProvinceName",
    "1.3.6.1.4.1.311.60.2.1.3":     "jurisdictionOfIncorporationCountryName",
}
