# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['mendeleev', 'mendeleev.vis']

package_data = \
{'': ['*']}

install_requires = \
['Pygments>=2.8.0,<3.0.0',
 'SQLAlchemy>=1.4.0,<2.0.0',
 'colorama>=0.4.4,<0.5.0',
 'numpy>=1.21,<2.0',
 'pandas>=0.25.0',
 'pyfiglet>=0.8.post1,<0.9',
 'six>=1.15.0,<2.0.0']

extras_require = \
{'vis': ['plotly>=5.0,<6.0',
         'seaborn>=0.11.1,<0.12.0',
         'bokeh>=2.3.0,<3.0.0',
         'jupyter-bokeh>=3.0.2,<4.0.0']}

setup_kwargs = {
    'name': 'mendeleev',
    'version': '0.11.0',
    'description': 'Pythonic periodic table of elements',
    'long_description': '[![Documentation Status](https://readthedocs.org/projects/mendeleev/badge/)](https://mendeleev.readthedocs.org)\n[![Latest version released on PyPi](https://img.shields.io/pypi/v/mendeleev.svg?style=flat-square&label=PYPI%20version)](https://pypi.python.org/pypi/mendeleev)\n[![MIT license](https://img.shields.io/badge/License-MIT-yellow.svg)](https://opensource.org/licenses/MIT)\n[![image](https://anaconda.org/conda-forge/github3.py/badges/installer/conda.svg)](https://anaconda.org/lmmentel/mendeleev)\n[![Python package](https://github.com/lmmentel/mendeleev/actions/workflows/main.yml/badge.svg)](https://github.com/lmmentel/mendeleev/actions/workflows/main.yml)\n[![Total alerts](https://img.shields.io/lgtm/alerts/g/lmmentel/mendeleev.svg?logo=lgtm&logoWidth=18)](https://lgtm.com/projects/g/lmmentel/mendeleev/alerts/)\n[![Language grade: Python](https://img.shields.io/lgtm/grade/python/g/lmmentel/mendeleev.svg?logo=lgtm&logoWidth=18)](https://lgtm.com/projects/g/lmmentel/mendeleev/context:python)\n[![image](https://pepy.tech/badge/mendeleev)](https://pepy.tech/project/mendeleev)\n[![DOI](https://zenodo.org/badge/204296088.svg)](https://zenodo.org/badge/latestdoi/204296088)\n\n\n<!-- PROJECT LOGO -->\n<br />\n<p align="center">\n  <a href="https://github.com/lmmentel/mendeleev">\n    <img src="docs/source/_static/img/name_and_logo.png" alt="Logo" width="300">\n  </a>\n\n  <h3 align="center">Pythonic periodic table of elements</h3>\n\n  <p align="center">\n    A package with a convenient python API for accessing various properties\nof elements, ions and isotopes in the periodic table of elements.\n    <br />\n    <br />\n    <a href="https://github.com/lmmentel/mendeleev/issues">Report Bug</a>\n    ·\n    <a href="https://github.com/lmmentel/mendeleev/issues">Request Feature</a>\n    ·\n    <a href="https://github.com/lmmentel/mendeleev/pulls">Submit a Pull Request</a>\n  </p>\n</p>\n\n\n<!-- TABLE OF CONTENTS -->\n## Table of Contents\n\n- [Table of Contents](#table-of-contents)\n- [About the project](#about-the-project)\n  - [Interactive web app](#interactive-web-app)\n- [Installation](#installation)\n- [Documentation](#documentation)\n- [Data](#data)\n  - [Basic properties](#basic-properties)\n  - [Standardized colors schemes](#standardized-colors-schemes)\n  - [Size related properties](#size-related-properties)\n  - [Electronegativity scales](#electronegativity-scales)\n  - [Descriptive properties](#descriptive-properties)\n  - [Physical properties](#physical-properties)\n  - [Computed properties](#computed-properties)\n  - [Isotope properties](#isotope-properties)\n- [Getting started](#getting-started)\n  - [Lists of elements](#lists-of-elements)\n    - [Isotopes](#isotopes)\n  - [Accesing data tables and the database](#accesing-data-tables-and-the-database)\n  - [Command line interface utility](#command-line-interface-utility)\n- [Contributing](#contributing)\n  - [Issues](#issues)\n  - [Pull requests](#pull-requests)\n- [License](#license)\n- [Citing](#citing)\n- [Funding](#funding)\n\n---\n\nsource: [https://github.com/lmmentel/mendeleev](https://github.com/lmmentel/mendeleev)\n\n---\n\n<h2> Important! </h2>\n\nVersion 0.5.1 will be the latest version to support Python2.7.\n\n**This package has been migrated from bitbucket.**\n\n**The bitbucket repo is no longer being maintaned and development will\ncontinue at github.**\n\n---\n\n## About the project\n\nThis package provides a convenient python API for accessing various\nproperties of elements, ions and isotopes in the periodic table of\nelements.\n\nMoreover it provides an easy to use interface to\n[pandas](http://pandas.pydata.org/) and convenient visualization\nfunctionality through [bokeh](http://bokeh.pydata.org/en/latest/) that\nenables you to create customized periodic tables displaying various\nproperties.\n\n![peridic_table](docs/source/_static/img/mendeleev_periodic_series.png)\nDjango Extensions is free and always will be. It is development and maintained by developers in an Open Source manner. Any support is welcome. You could help by writing documentation, pull-requests, report issues and/or translations.\niodic trends in the periodic tables. If you want to\nlook at some examples there are a few\n[tutorials](http://mendeleev.readthedocs.io/en/stable/tutorials.html)\navailable as [jupyter notebooks](http://jupyter.org/).\n\n### Interactive web app\n\nIf you would like to explore the data available in\n[mendeleev](http://mendeleev.readthedocs.org) check out the interactive\nweb app at [mendeleev.herokuapp.com](http://mendeleev.herokuapp.com/)\nwhere you can create your own periodic tables and visualize the\nrelations between various properties of elements.\n\n![Periodic table view](docs/source/_static/img/mendeleevapp_periodic.png)\n\n![Correlations view](docs/source/_static/img/mendeleevapp_correlations.png)\n\n## Installation\n\nThe preferred installation method is with\n[conda](https://conda.io/docs/intro.html) and you can install the\npackage from the [my Anaconda channel](https://anaconda.org/lmmentel/mendeleev)\nchannel by\n\n``` {.sourceCode .bash}\nconda install -c lmmentel mendeleev=0.11.0\n```\n\nThe package can also be installed using\n[pip](https://pypi.python.org/pypi/pip)\n\n``` {.sourceCode .bash}\npip install mendeleev\n```\nor [pipenv](https://pipenv.readthedocs.io/en/latest/)\n\n``` {.sourceCode .bash}\npipenv install mendeleev\n```\n\nYou can also install the most recent version from the repository:\n\n``` {.sourceCode .bash}\npip install git+https://github.com/lmmentel/mendeleev.git\n```\n\n## Documentation\n\nFull documentation is hosted on [Read the Docs](http://mendeleev.readthedocs.org/en/latest/).\n\nThere are also tutorials available as [Jupyter](https://jupyter.org/)\nnotebooks on [binder](https://mybinder.org/) where you can explore the examples interactively:\n\n- [Quick start](https://mybinder.org/v2/gh/lmmentel/mendeleev/master?filepath=docs%2Fsource%2Fnotebooks%2Fquick_start.ipynb)\n- [Bulk data access](https://mybinder.org/v2/gh/lmmentel/mendeleev/master?filepath=docs%2Fsource%2Fnotebooks%2Fbulk_data_access.ipynb)\n- [Electronic Configuration](https://mybinder.org/v2/gh/lmmentel/mendeleev/master?filepath=docs%2Fsource%2Fnotebooks%2Felectronic_configuration.ipynb)\n- [Ions](https://mybinder.org/v2/gh/lmmentel/mendeleev/master?filepath=docs%2Fsource%2Fnotebooks%2Fions.ipynb)\n- [Visualizations](https://mybinder.org/v2/gh/lmmentel/mendeleev/master?filepath=docs%2Fsource%2Fnotebooks%2Fvisualizations.ipynb)\n- [Advanced visualizations](https://mybinder.org/v2/gh/lmmentel/mendeleev/master?filepath=docs%2Fsource%2Fnotebooks%2Fadvanced_visualizations.ipynb)\n\n## Data\n\nA comprehensive list of the available data together with appropriate\nreferences are available in the\n[documentation](http://mendeleev.readthedocs.org). Here the most\nimportant entries are listed:\n\n### Basic properties\n\n- atomic number\n- atomic weight\n- block\n- cas\n- electrons\n- electronic configuration\n- group\n- name\n- neutrons\n- period\n- protons\n- series\n- symbol\n\n### Standardized colors schemes\n\n-   cpk\\_color\n-   jmol\\_color\n-   molcas\\_gv\\_color\n\n### Size related properties\n\n-   atomic radius (Slater, Rahm)\n-   covalent radius (Bragg, Cordero, Pyykko)\n-   ionic radius\n-   metallic radius\n-   van der Waals radius (Alvarez, Batsanov, Bondi, Dreiding, MM3, RT,\n    Truhlar, UFF)\n\n### Electronegativity scales\n\n-   Allen\n-   Allred & Rochow\n-   Cottrell & Sutton\n-   Ghosh\n-   Gordy\n-   Li & Xue\n-   Nagle\n-   Martynov & Batsanov\n-   Mulliken\n-   Pauling\n-   Sanderson\n\n### Descriptive properties\n\n-   discoverers\n-   discovery location\n-   dipole year\n-   description\n-   name origin\n-   sources\n-   uses\n\n### Physical properties\n\n-   boiling point\n-   C\\<sub\\>6\\</sub\\>\n-   density\n-   dipole polarizability\n-   electron affinity\n-   evaporation heat\n-   gas basicity\n-   ionization energies\n-   lattice structure\n-   melting point\n-   oxidation states\n-   proton affinity\n-   specific heat\n-   thermal conductivity\n-   nuclear screening constants (Slater & Clementi)\n\n### Computed properties\n\n-   hardness\n-   softness\n-   electrophilicity\n\n### Isotope properties\n\n-   abundance\n-   g\\_factor\n-   half\\_life\n-   radioactivity\n-   mass\n-   mass number\n-   spin\n-   quadrupole\\_moment\n\n## Getting started\n\nThe simplest way of accessing the element data is by importing elements\ndirectly from the [mendeleev]{.title-ref} package by their symbols. For\nexample consider iron (Fe):\n\n    >>> from mendeleev import Fe\n    >>> Fe.name\n    \'Iron\'\n    >>> Fe.atomic_number\n    26\n    >>> Fe.thermal_conductivity\n    80.4\n\nAnother, more flexible way is through the `element` method that returns\nthe `Element` object:\n\n    >>> from mendeleev import element\n\nThe `element` method accepts unique identifiers: atomic number, atomic\nsymbol or element\\\'s name in english. To retrieve the entries on Silicon\nby symbol type\n\n``` {.sourceCode .python}\n>>> si = element(\'Si\')\n>>> si.name\n\'Silicon\'\n```\n\nSimilarly to access the data by atomic number or element names type\n\n``` {.sourceCode .python}\n>>> al = element(13)\n>>> al.name\n\'Aluminium\'\n>>> o = element(\'Oxygen\')\n>>> o.atomic_number\n8\n```\n\n### Lists of elements\n\nThe `element` method also accepts list or tuple of identifiers and then\nreturns a list of `Element` objects\n\n``` {.sourceCode .python}\n>>> c, h, o = element([\'C\', \'Hydrogen\', 8])\n>>> c.name, h.name, o.name\n(\'Carbon\', \'Hydrogen\', \'Oxygen\')\n```\n\n#### Isotopes\n\nThe `isotopes` attribute returns a list of `Isotope` objects with the\nfollowing attributes per isotope\n\n-   `atomic_number`\n-   `mass`\n-   `abundance`\n-   `mass_number`\n\n``` {.sourceCode .python}\n>>> fe = element(\'Fe\')\n>>> for iso in fe.isotopes:\n...     print(iso)\n 26   55.93494  91.75%    56\n 26   56.93540   2.12%    57\n 26   57.93328   0.28%    58\n 26   53.93961   5.85%    54\n```\n\nThe columns represent the attributes `atomic_number`, `mass`,\n`abundance` and `mass_number` respectively.\n\n### Accesing data tables and the database\n\n[mendeleev](http://mendeleev.readthedocs.org) offers also methods for\naccessing whole tables of data, e.g. table with the data on all isotopes\nand methods for interacting directly with the database engine, for more\ndetails see the [API\ndocumentation](https://mendeleev.readthedocs.io/en/stable/code.html#accessing-data)\nand [this\ntutorial](https://mendeleev.readthedocs.io/en/stable/notebooks/02_tables.html).\n\n### Command line interface utility\n\nFor those who work in the terminal there is a simple command line\ninterface (CLI) for printing the information about a given element. The\nscript name is [element.py]{.title-ref} and it accepts either the symbol\nor name of the element or it\\\'s atomic number as an argument and prints\nthe data about it. For example, to print the properties of silicon type\n\n``` {.sourceCode .bash}\n$ element.py Si\n                            _  _  _  _      _\n                          _(_)(_)(_)(_)_   (_)\n                         (_)          (_)_  _\n                         (_)_  _  _  _  (_)(_)\n                           (_)(_)(_)(_)_   (_)\n                          _           (_)  (_)\n                         (_)_  _  _  _(_)_ (_) _\n                           (_)(_)(_)(_) (_)(_)(_)\n\n\n\nDescription\n===========\n\n  Metalloid element belonging to group 14 of the periodic table. It is\n  the second most abundant element in the Earth\'s crust, making up 25.7%\n  of it by weight. Chemically less reactive than carbon. First\n  identified by Lavoisier in 1787 and first isolated in 1823 by\n  Berzelius.\n\nSources\n=======\n\n  Makes up major portion of clay, granite, quartz (SiO2), and sand.\n  Commercial production depends on a reaction between sand (SiO2) and\n  carbon at a temperature of around 2200 °C.\n\nUses\n====\n\n  Used in glass as silicon dioxide (SiO2). Silicon carbide (SiC) is one\n  of the hardest substances known and used in polishing. Also the\n  crystalline form is used in semiconductors.\n\nProperties\n==========\n\nAbundance crust                                         282000\nAbundance sea                                              2.2\nAnnotation\nAtomic number                                               14\nAtomic radius                                              132\nAtomic radius rahm                                         232\nAtomic volume                                             12.1\nAtomic weight                                           28.085\nAtomic weight uncertainty                                  NaN\nBlock                                                        p\nBoiling point                                             2628\nC6                                                         305\nC6 gb                                                      308\nCas                                                  7440-21-3\nCovalent radius bragg                                      117\nCovalent radius cordero                                    111\nCovalent radius pyykko                                     116\nCovalent radius pyykko double                              107\nCovalent radius pyykko triple                              102\nCovalent radius slater                                     110\nCpk color                                              #daa520\nDensity                                                   2.33\nDipole polarizability                                    37.31\nDiscoverers                                     Jöns Berzelius\nDiscovery location                                      Sweden\nDiscovery year                                            1824\nElectron affinity                                      1.38952\nElectronic configuration                          [Ne] 3s2 3p2\nEn allen                                                 11.33\nEn ghosh                                              0.178503\nEn pauling                                                 1.9\nEvaporation heat                                           383\nFusion heat                                               50.6\nGas basicity                                             814.1\nGeochemical class                                        major\nGoldschmidt class                                    litophile\nGroup id                                                    14\nHeat of formation                                          450\nIs monoisotopic                                           None\nIs radioactive                                           False\nJmol color                                             #f0c8a0\nLattice constant                                          5.43\nLattice structure                                          DIA\nMelting point                                             1683\nMetallic radius                                            117\nMetallic radius c12                                        138\nMolcas gv color                                        #f0c8a0\nName                                                   Silicon\nName origin                    Latin: silex, silicus, (flint).\nPeriod                                                       3\nProton affinity                                            837\nSeries id                                                    5\nSpecific heat                                            0.703\nSymbol                                                      Si\nThermal conductivity                                       149\nVdw radius                                                 210\nVdw radius alvarez                                         219\nVdw radius batsanov                                        210\nVdw radius bondi                                           210\nVdw radius dreiding                                        427\nVdw radius mm3                                             229\nVdw radius rt                                              NaN\nVdw radius truhlar                                         NaN\nVdw radius uff                                           429.5\n```\n\n## Contributing\n\n`mendeleev` is free and always will be. It is developed and maintained by developers in an Open Source manner.\n**Any contributions are welcome**. You could help by writing documentation, pull-requests, report issues or suggesting new features.\n\n### [Issues](https://github.com/lmmentel/mendeleev/issues)\n\nFeel free to submit [issues](https://github.com/lmmentel/mendeleev/issues) regarding:\n\n-   data updates and recommendations\n-   enhancement requests and new useful features\n-   code bugs\n-   data or citation inconsistencies or errors\n\n### [Pull requests](https://github.com/lmmentel/mendeleev/pulls)\n\n-   before stating to work on your pull request please [submit an\n    issue](https://github.com/lmmentel/mendeleev/issues) first\n-   fork the repo on [github](https://github.com/lmmentel/mendeleev)\n-   clone the project to your own machine\n-   commit changes to your own branch\n-   push your work back up to your fork\n-   submit a [pull request](https://github.com/lmmentel/mendeleev/pulls)\n    so that your changes can be reviewed\n\n## License\n\nThe packegs is release under the persmissive MIT license, see [LICENSE](https://github.com/lmmentel/mendeleev/blob/master/LICENSE)\n\n## Citing\n\nIf you use [mendeleev](http://mendeleev.readthedocs.org) in a scientific\npublication, please consider citing the software as\n\n| \xa0\xa0\xa0L. M. Mentel, *mendeleev* - A Python resource for properties of\n  chemical elements, ions and isotopes. , 2014\\-- . Available at:\n  <https://github.com/lmmentel/mendeleev>.\n\nHere\\\'s the reference in the\n[BibLaTeX](https://www.ctan.org/pkg/biblatex?lang=en) format\n\n``` {.sourceCode .latex}\n@software{mendeleev2014,\n   author = {Mentel, Łukasz},\n   title = {{mendeleev} -- A Python resource for properties of chemical elements, ions and isotopes},\n   url = {https://github.com/lmmentel/mendeleev},\n   version = {0.11.0},\n   date = {2014--},\n```\n\n> }\n\nor the older [BibTeX](http://www.bibtex.org/) format\n\n``` {.sourceCode .latex}\n@misc{mendeleev2014,\n   auhor = {Mentel, Łukasz},\n   title = {mendeleev} -- A Python resource for properties of chemical elements, ions and isotopes, ver. 0.11.0},\n   howpublished = {\\url{https://github.com/lmmentel/mendeleev}},\n   year  = {2014--},\n}\n```\n\n## Funding\n\nThis project was supported by the RCN (The Research Council of Norway)\nproject number 239193.\n',
    'author': 'Lukasz Mentel',
    'author_email': 'lmmentel@gmail.com',
    'maintainer': 'Lukasz Mentel',
    'maintainer_email': 'lmmentel@gmail.com',
    'url': 'https://github.com/lmmentel/mendeleev',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'python_requires': '>=3.7.1,<3.11',
}


setup(**setup_kwargs)
