/*
 * Decompiled with CFR 0.152.
 */
package org.kie.util.maven.support;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.StringReader;
import java.util.Properties;
import org.kie.api.builder.ReleaseId;
import org.kie.util.maven.support.PomModel;

public class ReleaseIdImpl
implements ReleaseId,
Externalizable {
    private static final String PROJECT_VERSION_MAVEN_PROPERTY = "${project.version}";
    private static final String PARENT_VERSION_MAVEN_PROPERTY = "${project.parent.version}";
    private String groupId;
    private String artifactId;
    private String version;
    private String type;
    private String snapshotVersion;

    public ReleaseIdImpl() {
    }

    public ReleaseIdImpl(String releaseId) {
        String[] split = releaseId.split(":");
        this.groupId = split[0];
        this.artifactId = split[1];
        this.version = split[2];
    }

    public ReleaseIdImpl(String groupId, String artifactId, String version) {
        this(groupId, artifactId, version, "jar");
    }

    public ReleaseIdImpl(String groupId, String artifactId, String version, String type) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.type = type;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public String getArtifactId() {
        return this.artifactId;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getType() {
        return this.type;
    }

    public String toString() {
        return this.type == null || this.type.equals("jar") ? this.groupId + ":" + this.artifactId + ":" + this.version : this.groupId + ":" + this.artifactId + ":" + this.type + ":" + this.version;
    }

    @Override
    public String toExternalForm() {
        return this.toString();
    }

    public String getPomXmlPath() {
        return ReleaseIdImpl.getPomXmlPath(this);
    }

    public String getPomPropertiesPath() {
        return ReleaseIdImpl.getPomPropertiesPath(this);
    }

    public static String getPomXmlPath(ReleaseId releaseId) {
        return "META-INF/maven/" + releaseId.getGroupId() + "/" + releaseId.getArtifactId() + "/pom.xml";
    }

    public static String getPomPropertiesPath(ReleaseId releaseId) {
        return "META-INF/maven/" + releaseId.getGroupId() + "/" + releaseId.getArtifactId() + "/pom.properties";
    }

    public static ReleaseIdImpl fromPropertiesString(String path) {
        Properties props = new Properties();
        try {
            props.load(new StringReader(path));
            return ReleaseIdImpl.getReleaseIdFromProperties(props, path);
        }
        catch (IOException e) {
            throw new RuntimeException("pom.properties was malformed\n" + path, e);
        }
    }

    public static ReleaseId fromPropertiesStream(InputStream stream, String path) {
        Properties props = new Properties();
        try {
            props.load(stream);
            return ReleaseIdImpl.getReleaseIdFromProperties(props, path);
        }
        catch (IOException e) {
            throw new RuntimeException("pom.properties was malformed\n" + path, e);
        }
    }

    private static ReleaseIdImpl getReleaseIdFromProperties(Properties props, String path) {
        String groupId = props.getProperty("groupId");
        String artifactId = props.getProperty("artifactId");
        String version = props.getProperty("version");
        if (ReleaseIdImpl.isEmpty(groupId) || ReleaseIdImpl.isEmpty(artifactId) || ReleaseIdImpl.isEmpty(version)) {
            throw new RuntimeException("pom.properties exists but ReleaseId content is malformed\n" + path);
        }
        return new ReleaseIdImpl(groupId, artifactId, version);
    }

    public String getCompilationCachePathPrefix() {
        return "META-INF/";
    }

    @Override
    public boolean isSnapshot() {
        return this.version.endsWith("-SNAPSHOT");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ReleaseIdImpl)) {
            return false;
        }
        ReleaseIdImpl that = (ReleaseIdImpl)o;
        return this.equalsIgnoreNull(this.artifactId, that.artifactId) && this.equalsIgnoreNull(this.groupId, that.groupId) && this.equalsIgnoreNull(this.version, that.version) && this.equalsIgnoreNull(this.type, that.type);
    }

    private boolean equalsIgnoreNull(Object o1, Object o2) {
        return o1 != null ? o1.equals(o2) : o2 == null;
    }

    public int hashCode() {
        int result = this.groupId != null ? this.groupId.hashCode() : 0;
        result = 29 * result + (this.artifactId != null ? this.artifactId.hashCode() : 0);
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        result = 37 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }

    public String getSnapshotVersion() {
        return this.snapshotVersion;
    }

    public void setSnapshotVersion(String snapshotVersion) {
        this.snapshotVersion = snapshotVersion;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.groupId);
        out.writeObject(this.artifactId);
        out.writeObject(this.version);
        out.writeObject(this.type);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.groupId = (String)in.readObject();
        this.artifactId = (String)in.readObject();
        this.version = (String)in.readObject();
        this.type = (String)in.readObject();
    }

    protected static boolean isEmpty(CharSequence str) {
        if (str == null || str.length() == 0) {
            return true;
        }
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String resolveVersion(String versionString, PomModel projectPomModel) {
        if (projectPomModel != null) {
            if (PROJECT_VERSION_MAVEN_PROPERTY.equals(versionString)) {
                return projectPomModel.getReleaseId().getVersion();
            }
            if (PARENT_VERSION_MAVEN_PROPERTY.equals(versionString) && projectPomModel.getParentReleaseId() != null) {
                return projectPomModel.getParentReleaseId().getVersion();
            }
            return versionString;
        }
        return versionString;
    }
}

