/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.constraints;

import java.io.Serializable;
import java.util.Collection;
import java.util.Objects;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.reteoo.SubnetworkTuple;
import org.drools.core.reteoo.Tuple;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.accessor.Accumulator;
import org.drools.modelcompiler.constraints.BindingEvaluator;
import org.kie.api.runtime.rule.AccumulateFunction;

public abstract class LambdaAccumulator
implements Accumulator {
    private final AccumulateFunction accumulateFunction;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LambdaAccumulator that = (LambdaAccumulator)o;
        return Objects.equals(this.accumulateFunction, that.accumulateFunction);
    }

    public int hashCode() {
        return Objects.hash(this.accumulateFunction);
    }

    protected LambdaAccumulator(AccumulateFunction accumulateFunction) {
        this.accumulateFunction = accumulateFunction;
    }

    @Override
    public Object createWorkingMemoryContext() {
        return null;
    }

    @Override
    public Object createContext() {
        return this.accumulateFunction.createContext();
    }

    @Override
    public Object init(Object workingMemoryContext, Object context, Tuple leftTuple, Declaration[] declarations, ReteEvaluator reteEvaluator) {
        context = this.accumulateFunction.initContext((Serializable)context);
        return context;
    }

    @Override
    public Object accumulate(Object workingMemoryContext, Object context, Tuple leftTuple, InternalFactHandle handle, Declaration[] declarations, Declaration[] innerDeclarations, ReteEvaluator reteEvaluator) {
        Object accumulatedObject = this.getAccumulatedObject(declarations, innerDeclarations, handle, leftTuple, reteEvaluator);
        return this.accumulateFunction.accumulateValue((Serializable)context, accumulatedObject);
    }

    protected abstract Object getAccumulatedObject(Declaration[] var1, Declaration[] var2, InternalFactHandle var3, Tuple var4, ReteEvaluator var5);

    @Override
    public boolean supportsReverse() {
        return this.accumulateFunction.supportsReverse();
    }

    @Override
    public boolean tryReverse(Object workingMemoryContext, Object context, Tuple leftTuple, InternalFactHandle handle, Object value, Declaration[] declarations, Declaration[] innerDeclarations, ReteEvaluator reteEvaluator) {
        if (value == null) {
            throw new IllegalStateException("Reversing a not existing accumulated object for fact " + handle);
        }
        return this.accumulateFunction.tryReverse((Serializable)context, value);
    }

    @Override
    public Object getResult(Object workingMemoryContext, Object context, Tuple leftTuple, Declaration[] declarations, ReteEvaluator reteEvaluator) {
        try {
            return this.accumulateFunction.getResult((Serializable)context);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static class FixedValueAcc
    extends LambdaAccumulator {
        private final Object value;

        public FixedValueAcc(AccumulateFunction accumulateFunction, Object value) {
            super(accumulateFunction);
            this.value = value;
        }

        @Override
        protected Object getAccumulatedObject(Declaration[] declarations, Declaration[] innerDeclarations, InternalFactHandle handle, Tuple tuple, ReteEvaluator reteEvaluator) {
            return this.value;
        }
    }

    public static class NotBindingAcc
    extends LambdaAccumulator {
        public NotBindingAcc(AccumulateFunction accumulateFunction) {
            super(accumulateFunction);
        }

        @Override
        protected Object getAccumulatedObject(Declaration[] declarations, Declaration[] innerDeclarations, InternalFactHandle handle, Tuple tuple, ReteEvaluator reteEvaluator) {
            Object accumulateObject = handle.getObject();
            if (accumulateObject instanceof SubnetworkTuple && declarations.length > 0) {
                return declarations[0].getValue((SubnetworkTuple)accumulateObject);
            }
            return accumulateObject;
        }
    }

    public static class BindingAcc
    extends LambdaAccumulator {
        private final BindingEvaluator binding;
        private final Collection<String> sourceVariables;

        public BindingAcc(AccumulateFunction accumulateFunction, Collection<String> sourceVariables, BindingEvaluator binding) {
            super(accumulateFunction);
            this.binding = binding;
            this.sourceVariables = sourceVariables;
        }

        @Override
        protected Object getAccumulatedObject(Declaration[] declarations, Declaration[] innerDeclarations, InternalFactHandle handle, Tuple tuple, ReteEvaluator reteEvaluator) {
            Object accumulateObject = handle.getObject();
            if (accumulateObject instanceof SubnetworkTuple) {
                Object[] args;
                Declaration[] bindingDeclarations = this.binding.getDeclarations();
                if (bindingDeclarations == null || bindingDeclarations.length == 0) {
                    args = new Object[this.sourceVariables.size()];
                    int i = 0;
                    for (String sourceVariable : this.sourceVariables) {
                        for (Declaration d : innerDeclarations) {
                            if (!d.getIdentifier().equals(sourceVariable)) continue;
                            args[i] = d.getValue((SubnetworkTuple)accumulateObject);
                            break;
                        }
                        ++i;
                    }
                } else {
                    args = new Object[bindingDeclarations.length];
                    for (int i = 0; i < bindingDeclarations.length; ++i) {
                        args[i] = bindingDeclarations[i].getValue((SubnetworkTuple)accumulateObject);
                    }
                }
                return this.binding.evaluate(args);
            }
            return this.binding.evaluate(handle, tuple, reteEvaluator, declarations, innerDeclarations);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            BindingAcc that = (BindingAcc)o;
            return Objects.equals(this.sourceVariables, that.sourceVariables);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.sourceVariables);
        }
    }
}

