/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.constraints;

import java.util.ArrayList;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.reteoo.Tuple;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.Pattern;
import org.drools.core.time.Interval;
import org.drools.model.BitMask;
import org.drools.model.Index;
import org.drools.model.SingleConstraint;
import org.drools.model.functions.Predicate1;
import org.drools.model.functions.Predicate2;
import org.drools.model.functions.Predicate3;
import org.drools.model.functions.Predicate4;
import org.drools.model.functions.Predicate5;
import org.drools.model.functions.PredicateN;
import org.drools.modelcompiler.constraints.BindingEvaluator;

public class ConstraintEvaluator {
    protected final SingleConstraint constraint;
    protected final Declaration[] declarations;
    private Declaration[] requiredDeclarations;
    private final Pattern pattern;
    private final InnerEvaluator innerEvaluator;

    public ConstraintEvaluator(Declaration[] declarations, SingleConstraint constraint) {
        this.constraint = constraint;
        this.pattern = null;
        this.declarations = declarations;
        this.requiredDeclarations = declarations;
        this.innerEvaluator = this.initInnerEvaluator(null);
    }

    public ConstraintEvaluator(Pattern pattern, SingleConstraint constraint) {
        this.constraint = constraint;
        this.pattern = pattern;
        this.declarations = new Declaration[]{pattern.getDeclaration()};
        this.requiredDeclarations = new Declaration[0];
        this.innerEvaluator = this.initInnerEvaluator(this.findPatternDeclaration());
    }

    public ConstraintEvaluator(Declaration[] declarations, Pattern pattern, SingleConstraint constraint) {
        this.constraint = constraint;
        this.declarations = declarations;
        this.pattern = pattern;
        this.innerEvaluator = this.initInnerEvaluator(this.findPatternAndRequiredDeclaration());
    }

    public SingleConstraint getConstraint() {
        return this.constraint;
    }

    private InnerEvaluator initInnerEvaluator(Declaration patternDeclaration) {
        if (this.isTemporal()) {
            this.setPatternDeclaration(patternDeclaration);
            return null;
        }
        switch (this.declarations.length) {
            case 1: {
                return this.declarations[0].isInternalFact() ? new InnerEvaluator._1(patternDeclaration, this.declarations[0], this.constraint.getPredicate1()) : new InnerEvaluator._1_FH(patternDeclaration, this.declarations[0], this.constraint.getPredicate1());
            }
            case 2: {
                return new InnerEvaluator._2(patternDeclaration, this.declarations[0], this.declarations[1], this.constraint.getPredicate2());
            }
            case 3: {
                return new InnerEvaluator._3(patternDeclaration, this.declarations[0], this.declarations[1], this.declarations[2], this.constraint.getPredicate3());
            }
            case 4: {
                return new InnerEvaluator._4(patternDeclaration, this.declarations[0], this.declarations[1], this.declarations[2], this.declarations[3], this.constraint.getPredicate4());
            }
            case 5: {
                return new InnerEvaluator._5(patternDeclaration, this.declarations[0], this.declarations[1], this.declarations[2], this.declarations[3], this.declarations[4], this.constraint.getPredicate5());
            }
        }
        return new InnerEvaluator._N(patternDeclaration, this.declarations, this.constraint.getPredicate());
    }

    private Declaration findPatternDeclaration() {
        for (int i = 0; i < this.declarations.length; ++i) {
            if (!this.pattern.getDeclaration().getIdentifier().equals(this.declarations[i].getIdentifier())) continue;
            return this.declarations[i];
        }
        return null;
    }

    private Declaration findPatternAndRequiredDeclaration() {
        Declaration patternDeclaration = null;
        ArrayList<Declaration> requiredDeclarationsList = new ArrayList<Declaration>();
        for (int i = 0; i < this.declarations.length; ++i) {
            if (this.pattern.getDeclaration() != null && this.pattern.getDeclaration().getIdentifier().equals(this.declarations[i].getIdentifier())) {
                patternDeclaration = this.declarations[i];
                continue;
            }
            requiredDeclarationsList.add(this.declarations[i]);
        }
        this.requiredDeclarations = requiredDeclarationsList.toArray(new Declaration[requiredDeclarationsList.size()]);
        return patternDeclaration;
    }

    public boolean evaluate(InternalFactHandle handle, ReteEvaluator reteEvaluator) {
        try {
            return this.innerEvaluator.evaluate(handle, reteEvaluator);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean evaluate(InternalFactHandle handle, Tuple tuple, ReteEvaluator reteEvaluator) {
        try {
            return this.innerEvaluator.evaluate(handle, tuple, reteEvaluator);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Index getIndex() {
        return this.constraint.getIndex();
    }

    public String[] getReactiveProps() {
        return this.constraint.getReactiveProps();
    }

    public BitMask getReactivityBitMask() {
        return this.constraint.getReactivityBitMask();
    }

    public String toString() {
        return this.constraint.toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ConstraintEvaluator otherEval = (ConstraintEvaluator)other;
        if (!this.getId().equals(otherEval.getId())) {
            return false;
        }
        if (this.declarations.length != otherEval.declarations.length) {
            return false;
        }
        for (int i = 0; i < this.declarations.length; ++i) {
            if (this.declarations[i].getExtractor().equals(otherEval.declarations[i].getExtractor())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String getId() {
        return this.constraint.getExprId();
    }

    public Declaration[] getRequiredDeclarations() {
        return this.requiredDeclarations;
    }

    public void replaceDeclaration(Declaration oldDecl, Declaration newDecl) {
        for (int i = 0; i < this.declarations.length; ++i) {
            if (!this.declarations[i].equals(oldDecl)) continue;
            this.declarations[i] = newDecl;
            switch (i) {
                case 0: {
                    if (this.innerEvaluator instanceof InnerEvaluator._1) {
                        ((InnerEvaluator._1)this.innerEvaluator).declaration = newDecl;
                        break;
                    }
                    if (this.innerEvaluator instanceof InnerEvaluator._1_FH) {
                        ((InnerEvaluator._1_FH)this.innerEvaluator).declaration = newDecl;
                        break;
                    }
                    if (this.innerEvaluator instanceof InnerEvaluator._2) {
                        ((InnerEvaluator._2)this.innerEvaluator).declaration1 = newDecl;
                        break;
                    }
                    if (this.innerEvaluator instanceof InnerEvaluator._3) {
                        ((InnerEvaluator._3)this.innerEvaluator).declaration1 = newDecl;
                        break;
                    }
                    if (this.innerEvaluator instanceof InnerEvaluator._4) {
                        ((InnerEvaluator._4)this.innerEvaluator).declaration1 = newDecl;
                        break;
                    }
                    if (!(this.innerEvaluator instanceof InnerEvaluator._5)) break;
                    ((InnerEvaluator._5)this.innerEvaluator).declaration1 = newDecl;
                    break;
                }
                case 1: {
                    if (this.innerEvaluator instanceof InnerEvaluator._2) {
                        ((InnerEvaluator._2)this.innerEvaluator).declaration2 = newDecl;
                        break;
                    }
                    if (this.innerEvaluator instanceof InnerEvaluator._3) {
                        ((InnerEvaluator._3)this.innerEvaluator).declaration2 = newDecl;
                        break;
                    }
                    if (this.innerEvaluator instanceof InnerEvaluator._4) {
                        ((InnerEvaluator._4)this.innerEvaluator).declaration2 = newDecl;
                        break;
                    }
                    if (!(this.innerEvaluator instanceof InnerEvaluator._5)) break;
                    ((InnerEvaluator._5)this.innerEvaluator).declaration2 = newDecl;
                    break;
                }
                case 2: {
                    if (this.innerEvaluator instanceof InnerEvaluator._3) {
                        ((InnerEvaluator._3)this.innerEvaluator).declaration3 = newDecl;
                        break;
                    }
                    if (this.innerEvaluator instanceof InnerEvaluator._4) {
                        ((InnerEvaluator._4)this.innerEvaluator).declaration3 = newDecl;
                        break;
                    }
                    if (!(this.innerEvaluator instanceof InnerEvaluator._5)) break;
                    ((InnerEvaluator._5)this.innerEvaluator).declaration3 = newDecl;
                    break;
                }
                case 3: {
                    if (this.innerEvaluator instanceof InnerEvaluator._4) {
                        ((InnerEvaluator._4)this.innerEvaluator).declaration4 = newDecl;
                        break;
                    }
                    if (!(this.innerEvaluator instanceof InnerEvaluator._5)) break;
                    ((InnerEvaluator._5)this.innerEvaluator).declaration4 = newDecl;
                    break;
                }
                case 4: {
                    if (!(this.innerEvaluator instanceof InnerEvaluator._5)) break;
                    ((InnerEvaluator._5)this.innerEvaluator).declaration5 = newDecl;
                }
            }
            break;
        }
    }

    public ConstraintEvaluator clone() {
        return this.pattern == null ? new ConstraintEvaluator(this.getClonedDeclarations(), this.constraint) : new ConstraintEvaluator(this.getClonedDeclarations(), this.pattern, this.constraint);
    }

    protected Declaration[] getClonedDeclarations() {
        Declaration[] clonedDeclarations = new Declaration[this.declarations.length];
        for (int i = 0; i < this.declarations.length; ++i) {
            clonedDeclarations[i] = this.declarations[i].clone();
        }
        return clonedDeclarations;
    }

    protected Declaration[] getDeclarations() {
        return this.declarations;
    }

    protected Pattern getPattern() {
        return this.pattern;
    }

    public boolean isTemporal() {
        return false;
    }

    public Interval getInterval() {
        throw new UnsupportedOperationException();
    }

    protected void setPatternDeclaration(Declaration patternDeclaration) {
        throw new UnsupportedOperationException();
    }

    static abstract class InnerEvaluator {
        private final Declaration patternDeclaration;

        protected InnerEvaluator(Declaration patternDeclaration) {
            this.patternDeclaration = patternDeclaration;
        }

        public abstract boolean evaluate(InternalFactHandle var1, ReteEvaluator var2) throws Exception;

        public abstract boolean evaluate(InternalFactHandle var1, Tuple var2, ReteEvaluator var3) throws Exception;

        protected Object getArgument(InternalFactHandle handle, ReteEvaluator reteEvaluator, Declaration declaration, Tuple tuple) {
            return declaration == this.patternDeclaration ? handle.getObject() : BindingEvaluator.getArgument(handle, reteEvaluator, declaration, tuple);
        }

        static class _N
        extends InnerEvaluator {
            private final Declaration[] declarations;
            private final PredicateN predicate;

            public _N(Declaration patternDeclaration, Declaration[] declarations, PredicateN predicate) {
                super(patternDeclaration);
                this.declarations = declarations;
                this.predicate = predicate;
            }

            @Override
            public boolean evaluate(InternalFactHandle handle, ReteEvaluator reteEvaluator) throws Exception {
                return this.predicate.test(this.getInvocationArgs(handle, null, reteEvaluator));
            }

            @Override
            public boolean evaluate(InternalFactHandle handle, Tuple tuple, ReteEvaluator reteEvaluator) throws Exception {
                return this.predicate.test(this.getInvocationArgs(handle, tuple, reteEvaluator));
            }

            private Object[] getInvocationArgs(InternalFactHandle handle, Tuple tuple, ReteEvaluator reteEvaluator) {
                Object[] params = new Object[this.declarations.length];
                for (int i = 0; i < this.declarations.length; ++i) {
                    params[i] = this.getArgument(handle, reteEvaluator, this.declarations[i], tuple);
                }
                return params;
            }
        }

        static class _5
        extends InnerEvaluator {
            private Declaration declaration1;
            private Declaration declaration2;
            private Declaration declaration3;
            private Declaration declaration4;
            private Declaration declaration5;
            private final Predicate5 predicate;

            public _5(Declaration patternDeclaration, Declaration declaration1, Declaration declaration2, Declaration declaration3, Declaration declaration4, Declaration declaration5, Predicate5 predicate) {
                super(patternDeclaration);
                this.declaration1 = declaration1;
                this.declaration2 = declaration2;
                this.declaration3 = declaration3;
                this.declaration4 = declaration4;
                this.declaration5 = declaration5;
                this.predicate = predicate;
            }

            @Override
            public boolean evaluate(InternalFactHandle handle, ReteEvaluator reteEvaluator) throws Exception {
                return this.predicate.test(this.getArgument(handle, reteEvaluator, this.declaration1, null), this.getArgument(handle, reteEvaluator, this.declaration2, null), this.getArgument(handle, reteEvaluator, this.declaration3, null), this.getArgument(handle, reteEvaluator, this.declaration4, null), this.getArgument(handle, reteEvaluator, this.declaration5, null));
            }

            @Override
            public boolean evaluate(InternalFactHandle handle, Tuple tuple, ReteEvaluator reteEvaluator) throws Exception {
                return this.predicate.test(this.getArgument(handle, reteEvaluator, this.declaration1, tuple), this.getArgument(handle, reteEvaluator, this.declaration2, tuple), this.getArgument(handle, reteEvaluator, this.declaration3, tuple), this.getArgument(handle, reteEvaluator, this.declaration4, tuple), this.getArgument(handle, reteEvaluator, this.declaration5, tuple));
            }
        }

        static class _4
        extends InnerEvaluator {
            private Declaration declaration1;
            private Declaration declaration2;
            private Declaration declaration3;
            private Declaration declaration4;
            private final Predicate4 predicate;

            public _4(Declaration patternDeclaration, Declaration declaration1, Declaration declaration2, Declaration declaration3, Declaration declaration4, Predicate4 predicate) {
                super(patternDeclaration);
                this.declaration1 = declaration1;
                this.declaration2 = declaration2;
                this.declaration3 = declaration3;
                this.declaration4 = declaration4;
                this.predicate = predicate;
            }

            @Override
            public boolean evaluate(InternalFactHandle handle, ReteEvaluator reteEvaluator) throws Exception {
                return this.predicate.test(this.getArgument(handle, reteEvaluator, this.declaration1, null), this.getArgument(handle, reteEvaluator, this.declaration2, null), this.getArgument(handle, reteEvaluator, this.declaration3, null), this.getArgument(handle, reteEvaluator, this.declaration4, null));
            }

            @Override
            public boolean evaluate(InternalFactHandle handle, Tuple tuple, ReteEvaluator reteEvaluator) throws Exception {
                return this.predicate.test(this.getArgument(handle, reteEvaluator, this.declaration1, tuple), this.getArgument(handle, reteEvaluator, this.declaration2, tuple), this.getArgument(handle, reteEvaluator, this.declaration3, tuple), this.getArgument(handle, reteEvaluator, this.declaration4, tuple));
            }
        }

        static class _3
        extends InnerEvaluator {
            private Declaration declaration1;
            private Declaration declaration2;
            private Declaration declaration3;
            private final Predicate3 predicate;

            public _3(Declaration patternDeclaration, Declaration declaration1, Declaration declaration2, Declaration declaration3, Predicate3 predicate) {
                super(patternDeclaration);
                this.declaration1 = declaration1;
                this.declaration2 = declaration2;
                this.declaration3 = declaration3;
                this.predicate = predicate;
            }

            @Override
            public boolean evaluate(InternalFactHandle handle, ReteEvaluator reteEvaluator) throws Exception {
                return this.predicate.test(this.getArgument(handle, reteEvaluator, this.declaration1, null), this.getArgument(handle, reteEvaluator, this.declaration2, null), this.getArgument(handle, reteEvaluator, this.declaration3, null));
            }

            @Override
            public boolean evaluate(InternalFactHandle handle, Tuple tuple, ReteEvaluator reteEvaluator) throws Exception {
                return this.predicate.test(this.getArgument(handle, reteEvaluator, this.declaration1, tuple), this.getArgument(handle, reteEvaluator, this.declaration2, tuple), this.getArgument(handle, reteEvaluator, this.declaration3, tuple));
            }
        }

        static class _2
        extends InnerEvaluator {
            private Declaration declaration1;
            private Declaration declaration2;
            private final Predicate2 predicate;

            public _2(Declaration patternDeclaration, Declaration declaration1, Declaration declaration2, Predicate2 predicate) {
                super(patternDeclaration);
                this.declaration1 = declaration1;
                this.declaration2 = declaration2;
                this.predicate = predicate;
            }

            @Override
            public boolean evaluate(InternalFactHandle handle, ReteEvaluator reteEvaluator) throws Exception {
                return this.predicate.test(this.getArgument(handle, reteEvaluator, this.declaration1, null), this.getArgument(handle, reteEvaluator, this.declaration2, null));
            }

            @Override
            public boolean evaluate(InternalFactHandle handle, Tuple tuple, ReteEvaluator reteEvaluator) throws Exception {
                return this.predicate.test(this.getArgument(handle, reteEvaluator, this.declaration1, tuple), this.getArgument(handle, reteEvaluator, this.declaration2, tuple));
            }
        }

        static class _1_FH
        extends InnerEvaluator {
            private Declaration declaration;
            private final Predicate1 predicate;

            public _1_FH(Declaration patternDeclaration, Declaration declaration, Predicate1 predicate) {
                super(patternDeclaration);
                this.declaration = declaration;
                this.predicate = predicate;
            }

            @Override
            public boolean evaluate(InternalFactHandle handle, ReteEvaluator reteEvaluator) throws Exception {
                return this.predicate.test(handle.getObject());
            }

            @Override
            public boolean evaluate(InternalFactHandle handle, Tuple tuple, ReteEvaluator reteEvaluator) throws Exception {
                return this.predicate.test(this.getArgument(handle, reteEvaluator, this.declaration, tuple));
            }
        }

        static class _1
        extends InnerEvaluator {
            private Declaration declaration;
            private final Predicate1 predicate;

            public _1(Declaration patternDeclaration, Declaration declaration, Predicate1 predicate) {
                super(patternDeclaration);
                this.declaration = declaration;
                this.predicate = predicate;
            }

            @Override
            public boolean evaluate(InternalFactHandle handle, ReteEvaluator reteEvaluator) throws Exception {
                return this.predicate.test(this.declaration.getValue(reteEvaluator, handle));
            }

            @Override
            public boolean evaluate(InternalFactHandle handle, Tuple tuple, ReteEvaluator reteEvaluator) throws Exception {
                return this.predicate.test(this.getArgument(handle, reteEvaluator, this.declaration, tuple));
            }
        }
    }
}

