/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.constraints;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.reteoo.Tuple;
import org.drools.core.rule.ContextEntry;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.accessor.FieldValue;
import org.drools.core.rule.accessor.ReadAccessor;
import org.drools.core.time.Interval;
import org.drools.core.util.AbstractHashTable;
import org.drools.core.util.index.IndexUtil;
import org.drools.model.Constraint;
import org.drools.modelcompiler.constraints.AbstractConstraint;
import org.drools.modelcompiler.constraints.LambdaConstraint;

public class CombinedConstraint
extends AbstractConstraint {
    private final Constraint.Type type;
    private final List<AbstractConstraint> constraints;
    private Declaration[] requiredDeclarations;

    public CombinedConstraint(Constraint.Type type, List<AbstractConstraint> constraints) {
        this.type = type;
        this.constraints = constraints;
    }

    @Override
    public boolean isUnification() {
        return false;
    }

    @Override
    public boolean isIndexable(short nodeType, RuleBaseConfiguration config) {
        return false;
    }

    @Override
    public IndexUtil.ConstraintType getConstraintType() {
        return IndexUtil.ConstraintType.UNKNOWN;
    }

    @Override
    public FieldValue getField() {
        return null;
    }

    @Override
    public AbstractHashTable.FieldIndex getFieldIndex() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ReadAccessor getFieldExtractor() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Declaration getIndexExtractor() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Interval getInterval() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Declaration[] getRequiredDeclarations() {
        if (this.requiredDeclarations == null) {
            this.requiredDeclarations = (Declaration[])this.constraints.stream().flatMap(c -> Stream.of(c.getRequiredDeclarations())).distinct().toArray(Declaration[]::new);
        }
        return this.requiredDeclarations;
    }

    @Override
    public void replaceDeclaration(Declaration oldDecl, Declaration newDecl) {
        this.constraints.forEach(c -> c.replaceDeclaration(oldDecl, newDecl));
        this.requiredDeclarations = null;
    }

    @Override
    public AbstractConstraint clone() {
        return new CombinedConstraint(this.type, this.constraints.stream().map(AbstractConstraint::clone).collect(Collectors.toList()));
    }

    @Override
    public boolean isTemporal() {
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.constraints == null ? 0 : this.constraints.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CombinedConstraint other = (CombinedConstraint)obj;
        if (this.constraints == null ? other.constraints != null : !this.constraints.equals(other.constraints)) {
            return false;
        }
        return this.type == other.type;
    }

    @Override
    public boolean isAllowed(InternalFactHandle handle, ReteEvaluator reteEvaluator) {
        return this.type == Constraint.Type.OR ? this.constraints.stream().anyMatch(c -> c.isAllowed(handle, reteEvaluator)) : this.constraints.stream().allMatch(c -> c.isAllowed(handle, reteEvaluator));
    }

    @Override
    public boolean isAllowedCachedLeft(ContextEntry context, InternalFactHandle handle) {
        return this.type == Constraint.Type.OR ? this.constraints.stream().anyMatch(c -> c.isAllowedCachedLeft(context, handle)) : this.constraints.stream().allMatch(c -> c.isAllowedCachedLeft(context, handle));
    }

    @Override
    public boolean isAllowedCachedRight(Tuple tuple, ContextEntry context) {
        return this.type == Constraint.Type.OR ? this.constraints.stream().anyMatch(c -> c.isAllowedCachedRight(tuple, context)) : this.constraints.stream().allMatch(c -> c.isAllowedCachedRight(tuple, context));
    }

    @Override
    public ContextEntry createContextEntry() {
        return new LambdaConstraint.LambdaContextEntry();
    }
}

