/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler;

import java.io.File;
import org.drools.compiler.compiler.io.memory.MemoryFileSystem;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.InternalKieModuleProvider;
import org.drools.modelcompiler.CanonicalKieModule;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieModuleModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CanonicalKieModuleProvider
extends InternalKieModuleProvider.DrlBasedKieModuleProvider
implements InternalKieModuleProvider {
    private static final Logger log = LoggerFactory.getLogger(CanonicalKieModuleProvider.class);

    @Override
    public InternalKieModule createKieModule(ReleaseId releaseId, KieModuleModel kieProject, File file) {
        return this.createCanonicalKieModule(super.createKieModule(releaseId, kieProject, file));
    }

    @Override
    public InternalKieModule createKieModule(ReleaseId releaseId, KieModuleModel kieProject, MemoryFileSystem mfs) {
        return this.createCanonicalKieModule(super.createKieModule(releaseId, kieProject, mfs));
    }

    private InternalKieModule createCanonicalKieModule(InternalKieModule internalKieModule) {
        if (internalKieModule.hasResource(CanonicalKieModule.getModelFileWithGAV(internalKieModule.getReleaseId()))) {
            if (log.isInfoEnabled()) {
                log.info("Artifact " + internalKieModule.getReleaseId() + " has executable model");
            }
            return new CanonicalKieModule(internalKieModule);
        }
        if (log.isInfoEnabled()) {
            log.info("No executable model found for artifact " + internalKieModule.getReleaseId() + ". Falling back to resources parsing.");
        }
        return internalKieModule;
    }
}

