/*
 * Decompiled with CFR 0.152.
 */
package org.drools.kiesession.session;

import java.util.function.Supplier;
import org.drools.core.util.ScalablePool;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.session.StatefulKnowledgeSessionImpl;

public class StatefulSessionPool {
    private final InternalKnowledgeBase kbase;
    private final ScalablePool<StatefulKnowledgeSessionImpl> pool;

    public StatefulSessionPool(InternalKnowledgeBase kbase, int initialSize, Supplier<StatefulKnowledgeSessionImpl> supplier) {
        this.kbase = kbase;
        this.pool = new ScalablePool<StatefulKnowledgeSessionImpl>(initialSize, supplier, s -> s.reset(), s -> s.fromPool(null).dispose());
    }

    public InternalKnowledgeBase getKieBase() {
        return this.kbase;
    }

    public StatefulKnowledgeSessionImpl get() {
        return this.pool.get().fromPool(this);
    }

    public void release(StatefulKnowledgeSessionImpl session) {
        this.pool.release(session);
    }

    public void shutdown() {
        this.pool.shutdown();
    }
}

