/*
 * Decompiled with CFR 0.152.
 */
package org.drools.kiesession.audit;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.drools.core.WorkingMemory;
import org.drools.core.base.XMLSupport;
import org.drools.kiesession.audit.LogEvent;
import org.drools.kiesession.audit.WorkingMemoryLog;
import org.drools.kiesession.audit.WorkingMemoryLogger;
import org.drools.util.IoUtils;
import org.kie.api.event.KieRuntimeEventManager;
import org.kie.api.logger.KieRuntimeLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkingMemoryFileLogger
extends WorkingMemoryLogger
implements KieRuntimeLogger {
    protected static final transient Logger logger = LoggerFactory.getLogger(WorkingMemoryFileLogger.class);
    public static final int DEFAULT_MAX_EVENTS_IN_MEMORY = 1000;
    private List<LogEvent> events = new ArrayList<LogEvent>();
    private String fileName = "event";
    private int maxEventsInMemory = 1000;
    private int nbOfFile = 0;
    private boolean split = true;
    private boolean initialized = false;
    protected boolean terminate = false;

    public WorkingMemoryFileLogger() {
    }

    public WorkingMemoryFileLogger(WorkingMemory workingMemory) {
        super(workingMemory);
    }

    public WorkingMemoryFileLogger(KieRuntimeEventManager session) {
        super(session);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.events = (List)in.readObject();
        this.fileName = (String)in.readObject();
        this.maxEventsInMemory = in.readInt();
        this.nbOfFile = in.readInt();
        this.split = in.readBoolean();
        this.initialized = in.readBoolean();
        this.terminate = in.readBoolean();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.events);
        out.writeObject(this.fileName);
        out.writeInt(this.maxEventsInMemory);
        out.writeInt(this.nbOfFile);
        out.writeBoolean(this.split);
        out.writeBoolean(this.initialized);
        out.writeBoolean(this.terminate);
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToDisk() {
        if (!this.initialized) {
            this.initializeLog();
        }
        try (FileOutputStream fileOut = new FileOutputStream(this.fileName + (String)(this.nbOfFile == 0 ? ".log" : this.nbOfFile + ".log"), true);
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fileOut, IoUtils.UTF8_CHARSET);){
            WorkingMemoryLog log;
            List<LogEvent> list = this.events;
            synchronized (list) {
                log = new WorkingMemoryLog(new ArrayList<LogEvent>(this.events));
                this.clear();
            }
            writer.write(XMLSupport.get().toXml(log) + "\n");
        }
        catch (FileNotFoundException exc) {
            throw new RuntimeException("Could not create the log file.  Please make sure that directory that the log file should be placed in does exist.");
        }
        catch (Throwable t) {
            logger.error("error", t);
        }
        if (this.terminate) {
            this.closeLog();
            this.terminate = true;
        } else if (this.split) {
            this.closeLog();
            ++this.nbOfFile;
            this.initialized = false;
        }
    }

    private void initializeLog() {
        try (FileOutputStream fileOut = new FileOutputStream(this.fileName + (String)(this.nbOfFile == 0 ? ".log" : this.nbOfFile + ".log"), false);
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fileOut, IoUtils.UTF8_CHARSET);){
            ((Writer)writer).append("<object-stream>\n");
            this.initialized = true;
        }
        catch (FileNotFoundException exc) {
            throw new RuntimeException("Could not create the log file.  Please make sure that directory that the log file should be placed in does exist.");
        }
        catch (Throwable t) {
            logger.error("error", t);
        }
    }

    private void closeLog() {
        try (FileOutputStream fileOut = new FileOutputStream(this.fileName + (String)(this.nbOfFile == 0 ? ".log" : this.nbOfFile + ".log"), true);
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fileOut, IoUtils.UTF8_CHARSET);){
            ((Writer)writer).append("</object-stream>\n");
        }
        catch (FileNotFoundException exc) {
            throw new RuntimeException("Could not close the log file.  Please make sure that directory that the log file should be placed in does exist.");
        }
        catch (Throwable t) {
            logger.error("error", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clear() {
        List<LogEvent> list = this.events;
        synchronized (list) {
            this.events.clear();
        }
    }

    public void setMaxEventsInMemory(int maxEventsInMemory) {
        this.maxEventsInMemory = maxEventsInMemory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logEventCreated(LogEvent logEvent) {
        List<LogEvent> list = this.events;
        synchronized (list) {
            this.events.add(logEvent);
            if (this.events.size() > this.maxEventsInMemory) {
                this.writeToDisk();
            }
        }
    }

    public void setSplit(boolean split) {
        this.split = split;
    }

    public void stop() {
        if (!this.terminate) {
            this.terminate = true;
            this.writeToDisk();
        }
    }

    @Override
    public void close() {
        this.stop();
    }
}

