/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.drools.core.ActivationListenerFactory;
import org.drools.core.base.ClassObjectType;
import org.drools.core.common.BaseNode;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.UpdateContext;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.impl.RuleBase;
import org.drools.core.phreak.PhreakBuilder;
import org.drools.core.reteoo.PathEndNode;
import org.drools.core.reteoo.RightInputAdapterNode;
import org.drools.core.reteoo.RuleBuilder;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.reteoo.WindowNode;
import org.drools.core.reteoo.builder.AccumulateBuilder;
import org.drools.core.reteoo.builder.AsyncReceiveBuilder;
import org.drools.core.reteoo.builder.AsyncSendBuilder;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.reteoo.builder.BuildUtils;
import org.drools.core.reteoo.builder.CollectBuilder;
import org.drools.core.reteoo.builder.ConditionalBranchBuilder;
import org.drools.core.reteoo.builder.EntryPointBuilder;
import org.drools.core.reteoo.builder.EvalBuilder;
import org.drools.core.reteoo.builder.ForallBuilder;
import org.drools.core.reteoo.builder.FromBuilder;
import org.drools.core.reteoo.builder.GroupElementBuilder;
import org.drools.core.reteoo.builder.NamedConsequenceBuilder;
import org.drools.core.reteoo.builder.PatternBuilder;
import org.drools.core.reteoo.builder.QueryElementBuilder;
import org.drools.core.reteoo.builder.ReactiveFromBuilder;
import org.drools.core.reteoo.builder.ReteooComponentBuilder;
import org.drools.core.reteoo.builder.TimerBuilder;
import org.drools.core.reteoo.builder.WindowBuilder;
import org.drools.core.reteoo.builder.WindowReferenceBuilder;
import org.drools.core.rule.Accumulate;
import org.drools.core.rule.AsyncReceive;
import org.drools.core.rule.AsyncSend;
import org.drools.core.rule.Collect;
import org.drools.core.rule.ConditionalBranch;
import org.drools.core.rule.EntryPointId;
import org.drools.core.rule.EvalCondition;
import org.drools.core.rule.Forall;
import org.drools.core.rule.From;
import org.drools.core.rule.GroupElement;
import org.drools.core.rule.InvalidPatternException;
import org.drools.core.rule.LogicTransformer;
import org.drools.core.rule.NamedConsequence;
import org.drools.core.rule.Pattern;
import org.drools.core.rule.QueryElement;
import org.drools.core.rule.WindowDeclaration;
import org.drools.core.rule.WindowReference;
import org.drools.core.rule.constraint.XpathConstraint;
import org.drools.core.time.TemporalDependencyMatrix;
import org.drools.core.time.impl.Timer;
import org.kie.api.conf.EventProcessingOption;

public class ReteooRuleBuilder
implements RuleBuilder {
    protected BuildUtils utils = new BuildUtils();

    public ReteooRuleBuilder() {
        this.utils.addBuilder(GroupElement.class, new GroupElementBuilder());
        this.utils.addBuilder(Pattern.class, new PatternBuilder());
        this.utils.addBuilder(EvalCondition.class, new EvalBuilder());
        this.utils.addBuilder(QueryElement.class, new QueryElementBuilder());
        this.utils.addBuilder(From.class, new FromBuilder());
        this.utils.addBuilder(Collect.class, new CollectBuilder());
        this.utils.addBuilder(Accumulate.class, new AccumulateBuilder());
        this.utils.addBuilder(Timer.class, new TimerBuilder());
        this.utils.addBuilder(Forall.class, new ForallBuilder());
        this.utils.addBuilder(EntryPointId.class, new EntryPointBuilder());
        this.utils.addBuilder(WindowReference.class, new WindowReferenceBuilder());
        this.utils.addBuilder(NamedConsequence.class, new NamedConsequenceBuilder());
        this.utils.addBuilder(ConditionalBranch.class, new ConditionalBranchBuilder());
        this.utils.addBuilder(XpathConstraint.class, new ReactiveFromBuilder());
        this.utils.addBuilder(AsyncSend.class, new AsyncSendBuilder());
        this.utils.addBuilder(AsyncReceive.class, new AsyncReceiveBuilder());
    }

    @Override
    public List<TerminalNode> addRule(RuleImpl rule, RuleBase kBase, Collection<InternalWorkingMemory> workingMemories) throws InvalidPatternException {
        ArrayList<TerminalNode> termNodes = new ArrayList<TerminalNode>();
        GroupElement[] subrules = rule.getTransformedLhs(LogicTransformer.getInstance(), kBase.getGlobals());
        for (int i = 0; i < subrules.length; ++i) {
            BuildContext context = new BuildContext(kBase, workingMemories);
            context.setRule(rule);
            context.setSubRuleIndex(i);
            if (EventProcessingOption.STREAM.equals(kBase.getConfiguration().getEventProcessingMode())) {
                TemporalDependencyMatrix temporal = this.utils.calculateTemporalDistance(subrules[i]);
                context.setTemporalDistance(temporal);
            }
            if (kBase.getConfiguration().isSequential()) {
                context.setTupleMemoryEnabled(false);
                context.setObjectTypeNodeMemoryEnabled(false);
            } else {
                context.setTupleMemoryEnabled(true);
                context.setObjectTypeNodeMemoryEnabled(true);
            }
            context.setSubRuleIndex(i);
            this.addSubRule(context, subrules[i], rule);
            termNodes.addAll(context.getTerminals());
        }
        return termNodes;
    }

    private void addSubRule(BuildContext context, GroupElement subrule, RuleImpl rule) throws InvalidPatternException {
        context.setSubRule(subrule);
        ReteooComponentBuilder builder = this.utils.getBuilderFor(subrule);
        if (builder.requiresLeftActivation(this.utils, subrule)) {
            this.addInitialFactPattern(subrule);
        }
        builder.build(context, this.utils, subrule);
        TerminalNode terminal = !context.isTerminated() ? ReteooRuleBuilder.buildTerminal(context, subrule, rule, this.utils) : (TerminalNode)((Object)context.getLastNode());
        ReteooRuleBuilder.attachTerminalNode(context, terminal);
    }

    private static TerminalNode buildTerminal(BuildContext context, GroupElement subrule, RuleImpl rule, BuildUtils utils) {
        return ReteooRuleBuilder.buildTerminalNodeForConsequence(context, subrule, context.getSubRuleIndex(), null, rule.getTimer(), utils);
    }

    public static TerminalNode buildTerminalNodeForConsequence(BuildContext context, GroupElement subrule, int subRuleIndex, NamedConsequence namedConsequence, Timer timer, BuildUtils utils) {
        RuleImpl rule = context.getRule();
        if (timer != null) {
            ReteooComponentBuilder builder = utils.getBuilderFor(Timer.class);
            builder.build(context, utils, rule.getTimer());
        }
        ActivationListenerFactory factory = context.getRuleBase().getConfiguration().getActivationListenerFactory(rule.getActivationListener());
        if (namedConsequence != null) {
            context.setConsequenceName(namedConsequence.getConsequenceName());
        }
        TerminalNode terminal = factory.createActivationListener(context.getNextNodeId(), context.getTupleSource(), rule, subrule, subRuleIndex, context, new Object[0]);
        context.setConsequenceName(null);
        context.getNodes().add((BaseNode)((Object)terminal));
        return terminal;
    }

    private static void attachTerminalNode(BuildContext context, TerminalNode terminalNode) {
        context.getTerminals().add(terminalNode);
        context.setTerminated(true);
        BaseNode baseTerminalNode = (BaseNode)((Object)terminalNode);
        context.getNodes().add(baseTerminalNode);
        baseTerminalNode.networkUpdated(new UpdateContext());
        baseTerminalNode.attach(context);
        ReteooRuleBuilder.setPathEndNodes(context, terminalNode);
        PhreakBuilder.get().addRule(terminalNode, context.getWorkingMemories(), context.getRuleBase());
    }

    private static void setPathEndNodes(BuildContext context, TerminalNode terminalNode) {
        PathEndNode[] pathEndNodes = context.getPathEndNodes().toArray(new PathEndNode[context.getPathEndNodes().size()]);
        for (int i = 0; i < pathEndNodes.length; ++i) {
            PathEndNode node;
            pathEndNodes[i] = node = context.getPathEndNodes().get(pathEndNodes.length - 1 - i);
            if (node instanceof RightInputAdapterNode && node.getPathEndNodes() != null) {
                PathEndNode[] riaPathEndNodes = new PathEndNode[node.getPathEndNodes().length + i];
                System.arraycopy(pathEndNodes, 0, riaPathEndNodes, 0, i);
                System.arraycopy(node.getPathEndNodes(), 0, riaPathEndNodes, i, node.getPathEndNodes().length);
                node.setPathEndNodes(riaPathEndNodes);
                continue;
            }
            node.setPathEndNodes(pathEndNodes);
        }
        terminalNode.visitLeftTupleNodes(n -> n.addAssociatedTerminal(terminalNode));
    }

    private void addInitialFactPattern(GroupElement subrule) {
        Pattern pattern = new Pattern(0, ClassObjectType.InitialFact_ObjectType);
        subrule.addChild(0, pattern);
    }

    @Override
    public void addEntryPoint(String id, RuleBase kBase, Collection<InternalWorkingMemory> workingMemories) {
        BuildContext context = new BuildContext(kBase, workingMemories);
        EntryPointId ep = new EntryPointId(id);
        ReteooComponentBuilder builder = this.utils.getBuilderFor(ep);
        builder.build(context, this.utils, ep);
    }

    @Override
    public WindowNode addWindowNode(WindowDeclaration window, RuleBase kBase, Collection<InternalWorkingMemory> workingMemories) {
        BuildContext context = new BuildContext(kBase, workingMemories);
        context.setTupleMemoryEnabled(!kBase.getConfiguration().isSequential());
        context.setObjectTypeNodeMemoryEnabled(!kBase.getConfiguration().isSequential());
        WindowBuilder.INSTANCE.build(context, this.utils, window);
        return (WindowNode)context.getObjectSource();
    }
}

