/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import org.drools.core.base.SalienceInteger;
import org.drools.core.common.AgendaItem;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.PropagationContext;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.phreak.PhreakRuleTerminalNode;
import org.drools.core.phreak.RuleExecutor;
import org.drools.core.reteoo.AbstractTerminalNode;
import org.drools.core.reteoo.AgendaComponentFactory;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RuleTerminalNodeLeftTuple;
import org.drools.core.reteoo.Sink;
import org.drools.core.reteoo.Tuple;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.GroupElement;

public class RuleTerminalNode
extends AbstractTerminalNode {
    private static final long serialVersionUID = 510L;
    protected Declaration[] salienceDeclarations;
    protected Declaration[] enabledDeclarations;
    protected boolean fireDirect;
    protected transient ObjectTypeNode.Id leftInputOtnId;
    protected String consequenceName;

    public RuleTerminalNode() {
    }

    public RuleTerminalNode(int id, LeftTupleSource source, RuleImpl rule, GroupElement subrule, int subruleIndex, BuildContext context) {
        super(id, context.getPartitionId(), context.getRuleBase().getConfiguration().isMultithreadEvaluation(), source, context, rule, subrule, subruleIndex);
        this.setFireDirect(rule.getActivationListener().equals("direct"));
        if (this.isFireDirect()) {
            rule.setSalience(new SalienceInteger(Integer.MAX_VALUE));
        }
        this.setDeclarations(this.getSubRule().getOuterDeclarations());
        this.initInferredMask();
        this.hashcode = this.calculateHashCode();
    }

    public void setDeclarations(Map<String, Declaration> decls) {
        this.setEnabledDeclarations(this.getRule().findEnabledDeclarations(decls));
        this.setSalienceDeclarations(this.getRule().findSalienceDeclarations(decls));
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[RuleTerminalNode(").append(this.getId()).append("): rule=").append(this.getRule().getName());
        if (this.consequenceName != null) {
            sb.append(", consequence=").append(this.consequenceName);
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void doAttach(BuildContext context) {
        super.doAttach(context);
        this.getLeftTupleSource().addTupleSink(this, context);
        this.addAssociation(context, context.getRule());
    }

    @Override
    void initDeclarations(Map<String, Declaration> decls, BuildContext context) {
        this.consequenceName = context.getConsequenceName();
        String[] requiredDeclarationNames = this.getRule().getRequiredDeclarationsForConsequence(this.getConsequenceName());
        this.requiredDeclarations = new Declaration[requiredDeclarationNames.length];
        int i = 0;
        for (String str : requiredDeclarationNames) {
            this.requiredDeclarations[i++] = decls.get(str);
        }
    }

    @Override
    public Declaration[] getSalienceDeclarations() {
        return this.salienceDeclarations;
    }

    public void setSalienceDeclarations(Declaration[] salienceDeclarations) {
        this.salienceDeclarations = salienceDeclarations;
    }

    public Declaration[] getEnabledDeclarations() {
        return this.enabledDeclarations;
    }

    public void setEnabledDeclarations(Declaration[] enabledDeclarations) {
        this.enabledDeclarations = enabledDeclarations;
    }

    public String getConsequenceName() {
        return this.consequenceName == null ? "default" : this.consequenceName;
    }

    public void cancelMatch(AgendaItem match, ReteEvaluator reteEvaluator) {
        match.cancel();
        if (match.isQueued()) {
            Tuple leftTuple = match.getTuple();
            if (match.getRuleAgendaItem() != null && leftTuple.getMemory() != null) {
                leftTuple.getMemory().remove(leftTuple);
            }
            RuleExecutor ruleExecutor = ((RuleTerminalNodeLeftTuple)leftTuple).getRuleAgendaItem().getRuleExecutor();
            PhreakRuleTerminalNode.doLeftDelete(ruleExecutor.getPathMemory().getActualActivationsManager(reteEvaluator), ruleExecutor, leftTuple);
        }
    }

    @Override
    protected int calculateHashCode() {
        return 31 * super.calculateHashCode() + (this.consequenceName == null ? 0 : this.consequenceName.hashCode());
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object) && Objects.equals(this.consequenceName, ((RuleTerminalNode)object).consequenceName);
    }

    @Override
    public short getType() {
        return 101;
    }

    @Override
    public LeftTuple createLeftTuple(InternalFactHandle factHandle, LeftTuple leftTuple, Sink sink) {
        return AgendaComponentFactory.get().createTerminalTuple(factHandle, leftTuple, sink);
    }

    @Override
    public LeftTuple createLeftTuple(InternalFactHandle factHandle, boolean leftTupleMemoryEnabled) {
        return AgendaComponentFactory.get().createTerminalTuple(factHandle, this, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, Sink sink, PropagationContext pctx, boolean leftTupleMemoryEnabled) {
        return AgendaComponentFactory.get().createTerminalTuple(leftTuple, sink, pctx, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, Sink sink) {
        return AgendaComponentFactory.get().createTerminalTuple(leftTuple, rightTuple, sink);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTuple currentLeftChild, LeftTuple currentRightChild, Sink sink, boolean leftTupleMemoryEnabled) {
        return AgendaComponentFactory.get().createTerminalTuple(leftTuple, rightTuple, currentLeftChild, currentRightChild, sink, leftTupleMemoryEnabled);
    }

    @Override
    public ObjectTypeNode.Id getLeftInputOtnId() {
        return this.leftInputOtnId;
    }

    @Override
    public void setLeftInputOtnId(ObjectTypeNode.Id leftInputOtnId) {
        this.leftInputOtnId = leftInputOtnId;
    }

    @Override
    public boolean isFireDirect() {
        return this.fireDirect;
    }

    public void setFireDirect(boolean fireDirect) {
        this.fireDirect = fireDirect;
    }

    public static class SortDeclarations
    implements Comparator<Declaration> {
        public static final SortDeclarations instance = new SortDeclarations();

        @Override
        public int compare(Declaration d1, Declaration d2) {
            return d1.getIdentifier().compareTo(d2.getIdentifier());
        }
    }
}

