/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.phreak;

import java.util.Comparator;
import org.drools.core.base.SalienceInteger;
import org.drools.core.common.ActivationsManager;
import org.drools.core.common.AgendaItem;
import org.drools.core.common.EventFactHandle;
import org.drools.core.common.EventSupport;
import org.drools.core.common.InternalActivationGroup;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.conflict.PhreakConflictResolver;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.event.RuleEventListenerSupport;
import org.drools.core.phreak.RuleAgendaItem;
import org.drools.core.phreak.RuleNetworkEvaluator;
import org.drools.core.reteoo.PathMemory;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.reteoo.RuleTerminalNodeLeftTuple;
import org.drools.core.reteoo.Tuple;
import org.drools.core.rule.consequence.Activation;
import org.drools.core.rule.consequence.Consequence;
import org.drools.core.rule.consequence.ConsequenceException;
import org.drools.core.rule.consequence.KnowledgeHelper;
import org.drools.core.util.BinaryHeapQueue;
import org.drools.core.util.index.TupleList;
import org.kie.api.event.rule.BeforeMatchFiredEvent;
import org.kie.api.event.rule.MatchCancelledCause;
import org.kie.api.runtime.rule.AgendaFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleExecutor {
    protected static final transient Logger log = LoggerFactory.getLogger(RuleExecutor.class);
    private final PathMemory pmem;
    private final RuleAgendaItem ruleAgendaItem;
    private final TupleList tupleList;
    private BinaryHeapQueue queue;
    private volatile boolean dirty;
    private final boolean declarativeAgendaEnabled;
    private boolean fireExitedEarly;

    public RuleExecutor(PathMemory pmem, RuleAgendaItem ruleAgendaItem, boolean declarativeAgendaEnabled) {
        this.pmem = pmem;
        this.ruleAgendaItem = ruleAgendaItem;
        this.tupleList = new TupleList();
        this.declarativeAgendaEnabled = declarativeAgendaEnabled;
        if (ruleAgendaItem.getRule().getSalience().isDynamic()) {
            this.queue = new BinaryHeapQueue(SalienceComparator.INSTANCE);
        }
    }

    public void evaluateNetwork(ActivationsManager activationsManager) {
        RuleNetworkEvaluator.INSTANCE.evaluateNetwork(this.pmem, this, activationsManager);
        this.setDirty(false);
    }

    public int evaluateNetworkAndFire(ReteEvaluator reteEvaluator, AgendaFilter filter, int fireCount, int fireLimit) {
        this.reEvaluateNetwork(reteEvaluator);
        return this.fire(reteEvaluator, this.pmem.getActualActivationsManager(reteEvaluator), filter, fireCount, fireLimit);
    }

    public int evaluateNetworkAndFire(ActivationsManager activationsManager, AgendaFilter filter, int fireCount, int fireLimit) {
        ReteEvaluator reteEvaluator = activationsManager.getReteEvaluator();
        this.reEvaluateNetwork(activationsManager);
        if (reteEvaluator.getSessionConfiguration().isDirectFiring()) {
            RuleTerminalNode rtn = (RuleTerminalNode)this.pmem.getPathEndNode();
            RuleImpl rule = rtn.getRule();
            int directFirings = this.tupleList.size();
            Tuple tuple = this.tupleList.getFirst();
            while (tuple != null) {
                if (this.cancelAndContinue(reteEvaluator, rtn, rule, tuple, filter)) {
                    --directFirings;
                } else {
                    this.innerFireActivation(reteEvaluator, activationsManager, (Activation)((Object)tuple), ((Activation)((Object)tuple)).getConsequence());
                }
                this.removeLeftTuple(tuple);
                tuple = this.tupleList.getFirst();
            }
            this.ruleAgendaItem.remove();
            return directFirings;
        }
        return this.fire(reteEvaluator, activationsManager, filter, fireCount, fireLimit);
    }

    public void fire(ActivationsManager activationsManager) {
        this.fire(activationsManager.getReteEvaluator(), activationsManager, null, 0, Integer.MAX_VALUE);
    }

    private int fire(ReteEvaluator reteEvaluator, ActivationsManager activationsManager, AgendaFilter filter, int fireCount, int fireLimit) {
        int localFireCount = 0;
        if (!this.tupleList.isEmpty()) {
            RuleAgendaItem nextRule;
            if (!this.fireExitedEarly && this.isDeclarativeAgendaEnabled() && !this.isHigherSalience(nextRule = activationsManager.peekNextRule())) {
                this.fireExitedEarly = true;
                return localFireCount;
            }
            RuleTerminalNode rtn = (RuleTerminalNode)this.pmem.getPathEndNode();
            RuleImpl rule = rtn.getRule();
            boolean ruleIsAllMatches = rule.isAllMatches();
            Tuple tuple = this.getNextTuple();
            if (ruleIsAllMatches) {
                this.fireConsequenceEvent(reteEvaluator, activationsManager, (AgendaItem)((Object)tuple), "$onBeforeAllFire$");
            }
            Tuple lastTuple = null;
            while (tuple != null) {
                if (!this.cancelAndContinue(reteEvaluator, rtn, rule, tuple, filter)) {
                    AgendaItem item = (AgendaItem)((Object)tuple);
                    if (activationsManager.getActivationsFilter() == null || activationsManager.getActivationsFilter().accept(item, reteEvaluator, rtn)) {
                        this.fireActivation(reteEvaluator, activationsManager, item);
                        ++localFireCount;
                        if (rtn.getLeftTupleSource() == null) break;
                        activationsManager.flushPropagations();
                        int salience = this.ruleAgendaItem.getSalience();
                        if (this.queue != null && !this.queue.isEmpty() && salience != this.queue.peek().getSalience()) {
                            this.ruleAgendaItem.dequeue();
                            this.ruleAgendaItem.setSalience(this.queue.peek().getSalience());
                            this.ruleAgendaItem.getAgendaGroup().add(this.ruleAgendaItem);
                        }
                        if (!ruleIsAllMatches) {
                            if (this.haltRuleFiring(fireCount, fireLimit, localFireCount, activationsManager)) break;
                            if (!reteEvaluator.isSequential()) {
                                this.reEvaluateNetwork(activationsManager);
                            }
                        }
                    }
                }
                lastTuple = tuple;
                tuple = this.getNextTuple();
            }
            if (ruleIsAllMatches) {
                this.fireConsequenceEvent(reteEvaluator, activationsManager, (AgendaItem)((Object)lastTuple), "$onAfterAllFire$");
            }
        }
        this.removeRuleAgendaItemWhenEmpty(reteEvaluator);
        this.fireExitedEarly = false;
        return localFireCount;
    }

    private Tuple getNextTuple() {
        Tuple leftTuple;
        if (this.tupleList.isEmpty()) {
            return null;
        }
        if (this.queue != null) {
            leftTuple = (Tuple)((Object)this.queue.dequeue());
            this.tupleList.remove(leftTuple);
        } else {
            leftTuple = this.tupleList.removeFirst();
            ((Activation)((Object)leftTuple)).setQueued(false);
        }
        return leftTuple;
    }

    public PathMemory getPathMemory() {
        return this.pmem;
    }

    public void removeRuleAgendaItemWhenEmpty(ReteEvaluator reteEvaluator) {
        if (!this.dirty && this.tupleList.isEmpty()) {
            if (log.isTraceEnabled()) {
                log.trace("Removing RuleAgendaItem " + this.ruleAgendaItem);
            }
            this.ruleAgendaItem.remove();
            if (this.ruleAgendaItem.getRule().isQuery()) {
                this.pmem.getActualActivationsManager(reteEvaluator).removeQueryAgendaItem(this.ruleAgendaItem);
            } else if (this.ruleAgendaItem.getRule().isEager()) {
                this.pmem.getActualActivationsManager(reteEvaluator).removeEagerRuleAgendaItem(this.ruleAgendaItem);
            }
        }
    }

    public void reEvaluateNetwork(ReteEvaluator reteEvaluator) {
        this.reEvaluateNetwork(this.pmem.getActualActivationsManager(reteEvaluator));
    }

    public void reEvaluateNetwork(ActivationsManager activationsManager) {
        if (this.isDirty()) {
            this.setDirty(false);
            RuleNetworkEvaluator.INSTANCE.evaluateNetwork(this.pmem, this, activationsManager);
        }
    }

    public RuleAgendaItem getRuleAgendaItem() {
        return this.ruleAgendaItem;
    }

    private boolean cancelAndContinue(ReteEvaluator reteEvaluator, RuleTerminalNode rtn, RuleImpl rule, Tuple leftTuple, AgendaFilter filter) {
        if (!rule.isEffective(leftTuple, rtn, reteEvaluator)) {
            return true;
        }
        if (rule.hasCalendars()) {
            long timestamp = reteEvaluator.getSessionClock().getCurrentTime();
            for (String cal : rule.getCalendars()) {
                if (reteEvaluator.getCalendars().get(cal).isTimeIncluded(timestamp)) continue;
                return true;
            }
        }
        return filter != null && !filter.accept((Activation)((Object)leftTuple));
    }

    private boolean haltRuleFiring(int fireCount, int fireLimit, int localFireCount, ActivationsManager activationsManager) {
        if (!activationsManager.isFiring() || fireLimit >= 0 && localFireCount + fireCount >= fireLimit) {
            return true;
        }
        activationsManager.evaluateEagerList();
        RuleAgendaItem nextRule = activationsManager.peekNextRule();
        return nextRule != null && (!this.ruleAgendaItem.getAgendaGroup().equals(nextRule.getAgendaGroup()) || !this.isHigherSalience(nextRule));
    }

    private boolean isHigherSalience(RuleAgendaItem nextRule) {
        return PhreakConflictResolver.doCompare(this.ruleAgendaItem, nextRule) >= 0;
    }

    public TupleList getLeftTupleList() {
        return this.tupleList;
    }

    public void addLeftTuple(Tuple tuple) {
        ((AgendaItem)((Object)tuple)).setQueued(true);
        this.tupleList.add(tuple);
        if (this.queue != null) {
            this.addQueuedLeftTuple(tuple);
        }
    }

    public void addQueuedLeftTuple(Tuple tuple) {
        int currentSalience = this.queue.isEmpty() ? 0 : this.queue.peek().getSalience();
        this.queue.enqueue((Activation)((Object)tuple));
        this.updateSalience(currentSalience);
    }

    public void removeLeftTuple(Tuple tuple) {
        ((AgendaItem)((Object)tuple)).setQueued(false);
        this.tupleList.remove(tuple);
        if (this.queue != null) {
            this.removeQueuedLeftTuple(tuple);
        }
    }

    private void removeQueuedLeftTuple(Tuple tuple) {
        int currentSalience = this.queue.isEmpty() ? 0 : this.queue.peek().getSalience();
        this.queue.dequeue((Activation)((Object)tuple));
        this.updateSalience(currentSalience);
    }

    private void updateSalience(int currentSalience) {
        int newSalience;
        int n = newSalience = this.queue.isEmpty() ? SalienceInteger.DEFAULT_SALIENCE.getValue() : this.queue.peek().getSalience();
        if (currentSalience != newSalience) {
            this.ruleAgendaItem.remove();
        }
        if (!this.ruleAgendaItem.isQueued()) {
            this.ruleAgendaItem.setSalience(newSalience);
            this.ruleAgendaItem.getAgendaGroup().add(this.ruleAgendaItem);
        }
    }

    public void cancel(ReteEvaluator reteEvaluator, EventSupport es) {
        while (!this.tupleList.isEmpty()) {
            RuleTerminalNodeLeftTuple rtnLt = (RuleTerminalNodeLeftTuple)this.tupleList.removeFirst();
            if (this.queue != null) {
                this.queue.dequeue(rtnLt);
            }
            es.getAgendaEventSupport().fireActivationCancelled(rtnLt, reteEvaluator, MatchCancelledCause.CLEAR);
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean isDeclarativeAgendaEnabled() {
        return this.declarativeAgendaEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireActivation(ReteEvaluator reteEvaluator, ActivationsManager activationsManager, Activation activation) throws ConsequenceException {
        reteEvaluator.startOperation();
        try {
            BeforeMatchFiredEvent beforeMatchFiredEvent = activationsManager.getAgendaEventSupport().fireBeforeActivationFired(activation, reteEvaluator);
            if (activation.getActivationGroupNode() != null) {
                InternalActivationGroup activationGroup = activation.getActivationGroupNode().getActivationGroup();
                activationGroup.removeActivation(activation);
                activationsManager.clearAndCancelActivationGroup(activationGroup);
            }
            activation.setQueued(false);
            try {
                this.innerFireActivation(reteEvaluator, activationsManager, activation, activation.getConsequence());
            }
            finally {
                for (Tuple tuple = activation.getTuple().skipEmptyHandles(); tuple != null; tuple = tuple.getParent()) {
                    if (!tuple.getFactHandle().isEvent()) continue;
                    EventFactHandle handle = (EventFactHandle)tuple.getFactHandle();
                    handle.decreaseActivationsCount();
                    if (!handle.expirePartition() || !handle.isExpired() || handle.getFirstRightTuple() != null || handle.getActivationsCount() > 0L) continue;
                    handle.getEntryPoint(reteEvaluator).delete(handle);
                }
            }
            activationsManager.getAgendaEventSupport().fireAfterActivationFired(activation, reteEvaluator, beforeMatchFiredEvent);
        }
        finally {
            reteEvaluator.endOperation();
        }
    }

    public void fireConsequenceEvent(ReteEvaluator reteEvaluator, ActivationsManager activationsManager, Activation activation, String consequenceName) {
        Consequence consequence = activation.getRule().getNamedConsequence(consequenceName);
        if (consequence != null) {
            this.fireActivationEvent(reteEvaluator, activationsManager, activation, consequence);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireActivationEvent(ReteEvaluator reteEvaluator, ActivationsManager activationsManager, Activation activation, Consequence consequence) throws ConsequenceException {
        reteEvaluator.startOperation();
        try {
            this.innerFireActivation(reteEvaluator, activationsManager, activation, consequence);
        }
        finally {
            reteEvaluator.endOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerFireActivation(ReteEvaluator reteEvaluator, ActivationsManager activationsManager, Activation activation, Consequence consequence) {
        KnowledgeHelper knowledgeHelper = activationsManager.getKnowledgeHelper();
        try {
            knowledgeHelper.setActivation(activation);
            if (log.isTraceEnabled()) {
                log.trace("Fire event {} for rule \"{}\" \n{}", consequence.getName(), activation.getRule().getName(), activation.getTuple());
            }
            RuleEventListenerSupport ruleEventSupport = reteEvaluator.getRuleEventSupport();
            ruleEventSupport.onBeforeMatchFire(activation);
            consequence.evaluate(knowledgeHelper, reteEvaluator);
            ruleEventSupport.onAfterMatchFire(activation);
            activation.setActive(false);
            knowledgeHelper.reset();
        }
        catch (Exception e) {
            knowledgeHelper.restoreActivationOnConsequenceFailure(activation);
            activationsManager.handleException(activation, e);
        }
        finally {
            if (activation.getActivationFactHandle() != null) {
                InternalFactHandle factHandle = activation.getActivationFactHandle();
                reteEvaluator.getDefaultEntryPoint().getEntryPointNode().modifyActivation(factHandle, activation.getPropagationContext(), reteEvaluator);
            }
        }
    }

    public static class SalienceComparator
    implements Comparator {
        public static final SalienceComparator INSTANCE = new SalienceComparator();

        public int compare(Object existing, Object adding) {
            int l2;
            int s2;
            RuleTerminalNodeLeftTuple rtnLt1 = (RuleTerminalNodeLeftTuple)existing;
            RuleTerminalNodeLeftTuple rtnLt2 = (RuleTerminalNodeLeftTuple)adding;
            int s1 = rtnLt1.getSalience();
            if (s1 > (s2 = rtnLt2.getSalience())) {
                return 1;
            }
            if (s1 < s2) {
                return -1;
            }
            int l1 = rtnLt1.getRule().getLoadOrder();
            if (l1 < (l2 = rtnLt2.getRule().getLoadOrder())) {
                return 1;
            }
            if (l1 > l2) {
                return -1;
            }
            return 0;
        }
    }
}

