/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.phreak;

import java.util.ArrayList;
import java.util.List;
import org.drools.core.common.NetworkNode;
import org.drools.core.impl.RuleBase;
import org.drools.core.reteoo.AsyncReceiveNode;
import org.drools.core.reteoo.AsyncSendNode;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.ConditionalBranchNode;
import org.drools.core.reteoo.EvalConditionNode;
import org.drools.core.reteoo.ExistsNode;
import org.drools.core.reteoo.FromNode;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.LeftTupleNode;
import org.drools.core.reteoo.LeftTupleSinkNode;
import org.drools.core.reteoo.LeftTupleSinkPropagator;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.NodeTypeEnums;
import org.drools.core.reteoo.NotNode;
import org.drools.core.reteoo.PathEndNode;
import org.drools.core.reteoo.QueryElementNode;
import org.drools.core.reteoo.ReactiveFromNode;
import org.drools.core.reteoo.RightInputAdapterNode;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.reteoo.TimerNode;

public class BuildtimeSegmentUtilities {
    public static final int NOT_NODE_BIT = 1;
    public static final int JOIN_NODE_BIT = 2;
    public static final int REACTIVE_EXISTS_NODE_BIT = 4;
    public static final int PASSIVE_EXISTS_NODE_BIT = 8;

    public static void createPathProtoMemories(TerminalNode tn, TerminalNode removingTn, RuleBase rbase) {
        SegmentMemory.SegmentPrototype[] smems = BuildtimeSegmentUtilities.createPathProtoMemories(tn, null, removingTn, rbase);
        if (smems != null) {
            BuildtimeSegmentUtilities.setSegments(tn, smems);
        }
    }

    private static void setSegments(PathEndNode endNode, SegmentMemory.SegmentPrototype[] smems) {
        ArrayList<SegmentMemory.SegmentPrototype> eager = new ArrayList<SegmentMemory.SegmentPrototype>();
        for (SegmentMemory.SegmentPrototype smem : smems) {
            if (smem == null || !BuildtimeSegmentUtilities.requiresAnEagerSegment(smem.getNodeTypesInSegment())) continue;
            eager.add(smem);
        }
        endNode.setEagerSegmentPrototypes(eager.toArray(new SegmentMemory.SegmentPrototype[eager.size()]));
        endNode.setSegmentPrototypes(smems);
    }

    public static SegmentMemory.SegmentPrototype[] createPathProtoMemories(LeftTupleNode lts, LeftTupleSource stopNode, TerminalNode removingTn, RuleBase rbase) {
        LeftTupleNode segmentRoot = lts;
        LeftTupleNode segmentTip = lts;
        ArrayList<SegmentMemory.SegmentPrototype> smems = new ArrayList<SegmentMemory.SegmentPrototype>();
        boolean inside = true;
        while (true) {
            if (!BuildtimeSegmentUtilities.isRootNode(segmentRoot, removingTn)) {
                segmentRoot = segmentRoot.getLeftTupleSource();
                continue;
            }
            smems.add(0, inside ? BuildtimeSegmentUtilities.createSegmentMemory(segmentRoot, segmentTip, removingTn, rbase) : null);
            if (inside && segmentRoot.getLeftTupleSource() == stopNode) {
                inside = false;
            }
            segmentTip = segmentRoot = segmentRoot.getLeftTupleSource();
            if (segmentRoot == null) break;
        }
        int ruleSegmentPosMask = 1;
        for (int counter = 0; counter < smems.size(); ++counter) {
            if (smems.get(counter) != null) {
                ((SegmentMemory.SegmentPrototype)smems.get(counter)).setPos(counter);
                ((SegmentMemory.SegmentPrototype)smems.get(counter)).setSegmentPosMaskBit(ruleSegmentPosMask);
            }
            ruleSegmentPosMask <<= 1;
        }
        return smems.toArray(new SegmentMemory.SegmentPrototype[smems.size()]);
    }

    public static SegmentMemory.SegmentPrototype createSegmentMemory(LeftTupleNode segmentRoot, LeftTupleNode segmentTip, TerminalNode removingTn, RuleBase rbase) {
        LeftTupleNode node = segmentRoot;
        int nodeTypesInSegment = 0;
        SegmentMemory.SegmentPrototype smem = new SegmentMemory.SegmentPrototype(segmentRoot, segmentTip);
        ArrayList<SegmentMemory.MemoryPrototype> memories = new ArrayList<SegmentMemory.MemoryPrototype>();
        ArrayList<LeftTupleNode> nodes = new ArrayList<LeftTupleNode>();
        long nodePosMask = 1L;
        long allLinkedTestMask = 0L;
        boolean updateNodeBit = true;
        while (true) {
            nodeTypesInSegment = BuildtimeSegmentUtilities.updateNodeTypesMask(node, nodeTypesInSegment);
            if (NodeTypeEnums.isBetaNode(node)) {
                allLinkedTestMask = BuildtimeSegmentUtilities.processBetaNode((BetaNode)node, smem, memories, nodes, nodePosMask, allLinkedTestMask, updateNodeBit, removingTn, rbase);
            } else {
                switch (node.getType()) {
                    case 120: {
                        allLinkedTestMask = BuildtimeSegmentUtilities.processLiaNode((LeftInputAdapterNode)node, memories, nodes, nodePosMask, allLinkedTestMask);
                        break;
                    }
                    case 167: {
                        BuildtimeSegmentUtilities.processConditionalBranchNode((ConditionalBranchNode)node, memories, nodes);
                        updateNodeBit = false;
                        break;
                    }
                    case 151: {
                        BuildtimeSegmentUtilities.processFromNode((FromNode)node, memories, nodes);
                        break;
                    }
                    case 131: {
                        BuildtimeSegmentUtilities.processEvalFromNode((EvalConditionNode)node, memories, nodes);
                        break;
                    }
                    case 153: {
                        BuildtimeSegmentUtilities.processReactiveFromNode((ReactiveFromNode)node, memories, nodes, nodePosMask);
                        break;
                    }
                    case 133: {
                        BuildtimeSegmentUtilities.processTimerNode((TimerNode)node, memories, nodes, nodePosMask);
                        break;
                    }
                    case 135: {
                        BuildtimeSegmentUtilities.processAsyncSendNode((AsyncSendNode)node, memories, nodes);
                        break;
                    }
                    case 137: {
                        BuildtimeSegmentUtilities.processAsyncReceiveNode((AsyncReceiveNode)node, memories, nodes, nodePosMask);
                        break;
                    }
                    case 165: {
                        updateNodeBit = BuildtimeSegmentUtilities.processQueryNode((QueryElementNode)node, memories, nodes, nodePosMask);
                        break;
                    }
                    case 71: {
                        BuildtimeSegmentUtilities.processRightInputAdapterNode((RightInputAdapterNode)node, memories, nodes);
                        break;
                    }
                    case 91: 
                    case 101: {
                        BuildtimeSegmentUtilities.processTerminalNode((TerminalNode)node, memories, nodes);
                    }
                }
            }
            nodePosMask = BuildtimeSegmentUtilities.nextNodePosMask(nodePosMask);
            if (node == segmentTip || !(node instanceof LeftTupleSource)) break;
            node = ((LeftTupleSource)node).getFirstLeftTupleSinkIgnoreRemoving(removingTn);
        }
        smem.setAllLinkedMaskTest(allLinkedTestMask);
        ArrayList<PathEndNode> endNodes = new ArrayList<PathEndNode>();
        BuildtimeSegmentUtilities.collectPathEndNodes(segmentTip, endNodes, removingTn);
        smem.setNodesInSegment(nodes.toArray(new LeftTupleNode[nodes.size()]));
        smem.setMemories(memories.toArray(new SegmentMemory.MemoryPrototype[memories.size()]));
        smem.setPathEndNodes(endNodes.toArray(new PathEndNode[endNodes.size()]));
        smem.setNodeTypesInSegment(nodeTypesInSegment);
        rbase.registerSegmentPrototype(segmentRoot, smem);
        return smem;
    }

    public static boolean requiresAnEagerSegment(int nodeTypesInSegment) {
        return BuildtimeSegmentUtilities.isSet(nodeTypesInSegment, 1) && !BuildtimeSegmentUtilities.isSet(nodeTypesInSegment, 2) && !BuildtimeSegmentUtilities.isSet(nodeTypesInSegment, 4);
    }

    private static void collectPathEndNodes(LeftTupleNode lt, List<PathEndNode> endNodes, TerminalNode removingTn) {
        if (removingTn != null & !NodeTypeEnums.isTerminalNode(lt) && !BuildtimeSegmentUtilities.sinkNotExclusivelyAssociatedWithTerminal(removingTn, lt)) {
            return;
        }
        if (NodeTypeEnums.isTerminalNode(lt)) {
            endNodes.add((PathEndNode)lt);
        } else if (71 == lt.getType()) {
            endNodes.add((PathEndNode)lt);
        }
        for (LeftTupleSinkNode sink = lt.getSinkPropagator().getLastLeftTupleSink(); sink != null; sink = sink.getPreviousLeftTupleSinkNode()) {
            BuildtimeSegmentUtilities.collectPathEndNodes(sink, endNodes, removingTn);
        }
    }

    public static long nextNodePosMask(long nodePosMask) {
        long nextNodePosMask = nodePosMask << 1;
        return nextNodePosMask > 0L ? nextNodePosMask : nodePosMask;
    }

    private static boolean processQueryNode(QueryElementNode queryNode, List<SegmentMemory.MemoryPrototype> memories, List<LeftTupleNode> nodes, long nodePosMask) {
        SegmentMemory.QueryMemoryPrototype queryNodeMem = new SegmentMemory.QueryMemoryPrototype(nodePosMask, queryNode);
        memories.add(queryNodeMem);
        nodes.add(queryNode);
        return !queryNode.getQueryElement().isAbductive();
    }

    private static void processAsyncSendNode(AsyncSendNode tupleSource, List<SegmentMemory.MemoryPrototype> memories, List<LeftTupleNode> nodes) {
        SegmentMemory.AsyncSendMemoryPrototype mem = new SegmentMemory.AsyncSendMemoryPrototype();
        memories.add(mem);
        nodes.add(tupleSource);
    }

    private static void processAsyncReceiveNode(AsyncReceiveNode tupleSource, List<SegmentMemory.MemoryPrototype> memories, List<LeftTupleNode> nodes, long nodePosMask) {
        SegmentMemory.AsyncReceiveMemoryPrototype mem = new SegmentMemory.AsyncReceiveMemoryPrototype(nodePosMask);
        memories.add(mem);
        nodes.add(tupleSource);
    }

    private static void processConditionalBranchNode(ConditionalBranchNode tupleSource, List<SegmentMemory.MemoryPrototype> memories, List<LeftTupleNode> nodes) {
        SegmentMemory.ConditionalBranchMemoryPrototype mem = new SegmentMemory.ConditionalBranchMemoryPrototype();
        memories.add(mem);
        nodes.add(tupleSource);
    }

    private static void processRightInputAdapterNode(RightInputAdapterNode tupleSource, List<SegmentMemory.MemoryPrototype> memories, List<LeftTupleNode> nodes) {
        SegmentMemory.RightInputAdapterPrototype mem = new SegmentMemory.RightInputAdapterPrototype();
        memories.add(mem);
        nodes.add(tupleSource);
    }

    private static void processTerminalNode(TerminalNode tupleSource, List<SegmentMemory.MemoryPrototype> memories, List<LeftTupleNode> nodes) {
        SegmentMemory.TerminalPrototype mem = new SegmentMemory.TerminalPrototype();
        memories.add(mem);
        nodes.add(tupleSource);
    }

    private static void processFromNode(FromNode tupleSource, List<SegmentMemory.MemoryPrototype> memories, List<LeftTupleNode> nodes) {
        SegmentMemory.FromMemoryPrototype mem = new SegmentMemory.FromMemoryPrototype();
        memories.add(mem);
        nodes.add(tupleSource);
    }

    private static void processEvalFromNode(EvalConditionNode tupleSource, List<SegmentMemory.MemoryPrototype> memories, List<LeftTupleNode> nodes) {
        SegmentMemory.EvalMemoryPrototype mem = new SegmentMemory.EvalMemoryPrototype();
        memories.add(mem);
        nodes.add(tupleSource);
    }

    private static void processReactiveFromNode(ReactiveFromNode tupleSource, List<SegmentMemory.MemoryPrototype> memories, List<LeftTupleNode> nodes, long nodePosMask) {
        SegmentMemory.ReactiveFromMemoryPrototype mem = new SegmentMemory.ReactiveFromMemoryPrototype(nodePosMask);
        memories.add(mem);
        nodes.add(tupleSource);
    }

    private static void processTimerNode(TimerNode tupleSource, List<SegmentMemory.MemoryPrototype> memories, List<LeftTupleNode> nodes, long nodePosMask) {
        SegmentMemory.TimerMemoryPrototype tnMem = new SegmentMemory.TimerMemoryPrototype(nodePosMask);
        memories.add(tnMem);
        nodes.add(tupleSource);
    }

    private static long processLiaNode(LeftInputAdapterNode tupleSource, List<SegmentMemory.MemoryPrototype> memories, List<LeftTupleNode> nodes, long nodePosMask, long allLinkedTestMask) {
        SegmentMemory.LiaMemoryPrototype liaMemory = new SegmentMemory.LiaMemoryPrototype(nodePosMask);
        memories.add(liaMemory);
        nodes.add(tupleSource);
        return allLinkedTestMask |= nodePosMask;
    }

    private static long processBetaNode(BetaNode betaNode, SegmentMemory.SegmentPrototype smem, List<SegmentMemory.MemoryPrototype> memories, List<LeftTupleNode> nodes, long nodePosMask, long allLinkedTestMask, boolean updateNodeBit, TerminalNode removingTn, RuleBase rbase) {
        RightInputAdapterNode riaNode = null;
        if (betaNode.isRightInputIsRiaNode()) {
            riaNode = (RightInputAdapterNode)betaNode.getRightInput();
            SegmentMemory.SegmentPrototype[] smems = BuildtimeSegmentUtilities.createPathProtoMemories(riaNode, riaNode.getStartTupleSource(), removingTn, rbase);
            BuildtimeSegmentUtilities.setSegments(riaNode, smems);
            if (updateNodeBit && BuildtimeSegmentUtilities.canBeDisabled(betaNode) && riaNode.getPathMemSpec().allLinkedTestMask() > 0L) {
                allLinkedTestMask |= nodePosMask;
            }
        } else if (updateNodeBit && BuildtimeSegmentUtilities.canBeDisabled(betaNode)) {
            allLinkedTestMask |= nodePosMask;
        }
        if (191 == betaNode.getType()) {
            smem.linkNode(nodePosMask);
        }
        SegmentMemory.BetaMemoryPrototype bm = new SegmentMemory.BetaMemoryPrototype(nodePosMask, riaNode);
        if (211 == betaNode.getType()) {
            SegmentMemory.AccumulateMemoryPrototype am = new SegmentMemory.AccumulateMemoryPrototype(bm);
            memories.add(am);
        } else {
            memories.add(bm);
        }
        nodes.add(betaNode);
        return allLinkedTestMask;
    }

    public static boolean canBeDisabled(BetaNode betaNode) {
        return (191 != betaNode.getType() || ((NotNode)betaNode).isEmptyBetaConstraints()) && 211 != betaNode.getType() && !betaNode.isRightInputPassive();
    }

    public static boolean isRootNode(LeftTupleNode node, TerminalNode removingTN) {
        return node.getType() == 120 || BuildtimeSegmentUtilities.isTipNode(node.getLeftTupleSource(), removingTN);
    }

    public static boolean isTipNode(LeftTupleNode node, TerminalNode removingTN) {
        return NodeTypeEnums.isEndNode(node) || BuildtimeSegmentUtilities.isNonTerminalTipNode(node, removingTN);
    }

    public static boolean isNonTerminalTipNode(LeftTupleNode node, TerminalNode removingTN) {
        LeftTupleSinkPropagator sinkPropagator = node.getSinkPropagator();
        if (removingTN == null) {
            return sinkPropagator.size() > 1;
        }
        if (sinkPropagator.size() == 1) {
            return false;
        }
        int count = 0;
        for (LeftTupleSinkNode sink = sinkPropagator.getFirstLeftTupleSink(); sink != null; sink = sink.getNextLeftTupleSinkNode()) {
            if (!BuildtimeSegmentUtilities.sinkNotExclusivelyAssociatedWithTerminal(removingTN, sink) || ++count <= 1) continue;
            return true;
        }
        return false;
    }

    public static boolean sinkNotExclusivelyAssociatedWithTerminal(TerminalNode removingTN, LeftTupleNode sink) {
        return sink.getAssociatedTerminalsSize() > 1 || !sink.hasAssociatedTerminal(removingTN);
    }

    public static int updateNodeTypesMask(NetworkNode node, int mask) {
        if (node != null) {
            switch (node.getType()) {
                case 181: {
                    mask |= 2;
                    break;
                }
                case 201: {
                    if (((ExistsNode)node).isRightInputPassive()) {
                        mask |= 8;
                        break;
                    }
                    mask |= 4;
                    break;
                }
                case 191: {
                    mask |= 1;
                }
            }
        }
        return mask;
    }

    public static boolean isSet(int mask, int bit) {
        return (mask & bit) == bit;
    }

    public static LeftTupleNode findSegmentRoot(LeftTupleNode tupleSource) {
        while (!BuildtimeSegmentUtilities.isRootNode(tupleSource, null)) {
            tupleSource = tupleSource.getLeftTupleSource();
        }
        return tupleSource;
    }

    public static boolean isAssociatedWith(NetworkNode node, TerminalNode tn) {
        return tn.isTerminalNodeOf((LeftTupleNode)node);
    }
}

