/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.drools.core.base.AccessorKey;
import org.drools.core.base.ReadAccessorSupplier;
import org.drools.core.common.DroolsObjectInput;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.impl.RuleBase;
import org.drools.core.rule.accessor.ReadAccessor;
import org.drools.util.ClassUtils;

public class DroolsObjectInputStream
extends ObjectInputStream
implements DroolsObjectInput {
    private ClassLoader classLoader;
    private RuleBase ruleBase;
    private InternalWorkingMemory workingMemory;
    private Package pkg;
    private ReadAccessorSupplier store;
    private Map<AccessorKey, List<Consumer<ReadAccessor>>> extractorBinders = new HashMap<AccessorKey, List<Consumer<ReadAccessor>>>();
    private Map<String, Object> customExtensions = new HashMap<String, Object>();
    private final Map<String, Object> clonedByIdentity;

    public DroolsObjectInputStream(InputStream inputStream) throws IOException {
        this(inputStream, null);
    }

    public DroolsObjectInputStream(InputStream inputStream, ClassLoader classLoader) throws IOException {
        this(inputStream, classLoader, null);
    }

    public DroolsObjectInputStream(InputStream inputStream, ClassLoader classLoader, Map<String, Object> clonedByIdentity) throws IOException {
        super(inputStream);
        if (classLoader == null && (classLoader = Thread.currentThread().getContextClassLoader()) == null) {
            classLoader = this.getClass().getClassLoader();
        }
        this.classLoader = classLoader;
        this.clonedByIdentity = clonedByIdentity;
    }

    public boolean isCloning() {
        return this.clonedByIdentity != null;
    }

    public <T> T getCloneByKey(String key) {
        return (T)this.clonedByIdentity.get(key);
    }

    protected Class resolveClass(String className) throws ClassNotFoundException {
        return ClassUtils.getClassFromName(className, true, this.classLoader);
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        return this.resolveClass(desc.getName());
    }

    public static InvalidClassException newInvalidClassException(Class clazz, Throwable cause) {
        return DroolsObjectInputStream.newInvalidClassException(clazz.getName(), cause);
    }

    public static InvalidClassException newInvalidClassException(String className, Throwable cause) {
        InvalidClassException exception = new InvalidClassException(className);
        exception.initCause(cause);
        return exception;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public RuleBase getRuleBase() {
        return this.ruleBase;
    }

    @Override
    public void setRuleBase(RuleBase ruleBase) {
        this.ruleBase = ruleBase;
        this.classLoader = this.ruleBase.getRootClassLoader();
    }

    @Override
    public InternalWorkingMemory getWorkingMemory() {
        return this.workingMemory;
    }

    @Override
    public void setWorkingMemory(InternalWorkingMemory workingMemory) {
        this.workingMemory = workingMemory;
    }

    @Override
    public Package getPackage() {
        return this.pkg;
    }

    @Override
    public void setPackage(Package pkg) {
        this.pkg = pkg;
    }

    @Override
    public ClassLoader getParentClassLoader() {
        return this.classLoader;
    }

    public void setStore(ReadAccessorSupplier store) {
        this.store = store;
    }

    public void readExtractor(Consumer<ReadAccessor> binder) throws ClassNotFoundException, IOException {
        Object accessor = this.readObject();
        if (accessor instanceof AccessorKey) {
            ReadAccessor reader;
            ReadAccessor readAccessor = reader = this.store != null ? this.store.getReader((AccessorKey)accessor) : null;
            if (reader == null) {
                this.extractorBinders.computeIfAbsent((AccessorKey)accessor, k -> new ArrayList()).add(binder);
            } else {
                binder.accept(reader);
            }
        } else {
            binder.accept((ReadAccessor)accessor);
        }
    }

    @Override
    public void setClassLoader(ClassLoader classLoader) {
        if (classLoader == null && (classLoader = Thread.currentThread().getContextClassLoader()) == null) {
            classLoader = this.getClass().getClassLoader();
        }
        this.classLoader = classLoader;
    }

    public Map<String, Object> getCustomExtensions() {
        return this.customExtensions;
    }

    public void addCustomExtensions(String key, Object extension) {
        this.customExtensions.put(key, extension);
    }
}

