/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.drools.core.BeliefSystemType;
import org.drools.core.ClockType;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.TimerJobFactoryType;
import org.drools.core.base.CoreComponentsBuilder;
import org.drools.core.process.WorkItemManagerFactory;
import org.drools.core.time.impl.TimerJobFactoryManager;
import org.drools.core.util.ConfFileUtils;
import org.drools.util.StringUtils;
import org.drools.wiring.api.classloader.ProjectClassLoader;
import org.kie.api.KieBase;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.ExecutableRunner;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.conf.AccumulateNullPropagationOption;
import org.kie.api.runtime.conf.BeliefSystemTypeOption;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.api.runtime.conf.DirectFiringOption;
import org.kie.api.runtime.conf.KeepReferenceOption;
import org.kie.api.runtime.conf.KieSessionOption;
import org.kie.api.runtime.conf.MultiValueKieSessionOption;
import org.kie.api.runtime.conf.QueryListenerOption;
import org.kie.api.runtime.conf.SingleValueKieSessionOption;
import org.kie.api.runtime.conf.ThreadSafeOption;
import org.kie.api.runtime.conf.TimedRuleExecutionFilter;
import org.kie.api.runtime.conf.TimedRuleExecutionOption;
import org.kie.api.runtime.conf.TimerJobFactoryOption;
import org.kie.api.runtime.conf.WorkItemHandlerOption;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.internal.runtime.conf.ForceEagerActivationFilter;
import org.kie.internal.runtime.conf.ForceEagerActivationOption;
import org.kie.internal.utils.ChainedProperties;

public class SessionConfiguration
implements KieSessionConfiguration,
Externalizable {
    private ChainedProperties chainedProperties;
    private volatile boolean immutable;
    private boolean keepReference;
    private boolean directFiring;
    private boolean threadSafe;
    private boolean accumulateNullPropagation;
    private ForceEagerActivationFilter forceEagerActivationFilter;
    private TimedRuleExecutionFilter timedRuleExecutionFilter;
    private ClockType clockType;
    private BeliefSystemType beliefSystemType;
    private QueryListenerOption queryListener;
    private Map<String, WorkItemHandler> workItemHandlers;
    private WorkItemManagerFactory workItemManagerFactory;
    private ExecutableRunner runner;
    private transient ClassLoader classLoader;
    private TimerJobFactoryType timerJobFactoryType;

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.chainedProperties);
        out.writeBoolean(this.immutable);
        out.writeBoolean(this.keepReference);
        out.writeObject((Object)this.clockType);
        out.writeObject(this.queryListener);
        out.writeObject(this.timerJobFactoryType);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.chainedProperties = (ChainedProperties)in.readObject();
        this.immutable = in.readBoolean();
        this.keepReference = in.readBoolean();
        this.clockType = (ClockType)((Object)in.readObject());
        this.queryListener = (QueryListenerOption)in.readObject();
        try {
            this.timerJobFactoryType = (TimerJobFactoryType)in.readObject();
        }
        catch (InvalidObjectException e) {
            if (e.getMessage().contains("DEFUALT")) {
                this.timerJobFactoryType = TimerJobFactoryType.DEFAULT;
            }
            throw e;
        }
    }

    public SessionConfiguration() {
        this.init(null, null, null);
    }

    public SessionConfiguration(Properties properties) {
        this.init(properties, null, null);
    }

    public SessionConfiguration(Properties properties, ClassLoader classLoader) {
        this.init(properties, classLoader, null);
    }

    public SessionConfiguration(Properties properties, ClassLoader classLoader, ChainedProperties chainedProperties) {
        this.init(properties, classLoader, chainedProperties);
    }

    private void init(Properties properties, ClassLoader classLoader, ChainedProperties chainedProperties) {
        this.classLoader = classLoader instanceof ProjectClassLoader ? classLoader : ProjectClassLoader.getClassLoader(classLoader, this.getClass());
        this.immutable = false;
        ChainedProperties chainedProperties2 = this.chainedProperties = chainedProperties != null ? chainedProperties : ChainedProperties.getChainedProperties(this.classLoader);
        if (properties != null) {
            this.chainedProperties = this.chainedProperties.clone();
            this.chainedProperties.addProperties(properties);
        }
        this.setKeepReference(Boolean.parseBoolean(this.getPropertyValue("drools.keepReference", "true")));
        this.setDirectFiring(Boolean.parseBoolean(this.getPropertyValue("drools.directFiring", "false")));
        this.setThreadSafe(Boolean.parseBoolean(this.getPropertyValue("drools.threadSafe", "true")));
        this.setAccumulateNullPropagation(Boolean.parseBoolean(this.getPropertyValue("drools.accumulateNullPropagation", "false")));
        this.setForceEagerActivationFilter(ForceEagerActivationOption.resolve(this.getPropertyValue("drools.forceEagerActivation", "false")).getFilter());
        this.setTimedRuleExecutionFilter(TimedRuleExecutionOption.resolve(this.getPropertyValue("drools.timedRuleExecution", "false")).getFilter());
        this.setBeliefSystemType(BeliefSystemType.resolveBeliefSystemType(this.getPropertyValue("drools.beliefSystem", BeliefSystemType.SIMPLE.getId())));
        this.setClockType(ClockType.resolveClockType(this.getPropertyValue("drools.clockType", ClockType.REALTIME_CLOCK.getId())));
        this.setQueryListenerOption(QueryListenerOption.determineQueryListenerClassOption(this.getPropertyValue("drools.queryListener", QueryListenerOption.STANDARD.getAsString())));
        this.setTimerJobFactoryType(TimerJobFactoryType.resolveTimerJobFactoryType(this.getPropertyValue("drools.timerJobFactory", TimerJobFactoryType.THREAD_SAFE_TRACKABLE.getId())));
    }

    public SessionConfiguration addDefaultProperties(Properties properties) {
        Properties defaultProperties = new Properties();
        for (Map.Entry<Object, Object> prop : properties.entrySet()) {
            if (this.chainedProperties.getProperty((String)prop.getKey(), null) != null) continue;
            defaultProperties.put(prop.getKey(), prop.getValue());
        }
        this.chainedProperties.addProperties(defaultProperties);
        return this;
    }

    public void makeImmutable() {
        this.immutable = true;
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    private void checkCanChange() {
        if (this.immutable) {
            throw new UnsupportedOperationException("Can't set a property after configuration becomes immutable");
        }
    }

    private void setKeepReference(boolean keepReference) {
        this.checkCanChange();
        this.keepReference = keepReference;
    }

    public boolean isKeepReference() {
        return this.keepReference;
    }

    private void setDirectFiring(boolean directFiring) {
        this.directFiring = directFiring;
    }

    public boolean isDirectFiring() {
        return this.directFiring;
    }

    private void setThreadSafe(boolean threadSafe) {
        this.threadSafe = threadSafe;
    }

    public boolean isThreadSafe() {
        return this.threadSafe;
    }

    private void setAccumulateNullPropagation(boolean accumulateNullPropagation) {
        this.accumulateNullPropagation = accumulateNullPropagation;
    }

    public boolean isAccumulateNullPropagation() {
        return this.accumulateNullPropagation;
    }

    private void setForceEagerActivationFilter(ForceEagerActivationFilter forceEagerActivationFilter) {
        this.forceEagerActivationFilter = forceEagerActivationFilter;
    }

    public ForceEagerActivationFilter getForceEagerActivationFilter() {
        return this.forceEagerActivationFilter;
    }

    private void setTimedRuleExecutionFilter(TimedRuleExecutionFilter timedRuleExecutionFilter) {
        this.timedRuleExecutionFilter = timedRuleExecutionFilter;
    }

    public TimedRuleExecutionFilter getTimedRuleExecutionFilter() {
        return this.timedRuleExecutionFilter;
    }

    public BeliefSystemType getBeliefSystemType() {
        return this.beliefSystemType;
    }

    private void setBeliefSystemType(BeliefSystemType beliefSystemType) {
        this.beliefSystemType = beliefSystemType;
    }

    public ClockType getClockType() {
        return this.clockType;
    }

    private void setClockType(ClockType clockType) {
        this.clockType = clockType;
    }

    public TimerJobFactoryType getTimerJobFactoryType() {
        return this.timerJobFactoryType;
    }

    private void setTimerJobFactoryType(TimerJobFactoryType timerJobFactoryType) {
        this.timerJobFactoryType = timerJobFactoryType;
    }

    public Map<String, WorkItemHandler> getWorkItemHandlers() {
        if (this.workItemHandlers == null) {
            this.initWorkItemHandlers(new HashMap<String, Object>());
        }
        return this.workItemHandlers;
    }

    public Map<String, WorkItemHandler> getWorkItemHandlers(Map<String, Object> params) {
        if (this.workItemHandlers == null) {
            this.initWorkItemHandlers(params);
        }
        return this.workItemHandlers;
    }

    private void initWorkItemHandlers(Map<String, Object> params) {
        String[] locations;
        this.workItemHandlers = new HashMap<String, WorkItemHandler>();
        for (String factoryLocation : locations = this.getPropertyValue("drools.workItemHandlers", "").split("\\s")) {
            if ((factoryLocation = factoryLocation.trim()).startsWith("\"")) {
                factoryLocation = factoryLocation.substring(1);
            }
            if (factoryLocation.endsWith("\"")) {
                factoryLocation = factoryLocation.substring(0, factoryLocation.length() - 1);
            }
            if (factoryLocation.equals("")) continue;
            this.loadWorkItemHandlers(factoryLocation, params);
        }
    }

    private void loadWorkItemHandlers(String location, Map<String, Object> params) {
        String content = ConfFileUtils.URLContentsToString(ConfFileUtils.getURL(location, null, RuleBaseConfiguration.class));
        Map workItemHandlers = (Map)CoreComponentsBuilder.get().getMVELExecutor().eval(content, params);
        this.workItemHandlers.putAll(workItemHandlers);
    }

    public WorkItemManagerFactory getWorkItemManagerFactory() {
        if (this.workItemManagerFactory == null) {
            this.initWorkItemManagerFactory();
        }
        return this.workItemManagerFactory;
    }

    public void setWorkItemManagerFactory(WorkItemManagerFactory workItemManagerFactory) {
        this.workItemManagerFactory = workItemManagerFactory;
    }

    private void initWorkItemManagerFactory() {
        String className = this.getPropertyValue("drools.workItemManagerFactory", "org.drools.core.process.impl.DefaultWorkItemManagerFactory");
        Class<?> clazz = null;
        try {
            clazz = this.classLoader.loadClass(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (clazz != null) {
            try {
                this.workItemManagerFactory = (WorkItemManagerFactory)clazz.newInstance();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to instantiate work item manager factory '" + className + "'", e);
            }
        } else {
            throw new IllegalArgumentException("Work item manager factory '" + className + "' not found");
        }
    }

    public String getProcessInstanceManagerFactory() {
        return this.getPropertyValue("drools.processInstanceManagerFactory", "org.jbpm.process.instance.impl.DefaultProcessInstanceManagerFactory");
    }

    public String getSignalManagerFactory() {
        return this.getPropertyValue("drools.processSignalManagerFactory", "org.jbpm.process.instance.event.DefaultSignalManagerFactory");
    }

    public ExecutableRunner getRunner(KieBase kbase, Environment environment) {
        if (this.runner == null) {
            this.initCommandService(kbase, environment);
        }
        return this.runner;
    }

    private void initCommandService(KieBase kbase, Environment environment) {
        String className = this.getPropertyValue("drools.commandService", null);
        if (className == null) {
            return;
        }
        Class<?> clazz = null;
        try {
            clazz = this.classLoader.loadClass(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (clazz != null) {
            try {
                this.runner = (ExecutableRunner)clazz.getConstructor(KieBase.class, KieSessionConfiguration.class, Environment.class).newInstance(kbase, this, environment);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to instantiate command service '" + className + "'", e);
            }
        } else {
            throw new IllegalArgumentException("Command service '" + className + "' not found");
        }
    }

    public String getPropertyValue(String name, String defaultValue) {
        return this.chainedProperties.getProperty(name, defaultValue);
    }

    public QueryListenerOption getQueryListenerOption() {
        return this.queryListener;
    }

    private void setQueryListenerOption(QueryListenerOption queryListener) {
        this.queryListener = queryListener;
    }

    public final boolean hasForceEagerActivationFilter() {
        try {
            return this.getForceEagerActivationFilter().accept(null);
        }
        catch (Exception e) {
            return true;
        }
    }

    public final TimerJobFactoryManager getTimerJobFactoryManager() {
        return this.getTimerJobFactoryType().createInstance();
    }

    @Override
    public final <T extends KieSessionOption> void setOption(T option) {
        this.checkCanChange();
        if (option instanceof ClockTypeOption) {
            this.setClockType(ClockType.resolveClockType(((ClockTypeOption)option).getClockType()));
        } else if (option instanceof TimerJobFactoryOption) {
            this.setTimerJobFactoryType(TimerJobFactoryType.resolveTimerJobFactoryType(((TimerJobFactoryOption)option).getTimerJobType()));
        } else if (option instanceof KeepReferenceOption) {
            this.setKeepReference(((KeepReferenceOption)option).isKeepReference());
        } else if (option instanceof DirectFiringOption) {
            this.setDirectFiring(((DirectFiringOption)option).isDirectFiring());
        } else if (option instanceof ThreadSafeOption) {
            this.setThreadSafe(((ThreadSafeOption)option).isThreadSafe());
        } else if (option instanceof AccumulateNullPropagationOption) {
            this.setAccumulateNullPropagation(((AccumulateNullPropagationOption)option).isAccumulateNullPropagation());
        } else if (option instanceof ForceEagerActivationOption) {
            this.setForceEagerActivationFilter(((ForceEagerActivationOption)option).getFilter());
        } else if (option instanceof TimedRuleExecutionOption) {
            this.setTimedRuleExecutionFilter(((TimedRuleExecutionOption)option).getFilter());
        } else if (option instanceof WorkItemHandlerOption) {
            this.getWorkItemHandlers().put(((WorkItemHandlerOption)option).getName(), ((WorkItemHandlerOption)option).getHandler());
        } else if (option instanceof QueryListenerOption) {
            this.setQueryListenerOption((QueryListenerOption)option);
        } else if (option instanceof BeliefSystemTypeOption) {
            this.setBeliefSystemType(BeliefSystemType.resolveBeliefSystemType(((BeliefSystemTypeOption)option).getBeliefSystemType()));
        }
    }

    @Override
    public final <T extends SingleValueKieSessionOption> T getOption(Class<T> option) {
        if (ClockTypeOption.class.equals(option)) {
            return (T)ClockTypeOption.get(this.getClockType().toExternalForm());
        }
        if (KeepReferenceOption.class.equals(option)) {
            return (T)(this.isKeepReference() ? KeepReferenceOption.YES : KeepReferenceOption.NO);
        }
        if (DirectFiringOption.class.equals(option)) {
            return (T)(this.isDirectFiring() ? DirectFiringOption.YES : DirectFiringOption.NO);
        }
        if (ThreadSafeOption.class.equals(option)) {
            return (T)(this.isThreadSafe() ? ThreadSafeOption.YES : ThreadSafeOption.NO);
        }
        if (AccumulateNullPropagationOption.class.equals(option)) {
            return (T)(this.isAccumulateNullPropagation() ? AccumulateNullPropagationOption.YES : AccumulateNullPropagationOption.NO);
        }
        if (TimerJobFactoryOption.class.equals(option)) {
            return (T)TimerJobFactoryOption.get(this.getTimerJobFactoryType().toExternalForm());
        }
        if (QueryListenerOption.class.equals(option)) {
            return (T)this.getQueryListenerOption();
        }
        if (BeliefSystemTypeOption.class.equals(option)) {
            return (T)BeliefSystemTypeOption.get(this.getBeliefSystemType().getId());
        }
        return null;
    }

    @Override
    public final <T extends MultiValueKieSessionOption> T getOption(Class<T> option, String key) {
        if (WorkItemHandlerOption.class.equals(option)) {
            return (T)WorkItemHandlerOption.get(key, this.getWorkItemHandlers().get(key));
        }
        return null;
    }

    @Override
    public final void setProperty(String name, String value) {
        if (StringUtils.isEmpty(name = name.trim())) {
            return;
        }
        this.checkCanChange();
        if (name.equals("drools.keepReference")) {
            this.setKeepReference(StringUtils.isEmpty(value) || Boolean.parseBoolean(value));
        } else if (name.equals("drools.directFiring")) {
            this.setDirectFiring(!StringUtils.isEmpty(value) && Boolean.parseBoolean(value));
        } else if (name.equals("drools.threadSafe")) {
            this.setThreadSafe(StringUtils.isEmpty(value) || Boolean.parseBoolean(value));
        } else if (name.equals("drools.accumulateNullPropagation")) {
            this.setAccumulateNullPropagation(!StringUtils.isEmpty(value) && Boolean.parseBoolean(value));
        } else if (name.equals("drools.forceEagerActivation")) {
            this.setForceEagerActivationFilter(ForceEagerActivationOption.resolve(StringUtils.isEmpty(value) ? "false" : value).getFilter());
        } else if (name.equals("drools.timedRuleExecution")) {
            this.setTimedRuleExecutionFilter(TimedRuleExecutionOption.resolve(StringUtils.isEmpty(value) ? "false" : value).getFilter());
        } else if (name.equals("drools.clockType")) {
            this.setClockType(ClockType.resolveClockType(StringUtils.isEmpty(value) ? "realtime" : value));
        } else if (name.equals("drools.timerJobFactory")) {
            this.setTimerJobFactoryType(TimerJobFactoryType.resolveTimerJobFactoryType(StringUtils.isEmpty(value) ? "default" : value));
        } else if (name.equals("drools.queryListener")) {
            String property = StringUtils.isEmpty(value) ? QueryListenerOption.STANDARD.getAsString() : value;
            this.setQueryListenerOption(QueryListenerOption.determineQueryListenerClassOption(property));
        } else if (name.equals("drools.beliefSystem")) {
            this.setBeliefSystemType(StringUtils.isEmpty(value) ? BeliefSystemType.SIMPLE : BeliefSystemType.resolveBeliefSystemType(value));
        }
    }

    @Override
    public final String getProperty(String name) {
        if (StringUtils.isEmpty(name = name.trim())) {
            return null;
        }
        if (name.equals("drools.keepReference")) {
            return Boolean.toString(this.isKeepReference());
        }
        if (name.equals("drools.directFiring")) {
            return Boolean.toString(this.isDirectFiring());
        }
        if (name.equals("drools.threadSafe")) {
            return Boolean.toString(this.isThreadSafe());
        }
        if (name.equals("drools.accumulateNullPropagation")) {
            return Boolean.toString(this.isAccumulateNullPropagation());
        }
        if (name.equals("drools.clockType")) {
            return this.getClockType().toExternalForm();
        }
        if (name.equals("drools.timerJobFactory")) {
            return this.getTimerJobFactoryType().toExternalForm();
        }
        if (name.equals("drools.queryListener")) {
            return this.getQueryListenerOption().getAsString();
        }
        if (name.equals("drools.beliefSystem")) {
            return this.getBeliefSystemType().getId();
        }
        return null;
    }
}

