/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.rule.builder.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.drools.core.rule.Annotated;
import org.drools.drl.ast.descr.AnnotatedBaseDescr;
import org.drools.drl.ast.descr.AnnotationDescr;
import org.drools.util.StringUtils;
import org.drools.util.TypeResolver;

public class AnnotationFactory {
    public static Annotation buildAnnotation(TypeResolver typeResolver, AnnotationDescr annotationDescr) {
        try {
            Class<?> annotationClass = typeResolver.resolveType(annotationDescr.getFullyQualifiedName());
            return AnnotationFactory.buildAnnotation(annotationDescr, annotationClass);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static Annotation buildAnnotation(AnnotationDescr annotationDescr, Class<?> annotationClass) {
        return (Annotation)Proxy.newProxyInstance(annotationClass.getClassLoader(), new Class[]{Annotation.class, annotationClass}, (InvocationHandler)new AnnotationInvocationHandler(annotationClass, annotationDescr));
    }

    public static <A extends Annotation> A getTypedAnnotation(AnnotatedBaseDescr annotatedBaseDescr, Class<A> annotationClass) {
        AnnotationDescr annotationDescr = annotatedBaseDescr.getAnnotation(annotationClass);
        return (A)(annotationDescr == null ? null : AnnotationFactory.buildAnnotation(annotationDescr, annotationClass));
    }

    public static Annotated toAnnotated(final AnnotatedBaseDescr annotatedBaseDescr) {
        return new Annotated(){

            @Override
            public boolean hasAnnotation(Class<? extends Annotation> annotationClass) {
                return annotatedBaseDescr.hasAnnotation(annotationClass);
            }

            @Override
            public <A extends Annotation> A getTypedAnnotation(Class<A> annotationClass) {
                return AnnotationFactory.getTypedAnnotation(annotatedBaseDescr, annotationClass);
            }
        };
    }

    public static class AnnotationInvocationHandler
    implements InvocationHandler {
        private final Class<?> annotationClass;
        private final AnnotationDescr annotationDescr;

        public AnnotationInvocationHandler(Class<?> annotationClass, AnnotationDescr annotationDescr) {
            this.annotationClass = annotationClass;
            this.annotationDescr = annotationDescr;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("annotationType")) {
                return this.annotationClass;
            }
            if (method.getName().equals("toString")) {
                return this.toString();
            }
            if (method.getName().equals("hashCode")) {
                return this.hashCode();
            }
            if (method.getName().equals("equals")) {
                return this.annotationDescr.equals(args[0]);
            }
            try {
                this.annotationClass.getMethod(method.getName(), new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("Invoked not existing method " + method.getName() + " on annotation " + this.annotationClass.getName());
            }
            Object value = this.annotationDescr.getValue(method.getName());
            return value == null ? method.getDefaultValue() : this.normalizeResult(method.getReturnType(), value);
        }

        public int hashCode() {
            return this.annotationDescr.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof AnnotationInvocationHandler && this.annotationDescr.equals(((AnnotationInvocationHandler)obj).annotationDescr);
        }

        public String toString() {
            return this.annotationDescr.toString();
        }

        private Object normalizeResult(Class<?> resultClass, Object val) {
            if (resultClass == String.class) {
                String value = val.toString();
                if (this.annotationDescr.isStrict()) {
                    if (value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"') {
                        return value.substring(1, value.length() - 1);
                    }
                    throw new RuntimeException("Cannot convert " + value + " to an instance of type " + resultClass.getName());
                }
                return value;
            }
            if (resultClass.isInstance(val)) {
                return val;
            }
            String value = val.toString();
            if (resultClass == Boolean.class || resultClass == Boolean.TYPE) {
                return Boolean.valueOf(value);
            }
            if (resultClass == Integer.class || resultClass == Integer.TYPE) {
                return Integer.valueOf(value);
            }
            if (resultClass.isEnum()) {
                String annotationHead = resultClass.getSimpleName() + ".";
                int typePos = value.indexOf(annotationHead);
                if (typePos >= 0) {
                    value = value.substring(typePos + annotationHead.length());
                }
                try {
                    return Enum.valueOf(resultClass, value);
                }
                catch (IllegalArgumentException e) {
                    if (!this.annotationDescr.isStrict()) {
                        value = StringUtils.ucFirst(value);
                        try {
                            return Enum.valueOf(resultClass, value);
                        }
                        catch (IllegalArgumentException e2) {
                            return Enum.valueOf(resultClass, value.toUpperCase());
                        }
                    }
                    throw e;
                }
            }
            throw new RuntimeException("Cannot convert " + value + " to an instance of type " + resultClass.getName());
        }
    }
}

