/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.kie.builder.impl;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.drools.util.IoUtils;
import org.drools.util.PortablePath;
import org.kie.memorycompiler.resources.ResourceReader;

public class DiskResourceReader
implements ResourceReader {
    private final File root;
    private final PortablePath rootPath;
    private Map<PortablePath, Integer> filesHashing;

    public DiskResourceReader(File root) {
        this.root = root;
        this.rootPath = PortablePath.of(root.getAbsolutePath());
    }

    @Override
    public boolean isAvailable(PortablePath resourcePath) {
        return new File(this.root, resourcePath.asString()).exists();
    }

    @Override
    public byte[] getBytes(PortablePath resourcePath) {
        try {
            return IoUtils.readBytesFromInputStream(new FileInputStream(new File(this.root, resourcePath.asString())));
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Collection<PortablePath> getFilePaths() {
        ArrayList<PortablePath> list = new ArrayList<PortablePath>();
        this.list(this.root, list);
        return list;
    }

    @Override
    public void mark() {
        this.filesHashing = this.hashFiles();
    }

    @Override
    public Collection<String> getModifiedResourcesSinceLastMark() {
        HashSet<String> modifiedResources = new HashSet<String>();
        Map<PortablePath, Integer> newHashing = this.hashFiles();
        for (Map.Entry<PortablePath, Integer> entry : newHashing.entrySet()) {
            Integer oldHashing = this.filesHashing.get(entry.getKey());
            if (oldHashing != null && oldHashing.equals(entry.getValue())) continue;
            modifiedResources.add(entry.getKey().asString());
        }
        for (PortablePath oldFile : this.filesHashing.keySet()) {
            if (newHashing.containsKey(oldFile)) continue;
            modifiedResources.add(oldFile.asString());
        }
        return modifiedResources;
    }

    private Map<PortablePath, Integer> hashFiles() {
        HashMap<PortablePath, Integer> hashing = new HashMap<PortablePath, Integer>();
        for (PortablePath filePath : this.getFilePaths()) {
            byte[] bytes = this.getBytes(filePath);
            if (bytes == null) continue;
            hashing.put(filePath, Arrays.hashCode(bytes));
        }
        return hashing;
    }

    private void list(File pFile, List<PortablePath> pFiles) {
        if (pFile.isDirectory()) {
            File[] directoryFiles = pFile.listFiles();
            for (int i = 0; i < directoryFiles.length; ++i) {
                this.list(directoryFiles[i], pFiles);
            }
        } else {
            pFiles.add(PortablePath.of(pFile.getAbsolutePath().substring(this.rootPath.asString().length() + 1)));
        }
    }
}

