/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.builder.impl.resources;

import java.util.List;
import org.drools.compiler.builder.conf.DecisionTableConfigurationImpl;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.compiler.builder.impl.resources.ResourceHandler;
import org.drools.compiler.lang.descr.CompositePackageDescr;
import org.drools.drl.ast.descr.PackageDescr;
import org.drools.drl.extensions.DecisionTableFactory;
import org.drools.drl.parser.DroolsParserException;
import org.kie.api.builder.ReleaseId;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceConfiguration;
import org.kie.api.io.ResourceType;
import org.kie.internal.builder.DecisionTableConfiguration;

public class DecisionTableResourceHandler
extends ResourceHandler {
    public DecisionTableResourceHandler(KnowledgeBuilderConfigurationImpl configuration, ReleaseId releaseId) {
        super(configuration, releaseId);
    }

    @Override
    public boolean handles(ResourceType type) {
        return type == ResourceType.DTABLE;
    }

    @Override
    public PackageDescr process(Resource resource, ResourceConfiguration rConfiguration) throws DroolsParserException {
        DecisionTableConfiguration dtableConfiguration;
        DecisionTableConfiguration decisionTableConfiguration = dtableConfiguration = rConfiguration instanceof DecisionTableConfiguration ? (DecisionTableConfiguration)rConfiguration : new DecisionTableConfigurationImpl();
        if (!dtableConfiguration.getRuleTemplateConfigurations().isEmpty()) {
            List<String> generatedDrls = DecisionTableFactory.loadFromInputStreamWithTemplates(resource, dtableConfiguration);
            if (generatedDrls.size() == 1) {
                return this.generatedDrlToPackageDescr(resource, generatedDrls.get(0));
            }
            CompositePackageDescr compositePackageDescr = null;
            for (String generatedDrl : generatedDrls) {
                PackageDescr packageDescr = this.generatedDrlToPackageDescr(resource, generatedDrl);
                if (packageDescr == null) continue;
                if (compositePackageDescr == null) {
                    compositePackageDescr = new CompositePackageDescr(resource, packageDescr);
                    continue;
                }
                compositePackageDescr.addPackageDescr(resource, packageDescr);
            }
            return compositePackageDescr;
        }
        dtableConfiguration.setTrimCell(this.configuration.isTrimCellsInDTable());
        String generatedDrl = DecisionTableFactory.loadFromResource(resource, dtableConfiguration);
        return this.generatedDrlToPackageDescr(resource, generatedDrl);
    }
}

