/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.builder.conf;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.drools.io.ResourceConfigurationImpl;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceConfiguration;
import org.kie.internal.builder.DecisionTableConfiguration;
import org.kie.internal.builder.DecisionTableInputType;
import org.kie.internal.builder.RuleTemplateConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecisionTableConfigurationImpl
extends ResourceConfigurationImpl
implements DecisionTableConfiguration {
    public static final String DROOLS_DT_TYPE = "drools.dt.type";
    public static final String DROOLS_DT_WORKSHEET = "drools.dt.worksheet";
    private final Logger logger = LoggerFactory.getLogger(DecisionTableConfigurationImpl.class);
    private DecisionTableInputType inputType = DecisionTableInputType.XLS;
    private String worksheetName;
    private Set<RuleTemplateConfiguration> templates = new HashSet<RuleTemplateConfiguration>();
    private boolean trimCell = true;

    @Override
    public boolean isTrimCell() {
        return this.trimCell;
    }

    @Override
    public void setTrimCell(boolean trimCell) {
        this.trimCell = trimCell;
    }

    @Override
    public void setInputType(DecisionTableInputType inputType) {
        this.inputType = inputType;
    }

    @Override
    public DecisionTableInputType getInputType() {
        return this.inputType;
    }

    @Override
    public void setWorksheetName(String worksheetName) {
        this.worksheetName = worksheetName;
    }

    @Override
    public String getWorksheetName() {
        return this.worksheetName;
    }

    @Override
    public void addRuleTemplateConfiguration(Resource template, int row, int col) {
        this.templates.add(new RuleTemplateInfo(template, row, col));
    }

    @Override
    public List<RuleTemplateConfiguration> getRuleTemplateConfigurations() {
        ArrayList<RuleTemplateConfiguration> confs = new ArrayList<RuleTemplateConfiguration>();
        confs.addAll(this.templates);
        return confs;
    }

    @Override
    public Properties toProperties() {
        Properties prop = super.toProperties();
        prop.setProperty(DROOLS_DT_TYPE, this.inputType.toString());
        if (this.worksheetName != null) {
            prop.setProperty(DROOLS_DT_WORKSHEET, this.worksheetName);
        }
        return prop;
    }

    @Override
    public ResourceConfiguration fromProperties(Properties prop) {
        super.fromProperties(prop);
        this.inputType = DecisionTableInputType.valueOf(prop.getProperty(DROOLS_DT_TYPE, DecisionTableInputType.XLS.toString()));
        this.worksheetName = prop.getProperty(DROOLS_DT_WORKSHEET, null);
        return this;
    }

    public static class RuleTemplateInfo
    implements RuleTemplateConfiguration {
        private final Resource template;
        private final int row;
        private final int col;

        public RuleTemplateInfo(Resource template, int row, int col) {
            this.template = template;
            this.row = row;
            this.col = col;
        }

        @Override
        public Resource getTemplate() {
            return this.template;
        }

        @Override
        public int getRow() {
            return this.row;
        }

        @Override
        public int getCol() {
            return this.col;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RuleTemplateInfo that = (RuleTemplateInfo)o;
            if (this.row != that.row) {
                return false;
            }
            if (this.col != that.col) {
                return false;
            }
            return this.template != null ? this.template.equals(that.template) : that.template == null;
        }

        public int hashCode() {
            int result = this.template != null ? this.template.hashCode() : 0;
            result = 31 * result + this.row;
            result = 31 * result + this.col;
            return result;
        }
    }
}

