/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ansible.rulebook.integration.api.rulesengine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.drools.ansible.rulebook.integration.api.rulesengine.RulesExecutorSession;
import org.drools.core.common.InternalFactHandle;
import org.kie.api.runtime.rule.AgendaFilter;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.runtime.rule.Match;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisterOnlyAgendaFilter
implements AgendaFilter {
    protected static final Logger log = LoggerFactory.getLogger(RegisterOnlyAgendaFilter.class);
    public static final String SYNTHETIC_RULE_TAG = "SYNTHETIC_RULE";
    public static final String RULE_TYPE_TAG = "RULE_TYPE";
    public static final Map<String, Function<Match, Match>> matchTransformers = new HashMap<String, Function<Match, Match>>();
    private final RulesExecutorSession rulesExecutorSession;
    private final Set<Long> ephemeralFactHandleIds = ConcurrentHashMap.newKeySet();
    private final Set<Match> matchedRules = new LinkedHashSet<Match>();
    private final List<FactHandle> factsToBeDeleted = new ArrayList<FactHandle>();

    public RegisterOnlyAgendaFilter(RulesExecutorSession rulesExecutorSession) {
        this.rulesExecutorSession = rulesExecutorSession;
    }

    public void registerEphemeralFact(Long factId) {
        this.ephemeralFactHandleIds.add(factId);
    }

    @Override
    public boolean accept(Match match) {
        List<? extends FactHandle> fhs = match.getFactHandles();
        boolean validMatch = this.isValidMatch(fhs);
        if (validMatch) {
            Map<String, Object> metadata;
            if (log.isInfoEnabled()) {
                log.info(RegisterOnlyAgendaFilter.matchToString(match));
            }
            if ((metadata = match.getRule().getMetaData()).get(SYNTHETIC_RULE_TAG) != null) {
                return true;
            }
            this.matchedRules.add((Match)matchTransformers.getOrDefault(metadata.get(RULE_TYPE_TAG), Function.identity()).apply(match));
        }
        if (!this.ephemeralFactHandleIds.isEmpty()) {
            for (FactHandle factHandle : fhs) {
                if (!this.ephemeralFactHandleIds.remove(((InternalFactHandle)factHandle).getId())) continue;
                this.factsToBeDeleted.add(factHandle);
            }
        }
        return validMatch;
    }

    public List<Match> finalizeAndGetResults() {
        for (FactHandle toBeDeleted : this.factsToBeDeleted) {
            this.rulesExecutorSession.delete(toBeDeleted);
        }
        this.factsToBeDeleted.clear();
        ArrayList<Match> matches = new ArrayList<Match>(this.matchedRules);
        this.matchedRules.clear();
        return matches;
    }

    public static void registerMatchTransformer(String ruleType, Function<Match, Match> transformer) {
        matchTransformers.put(ruleType, transformer);
    }

    private static String matchToString(Match match) {
        Map<String, Object> metadata = match.getRule().getMetaData();
        String ruleType = metadata.get(SYNTHETIC_RULE_TAG) != null ? "synthetic" : "effective";
        return "Activation of " + ruleType + " rule \"" + match.getRule().getName() + "\" with facts: " + match.getObjects();
    }

    private boolean isValidMatch(List<InternalFactHandle> fhs) {
        return !this.isSelfJoin(fhs);
    }

    private boolean isSelfJoin(List<InternalFactHandle> fhs) {
        for (int i = 0; i < fhs.size() - 1; ++i) {
            for (int j = i + 1; j < fhs.size(); ++j) {
                if (fhs.get(i) != fhs.get(j)) continue;
                return true;
            }
        }
        return false;
    }
}

