/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ansible.rulebook.integration.api.rulesengine;

import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.drools.ansible.rulebook.integration.api.rulesengine.AbstractRulesEvaluator;

public class AutomaticPseudoClock {
    private final ScheduledThreadPoolExecutor timer = new ScheduledThreadPoolExecutor(1, r -> {
        Thread t = new Thread(r);
        t.setDaemon(true);
        return t;
    });
    private final AbstractRulesEvaluator rulesEvaluator;
    private final long period;
    private volatile long nextTick;

    AutomaticPseudoClock(AbstractRulesEvaluator rulesEvaluator, long amount, TimeUnit unit) {
        this(rulesEvaluator, unit.toMillis(amount));
    }

    AutomaticPseudoClock(AbstractRulesEvaluator rulesEvaluator, long period) {
        this.period = period;
        this.rulesEvaluator = rulesEvaluator;
        this.timer.scheduleAtFixedRate(this::advancePseudoClock, period, period, TimeUnit.MILLISECONDS);
    }

    public long getPeriod() {
        return this.period;
    }

    public void shutdown() {
        this.timer.shutdown();
    }

    private void advancePseudoClock() {
        this.nextTick += this.period;
        this.rulesEvaluator.scheduledAdvanceTimeToMills(this.nextTick);
    }
}

