/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ansible.rulebook.integration.api.rulesengine;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class AsyncExecutor {
    private final ExecutorService executor = Executors.newSingleThreadExecutor(r -> {
        Thread t = new Thread(r);
        t.setDaemon(true);
        t.setName("drools-async-evaluator-thread");
        return t;
    });

    public CompletableFuture<?> submit(Runnable runnable) {
        return CompletableFuture.runAsync(runnable, this.executor);
    }

    public <T> CompletableFuture<T> submit(Callable<T> task) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return task.call();
            }
            catch (Exception e) {
                throw new CompletionException(e);
            }
        }, this.executor);
    }

    public void shutdown() {
        this.executor.shutdown();
    }
}

