/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ansible.rulebook.integration.api.domain.temporal;

import java.util.ArrayList;
import java.util.List;
import org.drools.ansible.rulebook.integration.api.domain.RuleGenerationContext;
import org.drools.ansible.rulebook.integration.api.domain.temporal.TimeAmount;
import org.drools.ansible.rulebook.integration.api.domain.temporal.TimeConstraint;
import org.drools.ansible.rulebook.integration.api.rulesengine.EmptyMatchDecorator;
import org.drools.ansible.rulebook.integration.api.rulesengine.RegisterOnlyAgendaFilter;
import org.drools.ansible.rulebook.integration.api.rulesmodel.PrototypeFactory;
import org.drools.core.base.accumulators.CountAccumulateFunction;
import org.drools.core.facttemplates.Event;
import org.drools.core.facttemplates.Fact;
import org.drools.model.ConstraintOperator;
import org.drools.model.DSL;
import org.drools.model.Declaration;
import org.drools.model.Drools;
import org.drools.model.Index;
import org.drools.model.PatternDSL;
import org.drools.model.Prototype;
import org.drools.model.PrototypeDSL;
import org.drools.model.PrototypeVariable;
import org.drools.model.Rule;
import org.drools.model.RuleItemBuilder;
import org.drools.model.Variable;
import org.drools.model.functions.accumulate.AccumulateFunction;
import org.drools.model.view.ViewItem;
import org.drools.model.view.ViewItemBuilder;
import org.drools.modelcompiler.facttemplate.FactFactory;
import org.kie.api.runtime.rule.Match;
import org.kie.api.runtime.rule.RuleContext;

public class TimedOutDefinition
implements TimeConstraint {
    public static final String KEYWORD = "timed_out";
    private final TimeAmount timeAmount;
    private final List<ViewItem> patterns = new ArrayList<ViewItem>();
    private final Prototype controlPrototype = PrototypeFactory.getPrototype("DROOLS_SYNTHETIC_PROTOTYPE");
    private final PrototypeVariable controlVar1 = PrototypeDSL.variable(this.controlPrototype, "c1");
    private final PrototypeVariable controlVar2 = PrototypeDSL.variable(this.controlPrototype, "c2");

    private static Match transformTimedOutMatch(Match match) {
        Fact fact = (Fact)match.getObjects().get(0);
        Object startEvent = fact.get("event");
        fact.set("event", null);
        return new EmptyMatchDecorator(match).withBoundObject(fact.get("binding").toString(), startEvent);
    }

    private TimedOutDefinition(TimeAmount timeAmount) {
        this.timeAmount = timeAmount;
    }

    public static TimedOutDefinition parseTimedOut(String timeWindow) {
        return new TimedOutDefinition(TimeAmount.parseTimeAmount(timeWindow));
    }

    @Override
    public boolean requiresAsyncExecution() {
        return true;
    }

    @Override
    public ViewItem processTimeConstraint(String ruleName, ViewItem pattern) {
        this.patterns.add(pattern);
        return pattern;
    }

    @Override
    public Variable<?>[] getTimeConstraintConsequenceVariables() {
        return new Variable[]{this.controlVar1};
    }

    @Override
    public void executeTimeConstraintConsequence(Drools drools, Object ... facts) {
        drools.delete(facts[0]);
    }

    @Override
    public Rule buildTimedRule(String ruleName, RuleItemBuilder pattern, RuleItemBuilder consequence) {
        String startTag = "start_" + ruleName;
        String endTag = "end_" + ruleName;
        return PatternDSL.rule(ruleName).metadata("RULE_TYPE", KEYWORD).build(PrototypeDSL.protoPattern(this.controlVar1).expr("rulename", (ConstraintOperator)Index.ConstraintType.EQUAL, startTag), DSL.not(PrototypeDSL.protoPattern(this.controlVar2).expr("rulename", (ConstraintOperator)Index.ConstraintType.EQUAL, endTag).expr(DSL.after(0L, this.timeAmount.getTimeUnit(), this.timeAmount.getAmount(), this.timeAmount.getTimeUnit()), this.controlVar1), new ViewItemBuilder[0]), consequence);
    }

    @Override
    public List<Rule> getControlRules(RuleGenerationContext ruleContext) {
        String rulePrefix = ruleContext.getRuleName() + "_";
        String startTag = "start_" + ruleContext.getRuleName();
        String endTag = "end_" + ruleContext.getRuleName();
        ArrayList<Rule> rules = new ArrayList<Rule>();
        PrototypeVariable controlVar3 = PrototypeDSL.variable(this.controlPrototype, "c3");
        Declaration<Long> resultCount = DSL.declarationOf(Long.class, "count");
        for (int i = 0; i < this.patterns.size(); ++i) {
            String name = rulePrefix + i;
            rules.add(PatternDSL.rule(name).metadata("SYNTHETIC_RULE", true).build(this.patterns.get(i), DSL.not(PrototypeDSL.protoPattern(this.controlVar1).expr("rulename", (ConstraintOperator)Index.ConstraintType.EQUAL, name), new ViewItemBuilder[0]), DSL.on(this.patterns.get(i).getFirstVariable()).execute((drools, t1) -> {
                Event controlEvent = FactFactory.createMapBasedEvent(this.controlPrototype).withExpiration(this.timeAmount.getAmount(), this.timeAmount.getTimeUnit());
                controlEvent.set("rulename", name);
                controlEvent.set("event", t1);
                controlEvent.set("binding", ((RuleContext)drools).getMatch().getDeclarationIds().get(0));
                ((Drools)drools).insert(controlEvent);
            })));
        }
        rules.add(PatternDSL.rule(startTag).metadata("SYNTHETIC_RULE", true).build(DSL.not(PrototypeDSL.protoPattern(this.controlVar1).expr("rulename", (ConstraintOperator)Index.ConstraintType.EQUAL, startTag), new ViewItemBuilder[0]), PrototypeDSL.protoPattern(this.controlVar2).expr(p -> ((String)p.get("rulename")).startsWith(rulePrefix)), DSL.on(this.controlVar2).execute((drools, firstEvent) -> {
            Event controlEvent = FactFactory.createMapBasedEvent(this.controlPrototype).withExpiration(this.timeAmount.getAmount(), this.timeAmount.getTimeUnit());
            controlEvent.set("rulename", startTag);
            controlEvent.set("event", firstEvent.get("event"));
            controlEvent.set("binding", firstEvent.get("binding"));
            drools.insert(controlEvent);
        })));
        rules.add(PatternDSL.rule(endTag).metadata("SYNTHETIC_RULE", true).build(PrototypeDSL.protoPattern(this.controlVar1).expr("rulename", (ConstraintOperator)Index.ConstraintType.EQUAL, startTag), DSL.accumulate(PrototypeDSL.protoPattern(this.controlVar2).expr(p -> ((String)p.get("rulename")).startsWith(rulePrefix)), DSL.accFunction(CountAccumulateFunction::new).as(resultCount), new AccumulateFunction[0]), PatternDSL.pattern(resultCount).expr(count -> count == (long)this.patterns.size()), DSL.on(resultCount).execute((drools, count) -> {
            Event controlEvent = FactFactory.createMapBasedEvent(this.controlPrototype).withExpiration(this.timeAmount.getAmount(), this.timeAmount.getTimeUnit());
            controlEvent.set("rulename", endTag);
            drools.insert(controlEvent);
        })));
        rules.add(PatternDSL.rule(rulePrefix + "cleanupEvents").metadata("SYNTHETIC_RULE", true).build(PrototypeDSL.protoPattern(this.controlVar1).expr("rulename", (ConstraintOperator)Index.ConstraintType.EQUAL, endTag), PrototypeDSL.protoPattern(this.controlVar2).expr(p -> ((String)p.get("rulename")).startsWith(rulePrefix)), DSL.on(this.controlVar1, this.controlVar2).execute((drools, c1, c2) -> {
            drools.delete(c2.get("event"));
            drools.delete(c2);
        })));
        rules.add(PatternDSL.rule(rulePrefix + "cleanupEvents2").metadata("SYNTHETIC_RULE", true).build(PrototypeDSL.protoPattern(this.controlVar1).expr("rulename", (ConstraintOperator)Index.ConstraintType.EQUAL, startTag), DSL.not(PrototypeDSL.protoPattern(this.controlVar2).expr("rulename", (ConstraintOperator)Index.ConstraintType.EQUAL, endTag).expr(DSL.after(0L, this.timeAmount.getTimeUnit(), this.timeAmount.getAmount(), this.timeAmount.getTimeUnit()), this.controlVar1), new ViewItemBuilder[0]), PrototypeDSL.protoPattern(controlVar3).expr(p -> ((String)p.get("rulename")).startsWith(rulePrefix)), DSL.on(this.controlVar1, controlVar3).execute((drools, c1, c3) -> {
            drools.delete(c3.get("event"));
            drools.delete(c3);
            drools.delete(c1);
        })));
        rules.add(PatternDSL.rule(rulePrefix + "cleanupTerminal").metadata("SYNTHETIC_RULE", true).build(PrototypeDSL.protoPattern(this.controlVar1).expr("rulename", (ConstraintOperator)Index.ConstraintType.EQUAL, startTag), PrototypeDSL.protoPattern(this.controlVar2).expr("rulename", (ConstraintOperator)Index.ConstraintType.EQUAL, endTag), DSL.on(this.controlVar1, this.controlVar2).execute((drools, c1, c2) -> {
            drools.delete(c1);
            drools.delete(c2);
        })));
        return rules;
    }

    static {
        RegisterOnlyAgendaFilter.registerMatchTransformer(KEYWORD, TimedOutDefinition::transformTimedOutMatch);
    }
}

