/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ansible.rulebook.integration.api.domain.temporal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.drools.ansible.rulebook.integration.api.domain.RuleGenerationContext;
import org.drools.ansible.rulebook.integration.api.domain.temporal.OnceAbstractTimeConstraint;
import org.drools.ansible.rulebook.integration.api.domain.temporal.TimeAmount;
import org.drools.ansible.rulebook.integration.api.rulesengine.EmptyMatchDecorator;
import org.drools.ansible.rulebook.integration.api.rulesengine.RegisterOnlyAgendaFilter;
import org.drools.ansible.rulebook.integration.api.rulesmodel.PrototypeFactory;
import org.drools.core.base.accumulators.CollectListAccumulateFunction;
import org.drools.core.facttemplates.Event;
import org.drools.core.facttemplates.Fact;
import org.drools.model.Argument;
import org.drools.model.ConstraintOperator;
import org.drools.model.DSL;
import org.drools.model.Drools;
import org.drools.model.DroolsEntryPoint;
import org.drools.model.Index;
import org.drools.model.PatternDSL;
import org.drools.model.Prototype;
import org.drools.model.PrototypeDSL;
import org.drools.model.PrototypeVariable;
import org.drools.model.Rule;
import org.drools.model.RuleItemBuilder;
import org.drools.model.Variable;
import org.drools.model.functions.accumulate.AccumulateFunction;
import org.drools.model.view.ViewItem;
import org.drools.model.view.ViewItemBuilder;
import org.drools.modelcompiler.facttemplate.FactFactory;
import org.kie.api.runtime.rule.Match;

public class OnceAfterDefinition
extends OnceAbstractTimeConstraint {
    public static final String KEYWORD = "once_after";
    private final Prototype controlPrototype = PrototypeFactory.getPrototype("DROOLS_SYNTHETIC_PROTOTYPE");
    private final PrototypeVariable controlVar1 = PrototypeDSL.variable(this.controlPrototype, "c1");
    private final PrototypeVariable controlVar2 = PrototypeDSL.variable(this.controlPrototype, "c2");
    private final Variable<List> resultsVar = DSL.declarationOf(List.class, "results");

    private static Match transformOnceAfterMatch(Match match) {
        EmptyMatchDecorator rewrittenMatch = new EmptyMatchDecorator(match);
        Collection results = (Collection)match.getDeclarationValue("results");
        if (results.size() == 1) {
            rewrittenMatch.withBoundObject("m", ((Fact)results.iterator().next()).get("event"));
        } else {
            int i = 0;
            for (Fact fact : results) {
                rewrittenMatch.withBoundObject("m_" + i++, fact.get("event"));
            }
        }
        return rewrittenMatch;
    }

    public OnceAfterDefinition(TimeAmount timeAmount, List<String> groupByAttributes) {
        super(timeAmount, groupByAttributes);
    }

    @Override
    public boolean requiresAsyncExecution() {
        return true;
    }

    @Override
    public Variable<?>[] getTimeConstraintConsequenceVariables() {
        return new Variable[]{this.controlVar1, this.resultsVar};
    }

    @Override
    public void executeTimeConstraintConsequence(Drools drools, Object ... facts) {
        drools.delete(facts[0]);
        ((List)facts[1]).forEach(drools::delete);
    }

    @Override
    public ViewItem processTimeConstraint(String ruleName, ViewItem pattern) {
        this.ruleName = ruleName;
        if (this.guardedPattern != null) {
            throw new IllegalStateException("Cannot process this TimeConstraint twice");
        }
        this.guardedPattern = (PrototypeDSL.PrototypePatternDef)pattern;
        return pattern;
    }

    @Override
    public Rule buildTimedRule(String ruleName, RuleItemBuilder pattern, RuleItemBuilder consequence) {
        PrototypeVariable controlVar3 = PrototypeDSL.variable(this.controlPrototype, "c3");
        return PatternDSL.rule(ruleName).metadata("RULE_TYPE", KEYWORD).build(PrototypeDSL.protoPattern(this.controlVar1).expr("end_once_after", (ConstraintOperator)Index.ConstraintType.EQUAL, ruleName), DSL.not(PrototypeDSL.protoPattern(this.controlVar2).expr("start_once_after", (ConstraintOperator)Index.ConstraintType.EQUAL, ruleName), new ViewItemBuilder[0]), DSL.accumulate(PrototypeDSL.protoPattern(controlVar3).expr("drools_rule_name", (ConstraintOperator)Index.ConstraintType.EQUAL, ruleName), DSL.accFunction(CollectListAccumulateFunction::new, (Argument)controlVar3).as(this.resultsVar), new AccumulateFunction[0]), consequence);
    }

    @Override
    public List<Rule> getControlRules(RuleGenerationContext ruleContext) {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        rules.add(PatternDSL.rule(this.ruleName + "_control").metadata("SYNTHETIC_RULE", true).build(this.guardedPattern, DSL.not(this.createControlPattern(), new ViewItemBuilder[0]), DSL.on(this.getPatternVariable()).execute((drools, event) -> {
            Event controlEvent = FactFactory.createMapBasedEvent(this.controlPrototype);
            for (String unique : this.groupByAttributes) {
                controlEvent.set(unique, event.get(unique));
            }
            controlEvent.set("drools_rule_name", this.ruleName);
            controlEvent.set("event", event);
            drools.insert(controlEvent);
            drools.delete(event);
        })));
        rules.add(PatternDSL.rule(this.ruleName + "_start").metadata("SYNTHETIC_RULE", true).build(PrototypeDSL.protoPattern(this.controlVar1).expr("drools_rule_name", (ConstraintOperator)Index.ConstraintType.EQUAL, this.ruleName), DSL.not(PrototypeDSL.protoPattern(this.controlVar2).expr("end_once_after", (ConstraintOperator)Index.ConstraintType.EQUAL, this.ruleName), new ViewItemBuilder[0]), DSL.on(this.controlVar1).execute((drools, c1) -> {
            Event startControlEvent = FactFactory.createMapBasedEvent(this.controlPrototype).withExpiration(this.timeAmount.getAmount(), this.timeAmount.getTimeUnit());
            startControlEvent.set("start_once_after", this.ruleName);
            drools.insert(startControlEvent);
            Event endControlEvent = FactFactory.createMapBasedEvent(this.controlPrototype);
            endControlEvent.set("end_once_after", this.ruleName);
            drools.insert(endControlEvent);
        })));
        rules.add(PatternDSL.rule(this.ruleName + "_cleanup").metadata("SYNTHETIC_RULE", true).build(this.guardedPattern, this.createControlPattern(), DSL.on(this.getPatternVariable()).execute(DroolsEntryPoint::delete)));
        return rules;
    }

    public String toString() {
        return "OnceWithinDefinition{ " + this.timeAmount + ", groupByAttributes=" + this.groupByAttributes + " }";
    }

    public static OnceAfterDefinition parseOnceAfter(String onceWithin, List<String> groupByAttributes) {
        List<String> sanitizedAttributes = groupByAttributes.stream().map(OnceAbstractTimeConstraint::sanitizeAttributeName).collect(Collectors.toList());
        return new OnceAfterDefinition(TimeAmount.parseTimeAmount(onceWithin), sanitizedAttributes);
    }

    static {
        RegisterOnlyAgendaFilter.registerMatchTransformer(KEYWORD, OnceAfterDefinition::transformOnceAfterMatch);
    }
}

