/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ansible.rulebook.integration.api.domain.constraints;

import java.util.Collection;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import org.drools.ansible.rulebook.integration.api.domain.RuleGenerationContext;
import org.drools.ansible.rulebook.integration.api.domain.conditions.ConditionExpression;
import org.drools.ansible.rulebook.integration.api.domain.conditions.ConditionParseUtil;
import org.drools.ansible.rulebook.integration.api.domain.constraints.ConditionFactory;
import org.drools.ansible.rulebook.integration.api.domain.constraints.Operators;
import org.drools.ansible.rulebook.integration.api.rulesmodel.ParsedCondition;
import org.drools.model.ConstraintOperator;
import org.drools.model.PrototypeExpression;

public enum SelectAttrConstraint implements ConstraintOperator,
ConditionFactory
{
    INSTANCE;

    public static final String EXPRESSION_NAME = "SelectAttrExpression";
    public static final String NEGATED_EXPRESSION_NAME = "SelectAttrNotExpression";

    @Override
    public <T, V> BiPredicate<T, V> asPredicate() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "SELECT_ATTR";
    }

    @Override
    public ParsedCondition createParsedCondition(RuleGenerationContext ruleContext, String expressionName, Map<?, ?> expression) {
        return SelectAttrConstraint.createSelectCondition(ruleContext, expression, expressionName.equals(EXPRESSION_NAME), true);
    }

    static ParsedCondition createSelectCondition(RuleGenerationContext ruleContext, Map<?, ?> expression, boolean positive, boolean withKey) {
        ConditionExpression left = ConditionExpression.map2Expr(ruleContext, expression.get("lhs"));
        ConstraintOperator operator = SelectAttrConstraint.createSelectOperator((Map)expression.get("rhs"), withKey);
        return new ParsedCondition(left.getPrototypeExpression(), operator, PrototypeExpression.fixedValue(positive));
    }

    private static ConstraintOperator createSelectOperator(Map<?, ?> rhs, boolean withKey) {
        String operator = ((Map)rhs.get("operator")).entrySet().iterator().next().getValue().toString().trim();
        Object value = ConditionParseUtil.toJsonValue(rhs.get("value"));
        if (!withKey) {
            return new SelectAttrOperator(Operators.toOperatorPredicate(operator, value));
        }
        String key = ((Map)rhs.get("key")).entrySet().iterator().next().getValue().toString().trim();
        return new SelectAttrOperator(m -> ConditionParseUtil.extractMapAttribute((Map)m, key), Operators.toOperatorPredicate(operator, value));
    }

    public static class SelectAttrOperator
    implements ConstraintOperator {
        private final Function keyExtractor;
        private final Predicate opPred;

        public SelectAttrOperator(Predicate opPred) {
            this(Function.identity(), opPred);
        }

        public SelectAttrOperator(Function keyExtractor, Predicate opPred) {
            this.keyExtractor = keyExtractor;
            this.opPred = opPred;
        }

        @Override
        public <T, V> BiPredicate<T, V> asPredicate() {
            return (t, v) -> {
                if (t == null) {
                    return false;
                }
                if (t instanceof Collection) {
                    return ((Collection)t).stream().map(this.keyExtractor).anyMatch(this.opPred) == ((Boolean)v).booleanValue();
                }
                Object value = this.keyExtractor.apply(t);
                return value != null && this.opPred.test(value) == ((Boolean)v).booleanValue();
            };
        }
    }
}

