/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ansible.rulebook.integration.api.domain.constraints;

import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.regex.Pattern;
import org.drools.ansible.rulebook.integration.api.domain.RuleGenerationContext;
import org.drools.ansible.rulebook.integration.api.domain.conditions.ConditionExpression;
import org.drools.ansible.rulebook.integration.api.domain.conditions.ConditionParseUtil;
import org.drools.ansible.rulebook.integration.api.domain.constraints.ConditionFactory;
import org.drools.ansible.rulebook.integration.api.rulesmodel.ParsedCondition;
import org.drools.model.ConstraintOperator;
import org.drools.model.PrototypeExpression;

public enum SearchMatchesConstraint implements ConstraintOperator,
ConditionFactory
{
    INSTANCE;

    public static final String EXPRESSION_NAME = "SearchMatchesExpression";
    public static final String NEGATED_EXPRESSION_NAME = "SearchNotMatchesExpression";

    @Override
    public <T, V> BiPredicate<T, V> asPredicate() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "SEARCH_MATCHES";
    }

    @Override
    public ParsedCondition createParsedCondition(RuleGenerationContext ruleContext, String expressionName, Map<?, ?> expression) {
        ConditionExpression left = ConditionExpression.map2Expr(ruleContext, expression.get("lhs"));
        ConstraintOperator operator = SearchMatchesConstraint.createMatchOperator((Map)expression.get("rhs"));
        return new ParsedCondition(left.getPrototypeExpression(), operator, PrototypeExpression.fixedValue(expressionName.equals(EXPRESSION_NAME)));
    }

    public static ConstraintOperator createMatchOperator(Map<?, ?> rhs) {
        Map searchType = (Map)rhs.get("SearchType");
        return new RegexConstraint(SearchMatchesConstraint.parsePattern(searchType), SearchMatchesConstraint.parseOptions(searchType));
    }

    private static String parsePattern(Map searchType) {
        String kind = ((Map)searchType.get("kind")).get("String").toString();
        String pattern = ConditionParseUtil.toRegexPattern(((Map)searchType.get("pattern")).get("String").toString(), kind);
        if (pattern == null) {
            throw new UnsupportedOperationException("Unknown kind: " + kind);
        }
        return pattern;
    }

    private static int parseOptions(Map searchType) {
        int flags = 0;
        List options = (List)searchType.get("options");
        if (options != null) {
            block8: for (Map option : options) {
                String optionName = ((Map)option.get("name")).get("String").toString();
                String optionValue = ((Map)option.get("value")).get("Boolean").toString();
                if (!optionValue.equalsIgnoreCase("true")) continue;
                switch (optionName) {
                    case "ignorecase": {
                        flags += 2;
                        continue block8;
                    }
                    case "multiline": {
                        flags += 8;
                        continue block8;
                    }
                }
                throw new UnsupportedOperationException("Unknown option: " + optionName);
            }
        }
        return flags;
    }

    public static class RegexConstraint
    implements ConstraintOperator {
        private final Pattern regexPattern;

        public RegexConstraint(String pattern, int flags) {
            this.regexPattern = Pattern.compile(pattern, flags);
        }

        @Override
        public <T, V> BiPredicate<T, V> asPredicate() {
            return (t, v) -> t != null && this.regexPattern.matcher(t.toString()).matches() == ((Boolean)v).booleanValue();
        }
    }
}

